/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.GrpcProtocol;
import org.apache.pekko.grpc.GrpcResponseMetadata;
import org.apache.pekko.grpc.GrpcSingleResponse;
import org.apache.pekko.grpc.ProtobufSerializer;
import org.apache.pekko.grpc.internal.CancellationBarrierGraphStage;
import org.apache.pekko.grpc.internal.Codec;
import org.apache.pekko.grpc.internal.Codecs$;
import org.apache.pekko.grpc.internal.GrpcEntityHelpers$;
import org.apache.pekko.grpc.internal.GrpcProtocolNative$;
import org.apache.pekko.grpc.internal.GrpcRequestHelpers$;
import org.apache.pekko.grpc.internal.HeaderMetadataImpl;
import org.apache.pekko.grpc.internal.Identity$;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.JavaMetadataImpl;
import org.apache.pekko.grpc.internal.MetadataImpl;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils$ResponsePromise$;
import org.apache.pekko.grpc.internal.WithProtobufSerializer;
import org.apache.pekko.grpc.scaladsl.Metadata;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.javadsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.ClientTransport$;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.OverflowStrategy$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.FlowOpsMat;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.SourceQueueWithComplete;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class PekkoHttpClientUtils$
implements Serializable {
    public static final PekkoHttpClientUtils$ResponsePromise$ ResponsePromise;
    public static final PekkoHttpClientUtils$ MODULE$;

    private PekkoHttpClientUtils$() {
    }

    static {
        MODULE$ = new PekkoHttpClientUtils$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PekkoHttpClientUtils$.class);
    }

    @InternalApi
    public InternalChannel createChannel(GrpcClientSettings settings, LoggingAdapter log, ClassicActorSystemProvider sys) {
        Flow flow;
        ExecutionContextExecutor ec = sys.classicSystem().dispatcher();
        log.debug("Creating gRPC client channel");
        GrpcProtocol.GrpcProtocolWriter writer = GrpcProtocolNative$.MODULE$.newWriter(Identity$.MODULE$);
        IntRef roundRobin = IntRef.create((int)0);
        ClientConnectionSettings clientConnectionSettings = ((ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(sys)).withTransport(ClientTransport$.MODULE$.withCustomResolver((Function2 & Serializable)(host, _$1) -> PekkoHttpClientUtils$.$anonfun$1(settings, roundRobin, ec, (String)host, BoxesRunTime.unboxToInt((Object)_$1))));
        OutgoingConnectionBuilder builder = Http$.MODULE$.apply(sys).connectionTo((String)settings.overrideAuthority().getOrElse(() -> PekkoHttpClientUtils$.$anonfun$2(settings))).withClientConnectionSettings(clientConnectionSettings);
        if (settings.useTls()) {
            HttpsConnectionContext connectionContext = ConnectionContext$.MODULE$.httpsClient((SSLContext)settings.sslContext().getOrElse(() -> PekkoHttpClientUtils$.$anonfun$3(settings)));
            flow = builder.withCustomHttpsConnectionContext(connectionContext).managedPersistentHttp2();
        } else {
            flow = builder.managedPersistentHttp2WithPriorKnowledge();
        }
        Flow http2client = flow;
        Tuple2 tuple2 = (Tuple2)Source$.MODULE$.queue(4242, OverflowStrategy$.MODULE$.fail()).via((Graph)http2client).toMat((Graph)Sink$.MODULE$.foreach((Function1)(JProcedure1 & Serializable)res -> ((PekkoHttpClientUtils.ResponsePromise)res.attribute(PekkoHttpClientUtils$ResponsePromise$.MODULE$.Key(), (JavaMapping)JavaMapping$.MODULE$.attributeKey()).get()).promise().trySuccess(res)), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem(sys));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SourceQueueWithComplete queue = (SourceQueueWithComplete)tuple2._1();
        Future doneFuture = (Future)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)queue, (Object)doneFuture);
        SourceQueueWithComplete queue2 = (SourceQueueWithComplete)tuple22._1();
        Future doneFuture2 = (Future)tuple22._2();
        return new InternalChannel(queue2, doneFuture2, ec, sys, settings, writer){
            private final SourceQueueWithComplete queue$2;
            private final Future doneFuture$1;
            private final ExecutionContextExecutor ec$3;
            private final ClassicActorSystemProvider sys$1;
            private final GrpcClientSettings settings$7;
            private final GrpcProtocol.GrpcProtocolWriter writer$1;
            {
                this.queue$2 = queue$3;
                this.doneFuture$1 = doneFuture$2;
                this.ec$3 = ec$11;
                this.sys$1 = sys$2;
                this.settings$7 = settings$9;
                this.writer$1 = writer$2;
            }

            public void shutdown() {
                this.queue$2.complete();
            }

            public Future done() {
                return this.doneFuture$1;
            }

            public Future invoke(Object request, MetadataImpl headers, MethodDescriptor descriptor, CallOptions options) {
                return this.invokeWithMetadata(request, headers, descriptor, options).map(PekkoHttpClientUtils$::org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$1$$_$invoke$$anonfun$1, (ExecutionContext)this.ec$3);
            }

            public Future invokeWithMetadata(Object request, MetadataImpl headers, MethodDescriptor descriptor, CallOptions options) {
                Source src = this.invokeWithMetadata(Source$.MODULE$.single(request), headers, descriptor, false, options);
                Tuple2 tuple2 = (Tuple2)src.toMat((Graph)Sink$.MODULE$.head(), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem(this.sys$1));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Future metadataFuture = (Future)tuple2._1();
                Future resultFuture = (Future)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)metadataFuture, (Object)resultFuture);
                Future metadataFuture2 = (Future)tuple22._1();
                Future resultFuture2 = (Future)tuple22._2();
                return metadataFuture2.zip(resultFuture2).map(PekkoHttpClientUtils$::org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$1$$_$invokeWithMetadata$$anonfun$1, (ExecutionContext)this.ec$3);
            }

            public Source invokeWithMetadata(Source source, MetadataImpl headers, MethodDescriptor descriptor, boolean streamingResponse, CallOptions options) {
                ProtobufSerializer serializer = PekkoHttpClientUtils$.MODULE$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$$_$serializerFromMethodDescriptor$1(descriptor);
                ProtobufSerializer deserializer = PekkoHttpClientUtils$.MODULE$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$$_$deserializerFromMethodDescriptor$1(descriptor);
                String scheme = this.settings$7.useTls() ? "https" : "http";
                HttpRequest httpRequest = GrpcRequestHelpers$.MODULE$.apply(Uri$.MODULE$.apply(new StringBuilder(4).append(scheme).append("://").append(this.settings$7.overrideAuthority().getOrElse(this::$anonfun$5)).append("/").append(descriptor.getFullMethodName()).toString()), (Seq<HttpHeader>)GrpcEntityHelpers$.MODULE$.metadataHeaders(headers.entries()), source, GrpcRequestHelpers$.MODULE$.apply$default$4(), serializer, this.writer$1, this.sys$1);
                return PekkoHttpClientUtils$.MODULE$.responseToSource((Future<HttpResponse>)PekkoHttpClientUtils$.MODULE$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$$_$singleRequest$1(this.queue$2, this.ec$3, httpRequest), deserializer, (ExecutionContext)this.ec$3, Materializer$.MODULE$.matFromSystem(this.sys$1));
            }

            private final String $anonfun$5() {
                return this.settings$7.serviceName();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$1$$_$invoke$$anonfun$1(org.apache.pekko.grpc.GrpcSingleResponse ), org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$1$$_$invokeWithMetadata$$anonfun$1(scala.Tuple2 ), $anonfun$5()}, serializedLambda);
            }
        };
    }

    @InternalApi
    public <O> Source<O, Future<GrpcResponseMetadata>> responseToSource(Future<HttpResponse> response, ProtobufSerializer<O> deserializer, ExecutionContext ec, Materializer mat) {
        return Source$.MODULE$.lazyFutureSource((Function0 & Serializable)() -> response.map((Function1 & Serializable)response -> {
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (statusCode == null ? success != null : !statusCode.equals(success)) {
                HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()), mat);
                StatusRuntimeException failure = this.mapToStatusException((HttpResponse)response, (Seq<HttpHeader>)((Seq)Seq$.MODULE$.empty()));
                return Source$.MODULE$.failed((Throwable)failure).mapMaterializedValue((Function1 & Serializable)_$4 -> Future$.MODULE$.failed((Throwable)failure));
            }
            Try<Codec> try_ = Codecs$.MODULE$.detect((HttpMessage)response);
            if (try_ instanceof Success) {
                Source source;
                Codec codec = (Codec)((Success)try_).value();
                GrpcProtocol.GrpcProtocolReader reader = GrpcProtocolNative$.MODULE$.newReader(codec);
                Promise trailerPromise = Promise$.MODULE$.apply();
                Future completionFuture = trailerPromise.future().flatMap((Function1 & Serializable)trailers -> MODULE$.parseResponseStatus((HttpResponse)response, (Seq<HttpHeader>)trailers), ec);
                ResponseEntity responseEntity = response.entity();
                if (responseEntity instanceof HttpEntity.Chunked) {
                    Source source2;
                    HttpEntity.Chunked chunked = HttpEntity.Chunked$.MODULE$.unapply((HttpEntity.Chunked)responseEntity);
                    ContentType contentType = chunked._1();
                    Source chunks = source2 = chunked._2();
                    source = (Source)((FlowOpsMat)chunks.map((Function1 & Serializable)x$1 -> {
                        HttpEntity.ChunkStreamPart chunkStreamPart = x$1;
                        if (chunkStreamPart instanceof HttpEntity.Chunk) {
                            HttpEntity.Chunk chunk = HttpEntity.Chunk$.MODULE$.unapply((HttpEntity.Chunk)chunkStreamPart);
                            ByteString byteString = chunk._1();
                            String string = chunk._2();
                            ByteString data = byteString;
                            return data;
                        }
                        if (chunkStreamPart instanceof HttpEntity.LastChunk) {
                            Seq seq;
                            HttpEntity.LastChunk lastChunk = HttpEntity.LastChunk$.MODULE$.unapply((HttpEntity.LastChunk)chunkStreamPart);
                            String string = lastChunk._1();
                            Seq trailer = seq = lastChunk._2();
                            trailerPromise.success((Object)trailer);
                            return ByteString$.MODULE$.empty();
                        }
                        throw new MatchError((Object)chunkStreamPart);
                    })).watchTermination((Function2)(JProcedure2 & Serializable)(_$5, done) -> done.onComplete((Function1 & Serializable)_$6 -> trailerPromise.trySuccess((Object)Seq$.MODULE$.empty()), ec));
                } else if (responseEntity instanceof HttpEntity.Strict) {
                    ByteString byteString;
                    HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)responseEntity);
                    ContentType contentType = strict._1();
                    ByteString data = byteString = strict._2();
                    Seq rawTrailers = (Seq)response.attribute((AttributeKey)AttributeKeys$.MODULE$.trailer(), (JavaMapping)JavaMapping$.MODULE$.attributeKey()).map((Function1 & Serializable)_$7 -> _$7.headers()).getOrElse(PekkoHttpClientUtils$::$anonfun$10);
                    Seq trailers2 = (Seq)rawTrailers.map((Function1 & Serializable)h -> RawHeader$.MODULE$.apply((String)h._1(), (String)h._2()));
                    trailerPromise.success((Object)trailers2);
                    source = Source$.MODULE$.single((Object)data);
                } else {
                    HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()), mat);
                    throw this.mapToStatusException((HttpResponse)response, (Seq<HttpHeader>)((Seq)scala.package$.MODULE$.Seq().empty()));
                }
                Source responseData = source;
                return ((Source)((Source)responseData.concat((Graph)Source$.MODULE$.maybe().mapMaterializedValue((Function1 & Serializable)promise -> promise.completeWith(completionFuture.map((Function1 & Serializable)_$8 -> None$.MODULE$, ec))))).via(new CancellationBarrierGraphStage()).via(reader.dataFrameDecoder()).map((Function1 & Serializable)bytes -> deserializer.deserialize((ByteString)bytes))).mapMaterializedValue((Function1 & Serializable)_$9 -> Future$.MODULE$.successful((Object)new GrpcResponseMetadata((HttpResponse)response, trailerPromise, ec){
                    private final HttpResponse response$4;
                    private final Promise trailerPromise$5;
                    private final ExecutionContext ec$9;
                    {
                        this.response$4 = response$5;
                        this.trailerPromise$5 = trailerPromise$6;
                        this.ec$9 = ec$12;
                    }

                    public Metadata headers() {
                        return new HeaderMetadataImpl((Seq<HttpHeader>)this.response$4.headers());
                    }

                    public org.apache.pekko.grpc.javadsl.Metadata getHeaders() {
                        return new JavaMetadataImpl(new HeaderMetadataImpl((Seq<HttpHeader>)this.response$4.headers()));
                    }

                    public Future trailers() {
                        return this.trailerPromise$5.future().map(PekkoHttpClientUtils$::org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$3$$_$trailers$$anonfun$1, this.ec$9);
                    }

                    public CompletionStage getTrailers() {
                        Future future = FutureConverters$.MODULE$.FutureOps(this.trailerPromise$5.future().map(PekkoHttpClientUtils$::org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$3$$_$getTrailers$$anonfun$1, this.ec$9));
                        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$3$$_$trailers$$anonfun$1(scala.collection.immutable.Seq ), org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$3$$_$getTrailers$$anonfun$1(scala.collection.immutable.Seq )}, serializedLambda);
                    }
                }));
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                return Source$.MODULE$.failed(e).mapMaterializedValue((Function1 & Serializable)_$11 -> Future$.MODULE$.failed(e));
            }
            throw new MatchError(try_);
        }, ec)).mapMaterializedValue((Function1 & Serializable)_$12 -> _$12.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Future<BoxedUnit> parseResponseStatus(HttpResponse response, Seq<HttpHeader> trailers) {
        Seq allHeaders = (Seq)response.headers().$plus$plus(trailers);
        Option option = allHeaders.find((Function1 & Serializable)_$13 -> {
            String string = _$13.name();
            String string2 = "grpc-status";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$14 -> _$14.value());
        if (option instanceof Some && "0".equals(((Some)option).value())) {
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return Future$.MODULE$.failed((Throwable)this.mapToStatusException(response, trailers));
    }

    private StatusRuntimeException mapToStatusException(HttpResponse response, Seq<HttpHeader> trailers) {
        Seq allHeaders = (Seq)response.headers().$plus$plus(trailers);
        io.grpc.Metadata metadata = new MetadataImpl(new HeaderMetadataImpl((Seq<HttpHeader>)allHeaders).asList()).toGoogleGrpcMetadata();
        Option option = allHeaders.find((Function1 & Serializable)_$15 -> {
            String string = _$15.name();
            String string2 = "grpc-status";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$16 -> _$16.value());
        if (None$.MODULE$.equals(option)) {
            return new StatusRuntimeException(this.mapHttpStatus(response).withDescription("No grpc-status found"), metadata);
        }
        if (option instanceof Some) {
            String statusCode = (String)((Some)option).value();
            Option description = allHeaders.find((Function1 & Serializable)_$17 -> {
                String string = _$17.name();
                String string2 = "grpc-message";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).map((Function1 & Serializable)_$18 -> _$18.value());
            return new StatusRuntimeException(Status.fromCodeValue((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(statusCode))).withDescription((String)description.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), metadata);
        }
        throw new MatchError((Object)option);
    }

    private Status mapHttpStatus(HttpResponse response) {
        StatusCode statusCode = response.status();
        StatusCodes.ClientError clientError = StatusCodes$.MODULE$.BadRequest();
        StatusCode statusCode2 = statusCode;
        if (!(clientError != null ? !clientError.equals(statusCode2) : statusCode2 != null)) {
            return Status.INTERNAL;
        }
        StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
        StatusCode statusCode3 = statusCode;
        if (!(clientError2 != null ? !clientError2.equals(statusCode3) : statusCode3 != null)) {
            return Status.UNAUTHENTICATED;
        }
        StatusCodes.ClientError clientError3 = StatusCodes$.MODULE$.Forbidden();
        StatusCode statusCode4 = statusCode;
        if (!(clientError3 != null ? !clientError3.equals(statusCode4) : statusCode4 != null)) {
            return Status.PERMISSION_DENIED;
        }
        StatusCodes.ClientError clientError4 = StatusCodes$.MODULE$.NotFound();
        StatusCode statusCode5 = statusCode;
        if (!(clientError4 != null ? !clientError4.equals(statusCode5) : statusCode5 != null)) {
            return Status.UNIMPLEMENTED;
        }
        StatusCodes.ClientError clientError5 = StatusCodes$.MODULE$.TooManyRequests();
        StatusCode statusCode6 = statusCode;
        if (!(clientError5 != null ? !clientError5.equals(statusCode6) : statusCode6 != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError = StatusCodes$.MODULE$.BadGateway();
        StatusCode statusCode7 = statusCode;
        if (!(serverError != null ? !serverError.equals(statusCode7) : statusCode7 != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError2 = StatusCodes$.MODULE$.ServiceUnavailable();
        StatusCode statusCode8 = statusCode;
        if (!(serverError2 != null ? !serverError2.equals(statusCode8) : statusCode8 != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError3 = StatusCodes$.MODULE$.GatewayTimeout();
        StatusCode statusCode9 = statusCode;
        if (!(serverError3 != null ? !serverError3.equals(statusCode9) : statusCode9 != null)) {
            return Status.UNAVAILABLE;
        }
        return Status.UNKNOWN;
    }

    private static final int $anonfun$1$$anonfun$2$$anonfun$1(GrpcClientSettings settings$3) {
        return settings$3.defaultPort();
    }

    private static final int $anonfun$1$$anonfun$2$$anonfun$2(GrpcClientSettings settings$4) {
        return settings$4.defaultPort();
    }

    private static final /* synthetic */ Future $anonfun$1(GrpcClientSettings settings$1, IntRef roundRobin$1, ExecutionContextExecutor ec$1, String host, int _$1) {
        settings$1.overrideAuthority().foreach((Function1)(JProcedure1 & Serializable)authority -> {
            String string = host;
            String string2 = authority;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        });
        return settings$1.serviceDiscovery().lookup(settings$1.serviceName(), new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()).map((Function1 & Serializable)resolved -> {
            ++roundRobin$2.elem;
            ServiceDiscovery.ResolvedTarget target = (ServiceDiscovery.ResolvedTarget)resolved.addresses().apply(roundRobin$2.elem % resolved.addresses().size());
            Option option = target.address();
            if (option instanceof Some) {
                InetAddress address = (InetAddress)((Some)option).value();
                return new InetSocketAddress(address, BoxesRunTime.unboxToInt((Object)target.port().getOrElse(() -> PekkoHttpClientUtils$.$anonfun$1$$anonfun$2$$anonfun$1(settings$1))));
            }
            if (None$.MODULE$.equals(option)) {
                return new InetSocketAddress(target.host(), BoxesRunTime.unboxToInt((Object)target.port().getOrElse(() -> PekkoHttpClientUtils$.$anonfun$1$$anonfun$2$$anonfun$2(settings$1))));
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)ec$1);
    }

    private static final String $anonfun$2(GrpcClientSettings settings$5) {
        return settings$5.serviceName();
    }

    private static final SSLContext $anonfun$3(GrpcClientSettings settings$6) {
        Option<TrustManager> option = settings$6.trustManager();
        if (None$.MODULE$.equals(option)) {
            return SSLContext.getDefault();
        }
        if (option instanceof Some) {
            TrustManager trustManager = (TrustManager)((Some)option).value();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(new KeyManager[0], new TrustManager[]{trustManager}, new SecureRandom());
            return sslContext;
        }
        throw new MatchError(option);
    }

    public final Future org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$$_$singleRequest$1(SourceQueueWithComplete queue$1, ExecutionContextExecutor ec$2, HttpRequest request) {
        Promise p = Promise$.MODULE$.apply();
        return queue$1.offer((Object)request.addAttribute(PekkoHttpClientUtils$ResponsePromise$.MODULE$.Key(), (Object)PekkoHttpClientUtils$ResponsePromise$.MODULE$.apply((Promise<HttpResponse>)p))).flatMap((Function1 & Serializable)_$2 -> p.future(), (ExecutionContext)ec$2);
    }

    public final ProtobufSerializer org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$$_$serializerFromMethodDescriptor$1(MethodDescriptor descriptor) {
        return ((WithProtobufSerializer)descriptor.getRequestMarshaller()).protobufSerializer();
    }

    public final ProtobufSerializer org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$$_$deserializerFromMethodDescriptor$1(MethodDescriptor descriptor) {
        return ((WithProtobufSerializer)descriptor.getResponseMarshaller()).protobufSerializer();
    }

    public static final /* synthetic */ Object org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$1$$_$invoke$$anonfun$1(GrpcSingleResponse _$3) {
        return _$3.value();
    }

    public static final /* synthetic */ GrpcSingleResponse org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$1$$_$invokeWithMetadata$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            GrpcResponseMetadata metadata = (GrpcResponseMetadata)tuple2._1();
            Object result = tuple2._2();
            return new GrpcSingleResponse<O>(result, metadata){
                private final Object result$1;
                private final GrpcResponseMetadata metadata$1;
                {
                    this.result$1 = result$2;
                    this.metadata$1 = metadata$2;
                }

                public Object value() {
                    return this.result$1;
                }

                public Object getValue() {
                    return this.result$1;
                }

                public Metadata headers() {
                    return this.metadata$1.headers();
                }

                public org.apache.pekko.grpc.javadsl.Metadata getHeaders() {
                    return this.metadata$1.getHeaders();
                }

                public Future trailers() {
                    return this.metadata$1.trailers();
                }

                public CompletionStage getTrailers() {
                    return this.metadata$1.getTrailers();
                }
            };
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Seq $anonfun$10() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static final /* synthetic */ HeaderMetadataImpl org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$3$$_$trailers$$anonfun$1(Seq _$10) {
        return new HeaderMetadataImpl((Seq<HttpHeader>)_$10);
    }

    public static final /* synthetic */ org.apache.pekko.grpc.javadsl.Metadata org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$anon$3$$_$getTrailers$$anonfun$1(Seq h) {
        return new JavaMetadataImpl(new HeaderMetadataImpl((Seq<HttpHeader>)h));
    }
}

