/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.GrpcResponseMetadata;
import org.apache.pekko.grpc.GrpcSingleResponse;
import org.apache.pekko.grpc.internal.CancellationBarrierGraphStage;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.MetadataImpl;
import org.apache.pekko.grpc.internal.MetadataImpl$;
import org.apache.pekko.grpc.internal.MetadataOperations;
import org.apache.pekko.grpc.internal.NettyClientUtils$;
import org.apache.pekko.grpc.scaladsl.Metadata;
import org.apache.pekko.grpc.scaladsl.SingleResponseRequestBuilder;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

@InternalApi
public final class ScalaClientStreamingRequestBuilder<I, O>
implements SingleResponseRequestBuilder<Source<I, NotUsed>, O>,
MetadataOperations<ScalaClientStreamingRequestBuilder<I, O>> {
    private final MethodDescriptor<I, O> descriptor;
    private final InternalChannel channel;
    private final CallOptions defaultOptions;
    private final GrpcClientSettings settings;
    private final MetadataImpl headers;
    private final Materializer mat;
    private final ExecutionContext ec;

    public ScalaClientStreamingRequestBuilder(MethodDescriptor<I, O> descriptor, InternalChannel channel, CallOptions defaultOptions, GrpcClientSettings settings, MetadataImpl headers, Materializer mat, ExecutionContext ec) {
        this.descriptor = descriptor;
        this.channel = channel;
        this.defaultOptions = defaultOptions;
        this.settings = settings;
        this.headers = headers;
        this.mat = mat;
        this.ec = ec;
    }

    @Override
    public MetadataImpl headers() {
        return this.headers;
    }

    @InternalStableApi
    public ScalaClientStreamingRequestBuilder(MethodDescriptor<I, O> descriptor, InternalChannel channel, CallOptions defaultOptions, GrpcClientSettings settings, Materializer mat, ExecutionContext ec) {
        this(descriptor, channel, defaultOptions, settings, MetadataImpl$.MODULE$.empty(), mat, ec);
    }

    @InternalStableApi
    public ScalaClientStreamingRequestBuilder(MethodDescriptor<I, O> descriptor, String fqMethodName, InternalChannel channel, CallOptions defaultOptions, GrpcClientSettings settings, Materializer mat, ExecutionContext ec) {
        this(descriptor, channel, defaultOptions, settings, MetadataImpl$.MODULE$.empty(), mat, ec);
    }

    private CallOptions callOptionsWithDeadline() {
        return NettyClientUtils$.MODULE$.callOptionsWithDeadline(this.defaultOptions, this.settings);
    }

    @Override
    public Future<O> invoke(Source<I, NotUsed> request) {
        return this.invokeWithMetadata(request).map((Function1 & Serializable)_$1 -> _$1.value(), ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<GrpcSingleResponse<O>> invokeWithMetadata(Source<I, NotUsed> source) {
        Future metadataFuture;
        Future future;
        block3: {
            Tuple2 tuple2;
            block2: {
                Source<O, Future<GrpcResponseMetadata>> src = this.channel.invokeWithMetadata(source, this.headers(), this.descriptor, false, this.callOptionsWithDeadline());
                tuple2 = (Tuple2)src.via(new CancellationBarrierGraphStage()).toMat((Graph)Sink$.MODULE$.head(), Keep$.MODULE$.both()).run(this.mat);
                if (tuple2 == null) break block2;
                Future future2 = (Future)tuple2._1();
                future = (Future)tuple2._2();
                if (!(future2 instanceof Future)) break block2;
                metadataFuture = future2;
                if (future instanceof Future) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Future resultFuture = future;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)metadataFuture, (Object)resultFuture);
        Future metadataFuture2 = (Future)tuple2._1();
        Future resultFuture2 = (Future)tuple2._2();
        return metadataFuture2.zip(resultFuture2).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                GrpcResponseMetadata metadata = (GrpcResponseMetadata)tuple2._1();
                Object result = tuple2._2();
                return new GrpcSingleResponse<O>(result, metadata){
                    private final Object result$1;
                    private final GrpcResponseMetadata metadata$1;
                    {
                        this.result$1 = result$2;
                        this.metadata$1 = metadata$2;
                    }

                    public Object value() {
                        return this.result$1;
                    }

                    public Object getValue() {
                        return this.result$1;
                    }

                    public Metadata headers() {
                        return this.metadata$1.headers();
                    }

                    public org.apache.pekko.grpc.javadsl.Metadata getHeaders() {
                        return this.metadata$1.getHeaders();
                    }

                    public Future trailers() {
                        return this.metadata$1.trailers();
                    }

                    public CompletionStage getTrailers() {
                        return this.metadata$1.getTrailers();
                    }
                };
            }
            throw new MatchError((Object)tuple2);
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public ScalaClientStreamingRequestBuilder<I, O> withHeaders(MetadataImpl headers) {
        return new ScalaClientStreamingRequestBuilder<I, O>(this.descriptor, this.channel, this.defaultOptions, this.settings, headers, this.mat, this.ec);
    }
}

