/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

@InternalApi
public final class UnaryCallAdapter<Res>
extends ClientCall.Listener<Res> {
    private final Promise<Res> responsePromise = Promise$.MODULE$.apply();

    public void onMessage(Res message) {
        if (!this.responsePromise.trySuccess(message)) {
            throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
        }
    }

    public void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            if (!this.responsePromise.isCompleted()) {
                this.responsePromise.tryFailure((Throwable)Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException(trailers));
                return;
            }
            return;
        }
        this.responsePromise.tryFailure((Throwable)status.asRuntimeException(trailers));
    }

    public Future<Res> future() {
        return this.responsePromise.future();
    }

    public CompletionStage<Res> cs() {
        Future future = FutureConverters$.MODULE$.FutureOps(this.future());
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }
}

