/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.javadsl;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcProtocol;
import org.apache.pekko.grpc.GrpcServiceException;
import org.apache.pekko.grpc.Trailers;
import org.apache.pekko.grpc.Trailers$;
import org.apache.pekko.grpc.internal.GrpcMetadataImpl;
import org.apache.pekko.grpc.internal.GrpcResponseHelpers$;
import org.apache.pekko.grpc.internal.MissingParameterException;
import org.apache.pekko.http.javadsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.http2.PeerClosedStreamException;
import org.apache.pekko.japi.Function;
import scala.NotImplementedError;
import scala.runtime.ModuleSerializationProxy;

@ApiMayChange
public final class GrpcExceptionHandler$
implements Serializable {
    public static final Trailers org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INTERNAL;
    public static final Trailers org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INVALID_ARGUMENT;
    public static final GrpcExceptionHandler$ MODULE$;

    private GrpcExceptionHandler$() {
    }

    static {
        MODULE$ = new GrpcExceptionHandler$();
        org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INTERNAL = Trailers$.MODULE$.apply(Status.INTERNAL);
        org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INVALID_ARGUMENT = Trailers$.MODULE$.apply(Status.INVALID_ARGUMENT);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GrpcExceptionHandler$.class);
    }

    public Function<ActorSystem, Function<Throwable, Trailers>> defaultMapper() {
        return new Function<ActorSystem, Function<Throwable, Trailers>>(){

            public Function apply(ActorSystem system) {
                return GrpcExceptionHandler$.MODULE$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$default(system);
            }
        };
    }

    public LoggingAdapter org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$log(ActorSystem system) {
        return Logging$.MODULE$.apply(system, (Object)"org.apache.pekko.grpc.javadsl.GrpcExceptionHandler", LogSource$.MODULE$.fromString());
    }

    @InternalApi
    public Function<Throwable, Trailers> org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$default(ActorSystem system) {
        return new Function<Throwable, Trailers>(system){
            private final ActorSystem system$1;
            {
                this.system$1 = system$2;
            }

            public Trailers apply(Throwable param) {
                Throwable throwable = param;
                if (throwable instanceof ExecutionException) {
                    ExecutionException e = (ExecutionException)throwable;
                    if (e.getCause() == null) {
                        return GrpcExceptionHandler$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INTERNAL;
                    }
                    return (Trailers)GrpcExceptionHandler$.MODULE$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$default(this.system$1).apply((Object)e.getCause());
                }
                if (throwable instanceof CompletionException) {
                    CompletionException e = (CompletionException)throwable;
                    if (e.getCause() == null) {
                        return GrpcExceptionHandler$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INTERNAL;
                    }
                    return (Trailers)GrpcExceptionHandler$.MODULE$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$default(this.system$1).apply((Object)e.getCause());
                }
                if (throwable instanceof GrpcServiceException) {
                    GrpcServiceException grpcException = (GrpcServiceException)((Object)throwable);
                    return Trailers$.MODULE$.apply(grpcException.status(), grpcException.metadata());
                }
                if (throwable instanceof MissingParameterException) {
                    return GrpcExceptionHandler$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INVALID_ARGUMENT;
                }
                if (throwable instanceof NotImplementedError) {
                    NotImplementedError e = (NotImplementedError)throwable;
                    return Trailers$.MODULE$.apply(Status.UNIMPLEMENTED.withDescription(e.getMessage()));
                }
                if (throwable instanceof UnsupportedOperationException) {
                    UnsupportedOperationException e = (UnsupportedOperationException)throwable;
                    return Trailers$.MODULE$.apply(Status.UNIMPLEMENTED.withDescription(e.getMessage()));
                }
                if (throwable instanceof StatusRuntimeException) {
                    StatusRuntimeException e = (StatusRuntimeException)throwable;
                    return Trailers$.MODULE$.apply(e.getStatus(), new GrpcMetadataImpl(e.getTrailers()));
                }
                if (throwable instanceof PeerClosedStreamException) {
                    PeerClosedStreamException e = (PeerClosedStreamException)throwable;
                    GrpcExceptionHandler$.MODULE$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$log(this.system$1).warning((Throwable)e, "Peer closed the stream: [{}]", (Object)e.getMessage());
                    return GrpcExceptionHandler$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INTERNAL;
                }
                Throwable other = throwable;
                GrpcExceptionHandler$.MODULE$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$log(this.system$1).error(other, "Unhandled error: [{}]", (Object)other.getMessage());
                return GrpcExceptionHandler$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$INTERNAL;
            }
        };
    }

    public HttpResponse standard(Throwable t, GrpcProtocol.GrpcProtocolWriter writer, ClassicActorSystemProvider system2) {
        return this.standard(t, (Function<ActorSystem, Function<Throwable, Trailers>>)((Function)system -> MODULE$.org$apache$pekko$grpc$javadsl$GrpcExceptionHandler$$$default((ActorSystem)system)), writer, system2);
    }

    public HttpResponse standard(Throwable t, Function<ActorSystem, Function<Throwable, Trailers>> mapper, GrpcProtocol.GrpcProtocolWriter writer, ClassicActorSystemProvider system) {
        return GrpcResponseHelpers$.MODULE$.status((Trailers)((Function)mapper.apply((Object)system.classicSystem())).apply((Object)t), writer);
    }
}

