/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.scaladsl;

import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.grpc.internal.EntryMetadataImpl;
import org.apache.pekko.grpc.internal.MetadataImpl$;
import org.apache.pekko.grpc.scaladsl.BytesEntry$;
import org.apache.pekko.grpc.scaladsl.Metadata;
import org.apache.pekko.grpc.scaladsl.MetadataBuilder$;
import org.apache.pekko.grpc.scaladsl.MetadataEntry;
import org.apache.pekko.grpc.scaladsl.StringEntry$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.util.ByteString;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;

@ApiMayChange
@DoNotInherit
public class MetadataBuilder {
    private List<Tuple2<String, MetadataEntry>> entries = package$.MODULE$.Nil();

    public static Metadata empty() {
        return MetadataBuilder$.MODULE$.empty();
    }

    public static Metadata fromHeaders(Seq<HttpHeader> seq) {
        return MetadataBuilder$.MODULE$.fromHeaders(seq);
    }

    public MetadataBuilder addText(String key, String value) {
        if (key.endsWith(MetadataImpl$.MODULE$.BINARY_SUFFIX())) {
            throw new IllegalArgumentException(new StringBuilder(40).append("String header names must not end with '").append(MetadataImpl$.MODULE$.BINARY_SUFFIX()).append("'").toString());
        }
        return this.addEntry(key, StringEntry$.MODULE$.apply(value));
    }

    public MetadataBuilder addBinary(String key, ByteString value) {
        if (!key.endsWith(MetadataImpl$.MODULE$.BINARY_SUFFIX())) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Binary header names must end with '").append(MetadataImpl$.MODULE$.BINARY_SUFFIX()).append("'").toString());
        }
        return this.addEntry(key, BytesEntry$.MODULE$.apply(value));
    }

    public Metadata build() {
        return new EntryMetadataImpl((List<Tuple2<String, MetadataEntry>>)this.entries.reverse());
    }

    private MetadataBuilder addEntry(String key, MetadataEntry entry) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)key, (Object)entry);
        this.entries = this.entries.$colon$colon((Object)tuple2);
        return this;
    }
}

