/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.caching;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.http.caching.CacheJavaMapping$Implicits$CachingSettings$;
import org.apache.pekko.http.caching.LfuCache;
import org.apache.pekko.http.caching.scaladsl.Cache;
import org.apache.pekko.http.caching.scaladsl.CachingSettings;
import org.apache.pekko.http.caching.scaladsl.CachingSettings$;
import org.apache.pekko.http.caching.scaladsl.LfuCacheSettings;
import org.apache.pekko.http.impl.util.J2SMapping;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.util.FunctionConverters$;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.Predef$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.FunctionWrappers;
import scala.runtime.ModuleSerializationProxy;

@ApiMayChange
public final class LfuCache$
implements Serializable {
    public static final LfuCache$ MODULE$ = new LfuCache$();

    private LfuCache$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LfuCache$.class);
    }

    public <K, V> Cache<K, V> apply(ActorSystem system) {
        return this.apply((CachingSettings)CachingSettings$.MODULE$.apply(system));
    }

    public <K, V> Cache<K, V> apply(CachingSettings cachingSettings) {
        LfuCacheSettings settings = cachingSettings.lfuCacheSettings();
        Predef$.MODULE$.require(settings.maxCapacity() >= 0, this::apply$$anonfun$1);
        Predef$.MODULE$.require(settings.initialCapacity() <= settings.maxCapacity(), this::apply$$anonfun$2);
        if (settings.timeToLive().isFinite() || settings.timeToIdle().isFinite()) {
            return this.expiringLfuCache(Int$.MODULE$.int2long(settings.maxCapacity()), settings.initialCapacity(), settings.timeToLive(), settings.timeToIdle());
        }
        return this.simpleLfuCache(settings.maxCapacity(), settings.initialCapacity());
    }

    public <K, V> org.apache.pekko.http.caching.javadsl.Cache<K, V> create(ActorSystem system) {
        return this.apply(system);
    }

    public <K, V> org.apache.pekko.http.caching.javadsl.Cache<K, V> create(org.apache.pekko.http.caching.javadsl.CachingSettings settings) {
        return this.apply((CachingSettings)JavaMapping.Implicits$.MODULE$.AddAsScala((Object)settings, (J2SMapping)CacheJavaMapping$Implicits$CachingSettings$.MODULE$).asScala());
    }

    private <K, V> LfuCache<K, V> simpleLfuCache(int maxCapacity, int initialCapacity) {
        AsyncCache store = Caffeine.newBuilder().initialCapacity(initialCapacity).maximumSize(Int$.MODULE$.int2long(maxCapacity)).buildAsync();
        return new LfuCache(store);
    }

    private <K, V> LfuCache<K, V> expiringLfuCache(long maxCapacity, int initialCapacity, Duration timeToLive, Duration timeToIdle) {
        Predef$.MODULE$.require(!timeToLive.isFinite() || !timeToIdle.isFinite() || timeToLive.$greater$eq((Object)timeToIdle), () -> this.expiringLfuCache$$anonfun$1(timeToLive, timeToIdle));
        Caffeine builder = Caffeine.newBuilder().initialCapacity(initialCapacity).maximumSize(maxCapacity);
        AsyncCache store = ((Caffeine)this.ttl$1(timeToLive).andThen(this.tti$1(timeToIdle)).apply((Object)builder)).buildAsync();
        return new LfuCache(store);
    }

    public <K, V> BiFunction<K, Executor, CompletableFuture<V>> toJavaMappingFunction(Function0<Future<V>> genValue) {
        Function2 function2 = FunctionConverters$.MODULE$.enrichAsJavaBiFunction((Function2 & Serializable)(_$1, _$2) -> {
            Future future = FutureConverters$.MODULE$.FutureOps((Future)genValue.apply());
            return FutureConverters.FutureOps$.MODULE$.asJava$extension(future).toCompletableFuture();
        });
        return FunctionWrappers.RichFunction2AsBiFunction$.MODULE$.asJava$extension(function2);
    }

    public <K, V> BiFunction<K, Executor, CompletableFuture<V>> toJavaMappingFunction(Function1<K, Future<V>> loadValue) {
        Function2 function2 = FunctionConverters$.MODULE$.enrichAsJavaBiFunction((Function2 & Serializable)(k, _$3) -> {
            Future future = FutureConverters$.MODULE$.FutureOps((Future)loadValue.apply(k));
            return FutureConverters.FutureOps$.MODULE$.asJava$extension(future).toCompletableFuture();
        });
        return FunctionWrappers.RichFunction2AsBiFunction$.MODULE$.asJava$extension(function2);
    }

    private final Object apply$$anonfun$1() {
        return "maxCapacity must not be negative";
    }

    private final Object apply$$anonfun$2() {
        return "initialCapacity must be <= maxCapacity";
    }

    private final Object expiringLfuCache$$anonfun$1(Duration timeToLive$1, Duration timeToIdle$1) {
        return new StringBuilder(41).append("timeToLive(").append(timeToLive$1).append(") must be >= than timeToIdle(").append(timeToIdle$1).append(")").toString();
    }

    private final Function1 ttl$1(Duration timeToLive$2) {
        return (Function1 & Serializable)builder -> {
            if (timeToLive$2.isFinite()) {
                return builder.expireAfterWrite(timeToLive$2.toMillis(), TimeUnit.MILLISECONDS);
            }
            return builder;
        };
    }

    private final Function1 tti$1(Duration timeToIdle$2) {
        return (Function1 & Serializable)builder -> {
            if (timeToIdle$2.isFinite()) {
                return builder.expireAfterAccess(timeToIdle$2.toMillis(), TimeUnit.MILLISECONDS);
            }
            return builder;
        };
    }
}

