/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.marshallers.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.pekko.http.javadsl.marshalling.Marshaller;
import org.apache.pekko.http.javadsl.model.HttpEntity;
import org.apache.pekko.http.javadsl.model.MediaType;
import org.apache.pekko.http.javadsl.model.MediaTypes;
import org.apache.pekko.http.javadsl.model.RequestEntity;
import org.apache.pekko.http.javadsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.ExceptionWithErrorInfo;
import org.apache.pekko.util.ByteString;

public class Jackson {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});

    public static <T> Marshaller<T, RequestEntity> marshaller() {
        return Jackson.marshaller(defaultObjectMapper);
    }

    public static <T> Marshaller<T, RequestEntity> marshaller(ObjectMapper objectMapper) {
        return Marshaller.wrapEntity(object -> Jackson.toJSON(objectMapper, object), (Marshaller)Marshaller.stringToEntity(), (MediaType)MediaTypes.APPLICATION_JSON);
    }

    public static <T> Unmarshaller<ByteString, T> byteStringUnmarshaller(Class<T> clazz) {
        return Jackson.byteStringUnmarshaller(defaultObjectMapper, clazz);
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(Class<T> clazz) {
        return Jackson.unmarshaller(defaultObjectMapper, clazz);
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(ObjectMapper objectMapper, Class<T> clazz) {
        return Unmarshaller.forMediaType((MediaType)MediaTypes.APPLICATION_JSON, (Unmarshaller)Unmarshaller.entityToString()).thenApply(string -> Jackson.fromJSON(objectMapper, string, clazz));
    }

    public static <T> Unmarshaller<ByteString, T> byteStringUnmarshaller(ObjectMapper objectMapper, Class<T> clazz) {
        return Unmarshaller.sync(byteString -> Jackson.fromJSON(objectMapper, byteString.utf8String(), clazz));
    }

    private static String toJSON(ObjectMapper objectMapper, Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalArgumentException("Cannot marshal to JSON: " + object, jsonProcessingException);
        }
    }

    private static <T> T fromJSON(ObjectMapper objectMapper, String string, Class<T> clazz) {
        try {
            return (T)objectMapper.readerFor(clazz).readValue(string);
        }
        catch (IOException iOException) {
            throw new JacksonUnmarshallingException(clazz, iOException);
        }
    }

    public static class JacksonUnmarshallingException
    extends ExceptionWithErrorInfo {
        public JacksonUnmarshallingException(Class<?> clazz, IOException iOException) {
            super(new ErrorInfo("Cannot unmarshal JSON as " + clazz.getSimpleName(), iOException.getMessage()), (Throwable)iOException);
        }
    }
}

