/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.testkit;

import java.io.Serializable;
import java.util.List;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.S2JMapping;
import org.apache.pekko.http.impl.util.S2JMapping$;
import org.apache.pekko.http.impl.util.package;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.javadsl.model.ContentType;
import org.apache.pekko.http.javadsl.model.HttpEntity;
import org.apache.pekko.http.javadsl.model.HttpHeader;
import org.apache.pekko.http.javadsl.model.MediaType;
import org.apache.pekko.http.javadsl.model.RequestEntity;
import org.apache.pekko.http.javadsl.model.StatusCode;
import org.apache.pekko.http.javadsl.model.StatusCodes;
import org.apache.pekko.http.javadsl.server.RouteResult;
import org.apache.pekko.http.javadsl.server.RoutingJavaMapping;
import org.apache.pekko.http.javadsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public abstract class TestRouteResult {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(TestRouteResult.class.getDeclaredField("response$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TestRouteResult.class.getDeclaredField("entity$lzy1"));
    private final Future<RouteResult> _result;
    private final FiniteDuration awaitAtMost;
    private final ExecutionContext ec;
    private final Materializer materializer;
    private volatile Object entity$lzy1;
    private volatile Object response$lzy1;

    public TestRouteResult(Future<RouteResult> _result, FiniteDuration awaitAtMost, ExecutionContext ec, Materializer materializer) {
        this._result = _result;
        this.awaitAtMost = awaitAtMost;
        this.ec = ec;
        this.materializer = materializer;
    }

    private HttpResponse _response() {
        Future future = package$.MODULE$.AddFutureAwaitResult(this._result);
        RouteResult routeResult = (RouteResult)package.AddFutureAwaitResult$.MODULE$.awaitResult$extension(future, (Duration)this.awaitAtMost);
        if (routeResult instanceof RouteResult.Complete) {
            HttpResponse httpResponse;
            RouteResult.Complete complete = RouteResult.Complete$.MODULE$.unapply((RouteResult.Complete)routeResult);
            HttpResponse r = httpResponse = complete._1();
            return r;
        }
        if (routeResult instanceof RouteResult.Rejected) {
            scala.collection.immutable.Seq seq;
            RouteResult.Rejected rejected = RouteResult.Rejected$.MODULE$.unapply((RouteResult.Rejected)routeResult);
            scala.collection.immutable.Seq rejections = seq = rejected._1();
            throw this.doFail(new StringBuilder(58).append("Expected route to complete, but was instead rejected with ").append(rejections).toString());
        }
        throw new MatchError((Object)routeResult);
    }

    private scala.collection.immutable.Seq<Rejection> _rejections() {
        Future future = package$.MODULE$.AddFutureAwaitResult(this._result);
        RouteResult routeResult = (RouteResult)package.AddFutureAwaitResult$.MODULE$.awaitResult$extension(future, (Duration)this.awaitAtMost);
        if (routeResult instanceof RouteResult.Complete) {
            HttpResponse httpResponse;
            RouteResult.Complete complete = RouteResult.Complete$.MODULE$.unapply((RouteResult.Complete)routeResult);
            HttpResponse r = httpResponse = complete._1();
            throw this.doFail(new StringBuilder(39).append("Request was not rejected, response was ").append(r).toString());
        }
        if (routeResult instanceof RouteResult.Rejected) {
            scala.collection.immutable.Seq seq;
            RouteResult.Rejected rejected = RouteResult.Rejected$.MODULE$.unapply((RouteResult.Rejected)routeResult);
            scala.collection.immutable.Seq ex = seq = rejected._1();
            return ex;
        }
        throw new MatchError((Object)routeResult);
    }

    public HttpEntity.Strict entity() {
        Object object = this.entity$lzy1;
        if (object instanceof HttpEntity.Strict) {
            return (HttpEntity.Strict)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (HttpEntity.Strict)this.entity$lzyINIT1();
    }

    private Object entity$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.entity$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    HttpEntity.Strict strict = null;
                    try {
                        Future future = package$.MODULE$.AddFutureAwaitResult(this._response().entity().toStrict(this.awaitAtMost, this.materializer));
                        strict = (HttpEntity.Strict)package.AddFutureAwaitResult$.MODULE$.awaitResult$extension(future, (Duration)this.awaitAtMost);
                        object2 = strict == null ? LazyVals.NullValue$.MODULE$ : strict;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.entity$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.entity$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return strict;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public HttpResponse response() {
        Object object = this.response$lzy1;
        if (object instanceof HttpResponse) {
            return (HttpResponse)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (HttpResponse)this.response$lzyINIT1();
    }

    private Object response$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.response$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = this._response().withEntity((RequestEntity)this.entity());
                        object2 = httpResponse == null ? LazyVals.NullValue$.MODULE$ : httpResponse;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.response$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return httpResponse;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ContentType contentType() {
        return this._response().entity().contentType();
    }

    public String contentTypeString() {
        return this.contentType().toString();
    }

    public MediaType mediaType() {
        return this.contentType().mediaType();
    }

    public String mediaTypeString() {
        return this.mediaType().toString();
    }

    public ByteString entityBytes() {
        return this.entity().getData();
    }

    public <T> T entity(Unmarshaller<HttpEntity, T> unmarshaller) {
        Future future = package$.MODULE$.AddFutureAwaitResult(Unmarshal$.MODULE$.apply((Object)this.response().entity()).to(unmarshaller.asScala(), this.ec, this.materializer));
        return (T)package.AddFutureAwaitResult$.MODULE$.awaitResult$extension(future, (Duration)this.awaitAtMost);
    }

    public String entityString() {
        return this.entity().getData().utf8String();
    }

    public StatusCode status() {
        return (StatusCode)JavaMapping.Implicits$.MODULE$.AddAsJava((Object)this.response().status(), S2JMapping$.MODULE$.fromScalaMapping((JavaMapping)JavaMapping.StatusCode$.MODULE$)).asJava();
    }

    public int statusCode() {
        return this.response().status().intValue();
    }

    public <T extends HttpHeader> T header(Class<T> clazz) {
        return (T)((HttpHeader)this.response().header(ClassTag$.MODULE$.apply(clazz)).getOrElse(() -> this.header$$anonfun$1(clazz)));
    }

    public List<org.apache.pekko.http.javadsl.server.Rejection> rejections() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this._rejections().map((Function1 & Serializable)_$1 -> (org.apache.pekko.http.javadsl.server.Rejection)JavaMapping.Implicits$.MODULE$.AddAsJava(_$1, (S2JMapping)RoutingJavaMapping.Rejection$.MODULE$).asJava())).asJava();
    }

    public org.apache.pekko.http.javadsl.server.Rejection rejection() {
        List<org.apache.pekko.http.javadsl.server.Rejection> r = this.rejections();
        if (r.size() == 1) {
            return r.get(0);
        }
        throw this.doFail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected a single rejection but got %s (%s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)r.size()), r})));
    }

    public TestRouteResult assertStatusCode(int expected) {
        return this.assertStatusCode(StatusCodes.get((int)expected));
    }

    public TestRouteResult assertStatusCode(StatusCode expected) {
        return this.assertEqualsKind(expected, this.status(), "status code");
    }

    public TestRouteResult assertMediaType(String expected) {
        return this.assertEqualsKind(expected, this.mediaTypeString(), "media type");
    }

    public TestRouteResult assertMediaType(MediaType expected) {
        return this.assertEqualsKind(expected, this.mediaType(), "media type");
    }

    public TestRouteResult assertContentType(String expected) {
        return this.assertEqualsKind(expected, this.contentTypeString(), "content type");
    }

    public TestRouteResult assertContentType(ContentType expected) {
        return this.assertEqualsKind(expected, this.contentType(), "content type");
    }

    public TestRouteResult assertEntity(String expected) {
        return this.assertEqualsKind(expected, this.entityString(), "entity");
    }

    public TestRouteResult assertEntityBytes(ByteString expected) {
        return this.assertEqualsKind(expected, this.entityBytes(), "entity");
    }

    public <T> TestRouteResult assertEntityAs(Unmarshaller<HttpEntity, T> unmarshaller, T expected) {
        return this.assertEqualsKind(expected, this.entity(unmarshaller), "entity");
    }

    public TestRouteResult assertHeaderKindExists(String name) {
        String lowercased = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(name));
        this.assertTrue(this.response().headers().exists((Function1 & Serializable)_$2 -> _$2.is(lowercased)), new StringBuilder(31).append("Expected `").append(name).append("` header was missing.").toString());
        return this;
    }

    public TestRouteResult assertHeaderKindNotExists(String name) {
        String lowercased = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(name));
        this.assertTrue(this.response().headers().forall((Function1 & Serializable)_$3 -> !_$3.is(lowercased)), new StringBuilder(37).append("`").append(name).append("` header was not expected to appear.").toString());
        return this;
    }

    public TestRouteResult assertHeaderExists(String name, String value) {
        String lowercased = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(name));
        scala.collection.immutable.Seq headers = (scala.collection.immutable.Seq)this.response().headers().filter((Function1 & Serializable)_$4 -> _$4.is(lowercased));
        if (headers.isEmpty()) {
            this.fail(new StringBuilder(31).append("Expected `").append(name).append("` header was missing.").toString());
        } else {
            this.assertTrue(headers.exists((Function1 & Serializable)_$5 -> {
                String string = _$5.value();
                String string2 = value;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }), new StringBuilder(60).append("`").append(name).append("` header was found but had the wrong value. Found headers: ").append(headers.mkString(", ")).toString());
        }
        return this;
    }

    public TestRouteResult assertHeaderExists(HttpHeader expected) {
        return this.assertHeaderExists(expected.name(), expected.value());
    }

    public TestRouteResult assertRejections(scala.collection.immutable.Seq<org.apache.pekko.http.javadsl.server.Rejection> expectedRejections) {
        Object object = JavaConverters$.MODULE$.asScalaBufferConverter(this.rejections()).asScala();
        scala.collection.immutable.Seq seq = expectedRejections.toSeq();
        if (!(object != null ? !object.equals(seq) : seq != null)) {
            return this;
        }
        throw this.doFail(new StringBuilder(53).append("Expected rejections [").append(expectedRejections.mkString(",")).append("], but rejected with [").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.rejections()).asScala()).mkString(",")).append("] instead.").toString());
    }

    public TestRouteResult assertRejections(org.apache.pekko.http.javadsl.server.Rejection ... expectedRejections) {
        return this.assertRejections((scala.collection.immutable.Seq<org.apache.pekko.http.javadsl.server.Rejection>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expectedRejections));
    }

    public TestRouteResult assertEqualsKind(Object expected, Object actual, String kind) {
        this.assertEquals(expected, actual, new StringBuilder(12).append("Unexpected ").append(kind).append("!").toString());
        return this;
    }

    public TestRouteResult assertEqualsKind(int expected, int actual, String kind) {
        this.assertEquals(expected, actual, new StringBuilder(12).append("Unexpected ").append(kind).append("!").toString());
        return this;
    }

    private Nothing$ doFail(String message) {
        this.fail(message);
        throw new IllegalStateException("Shouldn't be reached");
    }

    public abstract void fail(String var1);

    public abstract void assertEquals(Object var1, Object var2, String var3);

    public abstract void assertEquals(int var1, int var2, String var3);

    public abstract void assertTrue(boolean var1, String var2);

    private final Null$ header$$anonfun$1(Class clazz$1) {
        throw this.doFail(new StringBuilder(42).append("Expected header of type ").append(clazz$1.getSimpleName()).append(" but wasn't found.").toString());
    }
}

