/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server;

import java.io.Serializable;
import java.util.UUID;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.server.PathMatcher;
import org.apache.pekko.http.scaladsl.server.PathMatcher$;
import org.apache.pekko.http.scaladsl.server.PathMatcher$Lift$;
import org.apache.pekko.http.scaladsl.server.PathMatcher$Lift$MOps$;
import org.apache.pekko.http.scaladsl.server.PathMatcher$Matched$;
import org.apache.pekko.http.scaladsl.server.PathMatcher$Unmatched$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$HexIntNumber$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$HexLongNumber$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$IntNumber$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$LongNumber$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$PathEnd$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$Remaining$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$RemainingPath$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$Segment$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$Slash$;
import org.apache.pekko.http.scaladsl.server.util.Tuple;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps$Join$;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple1;
import scala.Tuple1$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Integral;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;

public interface PathMatchers {
    public static final long OFFSET$_m_8 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("Segment$lzy1"));
    public static final long OFFSET$_m_7 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("HexLongNumber$lzy1"));
    public static final long OFFSET$_m_6 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("HexIntNumber$lzy1"));
    public static final long OFFSET$_m_5 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("LongNumber$lzy1"));
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("IntNumber$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("RemainingPath$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("Remaining$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("PathEnd$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(PathMatchers$.class.getDeclaredField("Slash$lzy1"));

    public static void $init$(PathMatchers $this) {
        $this.org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$DoubleNumber_$eq(PathMatcher$.MODULE$.PathMatcher1Ops(PathMatcher$.MODULE$.apply(PathMatcher$.MODULE$._regex2PathMatcher(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[+-]?\\d*\\.?\\d*"))))).flatMap((Function1 & Serializable)string -> {
            None$ none$;
            try {
                none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.parseDouble(string)));
            }
            catch (NumberFormatException numberFormatException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }));
        $this.org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$JavaUUID_$eq(PathMatcher$.MODULE$.PathMatcher1Ops(PathMatcher$.MODULE$.apply(PathMatcher$.MODULE$._regex2PathMatcher(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}"))))).map((Function1 & Serializable)x$0 -> UUID.fromString(x$0)));
        $this.org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$Neutral_$eq(PathMatcher$.MODULE$.provide(BoxedUnit.UNIT, Tuple$.MODULE$.forUnit()));
        $this.org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$Segments_$eq($this.Segments(0, 128));
    }

    public static PathMatcher not$(PathMatchers $this, PathMatcher self) {
        return $this.not(self);
    }

    default public PathMatcher<BoxedUnit> not(PathMatcher<?> self) {
        return new PathMatcher<BoxedUnit>(self){
            private final PathMatcher self$1;
            {
                this.self$1 = self$2;
                super(Tuple$.MODULE$.forUnit());
            }

            public PathMatcher.Matching apply(Uri.Path path) {
                return this.self$1.apply(path) == PathMatcher$Unmatched$.MODULE$ ? PathMatcher$Matched$.MODULE$.apply(path, BoxedUnit.UNIT, this.ev()) : PathMatcher$Unmatched$.MODULE$;
            }
        };
    }

    public static PathMatcher separateOnSlashes$(PathMatchers $this, String string) {
        return $this.separateOnSlashes(string);
    }

    default public PathMatcher<BoxedUnit> separateOnSlashes(String string) {
        return PathMatchers.split$1(string, PathMatchers.split$default$1$1(), PathMatchers.split$default$2$1());
    }

    public static PathMatchers$Slash$ Slash$(PathMatchers $this) {
        return $this.Slash();
    }

    default public PathMatchers$Slash$ Slash() {
        return new PathMatchers$Slash$(this);
    }

    public static PathMatchers$PathEnd$ PathEnd$(PathMatchers $this) {
        return $this.PathEnd();
    }

    default public PathMatchers$PathEnd$ PathEnd() {
        return new PathMatchers$PathEnd$(this);
    }

    public static PathMatchers$Remaining$ Remaining$(PathMatchers $this) {
        return $this.Remaining();
    }

    default public PathMatchers$Remaining$ Remaining() {
        return new PathMatchers$Remaining$(this);
    }

    public static PathMatchers$RemainingPath$ RemainingPath$(PathMatchers $this) {
        return $this.RemainingPath();
    }

    default public PathMatchers$RemainingPath$ RemainingPath() {
        return new PathMatchers$RemainingPath$(this);
    }

    public static PathMatchers$IntNumber$ IntNumber$(PathMatchers $this) {
        return $this.IntNumber();
    }

    default public PathMatchers$IntNumber$ IntNumber() {
        return new PathMatchers$IntNumber$(this);
    }

    public static PathMatchers$LongNumber$ LongNumber$(PathMatchers $this) {
        return $this.LongNumber();
    }

    default public PathMatchers$LongNumber$ LongNumber() {
        return new PathMatchers$LongNumber$(this);
    }

    public static PathMatchers$HexIntNumber$ HexIntNumber$(PathMatchers $this) {
        return $this.HexIntNumber();
    }

    default public PathMatchers$HexIntNumber$ HexIntNumber() {
        return new PathMatchers$HexIntNumber$(this);
    }

    public static PathMatchers$HexLongNumber$ HexLongNumber$(PathMatchers $this) {
        return $this.HexLongNumber();
    }

    default public PathMatchers$HexLongNumber$ HexLongNumber() {
        return new PathMatchers$HexLongNumber$(this);
    }

    public PathMatcher<Tuple1<Object>> DoubleNumber();

    public void org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$DoubleNumber_$eq(PathMatcher var1);

    public PathMatcher<Tuple1<UUID>> JavaUUID();

    public void org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$JavaUUID_$eq(PathMatcher var1);

    public PathMatcher<BoxedUnit> Neutral();

    public void org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$Neutral_$eq(PathMatcher var1);

    public static PathMatchers$Segment$ Segment$(PathMatchers $this) {
        return $this.Segment();
    }

    default public PathMatchers$Segment$ Segment() {
        return new PathMatchers$Segment$(this);
    }

    public PathMatcher<Tuple1<List<String>>> Segments();

    public void org$apache$pekko$http$scaladsl$server$PathMatchers$_setter_$Segments_$eq(PathMatcher var1);

    public static PathMatcher Segments$(PathMatchers $this, int count) {
        return $this.Segments(count);
    }

    default public PathMatcher<Tuple1<List<String>>> Segments(int count) {
        return this.Segment().repeat(count, this.Slash(), PathMatcher$Lift$.MODULE$.liftSingleElement(PathMatcher$Lift$MOps$.MODULE$.ListMOps()));
    }

    public static PathMatcher Segments$(PathMatchers $this, int min, int max) {
        return $this.Segments(min, max);
    }

    default public PathMatcher<Tuple1<List<String>>> Segments(int min, int max) {
        return this.Segment().repeat(min, max, this.Slash(), PathMatcher$Lift$.MODULE$.liftSingleElement(PathMatcher$Lift$MOps$.MODULE$.ListMOps()));
    }

    public static PathMatcher nothingMatcher$(PathMatchers $this, Tuple evidence$13) {
        return $this.nothingMatcher(evidence$13);
    }

    default public <L> PathMatcher<L> nothingMatcher(Tuple<L> evidence$13) {
        return new PathMatcher<L>((Tuple)evidence$13){

            public PathMatcher.Matching apply(Uri.Path p) {
                return PathMatcher$Unmatched$.MODULE$;
            }
        };
    }

    private static PathMatcher append$1(PathMatcher matcher$tailLocal1$1, PathMatcher m) {
        if (matcher$tailLocal1$1 == null) {
            return m;
        }
        return matcher$tailLocal1$1.$div(m, TupleOps$Join$.MODULE$.join0P());
    }

    private static PathMatcher split$1(String string$1, int ix, PathMatcher matcher) {
        int nextIx;
        while ((nextIx = string$1.indexOf(47, ix)) >= 0) {
            int n = nextIx + 1;
            PathMatcher pathMatcher = PathMatchers.append$1(matcher, PathMatcher$.MODULE$._segmentStringToPathMatcher(string$1.substring(ix, nextIx)));
            ix = n;
            matcher = pathMatcher;
        }
        return PathMatchers.append$1(matcher, PathMatcher$.MODULE$._segmentStringToPathMatcher(string$1.substring(ix)));
    }

    private static int split$default$1$1() {
        return 0;
    }

    private static PathMatcher split$default$2$1() {
        return null;
    }

    public static int org$apache$pekko$http$scaladsl$server$PathMatchers$NumberMatcher$$_$digits$default$1$1() {
        return 0;
    }

    public abstract class NumberMatcher<T>
    extends PathMatcher<Tuple1<T>> {
        private final T max;
        private final T base;
        private final Integral<T> x;
        private final Object minusOne;
        private final Object maxDivBase;
        private final /* synthetic */ PathMatchers $outer;

        public NumberMatcher(PathMatchers $outer, T max, T base, Integral<T> x) {
            this.max = max;
            this.base = base;
            this.x = x;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(Tuple$.MODULE$.forTuple1());
            this.minusOne = x.mkNumericOps(x.zero()).$minus(x.one());
            this.maxDivBase = x.mkNumericOps(max).$div(base);
        }

        public T minusOne() {
            return (T)this.minusOne;
        }

        public T maxDivBase() {
            return (T)this.maxDivBase;
        }

        public PathMatcher.Matching<Tuple1<T>> apply(Uri.Path path) {
            Uri.Path path2 = path;
            if (path2 instanceof Uri.Path$.Segment) {
                Uri.Path$.Segment segment = Uri.Path$.Segment$.MODULE$.unapply((Uri.Path$.Segment)path2);
                String string = segment._1();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
                String segment2 = string;
                Uri.Path.SlashOrEmpty tail = slashOrEmpty;
                return this.digits$1(segment2, tail, PathMatchers.org$apache$pekko$http$scaladsl$server$PathMatchers$NumberMatcher$$_$digits$default$1$1(), this.digits$default$2$1());
            }
            return PathMatcher$Unmatched$.MODULE$;
        }

        public abstract T fromChar(char var1);

        public T fromDecimalChar(char c) {
            if ('0' <= c && c <= '9') {
                return (T)this.x.fromInt(c - 48);
            }
            return this.minusOne();
        }

        public T fromHexChar(char c) {
            if ('0' <= c && c <= '9') {
                return (T)this.x.fromInt(c - 48);
            }
            int cn = c | 0x20;
            if (97 <= cn && cn <= 102) {
                return (T)this.x.fromInt(cn - 97 + 10);
            }
            return this.minusOne();
        }

        public final /* synthetic */ PathMatchers org$apache$pekko$http$scaladsl$server$PathMatchers$NumberMatcher$$$outer() {
            return this.$outer;
        }

        private final PathMatcher.Matching digits$1(String segment$4, Uri.Path.SlashOrEmpty tail$1, int ix, Object value) {
            while (true) {
                T a;
                T t = a = ix < segment$4.length() ? this.fromChar(segment$4.charAt(ix)) : this.minusOne();
                if (BoxesRunTime.equals(a, this.minusOne())) {
                    PathMatcher.Matching matching;
                    if (BoxesRunTime.equals((Object)value, this.minusOne())) {
                        matching = PathMatcher$Unmatched$.MODULE$;
                    } else {
                        Uri.Path.SlashOrEmpty slashOrEmpty;
                        if (ix < segment$4.length()) {
                            String string = segment$4.substring(ix);
                            slashOrEmpty = tail$1.$colon$colon(string);
                        } else {
                            slashOrEmpty = tail$1;
                        }
                        matching = PathMatcher$Matched$.MODULE$.apply((Uri.Path)slashOrEmpty, Tuple1$.MODULE$.apply(value), this.ev());
                    }
                    return matching;
                }
                if (BoxesRunTime.equals((Object)value, this.minusOne())) {
                    int n = ix + 1;
                    T t2 = a;
                    ix = n;
                    value = t2;
                    continue;
                }
                if (!this.x.mkOrderingOps(value).$less$eq(this.maxDivBase()) || !this.x.mkOrderingOps(this.x.mkNumericOps(value).$times(this.base)).$less$eq(this.x.mkNumericOps(this.max).$minus(a))) break;
                int n = ix + 1;
                Object object = this.x.mkNumericOps(this.x.mkNumericOps(value).$times(this.base)).$plus(a);
                ix = n;
                value = object;
            }
            return PathMatcher$Unmatched$.MODULE$;
        }

        private final Object digits$default$2$1() {
            return this.minusOne();
        }
    }
}

