/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ByteContentRange;
import org.apache.pekko.http.scaladsl.model.ContentRange;
import org.apache.pekko.http.scaladsl.model.ContentRange$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.OptHttpResponse$;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.UniversalEntity;
import org.apache.pekko.http.scaladsl.model.headers.ByteRange;
import org.apache.pekko.http.scaladsl.model.headers.Content;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusRange$;
import org.apache.pekko.http.scaladsl.model.headers.Range;
import org.apache.pekko.http.scaladsl.model.headers.Range$;
import org.apache.pekko.http.scaladsl.model.headers.RangeUnit;
import org.apache.pekko.http.scaladsl.model.headers.RangeUnits;
import org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directive$SingleValueTransformers$;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.RouteResult$Complete$;
import org.apache.pekko.http.scaladsl.server.StandardRoute$;
import org.apache.pekko.http.scaladsl.server.TooManyRangesRejection$;
import org.apache.pekko.http.scaladsl.server.UnsatisfiableRangeRejection$;
import org.apache.pekko.http.scaladsl.server.directives.BasicDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.MethodDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.RangeDirectives;
import org.apache.pekko.http.scaladsl.server.directives.RangeDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.RouteDirectives$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps$Join$;
import org.apache.pekko.http.scaladsl.settings.RoutingSettings;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.OverflowStrategy$;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.UniformFanOutShape;
import org.apache.pekko.stream.scaladsl.Broadcast$;
import org.apache.pekko.stream.scaladsl.Concat$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public interface RangeDirectives {
    public static Directive withRangeSupport$(RangeDirectives $this) {
        return $this.withRangeSupport();
    }

    default public Directive<BoxedUnit> withRangeSupport() {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequestContext());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)ctx2 -> {
            RoutingSettings settings = ctx2.settings();
            LoggingAdapter log = ctx2.log();
            Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extract((Function1 & Serializable)ctx -> RangeDirectives.rangeHeaderOfGetRequests$1(ctx)));
            return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
                Range range;
                Option option = x$1;
                if (option instanceof Some && (range = (Range)((Some)option).value()) != null) {
                    Range range2 = Range$.MODULE$.unapply(range);
                    RangeUnit rangeUnit = range2._1();
                    Seq seq = range2._2();
                    if (RangeUnits.Bytes$.MODULE$.equals(rangeUnit)) {
                        Seq ranges = seq;
                        if (ranges.size() <= settings.rangeCountLimit()) {
                            return (Directive)this.applyRanges$1(settings, log, ranges).$amp(ConjunctionMagnet$.MODULE$.fromDirective(RangeDirectives$.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$$respondWithAcceptByteRangesHeader, TupleOps$Join$.MODULE$.join0P()));
                        }
                        return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{TooManyRangesRejection$.MODULE$.apply(settings.rangeCountLimit())})), Tuple$.MODULE$.forUnit());
                    }
                }
                return ((Directive)MethodDirectives$.MODULE$.get().$amp(ConjunctionMagnet$.MODULE$.fromDirective(RangeDirectives$.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$$respondWithAcceptByteRangesHeader, TupleOps$Join$.MODULE$.join0P()))).$bar(BasicDirectives$.MODULE$.pass());
            }, Tuple$.MODULE$.forUnit());
        }, Tuple$.MODULE$.forUnit());
    }

    private IndexRange.1 indexRange$1(long entityLength, ByteRange range) {
        public class Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 {
            private final long start;
            private final long end;
            private final /* synthetic */ RangeDirectives $outer;

            public Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1(RangeDirectives $outer, long start, long end) {
                this.start = start;
                this.end = end;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public long start() {
                return this.start;
            }

            public long end() {
                return this.end;
            }

            public long length() {
                return this.end() - this.start();
            }

            public UniversalEntity apply(UniversalEntity entity) {
                return entity.transformDataBytes(this.length(), StreamUtils$.MODULE$.sliceBytesTransformer(this.start(), this.length()));
            }

            public long distance(Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 other) {
                return this.mergedEnd(other) - this.mergedStart(other) - (this.length() + other.length());
            }

            public Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 mergeWith(Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 other) {
                return new Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1(this.$outer, this.mergedStart(other), this.mergedEnd(other));
            }

            public ContentRange.Default contentRange(long entityLength) {
                return ContentRange$.MODULE$.apply(this.start(), this.end() - 1L, entityLength);
            }

            private long mergedStart(Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 other) {
                return package$.MODULE$.min(this.start(), other.start());
            }

            private long mergedEnd(Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 other) {
                return package$.MODULE$.max(this.end(), other.end());
            }

            public final /* synthetic */ RangeDirectives org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$_$_$IndexRange$$$outer() {
                return this.$outer;
            }
        }
        ByteRange byteRange = range;
        if (byteRange instanceof ByteRange.Slice) {
            ByteRange.Slice slice = ByteRange.Slice$.MODULE$.unapply((ByteRange.Slice)byteRange);
            long l = slice._1();
            long l2 = slice._2();
            long start = l;
            long end = l2;
            return new Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1(this, start, package$.MODULE$.min(end + 1L, entityLength));
        }
        if (byteRange instanceof ByteRange.FromOffset) {
            long l;
            ByteRange.FromOffset fromOffset = ByteRange.FromOffset$.MODULE$.unapply((ByteRange.FromOffset)byteRange);
            long first = l = fromOffset._1();
            return new Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1(this, first, entityLength);
        }
        if (byteRange instanceof ByteRange.Suffix) {
            long l;
            ByteRange.Suffix suffix = ByteRange.Suffix$.MODULE$.unapply((ByteRange.Suffix)byteRange);
            long suffixLength = l = suffix._1();
            return new Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1(this, package$.MODULE$.max(0L, entityLength - suffixLength), entityLength);
        }
        throw new MatchError((Object)byteRange);
    }

    private static Seq coalesceRanges$1(RoutingSettings settings$2, Seq iRanges) {
        return (Seq)iRanges.foldLeft((Object)scala.package$.MODULE$.Seq().empty(), (Function2 & Serializable)(acc, iRange) -> {
            Tuple2 tuple2 = acc.partition((Function1 & Serializable)_$1 -> _$1.distance((Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1)iRange) <= settings$2.rangeCoalescingThreshold());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq mergeCandidates = (Seq)tuple2._1();
            Seq otherCandidates = (Seq)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)mergeCandidates, (Object)otherCandidates);
            Seq mergeCandidates2 = (Seq)tuple22._1();
            Seq otherCandidates2 = (Seq)tuple22._2();
            Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 merged = (Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1)mergeCandidates2.foldLeft(iRange, (Function2 & Serializable)(_$2, _$3) -> _$2.mergeWith((Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1)_$3));
            return (Seq)otherCandidates2.$colon$plus((Object)merged);
        });
    }

    public static Multipart.ByteRanges org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$multipartRanges$1$(RangeDirectives $this, RoutingSettings settings$8, Seq ranges, UniversalEntity entity) {
        return $this.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$multipartRanges$1(settings$8, ranges, entity);
    }

    default public Multipart.ByteRanges org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$multipartRanges$1(RoutingSettings settings$8, Seq ranges, UniversalEntity entity) {
        Source source;
        long length = entity.contentLength();
        Seq iRanges = (Seq)ranges.map((Function1 & Serializable)range -> this.indexRange$1(length, (ByteRange)range));
        Seq coalescedRanges = (Seq)RangeDirectives.coalesceRanges$1(settings$8, iRanges).sortBy((Function1 & Serializable)_$4 -> _$4.start(), (Ordering)Ordering.Long$.MODULE$);
        int n = coalescedRanges.size();
        if (0 == n) {
            source = Source$.MODULE$.empty();
        } else if (1 == n) {
            Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 range2 = (Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1)coalescedRanges.head();
            Flow flow = StreamUtils$.MODULE$.sliceBytesTransformer(range2.start(), range2.length());
            Source bytes = entity.dataBytes().via((Graph)flow);
            Multipart.ByteRanges.BodyPart part = Multipart.ByteRanges$.BodyPart$.MODULE$.apply((ContentRange)range2.contentRange(length), (BodyPartEntity)HttpEntity$.MODULE$.apply(entity.contentType(), range2.length(), bytes), Multipart.ByteRanges$.BodyPart$.MODULE$.apply$default$3(), Multipart.ByteRanges$.BodyPart$.MODULE$.apply$default$4());
            source = Source$.MODULE$.single((Object)part);
        } else {
            int n2 = n;
            source = Source$.MODULE$.fromGraph(GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
                UniformFanOutShape bcast = (UniformFanOutShape)b.add((Graph)Broadcast$.MODULE$.apply(n2, Broadcast$.MODULE$.apply$default$2()));
                UniformFanInShape merge = (UniformFanInShape)b.add(Concat$.MODULE$.apply(n2));
                coalescedRanges.foreach((Function1 & Serializable)range -> {
                    Flow flow = StreamUtils$.MODULE$.sliceBytesTransformer(range.start(), range.length());
                    return GraphDSL.Implicits$.MODULE$.fanOut2flow(bcast, b).$tilde$greater((Graph)flow.buffer(16, OverflowStrategy$.MODULE$.backpressure()).prefixAndTail(0).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Source bytes = (Source)tuple2._2();
                            return Multipart.ByteRanges$.BodyPart$.MODULE$.apply((ContentRange)range.contentRange(length), (BodyPartEntity)HttpEntity$.MODULE$.apply(entity.contentType(), range.length(), bytes), Multipart.ByteRanges$.BodyPart$.MODULE$.apply$default$3(), Multipart.ByteRanges$.BodyPart$.MODULE$.apply$default$4());
                        }
                        throw new MatchError((Object)tuple2);
                    }), b).$tilde$greater(merge, b);
                });
                new GraphDSL.Implicits$.SourceArrow(GraphDSL.Implicits$.MODULE$.SourceArrow((Graph)entity.dataBytes())).$tilde$greater(bcast, b);
                return SourceShape$.MODULE$.apply(merge.out());
            }));
        }
        Source source2 = source;
        return Multipart.ByteRanges$.MODULE$.apply(source2);
    }

    public static HttpResponse org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$rangeResponse$1$(RangeDirectives $this, ByteRange range, UniversalEntity entity, long length, Seq headers) {
        return $this.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$rangeResponse$1(range, entity, length, headers);
    }

    default public HttpResponse org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$rangeResponse$1(ByteRange range, UniversalEntity entity, long length, Seq headers) {
        Org_apache_pekko_http_scaladsl_server_directives_RangeDirectives$IndexRange$1 aiRange = this.indexRange$1(length, range);
        Content.minusRange minusRange2 = Content$minusRange$.MODULE$.apply((ByteContentRange)aiRange.contentRange(length));
        return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.PartialContent(), (Seq)headers.$plus$colon((Object)minusRange2), (ResponseEntity)aiRange.apply(entity), HttpResponse$.MODULE$.apply$default$4());
    }

    private static boolean satisfiable$1(long entityLength, ByteRange range) {
        ByteRange byteRange = range;
        if (byteRange instanceof ByteRange.Slice) {
            ByteRange.Slice slice = ByteRange.Slice$.MODULE$.unapply((ByteRange.Slice)byteRange);
            long l = slice._1();
            long l2 = slice._2();
            long firstPos = l;
            return firstPos < entityLength;
        }
        if (byteRange instanceof ByteRange.FromOffset) {
            ByteRange.FromOffset fromOffset = ByteRange.FromOffset$.MODULE$.unapply((ByteRange.FromOffset)byteRange);
            long l = fromOffset._1();
            long firstPos = l;
            return firstPos < entityLength;
        }
        if (byteRange instanceof ByteRange.Suffix) {
            ByteRange.Suffix suffix = ByteRange.Suffix$.MODULE$.unapply((ByteRange.Suffix)byteRange);
            long l = suffix._1();
            long length = l;
            return length > 0L;
        }
        throw new MatchError((Object)byteRange);
    }

    public static Option org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$universal$1(HttpEntity entity) {
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof UniversalEntity) {
            UniversalEntity u = (UniversalEntity)httpEntity;
            return Some$.MODULE$.apply((Object)u);
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ boolean org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$anon$1$$_$applyOrElse$$anonfun$1(long length$5, ByteRange range) {
        return RangeDirectives.satisfiable$1(length$5, range);
    }

    public static Directive applyRanges$1$(RangeDirectives $this, RoutingSettings settings$6, LoggingAdapter log$3, Seq ranges) {
        return $this.applyRanges$1(settings$6, log$3, ranges);
    }

    private Directive applyRanges$1(RoutingSettings settings$6, LoggingAdapter log$3, Seq ranges) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequestContext());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)ctx -> BasicDirectives$.MODULE$.mapRouteResultWithPF((PartialFunction)new Serializable(settings$6, log$3, ranges, (RequestContext)ctx, this){
            private final RoutingSettings settings$5;
            private final LoggingAdapter log$2;
            private final Seq ranges$2;
            private final RequestContext ctx$1;
            private final /* synthetic */ RangeDirectives $outer;
            {
                this.settings$5 = settings$9;
                this.log$2 = log$5;
                this.ranges$2 = ranges$3;
                this.ctx$1 = ctx$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(RouteResult x) {
                HttpResponse httpResponse;
                RouteResult.Complete complete;
                HttpResponse httpResponse2;
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Complete && (httpResponse2 = (complete = RouteResult$Complete$.MODULE$.unapply((RouteResult.Complete)routeResult))._1()) != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
                    HttpResponse httpResponse3 = httpResponse;
                    StatusCode statusCode = httpResponse3._1();
                    Seq seq = httpResponse3._2();
                    ResponseEntity responseEntity = httpResponse3._3();
                    HttpProtocol httpProtocol = httpResponse3._4();
                    StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                    StatusCode statusCode2 = statusCode;
                    if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                        Seq headers = seq;
                        ResponseEntity entity = responseEntity;
                        HttpProtocol protocol = httpProtocol;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(RouteResult x, Function1 function1) {
                HttpResponse httpResponse;
                RouteResult.Complete complete;
                HttpResponse httpResponse2;
                RouteResult routeResult = x;
                if (routeResult instanceof RouteResult.Complete && (httpResponse2 = (complete = RouteResult$Complete$.MODULE$.unapply((RouteResult.Complete)routeResult))._1()) != null && !OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
                    HttpResponse httpResponse3 = httpResponse;
                    StatusCode statusCode = httpResponse3._1();
                    Seq seq = httpResponse3._2();
                    ResponseEntity responseEntity = httpResponse3._3();
                    HttpProtocol httpProtocol = httpResponse3._4();
                    StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                    StatusCode statusCode2 = statusCode;
                    if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                        Seq headers = seq;
                        ResponseEntity entity = responseEntity;
                        HttpProtocol protocol = httpProtocol;
                        Option option = RangeDirectives.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$universal$1((HttpEntity)entity);
                        if (option instanceof Some) {
                            SeqOps seqOps;
                            UniversalEntity entity2 = (UniversalEntity)((Some)option).value();
                            long length = entity2.contentLength();
                            Seq seq2 = (Seq)this.ranges$2.filter(arg_0 -> RangeDirectives.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$anon$1$$_$applyOrElse$$anonfun$1(length, arg_0));
                            Nil$ nil$ = scala.package$.MODULE$.Nil();
                            Seq seq3 = seq2;
                            if (!(nil$ != null ? !nil$.equals(seq3) : seq3 != null)) {
                                return this.ctx$1.reject((Seq<Rejection>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{UnsatisfiableRangeRejection$.MODULE$.apply((Seq<ByteRange>)this.ranges$2, length)}));
                            }
                            if (seq2 != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq2), 1) == 0) {
                                ByteRange byteRange;
                                ByteRange satisfiableRange = byteRange = (ByteRange)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                                return this.ctx$1.complete(ToResponseMarshallable$.MODULE$.apply(this.$outer.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$rangeResponse$1(satisfiableRange, entity2, length, headers), Marshaller$.MODULE$.fromResponse()));
                            }
                            Seq satisfiableRanges = seq2;
                            return this.ctx$1.complete(ToResponseMarshallable$.MODULE$.apply(Tuple3$.MODULE$.apply((Object)StatusCodes$.MODULE$.PartialContent(), (Object)headers, (Object)this.$outer.org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$_$multipartRanges$1(this.settings$5, satisfiableRanges, entity2)), Marshaller$.MODULE$.fromStatusCodeAndHeadersAndValue(Marshaller$.MODULE$.multipartMarshaller(this.log$2))));
                        }
                        if (None$.MODULE$.equals(option)) {
                            return this.ctx$1.reject((Seq<Rejection>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{UnsatisfiableRangeRejection$.MODULE$.apply((Seq<ByteRange>)this.ranges$2, -1L)}));
                        }
                        throw new MatchError((Object)option);
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$http$scaladsl$server$directives$RangeDirectives$$anon$1$$_$applyOrElse$$anonfun$1(long org.apache.pekko.http.scaladsl.model.headers.ByteRange )}, serializedLambda);
            }
        }), Tuple$.MODULE$.forUnit());
    }

    private static Option rangeHeaderOfGetRequests$1(RequestContext ctx) {
        HttpMethod httpMethod = ctx.request().method();
        HttpMethod httpMethod2 = HttpMethods$.MODULE$.GET();
        if (!(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null)) {
            return ctx.request().header(ClassTag$.MODULE$.apply(Range.class));
        }
        return None$.MODULE$;
    }

    public static Directive withRangeSupport$$anonfun$1$(RangeDirectives $this, RequestContext ctx) {
        return $this.withRangeSupport$$anonfun$1(ctx);
    }
}

