/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.coding;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.scaladsl.coding.Compressor;
import org.apache.pekko.http.scaladsl.coding.DataMapper;
import org.apache.pekko.http.scaladsl.coding.Encoder$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.headers.Content;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusEncoding$;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncoding;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface Encoder {
    public static Function1<HttpMessage, Object> DefaultFilter() {
        return Encoder$.MODULE$.DefaultFilter();
    }

    public static boolean isCompressible(HttpMessage httpMessage) {
        return Encoder$.MODULE$.isCompressible(httpMessage);
    }

    public static Function1<HttpHeader, Object> isContentEncodingHeader() {
        return Encoder$.MODULE$.isContentEncodingHeader();
    }

    public HttpEncoding encoding();

    public Function1<HttpMessage, Object> messageFilter();

    public static HttpMessage encodeMessage$(Encoder $this, HttpMessage message) {
        return $this.encodeMessage(message);
    }

    default public HttpMessage encodeMessage(HttpMessage message) {
        if (BoxesRunTime.unboxToBoolean((Object)this.messageFilter().apply((Object)message)) && !message.headers().exists(Encoder$.MODULE$.isContentEncodingHeader())) {
            Content.minusEncoding minusEncoding2 = Content$minusEncoding$.MODULE$.apply(this.encoding(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpEncoding[0]));
            return message.transformEntityDataBytes(this.singleUseEncoderFlow()).withHeaders((Seq)message.headers().$plus$colon((Object)minusEncoding2));
        }
        return message.self();
    }

    public static Object encodeData$(Encoder $this, Object t, DataMapper mapper) {
        return $this.encodeData(t, mapper);
    }

    default public <T> T encodeData(T t, DataMapper<T> mapper) {
        return mapper.transformDataBytes(t, Flow$.MODULE$.fromGraph(this.singleUseEncoderFlow()));
    }

    public static Flow encoderFlow$(Encoder $this) {
        return $this.encoderFlow();
    }

    default public Flow<ByteString, ByteString, NotUsed> encoderFlow() {
        return Flow$.MODULE$.setup((Function2 & Serializable)(_$1, _$2) -> Flow$.MODULE$.fromGraph(this.singleUseEncoderFlow())).mapMaterializedValue((Function1 & Serializable)_$3 -> NotUsed$.MODULE$);
    }

    public static ByteString encode$(Encoder $this, ByteString input) {
        return $this.encode(input);
    }

    @InternalApi
    default public ByteString encode(ByteString input) {
        return this.newCompressor().compressAndFinish(input);
    }

    public static Future encodeAsync$(Encoder $this, ByteString input, Materializer mat) {
        return $this.encodeAsync(input, mat);
    }

    default public Future<ByteString> encodeAsync(ByteString input, Materializer mat) {
        return (Future)Source$.MODULE$.single((Object)input).via(this.singleUseEncoderFlow()).runWith((Graph)Sink$.MODULE$.fold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable)(_$4, _$5) -> _$4.$plus$plus(_$5)), mat);
    }

    @InternalApi
    public Compressor newCompressor();

    public static GraphStage newEncodeTransformer$(Encoder $this) {
        return $this.newEncodeTransformer();
    }

    @InternalApi
    default public GraphStage<FlowShape<ByteString, ByteString>> newEncodeTransformer() {
        return this.singleUseEncoderFlow();
    }

    private GraphStage<FlowShape<ByteString, ByteString>> singleUseEncoderFlow() {
        Compressor compressor = this.newCompressor();
        return StreamUtils$.MODULE$.byteStringTransformer((Function1 & Serializable)bytes -> Encoder.encodeChunk$1(compressor, bytes), (Function0 & Serializable)() -> Encoder.finish$1(compressor));
    }

    private static ByteString encodeChunk$1(Compressor compressor$1, ByteString bytes) {
        return compressor$1.compressAndFlush(bytes);
    }

    private static ByteString finish$1(Compressor compressor$2) {
        return compressor$2.finish();
    }
}

