/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.coding;

import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.coding.DeflateCompressor;
import org.apache.pekko.http.scaladsl.coding.GzipCompressor$;
import org.apache.pekko.http.scaladsl.coding.GzipDecompressor$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GzipCompressor.class.getDeclaredField("deflater$lzy1"));
    private final int compressionLevel;
    private volatile Object deflater$lzy1;
    private final CRC32 checkSum;
    private boolean headerSent;
    private long bytesRead;

    public static int DefaultCompressionLevel() {
        return GzipCompressor$.MODULE$.DefaultCompressionLevel();
    }

    public GzipCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        super(compressionLevel);
        this.checkSum = new CRC32();
        this.headerSent = false;
        this.bytesRead = 0L;
    }

    @Override
    public Deflater deflater() {
        Object object = this.deflater$lzy1;
        if (object instanceof Deflater) {
            return (Deflater)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Deflater)this.deflater$lzyINIT1();
    }

    private Object deflater$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.deflater$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Deflater deflater = null;
                    try {
                        deflater = new Deflater(this.compressionLevel, true);
                        object2 = deflater == null ? LazyVals.NullValue$.MODULE$ : deflater;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.deflater$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return deflater;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public GzipCompressor() {
        this(GzipCompressor$.MODULE$.DefaultCompressionLevel());
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum.update(input.toArrayUnsafe());
        this.bytesRead += (long)input.length();
    }

    private ByteString header() {
        if (!this.headerSent) {
            this.headerSent = true;
            return GzipDecompressor$.MODULE$.Header();
        }
        return ByteString$.MODULE$.empty();
    }

    private ByteString trailer() {
        int crc = (int)this.checkSum.getValue();
        int tot = (int)this.bytesRead;
        ByteString trailer = GzipCompressor.int32$1(crc).$plus$plus(GzipCompressor.int32$1(tot));
        return trailer;
    }

    private static final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }
}

