/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.marshalling;

import java.io.Serializable;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.common.EntityStreamingSupport;
import org.apache.pekko.http.scaladsl.marshalling.ContentTypeOverrider;
import org.apache.pekko.http.scaladsl.marshalling.EmptyValue;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.Marshalling;
import org.apache.pekko.http.scaladsl.marshalling.Marshalling$Opaque$;
import org.apache.pekko.http.scaladsl.marshalling.Marshalling$WithFixedContentType$;
import org.apache.pekko.http.scaladsl.marshalling.Marshalling$WithOpenCharset$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Try;

public abstract class Marshaller<A, B> {
    public static Marshaller ByteArrayMarshaller() {
        return Marshaller$.MODULE$.ByteArrayMarshaller();
    }

    public static Marshaller ByteStringMarshaller() {
        return Marshaller$.MODULE$.ByteStringMarshaller();
    }

    public static Marshaller CharArrayMarshaller() {
        return Marshaller$.MODULE$.CharArrayMarshaller();
    }

    public static Marshaller DoneMarshaller() {
        return Marshaller$.MODULE$.DoneMarshaller();
    }

    public static Marshaller FormDataMarshaller() {
        return Marshaller$.MODULE$.FormDataMarshaller();
    }

    public static Marshaller MessageEntityMarshaller() {
        return Marshaller$.MODULE$.MessageEntityMarshaller();
    }

    public static Marshaller StringMarshaller() {
        return Marshaller$.MODULE$.StringMarshaller();
    }

    public static Marshaller<byte[], RequestEntity> byteArrayMarshaller(ContentType contentType) {
        return Marshaller$.MODULE$.byteArrayMarshaller(contentType);
    }

    public static Marshaller<ByteString, RequestEntity> byteStringMarshaller(ContentType contentType) {
        return Marshaller$.MODULE$.byteStringMarshaller(contentType);
    }

    public static Marshaller<char[], RequestEntity> charArrayMarshaller(MediaType.WithFixedCharset withFixedCharset) {
        return Marshaller$.MODULE$.charArrayMarshaller(withFixedCharset);
    }

    public static Marshaller<char[], RequestEntity> charArrayMarshaller(MediaType.WithOpenCharset withOpenCharset) {
        return Marshaller$.MODULE$.charArrayMarshaller(withOpenCharset);
    }

    public static <A, B, C> Marshaller<A, C> combined(Function1<A, B> function1, Marshaller<B, C> marshaller) {
        return Marshaller$.MODULE$.combined(function1, marshaller);
    }

    public static <A1, A2, B> Marshaller<Either<A1, A2>, B> eitherMarshaller(Marshaller<A1, B> marshaller, Marshaller<A2, B> marshaller2) {
        return Marshaller$.MODULE$.eitherMarshaller((Marshaller)marshaller, (Marshaller)marshaller2);
    }

    public static <T, M> Marshaller<Source<T, M>, HttpResponse> fromEntityStreamingSupportAndByteStringMarshaller(ClassTag<T> classTag, EntityStreamingSupport entityStreamingSupport, Marshaller<T, ByteString> marshaller) {
        return Marshaller$.MODULE$.fromEntityStreamingSupportAndByteStringMarshaller((ClassTag)classTag, entityStreamingSupport, (Marshaller)marshaller);
    }

    public static <T, M> Marshaller<Source<T, M>, HttpResponse> fromEntityStreamingSupportAndByteStringSourceMarshaller(EntityStreamingSupport entityStreamingSupport, Marshaller<T, Source<ByteString, ?>> marshaller, ClassTag<T> classTag) {
        return Marshaller$.MODULE$.fromEntityStreamingSupportAndByteStringSourceMarshaller(entityStreamingSupport, (Marshaller)marshaller, (ClassTag)classTag);
    }

    public static <T, M> Marshaller<Source<T, M>, HttpResponse> fromEntityStreamingSupportAndEntityMarshaller(EntityStreamingSupport entityStreamingSupport, Marshaller<T, RequestEntity> marshaller, ClassTag<T> classTag) {
        return Marshaller$.MODULE$.fromEntityStreamingSupportAndEntityMarshaller(entityStreamingSupport, (Marshaller)marshaller, (ClassTag)classTag);
    }

    public static <T> Marshaller<Tuple4<HttpMethod, Uri, Seq<HttpHeader>, T>, HttpRequest> fromMethodAndUriAndHeadersAndValue(Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.fromMethodAndUriAndHeadersAndValue((Marshaller)marshaller);
    }

    public static <S, T> Marshaller<Tuple3<HttpMethod, Uri, T>, HttpRequest> fromMethodAndUriAndValue(Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.fromMethodAndUriAndValue((Marshaller)marshaller);
    }

    public static Marshaller fromRequest() {
        return Marshaller$.MODULE$.fromRequest();
    }

    public static Marshaller fromResponse() {
        return Marshaller$.MODULE$.fromResponse();
    }

    public static Marshaller fromStatusCode() {
        return Marshaller$.MODULE$.fromStatusCode();
    }

    public static Marshaller fromStatusCodeAndHeaders() {
        return Marshaller$.MODULE$.fromStatusCodeAndHeaders();
    }

    public static <T> Marshaller<Tuple3<StatusCode, Seq<HttpHeader>, T>, HttpResponse> fromStatusCodeAndHeadersAndValue(Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.fromStatusCodeAndHeadersAndValue((Marshaller)marshaller);
    }

    public static <S, T> Marshaller<Tuple2<S, T>, HttpResponse> fromStatusCodeAndValue(Function1<S, StatusCode> function1, Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.fromStatusCodeAndValue((Function1)function1, (Marshaller)marshaller);
    }

    public static <S, T> Marshaller<Tuple3<S, Seq<HttpHeader>, T>, HttpResponse> fromStatusCodeConvertibleAndHeadersAndT(Function1<S, StatusCode> function1, Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.fromStatusCodeConvertibleAndHeadersAndT((Function1)function1, (Marshaller)marshaller);
    }

    public static <T> Marshaller<T, HttpResponse> fromToEntityMarshaller(StatusCode statusCode, Seq<HttpHeader> seq, Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.fromToEntityMarshaller(statusCode, (Seq)seq, (Marshaller)marshaller);
    }

    public static Marshaller<Uri, HttpRequest> fromUri() {
        return Marshaller$.MODULE$.fromUri();
    }

    public static <A, B> Marshaller<Future<A>, B> futureMarshaller(Marshaller<A, B> marshaller) {
        return Marshaller$.MODULE$.futureMarshaller((Marshaller)marshaller);
    }

    public static <T> Marshaller<T, HttpResponse> liftMarshaller(Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.liftMarshaller((Marshaller)marshaller);
    }

    public static <T> Marshaller<T, HttpResponse> liftMarshallerConversion(Marshaller<T, RequestEntity> marshaller) {
        return Marshaller$.MODULE$.liftMarshallerConversion((Marshaller)marshaller);
    }

    public static <T extends Multipart> Marshaller<T, RequestEntity> multipartMarshaller(LoggingAdapter loggingAdapter) {
        return Marshaller$.MODULE$.multipartMarshaller(loggingAdapter);
    }

    public static <A, B> Marshaller<A, B> oneOf(Seq<Marshaller<A, B>> seq) {
        return Marshaller$.MODULE$.oneOf(seq);
    }

    public static <T, A, B> Marshaller<A, B> oneOf(Seq<T> seq, Function1<T, Marshaller<A, B>> function1) {
        return Marshaller$.MODULE$.oneOf(seq, function1);
    }

    public static <A, B> Marshaller<A, B> opaque(Function1<A, B> function1) {
        return Marshaller$.MODULE$.opaque(function1);
    }

    public static <A, B> Marshaller<Option<A>, B> optionMarshaller(Marshaller<A, B> marshaller, EmptyValue<B> emptyValue) {
        return Marshaller$.MODULE$.optionMarshaller((Marshaller)marshaller, (EmptyValue)emptyValue);
    }

    public static <A, B> Marshaller<A, B> strict(Function1<A, Marshalling<B>> function1) {
        return Marshaller$.MODULE$.strict(function1);
    }

    public static Marshaller<String, RequestEntity> stringMarshaller(MediaType.WithFixedCharset withFixedCharset) {
        return Marshaller$.MODULE$.stringMarshaller(withFixedCharset);
    }

    public static Marshaller<String, RequestEntity> stringMarshaller(MediaType.WithOpenCharset withOpenCharset) {
        return Marshaller$.MODULE$.stringMarshaller(withOpenCharset);
    }

    public static <T> Marshaller<Throwable, T> throwableMarshaller() {
        return Marshaller$.MODULE$.throwableMarshaller();
    }

    public static <A, B> Marshaller<Try<A>, B> tryMarshaller(Marshaller<A, B> marshaller) {
        return Marshaller$.MODULE$.tryMarshaller((Marshaller)marshaller);
    }

    public static <A, B> Marshaller<A, B> withFixedContentType(ContentType contentType, Function1<A, B> function1) {
        return Marshaller$.MODULE$.withFixedContentType(contentType, function1);
    }

    public static <A, B> Marshaller<A, B> withOpenCharset(MediaType.WithOpenCharset withOpenCharset, Function2<A, HttpCharset, B> function2) {
        return Marshaller$.MODULE$.withOpenCharset(withOpenCharset, function2);
    }

    public static <T> StatusCode fromToEntityMarshaller$default$1() {
        return Marshaller$.MODULE$.fromToEntityMarshaller$default$1();
    }

    public static <T extends Multipart> LoggingAdapter multipartMarshaller$default$1() {
        return Marshaller$.MODULE$.multipartMarshaller$default$1();
    }

    public static <T> Seq<HttpHeader> fromToEntityMarshaller$default$2() {
        return Marshaller$.MODULE$.fromToEntityMarshaller$default$2();
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$ByteArrayMarshaller_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$ByteArrayMarshaller_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$ByteStringMarshaller_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$ByteStringMarshaller_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$CharArrayMarshaller_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$CharArrayMarshaller_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$DoneMarshaller_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$DoneMarshaller_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$FormDataMarshaller_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$FormDataMarshaller_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$MessageEntityMarshaller_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$MessageEntityMarshaller_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$StringMarshaller_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToEntityMarshallers$_setter_$StringMarshaller_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToRequestMarshallers$_setter_$fromRequest_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToRequestMarshallers$_setter_$fromRequest_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToResponseMarshallers$_setter_$fromResponse_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToResponseMarshallers$_setter_$fromResponse_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToResponseMarshallers$_setter_$fromStatusCode_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToResponseMarshallers$_setter_$fromStatusCode_$eq(marshaller);
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$marshalling$PredefinedToResponseMarshallers$_setter_$fromStatusCodeAndHeaders_$eq(Marshaller marshaller) {
        Marshaller$.MODULE$.org$apache$pekko$http$scaladsl$marshalling$PredefinedToResponseMarshallers$_setter_$fromStatusCodeAndHeaders_$eq(marshaller);
    }

    public abstract Future<List<Marshalling<B>>> apply(A var1, ExecutionContext var2);

    public <C> Marshaller<A, C> map(Function1<B, C> f) {
        return Marshaller$.MODULE$.apply((Function1 & Serializable)ec -> (Function1 & Serializable)value -> {
            Future future = FastFuture$.MODULE$.EnhancedFuture(this.apply((A)value, (ExecutionContext)ec));
            Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
            return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)_$2 -> _$2.map(f)), ec);
        });
    }

    public <C, D> Marshaller<C, D> wrap(MediaType newMediaType, Function1<C, A> f, ContentTypeOverrider<D> mto) {
        return this.wrapWithEC(newMediaType, (Function1 & Serializable)_$3 -> f, mto);
    }

    public <C, D> Marshaller<C, D> wrapWithEC(MediaType newMediaType, Function1<ExecutionContext, Function1<C, A>> f, ContentTypeOverrider<D> cto) {
        return Marshaller$.MODULE$.apply((Function1 & Serializable)ec -> (Function1 & Serializable)value -> {
            Future future = FastFuture$.MODULE$.EnhancedFuture(this.apply((A)((Function1)f.apply(ec)).apply(value), (ExecutionContext)ec));
            Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
            return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)_$5 -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(_$5, (Object)newMediaType);
                if (tuple2 != null) {
                    Marshalling marshalling;
                    Marshalling marshalling2 = (Marshalling)tuple2._1();
                    MediaType mediaType = (MediaType)tuple2._2();
                    if (marshalling2 instanceof Marshalling.WithFixedContentType) {
                        Function0 function0;
                        Marshalling.WithFixedContentType withFixedContentType = Marshalling$WithFixedContentType$.MODULE$.unapply((Marshalling.WithFixedContentType)marshalling2);
                        ContentType contentType = withFixedContentType._1();
                        Function0 marshal = function0 = withFixedContentType._2();
                        if (mediaType instanceof MediaType.Binary) {
                            MediaType.Binary newMT = (MediaType.Binary)mediaType;
                            marshalling = Marshalling$WithFixedContentType$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(newMT), (Function0 & Serializable)() -> cto.apply(marshal.apply(), (ContentType)ContentType$.MODULE$.apply(newMT)));
                            return marshalling;
                        }
                    }
                    if (marshalling2 instanceof Marshalling.WithFixedContentType) {
                        Marshalling.WithFixedContentType withFixedContentType = Marshalling$WithFixedContentType$.MODULE$.unapply((Marshalling.WithFixedContentType)marshalling2);
                        ContentType contentType = withFixedContentType._1();
                        Function0 function0 = withFixedContentType._2();
                        if (contentType instanceof ContentType.Binary) {
                            ContentType.Binary oldCT = (ContentType.Binary)contentType;
                            Function0 marshal = function0;
                            if (mediaType instanceof MediaType.WithFixedCharset) {
                                MediaType.WithFixedCharset newMT = (MediaType.WithFixedCharset)mediaType;
                                marshalling = Marshalling$WithFixedContentType$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(newMT), (Function0 & Serializable)() -> cto.apply(marshal.apply(), (ContentType)ContentType$.MODULE$.apply(newMT)));
                                return marshalling;
                            }
                        }
                    }
                    if (marshalling2 instanceof Marshalling.WithFixedContentType) {
                        Marshalling.WithFixedContentType withFixedContentType = Marshalling$WithFixedContentType$.MODULE$.unapply((Marshalling.WithFixedContentType)marshalling2);
                        ContentType contentType = withFixedContentType._1();
                        Function0 function0 = withFixedContentType._2();
                        if (contentType instanceof ContentType.NonBinary) {
                            ContentType.NonBinary oldCT = (ContentType.NonBinary)contentType;
                            Function0 marshal = function0;
                            if (mediaType instanceof MediaType.WithFixedCharset) {
                                MediaType.WithFixedCharset newMT = (MediaType.WithFixedCharset)mediaType;
                                HttpCharset httpCharset = oldCT.charset();
                                HttpCharset httpCharset2 = newMT.charset();
                                if (!(httpCharset != null ? !httpCharset.equals(httpCharset2) : httpCharset2 != null)) {
                                    marshalling = Marshalling$WithFixedContentType$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(newMT), (Function0 & Serializable)() -> cto.apply(marshal.apply(), (ContentType)ContentType$.MODULE$.apply(newMT)));
                                    return marshalling;
                                }
                            }
                        }
                    }
                    if (marshalling2 instanceof Marshalling.WithFixedContentType) {
                        Marshalling.WithFixedContentType withFixedContentType = Marshalling$WithFixedContentType$.MODULE$.unapply((Marshalling.WithFixedContentType)marshalling2);
                        ContentType contentType = withFixedContentType._1();
                        Function0 function0 = withFixedContentType._2();
                        if (contentType instanceof ContentType.NonBinary) {
                            ContentType.NonBinary oldCT = (ContentType.NonBinary)contentType;
                            Function0 marshal = function0;
                            if (mediaType instanceof MediaType.WithOpenCharset) {
                                MediaType.WithOpenCharset newMT = (MediaType.WithOpenCharset)mediaType;
                                ContentType.WithCharset newCT = newMT.withCharset(oldCT.charset());
                                marshalling = Marshalling$WithFixedContentType$.MODULE$.apply((ContentType)newCT, (Function0 & Serializable)() -> cto.apply(marshal.apply(), (ContentType)newCT));
                                return marshalling;
                            }
                        }
                    }
                    if (marshalling2 instanceof Marshalling.WithOpenCharset) {
                        Marshalling.WithOpenCharset withOpenCharset = Marshalling$WithOpenCharset$.MODULE$.unapply((Marshalling.WithOpenCharset)marshalling2);
                        MediaType.WithOpenCharset withOpenCharset2 = withOpenCharset._1();
                        Function1 function1 = withOpenCharset._2();
                        MediaType.WithOpenCharset oldMT = withOpenCharset2;
                        Function1 marshal = function1;
                        if (mediaType instanceof MediaType.WithOpenCharset) {
                            MediaType.WithOpenCharset newMT = (MediaType.WithOpenCharset)mediaType;
                            marshalling = Marshalling$WithOpenCharset$.MODULE$.apply(newMT, (Function1 & Serializable)cs -> cto.apply(marshal.apply(cs), (ContentType)newMT.withCharset(cs)));
                            return marshalling;
                        }
                    }
                    if (marshalling2 instanceof Marshalling.WithOpenCharset) {
                        Marshalling.WithOpenCharset withOpenCharset = Marshalling$WithOpenCharset$.MODULE$.unapply((Marshalling.WithOpenCharset)marshalling2);
                        MediaType.WithOpenCharset withOpenCharset3 = withOpenCharset._1();
                        Function1 function1 = withOpenCharset._2();
                        MediaType.WithOpenCharset oldMT = withOpenCharset3;
                        Function1 marshal = function1;
                        if (mediaType instanceof MediaType.WithFixedCharset) {
                            MediaType.WithFixedCharset newMT = (MediaType.WithFixedCharset)mediaType;
                            marshalling = Marshalling$WithFixedContentType$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(newMT), (Function0 & Serializable)() -> cto.apply(marshal.apply((Object)newMT.charset()), (ContentType)ContentType$.MODULE$.apply(newMT)));
                            return marshalling;
                        }
                    }
                    if (marshalling2 instanceof Marshalling.Opaque) {
                        Function0 function0;
                        Marshalling.Opaque opaque = Marshalling$Opaque$.MODULE$.unapply((Marshalling.Opaque)marshalling2);
                        Function0 marshal = function0 = opaque._1();
                        if (mediaType instanceof MediaType.Binary) {
                            MediaType.Binary newMT = (MediaType.Binary)mediaType;
                            marshalling = Marshalling$WithFixedContentType$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(newMT), (Function0 & Serializable)() -> cto.apply(marshal.apply(), (ContentType)ContentType$.MODULE$.apply(newMT)));
                            return marshalling;
                        }
                    }
                    if (marshalling2 instanceof Marshalling.Opaque) {
                        Function0 function0;
                        Marshalling.Opaque opaque = Marshalling$Opaque$.MODULE$.unapply((Marshalling.Opaque)marshalling2);
                        Function0 marshal = function0 = opaque._1();
                        if (mediaType instanceof MediaType.WithFixedCharset) {
                            MediaType.WithFixedCharset newMT = (MediaType.WithFixedCharset)mediaType;
                            marshalling = Marshalling$WithFixedContentType$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(newMT), (Function0 & Serializable)() -> cto.apply(marshal.apply(), (ContentType)ContentType$.MODULE$.apply(newMT)));
                            return marshalling;
                        }
                    }
                }
                Tuple2 x = tuple2;
                throw package$.MODULE$.error(new StringBuilder(79).append("Illegal marshaller wrapping. Marshalling `").append(x).append("` cannot be wrapped with MediaType `").append(newMediaType).append("`").toString());
            }), ec);
        });
    }

    public <C> Marshaller<C, B> compose(Function1<C, A> f) {
        return Marshaller$.MODULE$.apply((Function1 & Serializable)ec -> (Function1 & Serializable)c -> this.apply((A)f.apply(c), (ExecutionContext)ec));
    }

    public <C> Marshaller<C, B> composeWithEC(Function1<ExecutionContext, Function1<C, A>> f) {
        return Marshaller$.MODULE$.apply((Function1 & Serializable)ec -> (Function1 & Serializable)c -> this.apply((A)((Function1)f.apply(ec)).apply(c), (ExecutionContext)ec));
    }
}

