/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.impl.util.S2JMapping$;
import org.apache.pekko.http.javadsl.marshalling.Marshaller;
import org.apache.pekko.http.javadsl.marshalling.Marshaller$;
import org.apache.pekko.http.javadsl.server.RoutingJavaMapping$convertDirectoryListing$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.DateTime;
import org.apache.pekko.http.scaladsl.model.DateTime$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.EntityTag$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directive$SingleValueTransformers$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteConcatenation$;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.directives.BasicDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.CacheConditionDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.ContentTypeResolver;
import org.apache.pekko.http.scaladsl.server.directives.DirectoryListing;
import org.apache.pekko.http.scaladsl.server.directives.DirectoryListing$;
import org.apache.pekko.http.scaladsl.server.directives.FileAndResourceDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.FileAndResourceDirectives$DirectoryRenderer$;
import org.apache.pekko.http.scaladsl.server.directives.FileAndResourceDirectives$ResourceFile$;
import org.apache.pekko.http.scaladsl.server.directives.MethodDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.RouteDirectives$;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface FileAndResourceDirectives {
    public static Function1 getFromFile$(FileAndResourceDirectives $this, String fileName, ContentTypeResolver resolver) {
        return $this.getFromFile(fileName, resolver);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromFile(String fileName, ContentTypeResolver resolver) {
        return this.getFromFile(new File(fileName), resolver);
    }

    public static Function1 getFromFile$(FileAndResourceDirectives $this, File file, ContentTypeResolver resolver) {
        return $this.getFromFile(file, resolver);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentTypeResolver resolver) {
        return this.getFromFile(file, resolver.apply(file.getName()));
    }

    public static Function1 getFromFile$(FileAndResourceDirectives $this, File file, ContentType contentType) {
        return $this.getFromFile(file, contentType);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentType contentType) {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(MethodDirectives$.MODULE$.get()).apply(() -> this.getFromFile$$anonfun$1(file, contentType));
    }

    private Directive<BoxedUnit> conditionalFor(long length, long lastModified) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractSettings());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)settings -> {
            if (settings.fileGetConditional()) {
                String tag = Long.toHexString(lastModified ^ Long.reverse(length));
                DateTime lastModifiedDateTime = DateTime$.MODULE$.apply(package$.MODULE$.min(lastModified, System.currentTimeMillis()));
                return CacheConditionDirectives$.MODULE$.conditional(EntityTag$.MODULE$.apply(tag, EntityTag$.MODULE$.$lessinit$greater$default$2()), lastModifiedDateTime);
            }
            return BasicDirectives$.MODULE$.pass();
        }, Tuple$.MODULE$.forUnit());
    }

    public static Function1 getFromResource$(FileAndResourceDirectives $this, String resourceName, ContentTypeResolver resolver) {
        return $this.getFromResource(resourceName, resolver);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentTypeResolver resolver) {
        return this.getFromResource(resourceName, resolver.apply(resourceName), this.getFromResource$default$3());
    }

    public static Function1 getFromResource$(FileAndResourceDirectives $this, String resourceName, ContentType contentType, ClassLoader classLoader) {
        return $this.getFromResource(resourceName, contentType, classLoader);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentType contentType, ClassLoader classLoader) {
        if (!resourceName.endsWith("/")) {
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(MethodDirectives$.MODULE$.get()).apply(() -> this.getFromResource$$anonfun$1(classLoader, resourceName, contentType));
        }
        return RouteDirectives$.MODULE$.reject();
    }

    public static ClassLoader getFromResource$default$3$(FileAndResourceDirectives $this) {
        return $this.getFromResource$default$3();
    }

    default public ClassLoader getFromResource$default$3() {
        return this._defaultClassLoader();
    }

    public static Function1 getFromDirectory$(FileAndResourceDirectives $this, String directoryName, ContentTypeResolver resolver) {
        return $this.getFromDirectory(directoryName, resolver);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromDirectory(String directoryName, ContentTypeResolver resolver) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractUnmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)unmatchedPath -> (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractLog(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)log -> {
            String string = FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$safeDirectoryChildPath(FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$withTrailingSlash(directoryName), (Uri.Path)unmatchedPath, (LoggingAdapter)log, FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$safeDirectoryChildPath$default$4());
            if ("".equals(string)) {
                return RouteDirectives$.MODULE$.reject();
            }
            String fileName = string;
            return this.getFromFile(fileName, resolver);
        }));
    }

    public static Function1 listDirectoryContents$(FileAndResourceDirectives $this, Seq directories, DirectoryRenderer renderer) {
        return $this.listDirectoryContents((Seq<String>)directories, renderer);
    }

    default public Function1<RequestContext, Future<RouteResult>> listDirectoryContents(Seq<String> directories, DirectoryRenderer renderer) {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(MethodDirectives$.MODULE$.get()).apply(() -> FileAndResourceDirectives.listDirectoryContents$$anonfun$1(directories, renderer));
    }

    public static Function1 getFromBrowseableDirectory$(FileAndResourceDirectives $this, String directory, DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return $this.getFromBrowseableDirectory(directory, renderer, resolver);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectory(String directory, DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return this.getFromBrowseableDirectories((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{directory}), renderer, resolver);
    }

    public static Function1 getFromBrowseableDirectories$(FileAndResourceDirectives $this, Seq directories, DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return $this.getFromBrowseableDirectories((Seq<String>)directories, renderer, resolver);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectories(Seq<String> directories, DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return RouteConcatenation$.MODULE$._enhanceRouteWithConcatenation((Function1)((IterableOnceOps)directories.map((Function1 & Serializable)directoryName -> this.getFromDirectory((String)directoryName, resolver))).reduceLeft((Function2 & Serializable)(_$2, _$3) -> RouteConcatenation$.MODULE$._enhanceRouteWithConcatenation((Function1)_$2).$tilde((Function1<RequestContext, Future<RouteResult>>)_$3))).$tilde(this.listDirectoryContents(directories, renderer));
    }

    public static Function1 getFromResourceDirectory$(FileAndResourceDirectives $this, String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        return $this.getFromResourceDirectory(directoryName, classLoader, resolver);
    }

    default public Function1<RequestContext, Future<RouteResult>> getFromResourceDirectory(String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        String base = directoryName.isEmpty() ? "" : FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$withTrailingSlash(directoryName);
        return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractUnmatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)path -> (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractLog(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)log -> {
            String string = FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$safeJoinPaths(base, (Uri.Path)path, (LoggingAdapter)log, '/');
            if ("".equals(string)) {
                return RouteDirectives$.MODULE$.reject();
            }
            String resourceName = string;
            return this.getFromResource(resourceName, resolver.apply(resourceName), classLoader);
        }));
    }

    public static ClassLoader getFromResourceDirectory$default$2$(FileAndResourceDirectives $this) {
        return $this.getFromResourceDirectory$default$2();
    }

    default public ClassLoader getFromResourceDirectory$default$2() {
        return this._defaultClassLoader();
    }

    public static ClassLoader _defaultClassLoader$(FileAndResourceDirectives $this) {
        return $this._defaultClassLoader();
    }

    default public ClassLoader _defaultClassLoader() {
        return ActorSystem.class.getClassLoader();
    }

    private static ToResponseMarshallable getFromFile$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(ContentType contentType$4, File file$4) {
        return ToResponseMarshallable$.MODULE$.apply(HttpEntity.Default$.MODULE$.apply(contentType$4, file$4.length(), FileIO$.MODULE$.fromPath(file$4.toPath(), FileIO$.MODULE$.fromPath$default$2())), org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.liftMarshaller(org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.MessageEntityMarshaller()));
    }

    private static Function1 getFromFile$$anonfun$1$$anonfun$1$$anonfun$1(ContentType contentType$3, File file$3) {
        return RouteDirectives$.MODULE$.complete(() -> FileAndResourceDirectives.getFromFile$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(contentType$3, file$3));
    }

    private static ToResponseMarshallable getFromFile$$anonfun$1$$anonfun$1$$anonfun$2() {
        return ToResponseMarshallable$.MODULE$.apply(HttpEntity$.MODULE$.Empty(), org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.liftMarshaller(org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.MessageEntityMarshaller()));
    }

    private static Function1 getFromFile$$anonfun$1$$anonfun$1(File file$2, ContentType contentType$2) {
        if (file$2.length() > 0L) {
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(FileAndResourceDirectives$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$withRangeSupportAndPrecompressedMediaTypeSupport).apply(() -> FileAndResourceDirectives.getFromFile$$anonfun$1$$anonfun$1$$anonfun$1(contentType$2, file$2));
        }
        return RouteDirectives$.MODULE$.complete(FileAndResourceDirectives::getFromFile$$anonfun$1$$anonfun$1$$anonfun$2);
    }

    private Function1 getFromFile$$anonfun$1(File file$1, ContentType contentType$1) {
        if (file$1.isFile() && file$1.canRead()) {
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(this.conditionalFor(file$1.length(), file$1.lastModified())).apply(() -> FileAndResourceDirectives.getFromFile$$anonfun$1$$anonfun$1(file$1, contentType$1));
        }
        return RouteDirectives$.MODULE$.reject();
    }

    private static ToResponseMarshallable getFromResource$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ContentType contentType$8, long length$4, URL url$3) {
        return ToResponseMarshallable$.MODULE$.apply(HttpEntity.Default$.MODULE$.apply(contentType$8, length$4, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> url$3.openStream(), StreamConverters$.MODULE$.fromInputStream$default$2())), org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.liftMarshaller(org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.MessageEntityMarshaller()));
    }

    private static Function1 getFromResource$$anonfun$1$$anonfun$2$$anonfun$1(ContentType contentType$7, long length$3, URL url$2) {
        return RouteDirectives$.MODULE$.complete(() -> FileAndResourceDirectives.getFromResource$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(contentType$7, length$3, url$2));
    }

    private static ToResponseMarshallable getFromResource$$anonfun$1$$anonfun$2$$anonfun$2() {
        return ToResponseMarshallable$.MODULE$.apply(HttpEntity$.MODULE$.Empty(), org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.liftMarshaller(org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.MessageEntityMarshaller()));
    }

    private static Function1 getFromResource$$anonfun$1$$anonfun$2(long length$2, ContentType contentType$6, URL url$1) {
        if (length$2 > 0L) {
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(FileAndResourceDirectives$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$withRangeSupportAndPrecompressedMediaTypeSupport).apply(() -> FileAndResourceDirectives.getFromResource$$anonfun$1$$anonfun$2$$anonfun$1(contentType$6, length$2, url$1));
        }
        return RouteDirectives$.MODULE$.complete(FileAndResourceDirectives::getFromResource$$anonfun$1$$anonfun$2$$anonfun$2);
    }

    private Function1 getFromResource$$anonfun$1(ClassLoader classLoader$1, String resourceName$1, ContentType contentType$5) {
        ResourceFile resourceFile;
        Option option = Option$.MODULE$.apply((Object)classLoader$1.getResource(resourceName$1)).flatMap((Function1 & Serializable)url -> FileAndResourceDirectives$ResourceFile$.MODULE$.apply((URL)url));
        if (option instanceof Some && (resourceFile = (ResourceFile)((Some)option).value()) != null) {
            ResourceFile resourceFile2 = FileAndResourceDirectives$ResourceFile$.MODULE$.unapply(resourceFile);
            URL uRL = resourceFile2._1();
            long l = resourceFile2._2();
            long l2 = resourceFile2._3();
            URL url2 = uRL;
            long length = l;
            long lastModified = l2;
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(this.conditionalFor(length, lastModified)).apply(() -> FileAndResourceDirectives.getFromResource$$anonfun$1$$anonfun$2(length, contentType$5, url2));
        }
        return RouteDirectives$.MODULE$.reject();
    }

    private static ToResponseMarshallable listDirectoryContents$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String prefixPath$1, String pathString$1, Seq dirs$1, org.apache.pekko.http.scaladsl.marshalling.Marshaller marshaller$1) {
        String string = pathString$1;
        String string2 = "/";
        return ToResponseMarshallable$.MODULE$.apply(DirectoryListing$.MODULE$.apply(new StringBuilder(0).append(prefixPath$1).append(pathString$1).toString(), !(string != null ? !string.equals(string2) : string2 != null), (Seq<File>)((Seq)dirs$1.flatMap((Function1 & Serializable)_$1 -> Predef$.MODULE$.wrapRefArray((Object[])_$1.listFiles())))), org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.liftMarshaller(marshaller$1));
    }

    private static Function1 listDirectoryContents$$anonfun$1(Seq directories$2, DirectoryRenderer renderer$2) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractRequestContext(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)ctx -> (Function1)Directive$.MODULE$.addDirectiveApply(BasicDirectives$.MODULE$.extractMatchedPath(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)matched -> {
            String prefixPath = matched.toString();
            Uri.Path remainingPath = ctx.unmatchedPath();
            String pathString = FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$withTrailingSlash(FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$safeJoinPaths("/", remainingPath, ctx.log(), '/'));
            Seq dirs = (Seq)directories$2.flatMap((Function1 & Serializable)dir -> {
                String string = FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$safeDirectoryChildPath(FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$withTrailingSlash((String)dir), remainingPath, ctx.log(), FileAndResourceDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$FileAndResourceDirectives$$$safeDirectoryChildPath$default$4());
                if ("".equals(string)) {
                    return None$.MODULE$;
                }
                String fileName = string;
                File file = new File(fileName);
                if (file.isDirectory() && file.canRead()) {
                    return Some$.MODULE$.apply((Object)file);
                }
                return None$.MODULE$;
            });
            org.apache.pekko.http.scaladsl.marshalling.Marshaller<DirectoryListing, RequestEntity> marshaller = renderer$2.marshaller(ctx.settings().renderVanityFooter());
            if (dirs.isEmpty()) {
                return RouteDirectives$.MODULE$.reject();
            }
            return RouteDirectives$.MODULE$.complete(() -> FileAndResourceDirectives.listDirectoryContents$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(prefixPath, pathString, dirs, marshaller));
        }));
    }

    public static interface DirectoryRenderer
    extends org.apache.pekko.http.javadsl.server.directives.DirectoryRenderer {
        public static DirectoryRenderer defaultDirectoryRenderer() {
            return FileAndResourceDirectives$DirectoryRenderer$.MODULE$.defaultDirectoryRenderer();
        }

        public static DirectoryRenderer liftMarshaller(org.apache.pekko.http.scaladsl.marshalling.Marshaller<DirectoryListing, RequestEntity> marshaller) {
            return FileAndResourceDirectives$DirectoryRenderer$.MODULE$.liftMarshaller(marshaller);
        }

        public org.apache.pekko.http.scaladsl.marshalling.Marshaller<DirectoryListing, RequestEntity> marshaller(boolean var1);

        public static Marshaller directoryMarshaller$(DirectoryRenderer $this, boolean renderVanityFooter) {
            return $this.directoryMarshaller(renderVanityFooter);
        }

        @Override
        default public Marshaller<org.apache.pekko.http.javadsl.server.directives.DirectoryListing, org.apache.pekko.http.javadsl.model.RequestEntity> directoryMarshaller(boolean renderVanityFooter) {
            org.apache.pekko.http.scaladsl.marshalling.Marshaller combined = org.apache.pekko.http.scaladsl.marshalling.Marshaller$.MODULE$.combined((Function1 & Serializable)x -> (DirectoryListing)JavaMapping$.MODULE$.toScala(x, (JavaMapping)RoutingJavaMapping$convertDirectoryListing$.MODULE$), this.marshaller(renderVanityFooter)).map((Function1 & Serializable)_$4 -> (org.apache.pekko.http.javadsl.model.RequestEntity)JavaMapping.Implicits$.MODULE$.AddAsJava(_$4, S2JMapping$.MODULE$.fromScalaMapping((JavaMapping)JavaMapping.RequestEntity$.MODULE$)).asJava());
            return Marshaller$.MODULE$.fromScala(combined);
        }
    }

    public static interface LowLevelDirectoryRenderer {
        public static DirectoryRenderer defaultDirectoryRenderer$(LowLevelDirectoryRenderer $this) {
            return $this.defaultDirectoryRenderer();
        }

        default public DirectoryRenderer defaultDirectoryRenderer() {
            return new DirectoryRenderer(){

                public org.apache.pekko.http.scaladsl.marshalling.Marshaller marshaller(boolean renderVanityFooter) {
                    return DirectoryListing$.MODULE$.directoryMarshaller(renderVanityFooter);
                }
            };
        }
    }

    public static class ResourceFile
    implements Product,
    Serializable {
        private final URL url;
        private final long length;
        private final long lastModified;

        public static Option<ResourceFile> apply(URL uRL) {
            return FileAndResourceDirectives$ResourceFile$.MODULE$.apply(uRL);
        }

        public static ResourceFile apply(URL uRL, long l, long l2) {
            return FileAndResourceDirectives$ResourceFile$.MODULE$.apply(uRL, l, l2);
        }

        public static ResourceFile fromProduct(Product product) {
            return FileAndResourceDirectives$ResourceFile$.MODULE$.fromProduct(product);
        }

        public static ResourceFile unapply(ResourceFile resourceFile) {
            return FileAndResourceDirectives$ResourceFile$.MODULE$.unapply(resourceFile);
        }

        public ResourceFile(URL url, long length, long lastModified) {
            this.url = url;
            this.length = length;
            this.lastModified = lastModified;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.url()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastModified()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResourceFile)) return false;
            ResourceFile resourceFile = (ResourceFile)object;
            if (this.length() != resourceFile.length()) return false;
            if (this.lastModified() != resourceFile.lastModified()) return false;
            URL uRL = this.url();
            URL uRL2 = resourceFile.url();
            if (uRL == null) {
                if (uRL2 != null) {
                    return false;
                }
            } else if (!((Object)uRL).equals(uRL2)) return false;
            if (!resourceFile.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResourceFile;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ResourceFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "url";
                }
                case 1: {
                    return "length";
                }
                case 2: {
                    return "lastModified";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public URL url() {
            return this.url;
        }

        public long length() {
            return this.length;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public ResourceFile copy(URL url, long length, long lastModified) {
            return new ResourceFile(url, length, lastModified);
        }

        public URL copy$default$1() {
            return this.url();
        }

        public long copy$default$2() {
            return this.length();
        }

        public long copy$default$3() {
            return this.lastModified();
        }

        public URL _1() {
            return this.url();
        }

        public long _2() {
            return this.length();
        }

        public long _3() {
            return this.lastModified();
        }
    }
}

