/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.Serializable;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.HttpOrigin;
import org.apache.pekko.http.scaladsl.model.headers.HttpOriginRange;
import org.apache.pekko.http.scaladsl.model.headers.ModeledCompanion;
import org.apache.pekko.http.scaladsl.model.headers.Origin;
import org.apache.pekko.http.scaladsl.model.headers.Origin$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directive$SingleValueTransformers$;
import org.apache.pekko.http.scaladsl.server.InvalidOriginRejection$;
import org.apache.pekko.http.scaladsl.server.MalformedHeaderRejection$;
import org.apache.pekko.http.scaladsl.server.MissingHeaderRejection$;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.StandardRoute$;
import org.apache.pekko.http.scaladsl.server.directives.BasicDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.HeaderMagnet;
import org.apache.pekko.http.scaladsl.server.directives.HeaderMagnet$;
import org.apache.pekko.http.scaladsl.server.directives.RouteDirectives$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.Tupler$;
import scala.Function$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Symbol;
import scala.Tuple1;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public interface HeaderDirectives {
    public static Directive checkSameOrigin$(HeaderDirectives $this, HttpOriginRange.Default allowed) {
        return $this.checkSameOrigin(allowed);
    }

    default public Directive<BoxedUnit> checkSameOrigin(HttpOriginRange.Default allowed) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(this.headerValueByType(HeaderMagnet$.MODULE$.fromCompanionNormalHeader((ModeledCompanion)Origin$.MODULE$, ClassTag$.MODULE$.apply(Origin.class))));
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)origin2 -> {
            if (origin2.origins().exists((Function1 & Serializable)origin -> allowed.matches(origin))) {
                return BasicDirectives$.MODULE$.pass();
            }
            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{InvalidOriginRejection$.MODULE$.apply((Seq<HttpOrigin>)allowed.origins())})), Tuple$.MODULE$.forUnit());
        }, Tuple$.MODULE$.forUnit());
    }

    public static Directive headerValue$(HeaderDirectives $this, Function1 f) {
        return $this.headerValue(f);
    }

    default public <T> Directive<Tuple1<T>> headerValue(Function1<HttpHeader, Option<T>> f) {
        Function1 & Serializable protectedF = (Function1 & Serializable)header -> {
            Option option;
            try {
                option = ((Option)f.apply(header)).map((Function1 & Serializable)value -> scala.package$.MODULE$.Right().apply(value));
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option2.get();
                    option = Some$.MODULE$.apply((Object)scala.package$.MODULE$.Left().apply((Object)MalformedHeaderRejection$.MODULE$.apply(header.name(), EnhancedString$.MODULE$.nullAsEmpty$extension(package$.MODULE$.enhanceString_(e.getMessage())), (Option<Throwable>)Some$.MODULE$.apply((Object)e))));
                }
                throw throwable;
            }
            return option;
        };
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extract((Function1 & Serializable)_$1 -> _$1.request().headers().collectFirst(Function$.MODULE$.unlift(protectedF))));
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Either either = (Either)((Some)option).value();
                if (either instanceof Right) {
                    Object a = ((Right)either).value();
                    return BasicDirectives$.MODULE$.provide(a);
                }
                if (either instanceof Left) {
                    Rejection rejection = (Rejection)((Left)either).value();
                    return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{rejection})), Tuple$.MODULE$.forTuple1());
                }
            }
            if (None$.MODULE$.equals(option)) {
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject(), Tuple$.MODULE$.forTuple1());
            }
            throw new MatchError((Object)option);
        }, Tuple$.MODULE$.forTuple1());
    }

    public static Directive headerValuePF$(HeaderDirectives $this, PartialFunction pf) {
        return $this.headerValuePF(pf);
    }

    default public <T> Directive<Tuple1<T>> headerValuePF(PartialFunction<HttpHeader, T> pf) {
        return this.headerValue(pf.lift());
    }

    public static Directive headerValueByName$(HeaderDirectives $this, Symbol headerName) {
        return $this.headerValueByName(headerName);
    }

    default public Directive<Tuple1<String>> headerValueByName(Symbol headerName) {
        return this.headerValueByName(headerName.name());
    }

    public static Directive headerValueByName$(HeaderDirectives $this, String headerName) {
        return $this.headerValueByName(headerName);
    }

    default public Directive<Tuple1<String>> headerValueByName(String headerName) {
        return this.headerValue(this.optionalValue(headerName.toLowerCase())).$bar(StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{MissingHeaderRejection$.MODULE$.apply(headerName)})), Tuple$.MODULE$.forTuple1()));
    }

    public static Directive headerValueByType$(HeaderDirectives $this, HeaderMagnet magnet) {
        return $this.headerValueByType(magnet);
    }

    default public <T> Directive<Tuple1<T>> headerValueByType(HeaderMagnet<T> magnet) {
        return this.headerValuePF(magnet.extractPF()).$bar(StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{MissingHeaderRejection$.MODULE$.apply(magnet.headerName())})), Tuple$.MODULE$.forTuple1()));
    }

    public static Directive optionalHeaderValue$(HeaderDirectives $this, Function1 f) {
        return $this.optionalHeaderValue(f);
    }

    default public <T> Directive<Tuple1<Option<T>>> optionalHeaderValue(Function1<HttpHeader, Option<T>> f) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(this.headerValue(f));
        return Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1 & Serializable)_$2 -> Some$.MODULE$.apply(_$2), Tupler$.MODULE$.forAnyRef()).recoverPF(new Serializable(){

            public final boolean isDefinedAt(Seq x) {
                Seq seq = x;
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                Seq seq2 = seq;
                return !(nil$ != null ? !nil$.equals(seq2) : seq2 != null);
            }

            public final Object applyOrElse(Seq x, Function1 function1) {
                Seq seq = x;
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                Seq seq2 = seq;
                if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
                    return BasicDirectives$.MODULE$.provide(None$.MODULE$);
                }
                return function1.apply((Object)x);
            }
        }, Tuple$.MODULE$.forTuple1());
    }

    public static Directive optionalHeaderValuePF$(HeaderDirectives $this, PartialFunction pf) {
        return $this.optionalHeaderValuePF(pf);
    }

    default public <T> Directive<Tuple1<Option<T>>> optionalHeaderValuePF(PartialFunction<HttpHeader, T> pf) {
        return this.optionalHeaderValue(pf.lift());
    }

    public static Directive optionalHeaderValueByName$(HeaderDirectives $this, Symbol headerName) {
        return $this.optionalHeaderValueByName(headerName);
    }

    default public Directive<Tuple1<Option<String>>> optionalHeaderValueByName(Symbol headerName) {
        return this.optionalHeaderValueByName(headerName.name());
    }

    public static Directive optionalHeaderValueByName$(HeaderDirectives $this, String headerName) {
        return $this.optionalHeaderValueByName(headerName);
    }

    default public Directive<Tuple1<Option<String>>> optionalHeaderValueByName(String headerName) {
        String lowerCaseName = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(headerName));
        return BasicDirectives$.MODULE$.extract((Function1 & Serializable)_$3 -> _$3.request().headers().collectFirst((PartialFunction)new Serializable(lowerCaseName){
            private final String lowerCaseName$2;
            {
                this.lowerCaseName$2 = lowerCaseName$4;
            }

            public final boolean isDefinedAt(HttpHeader x) {
                HttpHeader h;
                HttpHeader httpHeader = x;
                return httpHeader != null && (h = httpHeader).is(this.lowerCaseName$2);
            }

            public final Object applyOrElse(HttpHeader x, Function1 function1) {
                HttpHeader h;
                HttpHeader httpHeader = x;
                if (httpHeader != null && (h = httpHeader).is(this.lowerCaseName$2)) {
                    return h.value();
                }
                return function1.apply((Object)x);
            }
        }));
    }

    public static Directive optionalHeaderValueByType$(HeaderDirectives $this, HeaderMagnet magnet) {
        return $this.optionalHeaderValueByType(magnet);
    }

    default public <T extends HttpHeader> Directive<Tuple1<Option<T>>> optionalHeaderValueByType(HeaderMagnet<T> magnet) {
        return this.optionalHeaderValuePF(magnet.extractPF());
    }

    private Function1<HttpHeader, Option<String>> optionalValue(String lowerCaseName) {
        return (Function1 & Serializable)x$1 -> {
            HttpHeader h;
            HttpHeader httpHeader = x$1;
            if (httpHeader != null && (h = httpHeader).is(lowerCaseName)) {
                return Some$.MODULE$.apply((Object)h.value());
            }
            return None$.MODULE$;
        };
    }
}

