// auto-generated by sbt-boilerplate
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2009-2020 Lightbend Inc. <https://www.lightbend.com>
 */
package org.apache.pekko.http.javadsl.server

import org.apache.pekko
import pekko.annotation.InternalApi
import pekko.http.scaladsl.server.{ PathMatcher => SPathMatcher }
import pekko.http.scaladsl.server.{ PathMatchers => SPathMatchers }
import java.util.{ List => JList }
import java.util.function.{ Function => JFunction }
import scala.collection.JavaConverters._

object JavaPathMatchers {

  /* This is a workaround for sbt-boilerplate being limited with 2 as the max distance between number and generated number */
  type PathMatcherTwoMoreThan1[A, B, T1] = PathMatcher3[A, B, T1]
  type PathMatcherTwoMoreThan2[A, B, T1, T2] = PathMatcher4[A, B, T1, T2]
  type PathMatcherTwoMoreThan3[A, B, T1, T2, T3] = PathMatcher5[A, B, T1, T2, T3]
  type PathMatcherTwoMoreThan4[A, B, T1, T2, T3, T4] = PathMatcher6[A, B, T1, T2, T3, T4]
  type PathMatcherTwoMoreThan5[A, B, T1, T2, T3, T4, T5] = PathMatcher7[A, B, T1, T2, T3, T4, T5]
  type PathMatcherTwoMoreThan6[A, B, T1, T2, T3, T4, T5, T6] = PathMatcher8[A, B, T1, T2, T3, T4, T5, T6]
  type PathMatcherTwoMoreThan7[A, B, T1, T2, T3, T4, T5, T6, T7] = PathMatcher9[A, B, T1, T2, T3, T4, T5, T6, T7]
  type PathMatcherTwoMoreThan8[A, B, T1, T2, T3, T4, T5, T6, T7, T8] = PathMatcher10[A, B, T1, T2, T3, T4, T5, T6, T7, T8]
  type PathMatcherTwoMoreThan9[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9] = PathMatcher11[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9]
  type PathMatcherTwoMoreThan10[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] = PathMatcher12[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]
  type PathMatcherTwoMoreThan11[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] = PathMatcher13[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]
  type PathMatcherTwoMoreThan12[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] = PathMatcher14[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]
  type PathMatcherTwoMoreThan13[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] = PathMatcher15[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]
  type PathMatcherTwoMoreThan14[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] = PathMatcher16[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]
  type PathMatcherTwoMoreThan15[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] = PathMatcher17[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]
  type PathMatcherTwoMoreThan16[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] = PathMatcher18[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]
  type PathMatcherTwoMoreThan17[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] = PathMatcher19[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]
  type PathMatcherTwoMoreThan18[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] = PathMatcher20[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]
  type PathMatcherTwoMoreThan19[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] = PathMatcher21[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]
  type PathMatcherTwoMoreThan20[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] = PathMatcher22[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]

  /** INTERNAL API */
  @InternalApi
  private[server] implicit def fromScala0(scalaMatcher: SPathMatcher[Unit]): PathMatcher0 =
    new PathMatcher0(scalaMatcher)

  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala1[T1](scalaMatcher: SPathMatcher[Tuple1[T1]]): PathMatcher1[T1] =
    new PathMatcher1(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala2[T1, T2](scalaMatcher: SPathMatcher[Tuple2[T1, T2]]): PathMatcher2[T1, T2] =
    new PathMatcher2(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala3[T1, T2, T3](scalaMatcher: SPathMatcher[Tuple3[T1, T2, T3]]): PathMatcher3[T1, T2, T3] =
    new PathMatcher3(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala4[T1, T2, T3, T4](scalaMatcher: SPathMatcher[Tuple4[T1, T2, T3, T4]]): PathMatcher4[T1, T2, T3, T4] =
    new PathMatcher4(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala5[T1, T2, T3, T4, T5](scalaMatcher: SPathMatcher[Tuple5[T1, T2, T3, T4, T5]]): PathMatcher5[T1, T2, T3, T4, T5] =
    new PathMatcher5(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala6[T1, T2, T3, T4, T5, T6](scalaMatcher: SPathMatcher[Tuple6[T1, T2, T3, T4, T5, T6]]): PathMatcher6[T1, T2, T3, T4, T5, T6] =
    new PathMatcher6(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala7[T1, T2, T3, T4, T5, T6, T7](scalaMatcher: SPathMatcher[Tuple7[T1, T2, T3, T4, T5, T6, T7]]): PathMatcher7[T1, T2, T3, T4, T5, T6, T7] =
    new PathMatcher7(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala8[T1, T2, T3, T4, T5, T6, T7, T8](scalaMatcher: SPathMatcher[Tuple8[T1, T2, T3, T4, T5, T6, T7, T8]]): PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8] =
    new PathMatcher8(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala9[T1, T2, T3, T4, T5, T6, T7, T8, T9](scalaMatcher: SPathMatcher[Tuple9[T1, T2, T3, T4, T5, T6, T7, T8, T9]]): PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9] =
    new PathMatcher9(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10](scalaMatcher: SPathMatcher[Tuple10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]]): PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] =
    new PathMatcher10(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11](scalaMatcher: SPathMatcher[Tuple11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]]): PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] =
    new PathMatcher11(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12](scalaMatcher: SPathMatcher[Tuple12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]]): PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] =
    new PathMatcher12(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13](scalaMatcher: SPathMatcher[Tuple13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]]): PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] =
    new PathMatcher13(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14](scalaMatcher: SPathMatcher[Tuple14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]]): PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] =
    new PathMatcher14(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15](scalaMatcher: SPathMatcher[Tuple15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]]): PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] =
    new PathMatcher15(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16](scalaMatcher: SPathMatcher[Tuple16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]]): PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] =
    new PathMatcher16(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17](scalaMatcher: SPathMatcher[Tuple17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]]): PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] =
    new PathMatcher17(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18](scalaMatcher: SPathMatcher[Tuple18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]]): PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] =
    new PathMatcher18(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19](scalaMatcher: SPathMatcher[Tuple19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]]): PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] =
    new PathMatcher19(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20](scalaMatcher: SPathMatcher[Tuple20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]]): PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] =
    new PathMatcher20(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21](scalaMatcher: SPathMatcher[Tuple21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]]): PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21] =
    new PathMatcher21(scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScala22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22](scalaMatcher: SPathMatcher[Tuple22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]]): PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22] =
    new PathMatcher22(scalaMatcher)
  


  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan1[A, B, T1](scalaMatcher: SPathMatcher[(A, B, T1)]) =
    new PathMatcherTwoMoreThan1[A, B, T1](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan2[A, B, T1, T2](scalaMatcher: SPathMatcher[(A, B, T1, T2)]) =
    new PathMatcherTwoMoreThan2[A, B, T1, T2](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan3[A, B, T1, T2, T3](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3)]) =
    new PathMatcherTwoMoreThan3[A, B, T1, T2, T3](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan4[A, B, T1, T2, T3, T4](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4)]) =
    new PathMatcherTwoMoreThan4[A, B, T1, T2, T3, T4](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan5[A, B, T1, T2, T3, T4, T5](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5)]) =
    new PathMatcherTwoMoreThan5[A, B, T1, T2, T3, T4, T5](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan6[A, B, T1, T2, T3, T4, T5, T6](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6)]) =
    new PathMatcherTwoMoreThan6[A, B, T1, T2, T3, T4, T5, T6](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan7[A, B, T1, T2, T3, T4, T5, T6, T7](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7)]) =
    new PathMatcherTwoMoreThan7[A, B, T1, T2, T3, T4, T5, T6, T7](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan8[A, B, T1, T2, T3, T4, T5, T6, T7, T8](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8)]) =
    new PathMatcherTwoMoreThan8[A, B, T1, T2, T3, T4, T5, T6, T7, T8](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan9[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9)]) =
    new PathMatcherTwoMoreThan9[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan10[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10)]) =
    new PathMatcherTwoMoreThan10[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan11[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11)]) =
    new PathMatcherTwoMoreThan11[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan12[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12)]) =
    new PathMatcherTwoMoreThan12[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan13[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13)]) =
    new PathMatcherTwoMoreThan13[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan14[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14)]) =
    new PathMatcherTwoMoreThan14[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan15[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15)]) =
    new PathMatcherTwoMoreThan15[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan16[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16)]) =
    new PathMatcherTwoMoreThan16[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan17[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17)]) =
    new PathMatcherTwoMoreThan17[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan18[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18)]) =
    new PathMatcherTwoMoreThan18[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan19[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19)]) =
    new PathMatcherTwoMoreThan19[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19](scalaMatcher)
  
  /** INTERNAL API */
  @InternalApi
  private[server] def fromScalaTwoMoreThan20[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20](scalaMatcher: SPathMatcher[(A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20)]) =
    new PathMatcherTwoMoreThan20[A, B, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20](scalaMatcher)
  

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher0(val toScala: SPathMatcher[Unit]) {
  import JavaPathMatchers._

  def slash() = fromScala0(toScala./)

  def slash(segment: String)                   : PathMatcher0         = fromScala0(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher0         = fromScala0(toScala / next.toScala)
  def slash[T](next: PathMatcher1[T])          : PathMatcher1[T]      = fromScala1(toScala / next.toScala)
  def slash[T1, T2](next: PathMatcher2[T1, T2]): PathMatcher2[T1, T2] = fromScala2(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher0         = fromScala0(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher0         = fromScala0(toScala ~ next.toScala)
  def concat[T](next: PathMatcher1[T])          : PathMatcher1[T]      = fromScala1(toScala ~ next.toScala)
  def concat[T1, T2](next: PathMatcher2[T1, T2]): PathMatcher2[T1, T2] = fromScala2(toScala ~ next.toScala)

  def orElse(segment: String) = fromScala0(toScala | segment)
  def orElse(alternative: PathMatcher0) = fromScala0(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

  def repeat(min: Int, max: Int): PathMatcher0 = repeat(min, max, SPathMatchers.Neutral)
  def repeat(min: Int, max: Int, separator: PathMatcher0): PathMatcher0 = fromScala0(toScala.repeat(min, max, separator.toScala))

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher1[T1](val toScala: SPathMatcher[Tuple1[T1]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher1[T1]         = fromScala1(toScala./)
  def slash(segment: String)                   : PathMatcher1[T1]         = fromScala1(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher1[T1]         = fromScala1(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])           = fromScala2(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan1(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher1[T1]         = fromScala1(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher1[T1]         = fromScala1(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])           = fromScala2(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan1(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher1[T1]) = fromScala1(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

  def repeat(min: Int, max: Int): PathMatcher1[JList[T1]] = repeat(min, max, SPathMatchers.Neutral)
  def repeat(min: Int, max: Int, separator: PathMatcher0): PathMatcher1[JList[T1]] =
    fromScala1(toScala.repeat(min, max, separator.toScala).map(_.asJava))

  def map[U](f: JFunction[T1, U]) =
    fromScala1(toScala.map(t => f.apply(t)))
}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher2[T1, T2](val toScala: SPathMatcher[Tuple2[T1, T2]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher2[T1, T2]         = fromScala2(toScala./)
  def slash(segment: String)                   : PathMatcher2[T1, T2]         = fromScala2(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher2[T1, T2]         = fromScala2(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan1(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan2(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher2[T1, T2]         = fromScala2(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher2[T1, T2]         = fromScala2(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher3[T1, T2, N]      = fromScalaTwoMoreThan1(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan2(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher2[T1, T2]) = fromScala2(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher3[T1, T2, T3](val toScala: SPathMatcher[Tuple3[T1, T2, T3]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher3[T1, T2, T3]         = fromScala3(toScala./)
  def slash(segment: String)                   : PathMatcher3[T1, T2, T3]         = fromScala3(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher3[T1, T2, T3]         = fromScala3(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan2(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan3(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher3[T1, T2, T3]         = fromScala3(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher3[T1, T2, T3]         = fromScala3(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher4[T1, T2, T3, N]      = fromScalaTwoMoreThan2(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan3(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher3[T1, T2, T3]) = fromScala3(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher4[T1, T2, T3, T4](val toScala: SPathMatcher[Tuple4[T1, T2, T3, T4]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher4[T1, T2, T3, T4]         = fromScala4(toScala./)
  def slash(segment: String)                   : PathMatcher4[T1, T2, T3, T4]         = fromScala4(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher4[T1, T2, T3, T4]         = fromScala4(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan3(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan4(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher4[T1, T2, T3, T4]         = fromScala4(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher4[T1, T2, T3, T4]         = fromScala4(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher5[T1, T2, T3, T4, N]      = fromScalaTwoMoreThan3(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan4(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher4[T1, T2, T3, T4]) = fromScala4(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher5[T1, T2, T3, T4, T5](val toScala: SPathMatcher[Tuple5[T1, T2, T3, T4, T5]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher5[T1, T2, T3, T4, T5]         = fromScala5(toScala./)
  def slash(segment: String)                   : PathMatcher5[T1, T2, T3, T4, T5]         = fromScala5(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher5[T1, T2, T3, T4, T5]         = fromScala5(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan4(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan5(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher5[T1, T2, T3, T4, T5]         = fromScala5(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher5[T1, T2, T3, T4, T5]         = fromScala5(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher6[T1, T2, T3, T4, T5, N]      = fromScalaTwoMoreThan4(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan5(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher5[T1, T2, T3, T4, T5]) = fromScala5(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher6[T1, T2, T3, T4, T5, T6](val toScala: SPathMatcher[Tuple6[T1, T2, T3, T4, T5, T6]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher6[T1, T2, T3, T4, T5, T6]         = fromScala6(toScala./)
  def slash(segment: String)                   : PathMatcher6[T1, T2, T3, T4, T5, T6]         = fromScala6(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher6[T1, T2, T3, T4, T5, T6]         = fromScala6(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan5(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan6(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher6[T1, T2, T3, T4, T5, T6]         = fromScala6(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher6[T1, T2, T3, T4, T5, T6]         = fromScala6(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher7[T1, T2, T3, T4, T5, T6, N]      = fromScalaTwoMoreThan5(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan6(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher6[T1, T2, T3, T4, T5, T6]) = fromScala6(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher7[T1, T2, T3, T4, T5, T6, T7](val toScala: SPathMatcher[Tuple7[T1, T2, T3, T4, T5, T6, T7]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher7[T1, T2, T3, T4, T5, T6, T7]         = fromScala7(toScala./)
  def slash(segment: String)                   : PathMatcher7[T1, T2, T3, T4, T5, T6, T7]         = fromScala7(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher7[T1, T2, T3, T4, T5, T6, T7]         = fromScala7(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan6(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan7(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher7[T1, T2, T3, T4, T5, T6, T7]         = fromScala7(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher7[T1, T2, T3, T4, T5, T6, T7]         = fromScala7(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher8[T1, T2, T3, T4, T5, T6, T7, N]      = fromScalaTwoMoreThan6(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan7(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher7[T1, T2, T3, T4, T5, T6, T7]) = fromScala7(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8](val toScala: SPathMatcher[Tuple8[T1, T2, T3, T4, T5, T6, T7, T8]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8]         = fromScala8(toScala./)
  def slash(segment: String)                   : PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8]         = fromScala8(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8]         = fromScala8(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan7(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan8(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8]         = fromScala8(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8]         = fromScala8(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, N]      = fromScalaTwoMoreThan7(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan8(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher8[T1, T2, T3, T4, T5, T6, T7, T8]) = fromScala8(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9](val toScala: SPathMatcher[Tuple9[T1, T2, T3, T4, T5, T6, T7, T8, T9]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9]         = fromScala9(toScala./)
  def slash(segment: String)                   : PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9]         = fromScala9(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9]         = fromScala9(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan8(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan9(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9]         = fromScala9(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9]         = fromScala9(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, N]      = fromScalaTwoMoreThan8(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan9(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher9[T1, T2, T3, T4, T5, T6, T7, T8, T9]) = fromScala9(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10](val toScala: SPathMatcher[Tuple10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]         = fromScala10(toScala./)
  def slash(segment: String)                   : PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]         = fromScala10(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]         = fromScala10(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan9(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan10(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]         = fromScala10(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]         = fromScala10(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, N]      = fromScalaTwoMoreThan9(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan10(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]) = fromScala10(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11](val toScala: SPathMatcher[Tuple11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]         = fromScala11(toScala./)
  def slash(segment: String)                   : PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]         = fromScala11(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]         = fromScala11(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan10(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan11(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]         = fromScala11(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]         = fromScala11(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, N]      = fromScalaTwoMoreThan10(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan11(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]) = fromScala11(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12](val toScala: SPathMatcher[Tuple12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]         = fromScala12(toScala./)
  def slash(segment: String)                   : PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]         = fromScala12(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]         = fromScala12(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan11(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan12(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]         = fromScala12(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]         = fromScala12(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, N]      = fromScalaTwoMoreThan11(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan12(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]) = fromScala12(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13](val toScala: SPathMatcher[Tuple13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]         = fromScala13(toScala./)
  def slash(segment: String)                   : PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]         = fromScala13(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]         = fromScala13(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan12(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan13(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]         = fromScala13(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]         = fromScala13(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, N]      = fromScalaTwoMoreThan12(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan13(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]) = fromScala13(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14](val toScala: SPathMatcher[Tuple14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]         = fromScala14(toScala./)
  def slash(segment: String)                   : PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]         = fromScala14(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]         = fromScala14(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan13(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan14(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]         = fromScala14(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]         = fromScala14(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, N]      = fromScalaTwoMoreThan13(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan14(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]) = fromScala14(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15](val toScala: SPathMatcher[Tuple15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]         = fromScala15(toScala./)
  def slash(segment: String)                   : PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]         = fromScala15(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]         = fromScala15(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan14(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan15(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]         = fromScala15(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]         = fromScala15(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, N]      = fromScalaTwoMoreThan14(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan15(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]) = fromScala15(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16](val toScala: SPathMatcher[Tuple16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]         = fromScala16(toScala./)
  def slash(segment: String)                   : PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]         = fromScala16(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]         = fromScala16(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan15(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan16(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]         = fromScala16(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]         = fromScala16(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, N]      = fromScalaTwoMoreThan15(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan16(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]) = fromScala16(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17](val toScala: SPathMatcher[Tuple17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]         = fromScala17(toScala./)
  def slash(segment: String)                   : PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]         = fromScala17(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]         = fromScala17(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan16(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan17(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]         = fromScala17(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]         = fromScala17(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, N]      = fromScalaTwoMoreThan16(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan17(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]) = fromScala17(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18](val toScala: SPathMatcher[Tuple18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]         = fromScala18(toScala./)
  def slash(segment: String)                   : PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]         = fromScala18(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]         = fromScala18(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan17(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan18(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]         = fromScala18(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]         = fromScala18(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, N]      = fromScalaTwoMoreThan17(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan18(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]) = fromScala18(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19](val toScala: SPathMatcher[Tuple19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]         = fromScala19(toScala./)
  def slash(segment: String)                   : PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]         = fromScala19(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]         = fromScala19(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan18(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan19(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]         = fromScala19(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]         = fromScala19(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, N]      = fromScalaTwoMoreThan18(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan19(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]) = fromScala19(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20](val toScala: SPathMatcher[Tuple20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]         = fromScala20(toScala./)
  def slash(segment: String)                   : PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]         = fromScala20(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]         = fromScala20(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N])                   = fromScalaTwoMoreThan19(toScala / next.toScala)
  def slash[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan20(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]         = fromScala20(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]         = fromScala20(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N])          : PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, N]      = fromScalaTwoMoreThan19(toScala ~ next.toScala)
  def concat[N1, N2](next: PathMatcher2[N1, N2]) = fromScalaTwoMoreThan20(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]) = fromScala20(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}


/* The last 21 and 22 are special as we are not able to generate slash/concat for them (would need to add more params) */

/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 *
 * It is not possible to append more matchers with keeping their values as parameters (due to limit of Tuple22).
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21](val toScala: SPathMatcher[Tuple21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]]) {
  import JavaPathMatchers._

  def slash()                         : PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]         = fromScala21(toScala./)
  def slash(segment: String)          : PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]         = fromScala21(toScala / segment)
  def slash(next: PathMatcher0)       : PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]         = fromScala21(toScala./(next.toScala))
  def slash[N](next: PathMatcher1[N]) = fromScala22(toScala / next.toScala)

  def concat(segment: String)                   : PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]         = fromScala21(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]         = fromScala21(toScala ~ next.toScala)
  def concat[N](next: PathMatcher1[N]) = fromScala22(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]) = fromScala21(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}


/**
 * A PathMatcher tries to match a prefix of a given string and returns either a PathMatcher.Matched instance
 * if matched, otherwise PathMatchers.Unmatched.
 *
 * It is not possible to append more matchers with keeping their values as parameters (due to limit of Tuple22).
 */
// Generated class, do not edit in place, but edit template instead.
final class PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22](val toScala: SPathMatcher[Tuple22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]]) {
  import JavaPathMatchers._

  def slash()                                  : PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]         = fromScala22(toScala./)
  def slash(segment: String)                   : PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]         = fromScala22(toScala / segment)
  def slash(next: PathMatcher0)                : PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]         = fromScala22(toScala./(next.toScala))

  def concat(segment: String)                   : PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]         = fromScala22(toScala ~ segment)
  def concat(next: PathMatcher0)                : PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]         = fromScala22(toScala ~ next.toScala)

  def orElse(alternative: PathMatcher22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]) = fromScala22(toScala | alternative.toScala)

  def invert = fromScala0(!toScala)

}
