/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.coordination.lease.kubernetes;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.coordination.lease.LeaseException;
import org.apache.pekko.coordination.lease.LeaseSettings;
import org.apache.pekko.coordination.lease.LeaseTimeoutException;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesLease$;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesSettings;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesSettings$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$LeaseAcquired$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$LeaseReleased$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$LeaseTaken$;
import org.apache.pekko.coordination.lease.kubernetes.internal.KubernetesApiImpl;
import org.apache.pekko.coordination.lease.scaladsl.Lease;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.ConstantFun$;
import org.apache.pekko.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005mv!B\u0011#\u0011\u0003yc!B\u0019#\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0019\u000b!\u0019!C\u0005\u000f\"1!+\u0001Q\u0001\n!CQaU\u0001\u0005\nQCQ!Y\u0001\u0005\n\tDQA]\u0001\u0005\nM4A!\r\u0012\u0001k\"AAP\u0003B\u0001B\u0003%Q\u0010\u0003\u0006\u0002\b)\u0011\t\u0011)A\u0005\u0003\u0013AA\"a\u0004\u000b\u0005\u0003\u0005\u000b\u0011BA\t\u00033Aq!\u000f\u0006\u0005\u0002!\nY\u0002C\u0005\u0002&)\u0011\r\u0011\"\u0003\u0002(!A\u0011Q\u0007\u0006!\u0002\u0013\tI\u0003C\u0005\u00028)\u0011\r\u0011\"\u0003\u0002:!A\u0011\u0011\t\u0006!\u0002\u0013\tY\u0004C\u0005\u0002D)\u0011\r\u0011\"\u0003\u0002F!A\u00111\u000b\u0006!\u0002\u0013\t9\u0005C\u0005\u0002V)\u0011\r\u0011b\u0003\u0002X!A\u00111\r\u0006!\u0002\u0013\tI\u0006\u0003\u0004:\u0015\u0011\u0005\u0011Q\r\u0005\n\u0003[R!\u0019!C\u0005\u0003_Bq!!\u001d\u000bA\u0003%Q\u000bC\u0005\u0002t)\u0011\r\u0011\"\u0003\u0002v!A\u0011Q\u0010\u0006!\u0002\u0013\t9\bC\u0004\u0002\u0000)!\t%!!\t\u000f\u0005%%\u0002\"\u0011\u0002\f\"9\u0011q\u0013\u0006\u0005B\u0005-\u0005bBAL\u0015\u0011\u0005\u0013\u0011\u0014\u0005\u000f\u0003oS\u0001\u0013aA\u0001\u0002\u0013%\u0011\u0011XA\r\u0003=YUOY3s]\u0016$Xm\u001d'fCN,'BA\u0012%\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003K\u0019\nQ\u0001\\3bg\u0016T!a\n\u0015\u0002\u0019\r|wN\u001d3j]\u0006$\u0018n\u001c8\u000b\u0005%R\u0013!\u00029fW.|'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00021\u00035\t!EA\bLk\n,'O\\3uKNdU-Y:f'\t\t1\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\n!bY8oM&<\u0007+\u0019;i+\u0005i\u0004C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0011a\u0017M\\4\u000b\u0003\t\u000bAA[1wC&\u0011Ai\u0010\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\r|gNZ5h!\u0006$\b\u000eI\u0001\rY\u0016\f7/Z\"pk:$XM]\u000b\u0002\u0011B\u0011\u0011\nU\u0007\u0002\u0015*\u00111\nT\u0001\u0007CR|W.[2\u000b\u00055s\u0015AC2p]\u000e,(O]3oi*\u0011q*Q\u0001\u0005kRLG.\u0003\u0002R\u0015\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fQ\u0002\\3bg\u0016\u001cu.\u001e8uKJ\u0004\u0013A\u0006;sk:\u001c\u0017\r^3U_Z\u001a4\t[1sC\u000e$XM]:\u0015\u0005U{\u0006C\u0001,^\u001d\t96\f\u0005\u0002Yk5\t\u0011L\u0003\u0002[]\u00051AH]8pizJ!\u0001X\u001b\u0002\rA\u0013X\rZ3g\u0013\t!eL\u0003\u0002]k!)\u0001m\u0002a\u0001+\u0006!a.Y7f\u0003\u0011!(/[7\u0015\u0007U\u001bG\rC\u0003a\u0011\u0001\u0007Q\u000bC\u0003f\u0011\u0001\u0007a-\u0001\u0006dQ\u0006\u0014\u0018m\u0019;feN\u00042a\u001a7p\u001d\tA'N\u0004\u0002YS&\ta'\u0003\u0002lk\u00059\u0001/Y2lC\u001e,\u0017BA7o\u0005\u0011a\u0015n\u001d;\u000b\u0005-,\u0004C\u0001\u001bq\u0013\t\tXG\u0001\u0003DQ\u0006\u0014\u0018!F7bW\u0016$ejU\u00191ge\u001au.\u001c9bi&\u0014G.\u001a\u000b\u0003+RDQ\u0001Y\u0005A\u0002U\u001b\"A\u0003<\u0011\u0005]TX\"\u0001=\u000b\u0005e$\u0013\u0001C:dC2\fGm\u001d7\n\u0005mD(!\u0002'fCN,\u0017AB:zgR,W\u000eE\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003A\u0013!B1di>\u0014\u0018bAA\u0003\u007f\n\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u0006QA.Z1tKR\u000b7.\u001a8\u0011\u0007%\u000bY!C\u0002\u0002\u000e)\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001C:fiRLgnZ:\u0011\t\u0005M\u0011QC\u0007\u0002I%\u0019\u0011q\u0003\u0013\u0003\u001b1+\u0017m]3TKR$\u0018N\\4t\u0013\r\tyA\u001f\u000b\t\u0003;\ty\"!\t\u0002$A\u0011\u0001G\u0003\u0005\u0006y:\u0001\r! \u0005\b\u0003\u000fq\u0001\u0019AA\u0005\u0011\u001d\tyA\u0004a\u0001\u0003#\ta\u0001\\8hO\u0016\u0014XCAA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018Y\u0005)1\u000f\u001c45U&!\u00111GA\u0017\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013aC69gN+G\u000f^5oON,\"!a\u000f\u0011\u0007A\ni$C\u0002\u0002@\t\u0012!cS;cKJtW\r^3t'\u0016$H/\u001b8hg\u0006a1\u000eO:TKR$\u0018N\\4tA\u000511\u000eO:Ba&,\"!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014#\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA)\u0003\u0017\u0012\u0011cS;cKJtW\r^3t\u0003BL\u0017*\u001c9m\u0003\u001dY\u0007h]!qS\u0002\nq\u0001^5nK>,H/\u0006\u0002\u0002ZA!\u00111LA0\u001b\t\tiF\u0003\u0002PQ%!\u0011\u0011MA/\u0005\u001d!\u0016.\\3pkR\f\u0001\u0002^5nK>,H\u000f\t\u000b\u0007\u0003;\t9'a\u001b\t\u000f\u0005%t\u00031\u0001\u0002\u0012\u0005iA.Z1tKN+G\u000f^5oONDQ\u0001`\fA\u0002u\f\u0011\u0002\\3bg\u0016t\u0015-\\3\u0016\u0003U\u000b!\u0002\\3bg\u0016t\u0015-\\3!\u0003)aW-Y:f\u0003\u000e$xN]\u000b\u0003\u0003o\u00022A`A=\u0013\r\tYh \u0002\t\u0003\u000e$xN\u001d*fM\u0006YA.Z1tK\u0006\u001bGo\u001c:!\u0003)\u0019\u0007.Z2l\u0019\u0016\f7/\u001a\u000b\u0003\u0003\u0007\u00032\u0001NAC\u0013\r\t9)\u000e\u0002\b\u0005>|G.Z1o\u0003\u001d\u0011X\r\\3bg\u0016$\"!!$\u0011\r\u0005=\u00151SAB\u001b\t\t\tJ\u0003\u0002Nk%!\u0011QSAI\u0005\u00191U\u000f^;sK\u00069\u0011mY9vSJ,G\u0003BAG\u00037Cq!!( \u0001\u0004\ty*A\tmK\u0006\u001cX\rT8ti\u000e\u000bG\u000e\u001c2bG.\u0004r\u0001NAQ\u0003K\u000b\t,C\u0002\u0002$V\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000bQ\n9+a+\n\u0007\u0005%VG\u0001\u0004PaRLwN\u001c\t\u0004O\u00065\u0016bAAX]\nIA\u000b\u001b:po\u0006\u0014G.\u001a\t\u0004i\u0005M\u0016bAA[k\t!QK\\5u\u00039\u0019X\u000f]3sIM,G\u000f^5oON,\"!!\u0005")
public class KubernetesLease
extends Lease {
    private final AtomicBoolean leaseTaken;
    private final Logger logger;
    private final KubernetesSettings k8sSettings;
    private final KubernetesApiImpl k8sApi;
    private final Timeout timeout;
    private final String leaseName;
    private final ActorRef leaseActor;

    public static String configPath() {
        return KubernetesLease$.MODULE$.configPath();
    }

    private /* synthetic */ LeaseSettings super$settings() {
        return super.settings();
    }

    private Logger logger() {
        return this.logger;
    }

    private KubernetesSettings k8sSettings() {
        return this.k8sSettings;
    }

    private KubernetesApiImpl k8sApi() {
        return this.k8sApi;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    private String leaseName() {
        return this.leaseName;
    }

    private ActorRef leaseActor() {
        return this.leaseActor;
    }

    public boolean checkLease() {
        return this.leaseTaken.get();
    }

    public Future<Object> release() {
        ActorRef qual$1 = package$.MODULE$.ask(this.leaseActor());
        LeaseActor.Release x$1 = new LeaseActor.Release();
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).transform((Function1 & Serializable)x0$1 -> {
            Object object;
            boolean bl = false;
            Success success = null;
            boolean bl2 = false;
            Failure failure = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Object object2 = success.value();
                if (LeaseActor$LeaseReleased$.MODULE$.equals(object2)) {
                    return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            if (bl && (object = success.value()) instanceof LeaseActor.InvalidRequest) {
                LeaseActor.InvalidRequest invalidRequest = (LeaseActor.InvalidRequest)object;
                String msg = invalidRequest.reason();
                return new Failure((Throwable)new LeaseException(msg));
            }
            if (try_ instanceof Failure) {
                bl2 = true;
                failure = (Failure)try_;
                if (failure.exception() instanceof AskTimeoutException) {
                    return new Failure((Throwable)new LeaseTimeoutException(new StringBuilder(62).append("Timed out trying to release lease [").append(this.leaseName()).append(", ").append(this.super$settings().ownerName()).append("]. It may still be taken.").toString()));
                }
            }
            if (bl2) {
                Throwable exception = failure.exception();
                return new Failure(exception);
            }
            throw new MatchError((Object)try_);
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<Object> acquire() {
        return this.acquire((Function1<Option<Throwable>, BoxedUnit>)ConstantFun$.MODULE$.scalaAnyToUnit());
    }

    public Future<Object> acquire(Function1<Option<Throwable>, BoxedUnit> leaseLostCallback) {
        ActorRef qual$1 = package$.MODULE$.ask(this.leaseActor());
        LeaseActor.Acquire x$1 = new LeaseActor.Acquire(leaseLostCallback);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).transform((Function1 & Serializable)x0$1 -> {
            Object object;
            Object object2;
            boolean bl = false;
            Success success = null;
            boolean bl2 = false;
            Failure failure = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Object object3 = success.value();
                if (LeaseActor$LeaseAcquired$.MODULE$.equals(object3)) {
                    return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            if (bl && LeaseActor$LeaseTaken$.MODULE$.equals(object2 = success.value())) {
                return new Success((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (bl && (object = success.value()) instanceof LeaseActor.InvalidRequest) {
                LeaseActor.InvalidRequest invalidRequest = (LeaseActor.InvalidRequest)object;
                String msg = invalidRequest.reason();
                return new Failure((Throwable)new LeaseException(msg));
            }
            if (try_ instanceof Failure) {
                bl2 = true;
                failure = (Failure)try_;
                if (failure.exception() instanceof AskTimeoutException) {
                    return new Failure((Throwable)new LeaseTimeoutException(new StringBuilder(62).append("Timed out trying to acquire lease [").append(this.leaseName()).append(", ").append(this.super$settings().ownerName()).append("]. It may still be taken.").toString()));
                }
            }
            if (bl2) {
                Throwable exception = failure.exception();
                return new Failure(exception);
            }
            throw new MatchError((Object)try_);
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    public KubernetesLease(ExtendedActorSystem system, AtomicBoolean leaseTaken, LeaseSettings settings) {
        this.leaseTaken = leaseTaken;
        super(settings);
        this.logger = LoggerFactory.getLogger(KubernetesLease.class);
        this.k8sSettings = KubernetesSettings$.MODULE$.apply(super.settings().leaseConfig(), super.settings().timeoutSettings());
        this.k8sApi = new KubernetesApiImpl((ActorSystem)system, this.k8sSettings());
        this.timeout = new Timeout(super.settings().timeoutSettings().operationTimeout());
        this.leaseName = KubernetesLease$.MODULE$.org$apache$pekko$coordination$lease$kubernetes$KubernetesLease$$makeDNS1039Compatible(super.settings().leaseName());
        this.leaseActor = system.systemActorOf(LeaseActor$.MODULE$.props(this.k8sApi(), super.settings(), this.leaseName(), leaseTaken), new StringBuilder(15).append("kubernetesLease").append(KubernetesLease$.MODULE$.org$apache$pekko$coordination$lease$kubernetes$KubernetesLease$$leaseCounter().incrementAndGet()).toString());
        String string = this.leaseName();
        String string2 = super.settings().leaseName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.logger().info("Original lease name [{}] sanitized for kubernetes: [{}]", new Object[]{super.settings().leaseName(), this.leaseName()});
        }
        this.logger().debug("Starting kubernetes lease actor [{}] for lease [{}], owner [{}]", new Object[]{this.leaseActor(), this.leaseName(), super.settings().ownerName()});
    }

    public KubernetesLease(LeaseSettings leaseSettings, ExtendedActorSystem system) {
        this(system, new AtomicBoolean(false), leaseSettings);
    }
}

