/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.coordination.lease.kubernetes;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.coordination.lease.LeaseException;
import org.apache.pekko.coordination.lease.LeaseSettings;
import org.apache.pekko.coordination.lease.LeaseTimeoutException;
import org.apache.pekko.coordination.lease.kubernetes.AbstractKubernetesLease$;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesApi;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesLease;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesSettings;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesSettings$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$LeaseAcquired$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$LeaseReleased$;
import org.apache.pekko.coordination.lease.kubernetes.LeaseActor$LeaseTaken$;
import org.apache.pekko.coordination.lease.scaladsl.Lease;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.ConstantFun$;
import org.apache.pekko.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dv!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004bB\u001d\u0002\u0005\u0004%\tA\u000f\u0005\u0007\u0007\u0006\u0001\u000b\u0011B\u001e\t\u000f\u0011\u000b!\u0019!C\u0005\u000b\"1\u0001+\u0001Q\u0001\n\u0019CQ!U\u0001\u0005\nICQaX\u0001\u0005\n\u0001DQ\u0001]\u0001\u0005\nE4Qa\f\u0011\u0002\u0002MD\u0001B\u001f\u0006\u0003\u0002\u0003\u0006Ia\u001f\u0005\u000b\u0003\u0007Q!\u0011!Q\u0001\n\u0005\u0015\u0001\u0002DA\u0006\u0015\t\u0005\t\u0015!\u0003\u0002\u000e\u0005U\u0001BB\u001c\u000b\t\u0003\t9\u0002C\u0005\u0002\")\u0011\r\u0011\"\u0003\u0002$!A\u0011\u0011\u0007\u0006!\u0002\u0013\t)\u0003C\u0005\u00024)\u0011\r\u0011\"\u0005\u00026!A\u0011Q\b\u0006!\u0002\u0013\t9\u0004C\u0004\u0002@)1\t\"!\u0011\t\u0013\u0005%#B1A\u0005\f\u0005-\u0003\u0002CA,\u0015\u0001\u0006I!!\u0014\t\u0013\u0005e#B1A\u0005\n\u0005m\u0003bBA/\u0015\u0001\u0006Ia\u0015\u0005\n\u0003?R!\u0019!C\u0005\u0003CB\u0001\"!\u001b\u000bA\u0003%\u00111\r\u0005\b\u0003WRA\u0011IA7\u0011\u001d\t)H\u0003C!\u0003oBq!a!\u000b\t\u0003\n9\bC\u0004\u0002\u0004*!\t%!\"\t\u001d\u0005\r&\u0002%A\u0002\u0002\u0003%I!!*\u0002\u0016\u00059\u0012IY:ue\u0006\u001cGoS;cKJtW\r^3t\u0019\u0016\f7/\u001a\u0006\u0003C\t\n!b[;cKJtW\r^3t\u0015\t\u0019C%A\u0003mK\u0006\u001cXM\u0003\u0002&M\u0005a1m\\8sI&t\u0017\r^5p]*\u0011q\u0005K\u0001\u0006a\u0016\\7n\u001c\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00059\nQ\"\u0001\u0011\u0003/\u0005\u00137\u000f\u001e:bGR\\UOY3s]\u0016$Xm\u001d'fCN,7CA\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!L\u0001\u000bG>tg-[4QCRDW#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001\u00027b]\u001eT\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\t11\u000b\u001e:j]\u001e\f1bY8oM&<\u0007+\u0019;iA\u0005aA.Z1tK\u000e{WO\u001c;feV\ta\t\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u00061\u0011\r^8nS\u000eT!a\u0013'\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002N\u007f\u0005!Q\u000f^5m\u0013\ty\u0005JA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u000eY\u0016\f7/Z\"pk:$XM\u001d\u0011\u0002-Q\u0014XO\\2bi\u0016$vNN\u001aDQ\u0006\u0014\u0018m\u0019;feN$\"aU/\u0011\u0005Q[fBA+Z!\t16'D\u0001X\u0015\tAF&\u0001\u0004=e>|GOP\u0005\u00035N\na\u0001\u0015:fI\u00164\u0017B\u0001\"]\u0015\tQ6\u0007C\u0003_\u000f\u0001\u00071+\u0001\u0003oC6,\u0017\u0001\u0002;sS6$2aU1c\u0011\u0015q\u0006\u00021\u0001T\u0011\u0015\u0019\u0007\u00021\u0001e\u0003)\u0019\u0007.\u0019:bGR,'o\u001d\t\u0004K*lgB\u00014i\u001d\t1v-C\u00015\u0013\tI7'A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'\u0001\u0002'jgRT!![\u001a\u0011\u0005Ir\u0017BA84\u0005\u0011\u0019\u0005.\u0019:\u0002+5\f7.\u001a#O'F\u00024'O\"p[B\fG/\u001b2mKR\u00111K\u001d\u0005\u0006=&\u0001\raU\n\u0003\u0015Q\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0012\u0002\u0011M\u001c\u0017\r\\1eg2L!!\u001f<\u0003\u000b1+\u0017m]3\u0002\rML8\u000f^3n!\tax0D\u0001~\u0015\tqh%A\u0003bGR|'/C\u0002\u0002\u0002u\u00141#\u0012=uK:$W\rZ!di>\u00148+_:uK6\f!\u0002\\3bg\u0016$\u0016m[3o!\r9\u0015qA\u0005\u0004\u0003\u0013A%!D!u_6L7MQ8pY\u0016\fg.\u0001\u0005tKR$\u0018N\\4t!\u0011\ty!!\u0005\u000e\u0003\tJ1!a\u0005#\u00055aU-Y:f'\u0016$H/\u001b8hg&\u0019\u00111\u0002=\u0015\u0011\u0005e\u00111DA\u000f\u0003?\u0001\"A\f\u0006\t\u000bit\u0001\u0019A>\t\u000f\u0005\ra\u00021\u0001\u0002\u0006!9\u00111\u0002\bA\u0002\u00055\u0011A\u00027pO\u001e,'/\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,)\nQa\u001d7gi)LA!a\f\u0002*\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006lqM\u001cV\r\u001e;j]\u001e\u001cXCAA\u001c!\rq\u0013\u0011H\u0005\u0004\u0003w\u0001#AE&vE\u0016\u0014h.\u001a;fgN+G\u000f^5oON\fAb\u001b\u001dt'\u0016$H/\u001b8hg\u0002\naa\u001b\u001dt\u0003BLWCAA\"!\rq\u0013QI\u0005\u0004\u0003\u000f\u0002#!D&vE\u0016\u0014h.\u001a;fg\u0006\u0003\u0018.A\u0004uS6,w.\u001e;\u0016\u0005\u00055\u0003\u0003BA(\u0003'j!!!\u0015\u000b\u000553\u0013\u0002BA+\u0003#\u0012q\u0001V5nK>,H/\u0001\u0005uS6,w.\u001e;!\u0003%aW-Y:f\u001d\u0006lW-F\u0001T\u0003)aW-Y:f\u001d\u0006lW\rI\u0001\u000bY\u0016\f7/Z!di>\u0014XCAA2!\ra\u0018QM\u0005\u0004\u0003Oj(\u0001C!di>\u0014(+\u001a4\u0002\u00171,\u0017m]3BGR|'\u000fI\u0001\u000bG\",7m\u001b'fCN,GCAA8!\r\u0011\u0014\u0011O\u0005\u0004\u0003g\u001a$a\u0002\"p_2,\u0017M\\\u0001\be\u0016dW-Y:f)\t\tI\b\u0005\u0004\u0002|\u0005}\u0014qN\u0007\u0003\u0003{R!aS\u001a\n\t\u0005\u0005\u0015Q\u0010\u0002\u0007\rV$XO]3\u0002\u000f\u0005\u001c\u0017/^5sKR!\u0011\u0011PAD\u0011\u001d\tI)\ba\u0001\u0003\u0017\u000b\u0011\u0003\\3bg\u0016dun\u001d;DC2d'-Y2l!\u001d\u0011\u0014QRAI\u0003;K1!a$4\u0005%1UO\\2uS>t\u0017\u0007E\u00033\u0003'\u000b9*C\u0002\u0002\u0016N\u0012aa\u00149uS>t\u0007cA3\u0002\u001a&\u0019\u00111\u00147\u0003\u0013QC'o\\<bE2,\u0007c\u0001\u001a\u0002 &\u0019\u0011\u0011U\u001a\u0003\tUs\u0017\u000e^\u0001\u000fgV\u0004XM\u001d\u0013tKR$\u0018N\\4t+\t\ti\u0001")
public abstract class AbstractKubernetesLease
extends Lease {
    private final AtomicBoolean leaseTaken;
    private final Logger logger;
    private final KubernetesSettings k8sSettings;
    private final Timeout timeout;
    private final String leaseName;
    private final ActorRef leaseActor;

    public static String configPath() {
        return AbstractKubernetesLease$.MODULE$.configPath();
    }

    private /* synthetic */ LeaseSettings super$settings() {
        return super.settings();
    }

    private Logger logger() {
        return this.logger;
    }

    public KubernetesSettings k8sSettings() {
        return this.k8sSettings;
    }

    public abstract KubernetesApi k8sApi();

    private Timeout timeout() {
        return this.timeout;
    }

    private String leaseName() {
        return this.leaseName;
    }

    private ActorRef leaseActor() {
        return this.leaseActor;
    }

    public boolean checkLease() {
        return this.leaseTaken.get();
    }

    public Future<Object> release() {
        ActorRef qual$1 = package$.MODULE$.ask(this.leaseActor());
        LeaseActor.Release x$1 = new LeaseActor.Release();
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).transform((Function1 & Serializable)x0$1 -> {
            Object object;
            boolean bl = false;
            Success success = null;
            boolean bl2 = false;
            Failure failure = null;
            if (x0$1 instanceof Success) {
                bl = true;
                success = (Success)x0$1;
                Object object2 = success.value();
                if (LeaseActor$LeaseReleased$.MODULE$.equals(object2)) {
                    return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            if (bl && (object = success.value()) instanceof LeaseActor.InvalidRequest) {
                String msg = ((LeaseActor.InvalidRequest)object).reason();
                return new Failure((Throwable)new LeaseException(msg));
            }
            if (x0$1 instanceof Failure) {
                bl2 = true;
                failure = (Failure)x0$1;
                if (failure.exception() instanceof AskTimeoutException) {
                    return new Failure((Throwable)new LeaseTimeoutException(new StringBuilder(62).append("Timed out trying to release lease [").append(this.leaseName()).append(", ").append(this.super$settings().ownerName()).append("]. It may still be taken.").toString()));
                }
            }
            if (bl2) {
                Throwable exception = failure.exception();
                return new Failure(exception);
            }
            throw new MatchError(x0$1);
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<Object> acquire() {
        return this.acquire((Function1<Option<Throwable>, BoxedUnit>)ConstantFun$.MODULE$.scalaAnyToUnit());
    }

    public Future<Object> acquire(Function1<Option<Throwable>, BoxedUnit> leaseLostCallback) {
        ActorRef qual$1 = package$.MODULE$.ask(this.leaseActor());
        LeaseActor.Acquire x$1 = new LeaseActor.Acquire(leaseLostCallback);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).transform((Function1 & Serializable)x0$1 -> {
            Object object;
            Object object2;
            boolean bl = false;
            Success success = null;
            boolean bl2 = false;
            Failure failure = null;
            if (x0$1 instanceof Success) {
                bl = true;
                success = (Success)x0$1;
                Object object3 = success.value();
                if (LeaseActor$LeaseAcquired$.MODULE$.equals(object3)) {
                    return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
            }
            if (bl && LeaseActor$LeaseTaken$.MODULE$.equals(object2 = success.value())) {
                return new Success((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (bl && (object = success.value()) instanceof LeaseActor.InvalidRequest) {
                String msg = ((LeaseActor.InvalidRequest)object).reason();
                return new Failure((Throwable)new LeaseException(msg));
            }
            if (x0$1 instanceof Failure) {
                bl2 = true;
                failure = (Failure)x0$1;
                if (failure.exception() instanceof AskTimeoutException) {
                    return new Failure((Throwable)new LeaseTimeoutException(new StringBuilder(62).append("Timed out trying to acquire lease [").append(this.leaseName()).append(", ").append(this.super$settings().ownerName()).append("]. It may still be taken.").toString()));
                }
            }
            if (bl2) {
                Throwable exception = failure.exception();
                return new Failure(exception);
            }
            throw new MatchError(x0$1);
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    public AbstractKubernetesLease(ExtendedActorSystem system, AtomicBoolean leaseTaken, LeaseSettings settings) {
        this.leaseTaken = leaseTaken;
        super(settings);
        this.logger = LoggerFactory.getLogger(KubernetesLease.class);
        this.k8sSettings = KubernetesSettings$.MODULE$.apply(super.settings().leaseConfig(), super.settings().timeoutSettings());
        this.timeout = new Timeout(super.settings().timeoutSettings().operationTimeout());
        this.leaseName = AbstractKubernetesLease$.MODULE$.org$apache$pekko$coordination$lease$kubernetes$AbstractKubernetesLease$$makeDNS1039Compatible(super.settings().leaseName());
        this.leaseActor = system.systemActorOf(LeaseActor$.MODULE$.props(this.k8sApi(), super.settings(), this.leaseName(), leaseTaken), new StringBuilder(15).append("kubernetesLease").append(AbstractKubernetesLease$.MODULE$.org$apache$pekko$coordination$lease$kubernetes$AbstractKubernetesLease$$leaseCounter().incrementAndGet()).toString());
        String string = this.leaseName();
        String string2 = super.settings().leaseName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.logger().info("Original lease name [{}] sanitized for kubernetes: [{}]", new Object[]{super.settings().leaseName(), this.leaseName()});
        }
        this.logger().debug("Starting kubernetes lease actor [{}] for lease [{}], owner [{}]", new Object[]{this.leaseActor(), this.leaseName(), super.settings().ownerName()});
    }
}

