/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.coordination.lease.kubernetes.internal;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.coordination.lease.LeaseException;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesSettings;
import org.apache.pekko.coordination.lease.kubernetes.LeaseResource;
import org.apache.pekko.coordination.lease.kubernetes.internal.AbstractKubernetesApiImpl;
import org.apache.pekko.coordination.lease.kubernetes.internal.LeaseCustomResource;
import org.apache.pekko.coordination.lease.kubernetes.internal.Metadata;
import org.apache.pekko.coordination.lease.kubernetes.internal.Spec;
import org.apache.pekko.http.scaladsl.marshalling.Marshal$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpMessage$;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.Materializer$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b!\u0002\u0006\f\u0001MI\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dBQa\u000b\u0001\u0005\u00021BQ\u0001\r\u0001\u0005BEBq!\u0018\u0001\u0012\u0002\u0013\u0005a\fC\u0003j\u0001\u0011\u0005#\u000eC\u0003r\u0001\u0011\u0005#\u000fC\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e\t\t2*\u001e2fe:,G/Z:Ba&LU\u000e\u001d7\u000b\u00051i\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00059y\u0011AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0001#E\u0001\u0006Y\u0016\f7/\u001a\u0006\u0003%M\tAbY8pe\u0012Lg.\u0019;j_:T!\u0001F\u000b\u0002\u000bA,7n[8\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003-I!!H\u0006\u00033\u0005\u00137\u000f\u001e:bGR\\UOY3s]\u0016$Xm]!qS&k\u0007\u000f\\\u0001\u0007gf\u001cH/Z7\u0004\u0001A\u0011\u0011\u0005J\u0007\u0002E)\u00111eE\u0001\u0006C\u000e$xN]\u0005\u0003K\t\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006A1/\u001a;uS:<7\u000f\u0005\u0002)S5\tQ\"\u0003\u0002+\u001b\t\u00112*\u001e2fe:,G/Z:TKR$\u0018N\\4t\u0003\u0019a\u0014N\\5u}Q\u0019QFL\u0018\u0011\u0005m\u0001\u0001\"\u0002\u0010\u0004\u0001\u0004\u0001\u0003\"\u0002\u0014\u0004\u0001\u00049\u0013aE;qI\u0006$X\rT3bg\u0016\u0014Vm]8ve\u000e,G#\u0002\u001aJ'V;\u0006cA\u001a9u5\tAG\u0003\u00026m\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001b\u0003\r\u0019+H/\u001e:f!\u0011Y4I\u0012$\u000f\u0005q\neBA\u001fA\u001b\u0005q$BA  \u0003\u0019a$o\\8u}%\tq'\u0003\u0002Cm\u00059\u0001/Y2lC\u001e,\u0017B\u0001#F\u0005\u0019)\u0015\u000e\u001e5fe*\u0011!I\u000e\t\u0003Q\u001dK!\u0001S\u0007\u0003\u001b1+\u0017m]3SKN|WO]2f\u0011\u0015QE\u00011\u0001L\u0003%aW-Y:f\u001d\u0006lW\r\u0005\u0002M!:\u0011QJ\u0014\t\u0003{YJ!a\u0014\u001c\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001fZBQ\u0001\u0016\u0003A\u0002-\u000b\u0011b\\<oKJt\u0015-\\3\t\u000bY#\u0001\u0019A&\u0002\u000fY,'o]5p]\"9\u0001\f\u0002I\u0001\u0002\u0004I\u0016\u0001\u0002;j[\u0016\u0004\"AW.\u000e\u0003YJ!\u0001\u0018\u001c\u0003\t1{gnZ\u0001\u001ekB$\u0017\r^3MK\u0006\u001cXMU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\tqL\u000b\u0002ZA.\n\u0011\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003MZ\n!\"\u00198o_R\fG/[8o\u0013\tA7MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001cZ3u\u0019\u0016\f7/\u001a*fg>,(oY3\u0015\u0005-|\u0007cA\u001a9YB\u0019!,\u001c$\n\u000594$AB(qi&|g\u000eC\u0003q\r\u0001\u00071*\u0001\u0003oC6,\u0017\u0001\u00049bi\"4uN\u001d'fCN,GcA:\u0002\u0004A\u0011AO \b\u0003krl\u0011A\u001e\u0006\u0003ob\fQ!\\8eK2T!!\u001f>\u0002\u0011M\u001c\u0017\r\\1eg2T!a_\n\u0002\t!$H\u000f]\u0005\u0003{Z\f1!\u0016:j\u0013\ry\u0018\u0011\u0001\u0002\u0005!\u0006$\bN\u0003\u0002~m\")\u0001o\u0002a\u0001\u0017\u0006\u00192M]3bi\u0016dU-Y:f%\u0016\u001cx.\u001e:dKR\u00191.!\u0003\t\u000bAD\u0001\u0019A&\u0002\u001fQ|G*Z1tKJ+7o\\;sG\u0016$2ARA\b\u0011\u001d\t\t\"\u0003a\u0001\u0003'\t1\u0001\\2s!\rY\u0012QC\u0005\u0004\u0003/Y!a\u0005'fCN,7)^:u_6\u0014Vm]8ve\u000e,\u0007f\u0001\u0001\u0002\u001cA!\u0011QDA\u0011\u001b\t\tyB\u0003\u0002g'%!\u00111EA\u0010\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public class KubernetesApiImpl
extends AbstractKubernetesApiImpl {
    private final ActorSystem system;
    private final KubernetesSettings settings;

    @Override
    public Future<Either<LeaseResource, LeaseResource>> updateLeaseResource(String leaseName, String ownerName, String version, long time) {
        LeaseCustomResource lcr = new LeaseCustomResource(new Metadata(leaseName, (Option<String>)new Some((Object)version)), new Spec(ownerName, System.currentTimeMillis()), "Lease", "pekko.apache.org/v1");
        return Marshal$.MODULE$.apply((Object)lcr).to(this.sprayJsonMarshaller(this.leaseCustomResourceFormat(), this.sprayJsonMarshaller$default$2()), (ExecutionContext)this.system.dispatcher()).flatMap((Function1 & Serializable)entity -> {
            this.log().debug("updating {} to {}", (Object)leaseName, (Object)lcr);
            return this.makeRequest(this.requestForPath(this.pathForLease(leaseName), HttpMethods$.MODULE$.PUT(), (RequestEntity)entity), new StringBuilder(79).append("Timed out updating lease [").append(leaseName).append("] to owner [").append(ownerName).append("]. It is not known if the update happened").toString()).flatMap((Function1 & Serializable)response -> {
                Future future;
                StatusCode statusCode = response.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                    future = Unmarshal$.MODULE$.apply((Object)response.entity()).to(this.sprayJsonUnmarshaller(this.leaseCustomResourceFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).map((Function1 & Serializable)updatedLcr -> {
                        this.log().debug("LCR after update: {}", updatedLcr);
                        return new Right((Object)this.toLeaseResource((LeaseCustomResource)updatedLcr));
                    }, (ExecutionContext)$this.system.dispatcher());
                } else {
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Conflict();
                    if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                        future = this.getLeaseResource(leaseName).flatMap((Function1 & Serializable)x0$1 -> {
                            if (None$.MODULE$.equals(x0$1)) {
                                return Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(55).append("GET after PUT conflict did not return a lease. Lease[").append(leaseName).append("-").append(ownerName).append("]").toString()));
                            }
                            if (x0$1 instanceof Some) {
                                LeaseResource lr = (LeaseResource)((Some)x0$1).value();
                                this.log().debug("LeaseResource read after conflict: {}", (Object)lr);
                                return Future$.MODULE$.successful((Object)new Left((Object)lr));
                            }
                            throw new MatchError(x0$1);
                        }, (ExecutionContext)$this.system.dispatcher());
                    } else {
                        StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
                        future = !(clientError2 != null ? !clientError2.equals(statusCode) : statusCode != null) ? this.handleUnauthorized((HttpResponse)response) : Unmarshal$.MODULE$.apply((Object)response.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)body -> Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(55).append("PUT for lease ").append(leaseName).append(" returned unexpected status code ").append(statusCode).append(". Body: ").append((String)body).toString())), (ExecutionContext)$this.system.dispatcher());
                    }
                }
                return future.map((Function1 & Serializable)result -> result, (ExecutionContext)$this.system.dispatcher());
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)this.system.dispatcher());
    }

    @Override
    public long updateLeaseResource$default$4() {
        return System.currentTimeMillis();
    }

    @Override
    public Future<Option<LeaseResource>> getLeaseResource(String name) {
        return this.makeRequest(this.requestForPath(this.pathForLease(name), this.requestForPath$default$2(), this.requestForPath$default$3()), new StringBuilder(24).append("Timed out reading lease ").append(name).toString()).flatMap((Function1 & Serializable)response -> response.entity().toStrict($this.settings.bodyReadTimeout(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                this.log().debug("Resource {} exists: {}", (Object)name, entity);
                future = Unmarshal$.MODULE$.apply(entity).to(this.sprayJsonUnmarshaller(this.leaseCustomResourceFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).map((Function1 & Serializable)lcr -> new Some((Object)this.toLeaseResource((LeaseCustomResource)lcr)), (ExecutionContext)$this.system.dispatcher());
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.NotFound();
                if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                    HttpMessage.HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)response), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys()));
                    this.log().debug("Resource does not exist: {}", (Object)name);
                    future = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else {
                    StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
                    future = !(clientError2 != null ? !clientError2.equals(statusCode) : statusCode != null) ? this.handleUnauthorized((HttpResponse)response) : Unmarshal$.MODULE$.apply((Object)response.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)body -> Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(78).append("Unexpected response from API server when retrieving lease StatusCode: ").append(statusCode).append(". Body: ").append((String)body).toString())), (ExecutionContext)$this.system.dispatcher());
                }
            }
            return future.map((Function1 & Serializable)lr -> lr, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    @Override
    public Uri.Path pathForLease(String name) {
        return Uri.Path$.Empty$.MODULE$.$div("apis").$div("pekko.apache.org").$div("v1").$div("namespaces").$div(this.namespace()).$div("leases").$div(name.replaceAll("[^\\d\\w\\-\\.]", "").toLowerCase());
    }

    @Override
    public Future<Option<LeaseResource>> createLeaseResource(String name) {
        LeaseCustomResource lcr = new LeaseCustomResource(new Metadata(name, (Option<String>)None$.MODULE$), new Spec("", System.currentTimeMillis()), "Lease", "pekko.apache.org/v1");
        return Marshal$.MODULE$.apply((Object)lcr).to(this.sprayJsonMarshaller(this.leaseCustomResourceFormat(), this.sprayJsonMarshaller$default$2()), (ExecutionContext)this.system.dispatcher()).flatMap((Function1 & Serializable)entity -> this.makeRequest(this.requestForPath(this.pathForLease(name), HttpMethods$.MODULE$.POST(), (RequestEntity)entity), new StringBuilder(25).append("Timed out creating lease ").append(name).toString()).flatMap((Function1 & Serializable)response -> response.entity().toStrict($this.settings.bodyReadTimeout(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)responseEntity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.Created();
            if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                this.log().debug("lease resource created");
                future = Unmarshal$.MODULE$.apply(responseEntity).to(this.sprayJsonUnmarshaller(this.leaseCustomResourceFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).map((Function1 & Serializable)lcr -> new Some((Object)this.toLeaseResource((LeaseCustomResource)lcr)), (ExecutionContext)$this.system.dispatcher());
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Conflict();
                if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                    this.log().debug("creation of lease resource failed as already exists. Will attempt to read again");
                    HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys()));
                    future = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else {
                    StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
                    future = !(clientError2 != null ? !clientError2.equals(statusCode) : statusCode != null) ? this.handleUnauthorized((HttpResponse)response) : responseEntity.toStrict($this.settings.bodyReadTimeout(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)e -> Unmarshal$.MODULE$.apply(e).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())), (ExecutionContext)$this.system.dispatcher()).flatMap((Function1 & Serializable)body -> Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(76).append("Unexpected response from API server when creating Lease StatusCode: ").append(statusCode).append(". Body: ").append((String)body).toString())), (ExecutionContext)$this.system.dispatcher());
                }
            }
            return future.map((Function1 & Serializable)lr -> lr, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private LeaseResource toLeaseResource(LeaseCustomResource lcr) {
        None$ none$;
        block5: {
            String string;
            block4: {
                this.log().debug("Converting {}", (Object)lcr);
                Predef$.MODULE$.require(lcr.metadata().resourceVersion().isDefined(), (Function0 & Serializable)() -> new StringBuilder(72).append("LeaseCustomResource returned from Kubernetes without a resourceVersion: ").append(lcr).toString());
                string = lcr.spec().owner();
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (string == null || "".equals(string)) {
                            break;
                        }
                        break block4;
                    }
                    default: {
                        break block4;
                    }
                }
                none$ = None$.MODULE$;
                break block5;
            }
            none$ = new Some((Object)string);
        }
        None$ owner = none$;
        return new LeaseResource((Option<String>)owner, (String)lcr.metadata().resourceVersion().get(), lcr.spec().time());
    }

    public KubernetesApiImpl(ActorSystem system, KubernetesSettings settings) {
        this.system = system;
        this.settings = settings;
        super(system, settings);
    }
}

