/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.coordination.lease.kubernetes.internal;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.coordination.lease.LeaseException;
import org.apache.pekko.coordination.lease.kubernetes.KubernetesSettings;
import org.apache.pekko.coordination.lease.kubernetes.LeaseResource;
import org.apache.pekko.coordination.lease.kubernetes.internal.AbstractKubernetesApiImpl;
import org.apache.pekko.coordination.lease.kubernetes.internal.Metadata;
import org.apache.pekko.coordination.lease.kubernetes.internal.NativeKubernetesApiImpl$;
import org.apache.pekko.coordination.lease.kubernetes.internal.NativeLeaseResource;
import org.apache.pekko.coordination.lease.kubernetes.internal.NativeSpec;
import org.apache.pekko.http.scaladsl.marshalling.Marshal$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpMessage$;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.Materializer$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005ms!\u0002\t\u0012\u0011\u0003\u0001c!\u0002\u0012\u0012\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%\t!\f\u0005\u0007q\u0005\u0001\u000b\u0011\u0002\u0018\u0007\u000b\t\n\u0002!G\u001d\t\u0011u*!\u0011!Q\u0001\nyB\u0001\u0002R\u0003\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006U\u0015!\t!\u0013\u0005\u0006\u001b\u0016!\tE\u0014\u0005\bm\u0016\t\n\u0011\"\u0001x\u0011\u001d\t)!\u0002C!\u0003\u000fAq!!\u0006\u0006\t\u0003\n9\u0002C\u0004\u00028\u0015!\t%!\u000f\t\u000f\u0005uR\u0001\"\u0003\u0002@!9\u0011\u0011I\u0003\u0005\n\u0005\r\u0013a\u0006(bi&4XmS;cKJtW\r^3t\u0003BL\u0017*\u001c9m\u0015\t\u00112#\u0001\u0005j]R,'O\\1m\u0015\t!R#\u0001\u0006lk\n,'O\\3uKNT!AF\f\u0002\u000b1,\u0017m]3\u000b\u0005aI\u0012\u0001D2p_J$\u0017N\\1uS>t'B\u0001\u000e\u001c\u0003\u0015\u0001Xm[6p\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001A\u0011\u0011%A\u0007\u0002#\t9b*\u0019;jm\u0016\\UOY3s]\u0016$Xm]!qS&k\u0007\u000f\\\n\u0003\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!\u0003Y\u0011fiQ\u001a4gej\u0015j\u0011*P?\u001a{%+T!U)\u0016\u0013V#\u0001\u0018\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014A\u00024pe6\fGO\u0003\u00024i\u0005!A/[7f\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u0019\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'/A\fS\r\u000e\u001b4gM\u001dN\u0013\u000e\u0013vj\u0018$P%6\u000bE\u000bV#SAM\u0011QA\u000f\t\u0003CmJ!\u0001P\t\u00033\u0005\u00137\u000f\u001e:bGR\\UOY3s]\u0016$Xm]!qS&k\u0007\u000f\\\u0001\u0007gf\u001cH/Z7\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005K\u0012!B1di>\u0014\u0018BA\"A\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0011M,G\u000f^5oON\u0004\"AR$\u000e\u0003MI!\u0001S\n\u0003%-+(-\u001a:oKR,7oU3ui&twm\u001d\u000b\u0004\u0015.c\u0005CA\u0011\u0006\u0011\u0015i\u0004\u00021\u0001?\u0011\u0015!\u0005\u00021\u0001F\u0003M)\b\u000fZ1uK2+\u0017m]3SKN|WO]2f)\u0015yEM\u001c9s!\r\u00016+V\u0007\u0002#*\u0011!KJ\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001+R\u0005\u00191U\u000f^;sKB!aKX1b\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002[?\u00051AH]8pizJ\u0011aJ\u0005\u0003;\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002`A\n1Q)\u001b;iKJT!!\u0018\u0014\u0011\u0005\u0019\u0013\u0017BA2\u0014\u00055aU-Y:f%\u0016\u001cx.\u001e:dK\")Q-\u0003a\u0001M\u0006IA.Z1tK:\u000bW.\u001a\t\u0003O.t!\u0001[5\u0011\u0005a3\u0013B\u00016'\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)4\u0003\"B8\n\u0001\u00041\u0017!C8x]\u0016\u0014h*Y7f\u0011\u0015\t\u0018\u00021\u0001g\u0003\u001d1XM]:j_:DqaM\u0005\u0011\u0002\u0003\u00071\u000f\u0005\u0002&i&\u0011QO\n\u0002\u0005\u0019>tw-A\u000fva\u0012\fG/\u001a'fCN,'+Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00135+\u0005A(FA:zW\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u007f\u001a\n!\"\u00198o_R\fG/[8o\u0013\r\t\u0019\u0001 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E4fi2+\u0017m]3SKN|WO]2f)\u0011\tI!!\u0005\u0011\tA\u001b\u00161\u0002\t\u0005K\u00055\u0011-C\u0002\u0002\u0010\u0019\u0012aa\u00149uS>t\u0007BBA\n\u0017\u0001\u0007a-\u0001\u0003oC6,\u0017\u0001\u00049bi\"4uN\u001d'fCN,G\u0003BA\r\u0003k\u0001B!a\u0007\u000209!\u0011QDA\u0016\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012!B7pI\u0016d'\u0002BA\u0013\u0003O\t\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0004\u0003SI\u0012\u0001\u00025uiBLA!!\f\u0002 \u0005\u0019QK]5\n\t\u0005E\u00121\u0007\u0002\u0005!\u0006$\bN\u0003\u0003\u0002.\u0005}\u0001BBA\n\u0019\u0001\u0007a-A\nde\u0016\fG/\u001a'fCN,'+Z:pkJ\u001cW\r\u0006\u0003\u0002\n\u0005m\u0002BBA\n\u001b\u0001\u0007a-\u0001\ndkJ\u0014XM\u001c;US6,'KR\"4gMJT#\u00014\u0002\u001fQ|G*Z1tKJ+7o\\;sG\u0016$2!YA#\u0011\u001d\t9e\u0004a\u0001\u0003\u0013\n1\u0001\\2s!\r\t\u00131J\u0005\u0004\u0003\u001b\n\"a\u0005(bi&4X\rT3bg\u0016\u0014Vm]8ve\u000e,\u0007fA\u0003\u0002RA!\u00111KA,\u001b\t\t)F\u0003\u0002\u00003%!\u0011\u0011LA+\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public class NativeKubernetesApiImpl
extends AbstractKubernetesApiImpl {
    private final ActorSystem system;
    private final KubernetesSettings settings;

    public static DateTimeFormatter RFC3339MICRO_FORMATTER() {
        return NativeKubernetesApiImpl$.MODULE$.RFC3339MICRO_FORMATTER();
    }

    @Override
    public Future<Either<LeaseResource, LeaseResource>> updateLeaseResource(String leaseName, String ownerName, String version, long time) {
        NativeLeaseResource lcr = new NativeLeaseResource(new Metadata(leaseName, (Option<String>)new Some((Object)version)), new NativeSpec(ownerName, this.currentTimeRFC3339()), "Lease", "coordination.k8s.io/v1");
        return Marshal$.MODULE$.apply((Object)lcr).to(this.sprayJsonMarshaller(this.leaseNativeResourceFormat(), this.sprayJsonMarshaller$default$2()), (ExecutionContext)this.system.dispatcher()).flatMap((Function1 & Serializable)entity -> {
            this.log().debug("updating {} to {}", (Object)leaseName, (Object)lcr);
            return this.makeRequest(this.requestForPath(this.pathForLease(leaseName), HttpMethods$.MODULE$.PUT(), (RequestEntity)entity), new StringBuilder(79).append("Timed out updating lease [").append(leaseName).append("] to owner [").append(ownerName).append("]. It is not known if the update happened").toString()).flatMap((Function1 & Serializable)response -> {
                Future future;
                StatusCode statusCode = response.status();
                StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                    future = Unmarshal$.MODULE$.apply((Object)response.entity()).to(this.sprayJsonUnmarshaller(this.leaseNativeResourceFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).map((Function1 & Serializable)updatedLcr -> {
                        this.log().debug("LCR after update: {}", updatedLcr);
                        return new Right((Object)this.toLeaseResource((NativeLeaseResource)updatedLcr));
                    }, (ExecutionContext)$this.system.dispatcher());
                } else {
                    StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Conflict();
                    if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                        future = this.getLeaseResource(leaseName).flatMap((Function1 & Serializable)x0$1 -> {
                            if (None$.MODULE$.equals(x0$1)) {
                                return Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(55).append("GET after PUT conflict did not return a lease. Lease[").append(leaseName).append("-").append(ownerName).append("]").toString()));
                            }
                            if (x0$1 instanceof Some) {
                                LeaseResource lr = (LeaseResource)((Some)x0$1).value();
                                this.log().debug("LeaseResource read after conflict: {}", (Object)lr);
                                return Future$.MODULE$.successful((Object)new Left((Object)lr));
                            }
                            throw new MatchError(x0$1);
                        }, (ExecutionContext)$this.system.dispatcher());
                    } else {
                        StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
                        future = !(clientError2 != null ? !clientError2.equals(statusCode) : statusCode != null) ? this.handleUnauthorized((HttpResponse)response) : Unmarshal$.MODULE$.apply((Object)response.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)body -> Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(55).append("PUT for lease ").append(leaseName).append(" returned unexpected status code ").append(statusCode).append(". Body: ").append((String)body).toString())), (ExecutionContext)$this.system.dispatcher());
                    }
                }
                return future.map((Function1 & Serializable)result -> result, (ExecutionContext)$this.system.dispatcher());
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)this.system.dispatcher());
    }

    @Override
    public long updateLeaseResource$default$4() {
        return System.currentTimeMillis();
    }

    @Override
    public Future<Option<LeaseResource>> getLeaseResource(String name) {
        return this.makeRequest(this.requestForPath(this.pathForLease(name), this.requestForPath$default$2(), this.requestForPath$default$3()), new StringBuilder(24).append("Timed out reading lease ").append(name).toString()).flatMap((Function1 & Serializable)response -> response.entity().toStrict($this.settings.bodyReadTimeout(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                this.log().debug("Resource {} exists: {}", (Object)name, entity);
                future = Unmarshal$.MODULE$.apply(entity).to(this.sprayJsonUnmarshaller(this.leaseNativeResourceFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).map((Function1 & Serializable)lcr -> new Some((Object)this.toLeaseResource((NativeLeaseResource)lcr)), (ExecutionContext)$this.system.dispatcher());
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.NotFound();
                if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                    HttpMessage.HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)response), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys()));
                    this.log().debug("Resource does not exist: {}", (Object)name);
                    future = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else {
                    StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
                    future = !(clientError2 != null ? !clientError2.equals(statusCode) : statusCode != null) ? this.handleUnauthorized((HttpResponse)response) : Unmarshal$.MODULE$.apply((Object)response.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)body -> Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(78).append("Unexpected response from API server when retrieving lease StatusCode: ").append(statusCode).append(". Body: ").append((String)body).toString())), (ExecutionContext)$this.system.dispatcher());
                }
            }
            return future.map((Function1 & Serializable)lr -> lr, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    @Override
    public Uri.Path pathForLease(String name) {
        return Uri.Path$.Empty$.MODULE$.$div("apis").$div("coordination.k8s.io").$div("v1").$div("namespaces").$div(this.namespace()).$div("leases").$div(name.replaceAll("[^\\d\\w\\-\\.]", "").toLowerCase());
    }

    @Override
    public Future<Option<LeaseResource>> createLeaseResource(String name) {
        NativeLeaseResource lcr = new NativeLeaseResource(new Metadata(name, (Option<String>)None$.MODULE$), new NativeSpec("", this.currentTimeRFC3339()), "Lease", "coordination.k8s.io/v1");
        return Marshal$.MODULE$.apply((Object)lcr).to(this.sprayJsonMarshaller(this.leaseNativeResourceFormat(), this.sprayJsonMarshaller$default$2()), (ExecutionContext)this.system.dispatcher()).flatMap((Function1 & Serializable)entity -> this.makeRequest(this.requestForPath(this.pathForLease(""), HttpMethods$.MODULE$.POST(), (RequestEntity)entity), new StringBuilder(25).append("Timed out creating lease ").append(name).toString()).flatMap((Function1 & Serializable)response -> response.entity().toStrict($this.settings.bodyReadTimeout(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)responseEntity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.Created();
            if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                this.log().debug("lease resource created");
                future = Unmarshal$.MODULE$.apply(responseEntity).to(this.sprayJsonUnmarshaller(this.leaseNativeResourceFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).map((Function1 & Serializable)lcr -> new Some((Object)this.toLeaseResource((NativeLeaseResource)lcr)), (ExecutionContext)$this.system.dispatcher());
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Conflict();
                if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                    this.log().debug("creation of lease resource failed as already exists. Will attempt to read again");
                    HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)entity), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys()));
                    future = Future$.MODULE$.successful((Object)None$.MODULE$);
                } else {
                    StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
                    future = !(clientError2 != null ? !clientError2.equals(statusCode) : statusCode != null) ? this.handleUnauthorized((HttpResponse)response) : responseEntity.toStrict($this.settings.bodyReadTimeout(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())).flatMap((Function1 & Serializable)e -> Unmarshal$.MODULE$.apply(e).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.sys())), (ExecutionContext)$this.system.dispatcher()).flatMap((Function1 & Serializable)body -> Future$.MODULE$.failed((Throwable)new LeaseException(new StringBuilder(76).append("Unexpected response from API server when creating Lease StatusCode: ").append(statusCode).append(". Body: ").append((String)body).toString())), (ExecutionContext)$this.system.dispatcher());
                }
            }
            return future.map((Function1 & Serializable)lr -> lr, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private String currentTimeRFC3339() {
        return NativeKubernetesApiImpl$.MODULE$.RFC3339MICRO_FORMATTER().withZone(ZoneId.of("UTC")).format(Instant.now());
    }

    private LeaseResource toLeaseResource(NativeLeaseResource lcr) {
        None$ none$;
        block5: {
            String string;
            block4: {
                this.log().debug("Converting {}", (Object)lcr);
                Predef$.MODULE$.require(lcr.metadata().resourceVersion().isDefined(), (Function0 & Serializable)() -> new StringBuilder(72).append("LeaseCustomResource returned from Kubernetes without a resourceVersion: ").append(lcr).toString());
                string = lcr.spec().holderIdentity();
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (string == null || "".equals(string)) {
                            break;
                        }
                        break block4;
                    }
                    default: {
                        break block4;
                    }
                }
                none$ = None$.MODULE$;
                break block5;
            }
            none$ = new Some((Object)string);
        }
        None$ owner = none$;
        return new LeaseResource((Option<String>)owner, (String)lcr.metadata().resourceVersion().get(), LocalDateTime.parse(lcr.spec().acquireTime(), NativeKubernetesApiImpl$.MODULE$.RFC3339MICRO_FORMATTER()).atZone(ZoneId.of("UTC")).toInstant().toEpochMilli());
    }

    public NativeKubernetesApiImpl(ActorSystem system, KubernetesSettings settings) {
        this.system = system;
        this.settings = settings;
        super(system, settings);
    }
}

