/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.discovery.Discovery$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings$;
import org.apache.pekko.management.cluster.bootstrap.JoinDecider;
import org.apache.pekko.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import org.apache.pekko.management.scaladsl.ManagementRouteProvider;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettings;
import org.apache.pekko.management.scaladsl.PekkoManagement;
import org.apache.pekko.management.scaladsl.PekkoManagement$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u001b7\u0005\rC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ya\u0016\u0005\u00065\u0002!\ta\u0017\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019A\u0007\u0001)A\u0005E\"9\u0011\u000e\u0001b\u0001\n\u001bQ\u0007bBA_\u0001\u0001\u0006ia\u001b\u0005\n\u0003\u007f\u0003!\u0019!C\u0001\u0003\u0003D\u0001\"!3\u0001A\u0003%\u00111\u0019\u0005\u000b\u0003\u0017\u0004\u0001R1A\u0005\u0002\u00055\u0007\"CAm\u0001\t\u0007I\u0011BAn\u0011!\t\u0019\u000f\u0001Q\u0001\n\u0005u\u0007\u0002CAs\u0001\u0001\u0006I!a:\t\u0013\t\r\u0001A1A\u0005\n\t\u0015\u0001\u0002\u0003B\u0004\u0001\u0001\u0006I!a$\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!9!1\b\u0001\u0005\u0002\tu\u0002\u0002\u0003B#\u0001\u0011\u0005aG!\u0010\t\u0011\tU\u0003\u0001\"\u0001=\u0005/B\u0001Ba\u0018\u0001\t\u0003a$\u0011M\u0004\u0006uZB\ta\u001f\u0004\u0006kYB\t\u0001 \u0005\u00075V!\t!a\u0002\t\u000f\u0005%Q\u0003\"\u0011\u0002\f!9\u0011QB\u000b\u0005B\u0005=\u0001bBA\u0007+\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003G)B\u0011IA\u0013\u000f!\tI#\u0006E\u0001m\u0005-b\u0001CA\u0018+!\u0005a'!\r\t\ricB\u0011AA\u001a\r%\t)\u0004\bI\u0001$C\t9dB\u0004\u0002:rA\t)a,\u0007\u000f\u0005%F\u0004#!\u0002,\"1!\f\tC\u0001\u0003[C\u0011\"a\u0015!\u0003\u0003%\t%!\u0016\t\u0013\u0005\r\u0004%!A\u0005\u0002\u0005\u0015\u0004\"CA7A\u0005\u0005I\u0011AAY\u0011%\tY\bIA\u0001\n\u0003\ni\bC\u0005\u0002\f\u0002\n\t\u0011\"\u0001\u00026\"I\u0011q\u0013\u0011\u0002\u0002\u0013\u0005\u0013\u0011\u0014\u0005\n\u00037\u0003\u0013\u0011!C!\u0003;C\u0011\"a(!\u0003\u0003%I!!)\b\u000f\u0005mF\u0004#!\u0002R\u00199\u00111\b\u000f\t\u0002\u0006u\u0002B\u0002.,\t\u0003\ty\u0005C\u0005\u0002T-\n\t\u0011\"\u0011\u0002V!I\u00111M\u0016\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003[Z\u0013\u0011!C\u0001\u0003_B\u0011\"a\u001f,\u0003\u0003%\t%! \t\u0013\u0005-5&!A\u0005\u0002\u00055\u0005\"CALW\u0005\u0005I\u0011IAM\u0011%\tYjKA\u0001\n\u0003\ni\nC\u0005\u0002 .\n\t\u0011\"\u0003\u0002\"\n\u00012\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r\u001d\u0006\u0003oa\n\u0011BY8piN$(/\u00199\u000b\u0005eR\u0014aB2mkN$XM\u001d\u0006\u0003wq\n!\"\\1oC\u001e,W.\u001a8u\u0015\tid(A\u0003qK.\\wN\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0011S\u0005\u000b\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001br\nQ!Y2u_JL!a\u0014'\u0003\u0013\u0015CH/\u001a8tS>t\u0007CA)U\u001b\u0005\u0011&BA*;\u0003!\u00198-\u00197bINd\u0017BA+S\u0005]i\u0015M\\1hK6,g\u000e\u001e*pkR,\u0007K]8wS\u0012,'/\u0001\u0004tsN$X-\u001c\t\u0003\u0017bK!!\u0017'\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\u0005aFCA/`!\tq\u0006!D\u00017\u0011\u00151&\u0001q\u0001X\u0003\rawnZ\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q\rP\u0001\u0006KZ,g\u000e^\u0005\u0003O\u0012\u0014a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013!\u00042p_R\u001cHO]1q'R,\u0007/F\u0001l!\raWo^\u0007\u0002[*\u0011an\\\u0001\u0007CR|W.[2\u000b\u0005A\f\u0018AC2p]\u000e,(O]3oi*\u0011!o]\u0001\u0005kRLGNC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Yl'aD!u_6L7MU3gKJ,gnY3\u0011\u0005atbBA=\u001c\u001d\tqF#\u0001\tDYV\u001cH/\u001a:C_>$8\u000f\u001e:baB\u0011a,F\n\u0006+\u0011k\u0018\u0011\u0001\t\u0004\u0017zl\u0016BA@M\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u0007-\u000b\u0019!C\u0002\u0002\u00061\u00131#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012a_\u0001\u0007Y>|7.\u001e9\u0016\u0003e\f1aZ3u)\ri\u0016\u0011\u0003\u0005\u0007-b\u0001\r!a\u0005\u0011\u0007-\u000b)\"C\u0002\u0002\u00181\u00131\"Q2u_J\u001c\u0016p\u001d;f[R\u0019Q,a\u0007\t\rYK\u0002\u0019AA\u000f!\rY\u0015qD\u0005\u0004\u0003Ca%AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014\u0018aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007u\u000b9\u0003C\u0003W5\u0001\u0007q+\u0001\u0005J]R,'O\\1m!\r\ti\u0003H\u0007\u0002+\tA\u0011J\u001c;fe:\fGn\u0005\u0002\u001d\tR\u0011\u00111\u0006\u0002\u000e\u0005>|Go\u001d;sCB\u001cF/\u001a9\u0014\u0005y!\u0015f\u0001\u0010,A\ta\u0011J\\5uS\u0006d\u0017N_5oONA1\u0006RA \u0003\u0007\nI\u0005E\u0002\u0002Byi\u0011\u0001\b\t\u0004\u000b\u0006\u0015\u0013bAA$\r\n9\u0001K]8ek\u000e$\bcA#\u0002L%\u0019\u0011Q\n$\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005E\u0003cAA!W\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0016\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018t\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u00141\f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0004cA#\u0002j%\u0019\u00111\u000e$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E\u0014q\u000f\t\u0004\u000b\u0006M\u0014bAA;\r\n\u0019\u0011I\\=\t\u0013\u0005et&!AA\u0002\u0005\u001d\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0000A1\u0011\u0011QAD\u0003cj!!a!\u000b\u0007\u0005\u0015e)\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0004\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty)!&\u0011\u0007\u0015\u000b\t*C\u0002\u0002\u0014\u001a\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002zE\n\t\u00111\u0001\u0002r\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002h\u0005AAo\\*ue&tw\r\u0006\u0002\u0002X\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u000b\u0005\u0003\u0002Z\u0005\u0015\u0016\u0002BAT\u00037\u0012aa\u00142kK\u000e$(A\u0003(piJ+hN\\5oONA\u0001\u0005RA \u0003\u0007\nI\u0005\u0006\u0002\u00020B\u0019\u0011\u0011\t\u0011\u0015\t\u0005E\u00141\u0017\u0005\n\u0003s\"\u0013\u0011!a\u0001\u0003O\"B!a$\u00028\"I\u0011\u0011\u0010\u0014\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u000b\u001d>$(+\u001e8oS:<\u0017\u0001D%oSRL\u0017\r\\5{S:<\u0017A\u00042p_R\u001cHO]1q'R,\u0007\u000fI\u0001\tg\u0016$H/\u001b8hgV\u0011\u00111\u0019\t\u0004=\u0006\u0015\u0017bAAdm\tA2\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r]*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013!\u00033jg\u000e|g/\u001a:z+\t\ty\r\u0005\u0003\u0002R\u0006UWBAAj\u0015\r\tY\rP\u0005\u0005\u0003/\f\u0019N\u0001\tTKJ4\u0018nY3ESN\u001cwN^3ss\u0006Y!n\\5o\t\u0016\u001c\u0017\u000eZ3s+\t\ti\u000eE\u0002_\u0003?L1!!97\u0005-Qu.\u001b8EK\u000eLG-\u001a:\u0002\u0019)|\u0017N\u001c#fG&$WM\u001d\u0011\u0002)}\u001bX\r\u001c4D_:$\u0018m\u0019;Q_&tG/\u0016:j!\u0019\tI/!<\u0002r6\u0011\u00111\u001e\u0006\u0003a\u001aKA!a<\u0002l\n9\u0001K]8nSN,\u0007\u0003BAz\u0003\u007fl!!!>\u000b\t\u0005]\u0018\u0011`\u0001\u0006[>$W\r\u001c\u0006\u0004'\u0006m(bAA\u007fy\u0005!\u0001\u000e\u001e;q\u0013\u0011\u0011\t!!>\u0003\u0007U\u0013\u0018.A\u0005bkR|7\u000f^1siV\u0011\u0011qR\u0001\u000bCV$xn\u001d;beR\u0004\u0013A\u0002:pkR,7\u000f\u0006\u0003\u0003\u000e\tE\u0002\u0003\u0002B\b\u0005WqAA!\u0005\u0003&9!!1\u0003B\u0011\u001d\u0011\u0011)Ba\b\u000f\t\t]!Q\u0004\b\u0005\u00053\u0011Y\"D\u0001?\u0013\tid(C\u0002\u0002~rJ1aUA~\u0013\u0011\u0011\u0019#!?\u0002\rM,'O^3s\u0013\u0011\u00119C!\u000b\u0002\u000fA\f7m[1hK*!!1EA}\u0013\u0011\u0011iCa\f\u0003\u000bI{W\u000f^3\u000b\t\t\u001d\"\u0011\u0006\u0005\b\u0005gy\u0001\u0019\u0001B\u001b\u0003U\u0011x.\u001e;f!J|g/\u001b3feN+G\u000f^5oON\u00042!\u0015B\u001c\u0013\r\u0011ID\u0015\u0002 \u001b\u0006t\u0017mZ3nK:$(k\\;uKB\u0013xN^5eKJ\u001cV\r\u001e;j]\u001e\u001c\u0018!B:uCJ$HC\u0001B !\r)%\u0011I\u0005\u0004\u0005\u00072%\u0001B+oSR\fa#\u001a8tkJ,7+\u001a7g\u0007>tG/Y2u!>Lg\u000e\u001e\u0015\u0004#\t%\u0003\u0003\u0002B&\u0005#j!A!\u0014\u000b\u0007\t=C(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0015\u0003N\tY\u0011J\u001c;fe:\fG.\u00119j\u0003M\u0019X\r^*fY\u001a\u001cuN\u001c;bGR\u0004v.\u001b8u)\u0011\u0011yD!\u0017\t\u000f\tm#\u00031\u0001\u0002r\u00069!-Y:f+JL\u0007f\u0001\n\u0003J\u0005\u00012/\u001a7g\u0007>tG/Y2u!>Lg\u000e^\u000b\u0003\u0005G\u0002b!!;\u0003f\u0005E\u0018\u0002\u0002B4\u0003W\u0014aAR;ukJ,\u0007fA\n\u0003J\u0001")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private ServiceDiscovery discovery;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;
    private final boolean autostart;
    private volatile boolean bitmap$0;

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    private ServiceDiscovery discovery$lzycompute() {
        ClusterBootstrap clusterBootstrap = this;
        synchronized (clusterBootstrap) {
            if (!this.bitmap$0) {
                ServiceDiscovery serviceDiscovery;
                String string = this.settings().contactPointDiscovery().discoveryMethod();
                if ("pekko.discovery".equals(string)) {
                    ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                    this.log().info("Bootstrap using default `pekko.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                    serviceDiscovery = discovery;
                } else {
                    this.log().info("Bootstrap using `pekko.discovery` method: {}", (Object)string);
                    serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(string);
                }
                this.discovery = serviceDiscovery;
                this.bitmap$0 = true;
            }
        }
        return this.discovery;
    }

    public ServiceDiscovery discovery() {
        if (!this.bitmap$0) {
            return this.discovery$lzycompute();
        }
        return this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    private boolean autostart() {
        return this.autostart;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `pekko.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
            return;
        }
        if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1 & Serializable & scala.Serializable)uri -> {
                ClusterBootstrap.$anonfun$start$1(bootstrap, uri);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system.dispatcher());
            return;
        }
        this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.selfContactPoint().isCompleted()) {
                $this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
                this.log().error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via pekko-management.");
                return;
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    private final void autostartFailed$1(Throwable ex) {
        this.log().error(ex, "Failed to autostart cluster bootstrap, terminating system");
        this.system.terminate();
    }

    public static final /* synthetic */ void $anonfun$start$1(ActorRef bootstrap$1, Uri uri) {
        BootstrapCoordinator.Protocol.InitiateBootstrapping x$1 = new BootstrapCoordinator.Protocol.InitiateBootstrapping(uri);
        ActorRef x$2 = bootstrap$1.$bang$default$2((Object)x$1);
        bootstrap$1.$bang((Object)x$1, x$2);
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        BoxedUnit boxedUnit;
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
        this.autostart = system.settings().config().getStringList("pekko.extensions").contains(ClusterBootstrap.class.getName());
        if (this.autostart()) {
            this.log().info("ClusterBootstrap loaded through 'pekko.extensions' auto starting management and bootstrap.");
            boxedUnit = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    ((PekkoManagement)PekkoManagement$.MODULE$.apply((ActorSystem)$this.system)).start().failed().foreach((Function1 & Serializable & scala.Serializable)ex -> {
                        this.autostartFailed$1(ex);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    ((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply((ActorSystem)$this.system)).start();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable ex2 = (Throwable)option.get();
                        this.autostartFailed$1(ex2);
                    }
                    throw throwable;
                }
            }, (ExecutionContext)system.dispatcher());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

