/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.management.cluster.bootstrap.BootstrapLogMarker$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.JoinDecider;
import org.apache.pekko.management.cluster.bootstrap.SeedNodesInformation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\raA\u0002\u0007\u000e\u0003\u0003i\u0011\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0003A!A!\u0002\u0013i\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004bB\u001b\u0001\u0005\u0004%\tB\u000e\u0005\u0007{\u0001\u0001\u000b\u0011B\u001c\t\u000by\u0002A\u0011C \t\u000by\u0002A\u0011C*\t\r\r\u0004A\u0011A\u0007e\u0011\u0019)\u0007\u0001\"\u0001\u000eM\"1\u0011\u000f\u0001C\u0001\u001bIDQ!\u001e\u0001\u0005\u0012Y\u0014AcU3mM\u0006;\u0018M]3K_&tG)Z2jI\u0016\u0014(B\u0001\b\u0010\u0003%\u0011wn\u001c;tiJ\f\u0007O\u0003\u0002\u0011#\u000591\r\\;ti\u0016\u0014(B\u0001\n\u0014\u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0003)U\tQ\u0001]3lW>T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sON\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u000e\u0013\t\u0019SBA\u0006K_&tG)Z2jI\u0016\u0014\u0018AB:zgR,Wn\u0001\u0001\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\u001a\u0012!B1di>\u0014\u0018BA\u0016)\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0011M,G\u000f^5oON\u0004\"!\t\u0018\n\u0005=j!\u0001G\"mkN$XM\u001d\"p_R\u001cHO]1q'\u0016$H/\u001b8hg\u00061A(\u001b8jiz\"2AM\u001a5!\t\t\u0003\u0001C\u0003%\u0007\u0001\u0007a\u0005C\u0003-\u0007\u0001\u0007Q&A\u0002m_\u001e,\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003uM\tQ!\u001a<f]RL!\u0001P\u001d\u0003)5\u000b'o[3s\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002%\r|g\u000e^1diB{\u0017N\u001c;TiJLgn\u001a\u000b\u0003\u0001.\u0003\"!\u0011%\u000f\u0005\t3\u0005CA\"\u001d\u001b\u0005!%BA#&\u0003\u0019a$o\\8u}%\u0011q\tH\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H9!)AJ\u0002a\u0001\u001b\u0006a1m\u001c8uC\u000e$\bk\\5oiB!1D\u0014!Q\u0013\tyED\u0001\u0004UkBdWM\r\t\u00037EK!A\u0015\u000f\u0003\u0007%sG\u000f\u0006\u0002A)\")Aj\u0002a\u0001+B\u0011a\u000b\u0019\b\u0003/vs!\u0001W.\u000f\u0005eSV\"A\u000b\n\u0005Q)\u0012B\u0001/\u0014\u0003%!\u0017n]2pm\u0016\u0014\u00180\u0003\u0002_?\u0006\u00012+\u001a:wS\u000e,G)[:d_Z,'/\u001f\u0006\u00039NI!!\u00192\u0003\u001dI+7o\u001c7wK\u0012$\u0016M]4fi*\u0011alX\u0001\u0011g\u0016dgmQ8oi\u0006\u001cG\u000fU8j]R,\u0012!T\u0001\fG\u0006t'j\\5o'\u0016dg\rF\u0002hU2\u0004\"a\u00075\n\u0005%d\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006W&\u0001\r!V\u0001\u0007i\u0006\u0014x-\u001a;\t\u000b5L\u0001\u0019\u00018\u0002\t%tgm\u001c\t\u0003C=L!\u0001]\u0007\u0003)M+W\r\u001a(pI\u0016\u001c\u0018J\u001c4pe6\fG/[8o\u0003-i\u0017\r^2iKN\u001cV\r\u001c4\u0015\u0007\u001d\u001cH\u000fC\u0003l\u0015\u0001\u0007Q\u000bC\u0003M\u0015\u0001\u0007Q*A\u0006i_N$X*\u0019;dQ\u0016\u001cHcA4xs\")\u0001p\u0003a\u0001\u0001\u0006!\u0001n\\:u\u0011\u0015Y7\u00021\u0001VQ\t\u00011\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f'\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0005QPA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public abstract class SelfAwareJoinDecider
implements JoinDecider {
    private final ActorSystem system;
    private final MarkerLoggingAdapter log;

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public String contactPointString(Tuple2<String, Object> contactPoint) {
        return contactPoint.productIterator().mkString(":");
    }

    public String contactPointString(ServiceDiscovery.ResolvedTarget contactPoint) {
        return new StringBuilder(1).append(contactPoint.host()).append(":").append(contactPoint.port().getOrElse((Function0 & Serializable & scala.Serializable)() -> "0")).toString();
    }

    public Tuple2<String, Object> selfContactPoint() {
        return (Tuple2)Await$.MODULE$.result((Awaitable)((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply(this.system)).selfContactPoint().map((Function1 & Serializable & scala.Serializable)uri -> new Tuple2((Object)uri.authority().host().toString(), (Object)BoxesRunTime.boxToInteger((int)uri.authority().port())), (ExecutionContext)this.system.dispatcher()), (Duration)Duration$.MODULE$.Inf());
    }

    public boolean canJoinSelf(ServiceDiscovery.ResolvedTarget target, SeedNodesInformation info) {
        block1: {
            Tuple2<String, Object> self = this.selfContactPoint();
            if (this.matchesSelf(target, self)) {
                return true;
            }
            if (info.contactPoints().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.matchesSelf(x$1, (Tuple2<String, Object>)self)))) break block1;
            this.log().warning(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable & scala.Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint), Set$.MODULE$.canBuildFrom())), info.allSeedNodes()), "Self contact point [{}] not found in targets {}", (Object)this.contactPointString(this.selfContactPoint()), (Object)info.contactPoints().mkString(", "));
        }
        return false;
    }

    public boolean matchesSelf(ServiceDiscovery.ResolvedTarget target, Tuple2<String, Object> contactPoint) {
        Tuple2<String, Object> tuple2 = contactPoint;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String host = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        String host2 = (String)tuple22._1();
        int port2 = tuple22._2$mcI$sp();
        Option option = target.port();
        if (None$.MODULE$.equals(option)) {
            return this.hostMatches(host2, target);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int lowestPort = BoxesRunTime.unboxToInt((Object)some.value());
            return this.hostMatches(host2, target) && port2 == lowestPort;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hostMatches(String host, ServiceDiscovery.ResolvedTarget target) {
        String hostWithoutBracket = host.replaceAll("[\\[\\]]", "");
        String string = host;
        String string2 = target.host();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = hostWithoutBracket;
        String string4 = target.host();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!target.address().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getHostAddress()).contains((Object)hostWithoutBracket)) return false;
        return true;
    }

    public SelfAwareJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.system = system;
        this.log = Logging$.MODULE$.withMarker(system, this.getClass(), LogSource$.MODULE$.fromClass());
    }
}

