/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management;

import java.io.Serializable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.management.HealthCheckSettings;
import org.apache.pekko.management.HealthCheckSettings$;
import org.apache.pekko.management.scaladsl.HealthChecks;
import org.apache.pekko.management.scaladsl.HealthChecks$;
import org.apache.pekko.management.scaladsl.ManagementRouteProvider;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettings;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public class HealthCheckRoutes
implements ManagementRouteProvider {
    private final HealthCheckSettings settings;
    private final HealthChecks healthChecks;
    private final Function1<Try<Either<String, BoxedUnit>>, Function1<RequestContext, Future<RouteResult>>> healthCheckResponse;

    public HealthCheckRoutes(ExtendedActorSystem system) {
        this.settings = HealthCheckSettings$.MODULE$.apply(system.settings().config().getConfig("pekko.management.health-checks"));
        this.healthChecks = HealthChecks$.MODULE$.apply(system, this.settings);
        this.healthCheckResponse = (Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Either either = (Either)((Success)try_).value();
                if (either instanceof Right) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = ((Right)either).value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        return Directives$.MODULE$.complete(HealthCheckRoutes::$init$$$anonfun$1$$anonfun$1);
                    }
                }
                if (either instanceof Left) {
                    String failingChecks = (String)((Left)either).value();
                    return Directives$.MODULE$.complete(() -> HealthCheckRoutes.$init$$$anonfun$1$$anonfun$2(failingChecks));
                }
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                return Directives$.MODULE$.complete(() -> HealthCheckRoutes.$init$$$anonfun$1$$anonfun$3(t));
            }
            throw new MatchError((Object)try_);
        };
    }

    public HealthChecks healthChecks() {
        return this.healthChecks;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings mrps) {
        return Directives$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(PathMatchers$.MODULE$.separateOnSlashes(this.settings.readinessPath()))).apply(this::routes$$anonfun$1), (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(PathMatchers$.MODULE$.separateOnSlashes(this.settings.livenessPath()))).apply(this::routes$$anonfun$2)}));
    }

    private static final ToResponseMarshallable $init$$$anonfun$1$$anonfun$1() {
        return ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.OK(), Marshaller$.MODULE$.fromStatusCode());
    }

    private static final ToResponseMarshallable $init$$$anonfun$1$$anonfun$2(String failingChecks$1) {
        StatusCodes.ServerError serverError = (StatusCodes.ServerError)Predef$.MODULE$.ArrowAssoc((Object)StatusCodes$.MODULE$.InternalServerError());
        return ToResponseMarshallable$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)serverError, (Object)new StringBuilder(13).append("Not Healthy: ").append(failingChecks$1).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue(Predef$.MODULE$.$conforms(), Marshaller$.MODULE$.StringMarshaller()));
    }

    private static final ToResponseMarshallable $init$$$anonfun$1$$anonfun$3(Throwable t$1) {
        StatusCodes.ServerError serverError = (StatusCodes.ServerError)Predef$.MODULE$.ArrowAssoc((Object)StatusCodes$.MODULE$.InternalServerError());
        return ToResponseMarshallable$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)serverError, (Object)new StringBuilder(21).append("Health Check Failed: ").append(t$1.getMessage()).toString()), Marshaller$.MODULE$.fromStatusCodeAndValue(Predef$.MODULE$.$conforms(), Marshaller$.MODULE$.StringMarshaller()));
    }

    private final Future routes$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.healthChecks().readyResult();
    }

    private final Function1 routes$$anonfun$1$$anonfun$1() {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.onComplete(this::routes$$anonfun$1$$anonfun$1$$anonfun$1), ApplyConverter$.MODULE$.hac1()).apply(this.healthCheckResponse);
    }

    private final Function1 routes$$anonfun$1() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply(this::routes$$anonfun$1$$anonfun$1);
    }

    private final Future routes$$anonfun$2$$anonfun$1$$anonfun$1() {
        return this.healthChecks().aliveResult();
    }

    private final Function1 routes$$anonfun$2$$anonfun$1() {
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.onComplete(this::routes$$anonfun$2$$anonfun$1$$anonfun$1), ApplyConverter$.MODULE$.hac1()).apply(this.healthCheckResponse);
    }

    private final Function1 routes$$anonfun$2() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply(this::routes$$anonfun$2$$anonfun$1);
    }
}

