/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.internal;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.management.HealthCheckSettings;
import org.apache.pekko.management.InvalidHealthCheckException;
import org.apache.pekko.management.ManagementLogMarker$;
import org.apache.pekko.management.NamedHealthCheck;
import org.apache.pekko.management.internal.CheckFailedException$;
import org.apache.pekko.management.internal.CheckTimeoutException$;
import org.apache.pekko.management.javadsl.LivenessCheckSetup;
import org.apache.pekko.management.javadsl.StartupCheckSetup;
import org.apache.pekko.management.scaladsl.HealthChecks;
import org.apache.pekko.management.scaladsl.ReadinessCheckSetup;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@InternalApi
public final class HealthChecksImpl
extends HealthChecks {
    public final ExtendedActorSystem org$apache$pekko$management$internal$HealthChecksImpl$$system;
    public final HealthCheckSettings org$apache$pekko$management$internal$HealthChecksImpl$$settings;
    private final MarkerLoggingAdapter log;
    private final Seq<Function0<Future<Object>>> startupChecks;
    private final Seq<Function0<Future<Object>>> readiness;
    private final Seq<Function0<Future<Object>>> liveness;

    public HealthChecksImpl(ExtendedActorSystem system, HealthCheckSettings settings) {
        Seq<Function0<Future<Object>>> seq;
        Nil$ nil$;
        Seq<Function0<Future<Object>>> seq2;
        Nil$ nil$2;
        Seq<Function0<Future<Object>>> seq3;
        Nil$ nil$3;
        this.org$apache$pekko$management$internal$HealthChecksImpl$$system = system;
        this.org$apache$pekko$management$internal$HealthChecksImpl$$settings = settings;
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, HealthChecksImpl.class, LogSource$.MODULE$.fromAnyClass());
        this.log.info("Loading startup checks [{}]", (Object)((IterableOnceOps)settings.startupChecks().map((Function1 & Serializable)a -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)a.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)a.fullyQualifiedClassName());
        })).mkString(", "));
        this.log.info("Loading readiness checks [{}]", (Object)((IterableOnceOps)settings.readinessChecks().map((Function1 & Serializable)a -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)a.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)a.fullyQualifiedClassName());
        })).mkString(", "));
        this.log.info("Loading liveness checks [{}]", (Object)((IterableOnceOps)settings.livenessChecks().map((Function1 & Serializable)a -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)a.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)a.fullyQualifiedClassName());
        })).mkString(", "));
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(org.apache.pekko.management.scaladsl.StartupCheckSetup.class));
        if (None$.MODULE$.equals(option)) {
            nil$3 = package$.MODULE$.Nil();
        } else if (option instanceof Some) {
            org.apache.pekko.management.scaladsl.StartupCheckSetup setup = (org.apache.pekko.management.scaladsl.StartupCheckSetup)((Object)((Some)option).value());
            nil$3 = (Seq)setup.createHealthChecks().apply((Object)system);
        } else {
            throw new MatchError((Object)option);
        }
        Nil$ fromScaladslSetup = nil$3;
        Option option2 = system.settings().setup().get(ClassTag$.MODULE$.apply(StartupCheckSetup.class));
        if (None$.MODULE$.equals(option2)) {
            seq3 = package$.MODULE$.Nil();
        } else if (option2 instanceof Some) {
            StartupCheckSetup setup = (StartupCheckSetup)((Object)((Some)option2).value());
            seq3 = this.convertSuppliersToScala(setup.createHealthChecks().apply((ActorSystem)system));
        } else {
            throw new MatchError((Object)option2);
        }
        Seq<Function0<Future<Object>>> fromJavadslSetup = seq3;
        Seq<Function0<Future<Object>>> fromConfig = this.load(settings.startupChecks());
        this.startupChecks = (Seq)((IterableOps)fromConfig.$plus$plus((IterableOnce)fromScaladslSetup)).$plus$plus((IterableOnce)fromJavadslSetup);
        Option option3 = system.settings().setup().get(ClassTag$.MODULE$.apply(ReadinessCheckSetup.class));
        if (None$.MODULE$.equals(option3)) {
            nil$2 = package$.MODULE$.Nil();
        } else if (option3 instanceof Some) {
            ReadinessCheckSetup setup = (ReadinessCheckSetup)((Object)((Some)option3).value());
            nil$2 = (Seq)setup.createHealthChecks().apply((Object)system);
        } else {
            throw new MatchError((Object)option3);
        }
        Nil$ fromScaladslSetup2 = nil$2;
        Option option4 = system.settings().setup().get(ClassTag$.MODULE$.apply(org.apache.pekko.management.javadsl.ReadinessCheckSetup.class));
        if (None$.MODULE$.equals(option4)) {
            seq2 = package$.MODULE$.Nil();
        } else if (option4 instanceof Some) {
            org.apache.pekko.management.javadsl.ReadinessCheckSetup setup = (org.apache.pekko.management.javadsl.ReadinessCheckSetup)((Object)((Some)option4).value());
            seq2 = this.convertSuppliersToScala(setup.createHealthChecks().apply((ActorSystem)system));
        } else {
            throw new MatchError((Object)option4);
        }
        Seq<Function0<Future<Object>>> fromJavadslSetup2 = seq2;
        Seq<Function0<Future<Object>>> fromConfig2 = this.load(settings.readinessChecks());
        this.readiness = (Seq)((IterableOps)fromConfig2.$plus$plus((IterableOnce)fromScaladslSetup2)).$plus$plus((IterableOnce)fromJavadslSetup2);
        Option option5 = system.settings().setup().get(ClassTag$.MODULE$.apply(org.apache.pekko.management.scaladsl.LivenessCheckSetup.class));
        if (None$.MODULE$.equals(option5)) {
            nil$ = package$.MODULE$.Nil();
        } else if (option5 instanceof Some) {
            org.apache.pekko.management.scaladsl.LivenessCheckSetup setup = (org.apache.pekko.management.scaladsl.LivenessCheckSetup)((Object)((Some)option5).value());
            nil$ = (Seq)setup.createHealthChecks().apply((Object)system);
        } else {
            throw new MatchError((Object)option5);
        }
        Nil$ fromScaladslSetup3 = nil$;
        Option option6 = system.settings().setup().get(ClassTag$.MODULE$.apply(LivenessCheckSetup.class));
        if (None$.MODULE$.equals(option6)) {
            seq = package$.MODULE$.Nil();
        } else if (option6 instanceof Some) {
            LivenessCheckSetup setup = (LivenessCheckSetup)((Object)((Some)option6).value());
            seq = this.convertSuppliersToScala(setup.createHealthChecks().apply((ActorSystem)system));
        } else {
            throw new MatchError((Object)option6);
        }
        Seq<Function0<Future<Object>>> fromJavadslSetup3 = seq;
        Seq<Function0<Future<Object>>> fromConfig3 = this.load(settings.livenessChecks());
        this.liveness = (Seq)((IterableOps)fromConfig3.$plus$plus((IterableOnce)fromScaladslSetup3)).$plus$plus((IterableOnce)fromJavadslSetup3);
    }

    private Seq<Function0<Future<Object>>> convertSuppliersToScala(java.util.List<Supplier<CompletionStage<Boolean>>> suppliers) {
        return package.JavaConverters$.MODULE$.ListHasAsScala(suppliers).asScala().toList().map((Function1 & Serializable)supplier -> this.convertSupplierToScala((Supplier<CompletionStage<Boolean>>)supplier));
    }

    private Function0<Future<Object>> convertSupplierToScala(Supplier<CompletionStage<Boolean>> supplier) {
        return (Function0 & Serializable)() -> {
            CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)supplier.get());
            return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(completionStage).map((Function1 & Serializable)_$1 -> _$1, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
        };
    }

    private Try<Function0<Future<Object>>> tryLoadScalaHealthCheck(String fqcn) {
        return this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dynamicAccess().createInstanceFor(fqcn, (Seq)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply(ActorSystem.class, (Object)this.org$apache$pekko$management$internal$HealthChecksImpl$$system), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Function0.class)).recoverWith((PartialFunction)new Serializable(fqcn, this){
            private final String fqcn$1;
            private final /* synthetic */ HealthChecksImpl $outer;
            {
                this.fqcn$1 = fqcn$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchMethodException) {
                    return this.$outer.org$apache$pekko$management$internal$HealthChecksImpl$$system.dynamicAccess().createInstanceFor(this.fqcn$1, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Function0.class));
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Try<Function0<Future<Object>>> org$apache$pekko$management$internal$HealthChecksImpl$$tryLoadJavaHealthCheck(String fqcn) {
        return this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dynamicAccess().createInstanceFor(fqcn, (Seq)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply(ActorSystem.class, (Object)this.org$apache$pekko$management$internal$HealthChecksImpl$$system), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Supplier.class)).recoverWith((PartialFunction)new Serializable(fqcn, this){
            private final String fqcn$2;
            private final /* synthetic */ HealthChecksImpl $outer;
            {
                this.fqcn$2 = fqcn$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchMethodException) {
                    return this.$outer.org$apache$pekko$management$internal$HealthChecksImpl$$system.dynamicAccess().createInstanceFor(this.fqcn$2, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Supplier.class));
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)supplier -> this.convertSupplierToScala((Supplier<CompletionStage<Boolean>>)supplier));
    }

    private Seq<Function0<Future<Object>>> load(Seq<NamedHealthCheck> checks) {
        return (Seq)((IterableOps)checks.map((Function1 & Serializable)namedHealthCheck -> this.tryLoadScalaHealthCheck(namedHealthCheck.fullyQualifiedClassName()).recoverWith((PartialFunction)new Serializable((NamedHealthCheck)namedHealthCheck, this){
            private final NamedHealthCheck namedHealthCheck$1;
            private final /* synthetic */ HealthChecksImpl $outer;
            {
                this.namedHealthCheck$1 = namedHealthCheck$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof ClassCastException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof ClassCastException) {
                    return this.$outer.org$apache$pekko$management$internal$HealthChecksImpl$$tryLoadJavaHealthCheck(this.namedHealthCheck$1.fullyQualifiedClassName());
                }
                return function1.apply((Object)x);
            }
        }))).map((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Function0 c = (Function0)((Success)try_).value();
                return c;
            }
            if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (throwable instanceof NoSuchMethodException) {
                    throw new InvalidHealthCheckException(new StringBuilder(108).append("Health checks: [").append(checks.mkString(",")).append("] must have a no args constructor or a single argument constructor that takes an ActorSystem").toString());
                }
                if (throwable instanceof ClassCastException) {
                    throw new InvalidHealthCheckException(new StringBuilder(55).append("Health checks: [").append(checks.mkString(",")).append("] must have type: () => Future[Boolean]").toString());
                }
                if (throwable instanceof ClassNotFoundException) {
                    ClassNotFoundException c = (ClassNotFoundException)throwable;
                    throw new InvalidHealthCheckException(new StringBuilder(26).append("Health check: [").append(c.getMessage()).append("] not found").toString());
                }
                Throwable t = throwable;
                throw new InvalidHealthCheckException("Uncaught exception from Health check construction", t);
            }
            throw new MatchError((Object)try_);
        });
    }

    @Override
    public Future<Either<String, BoxedUnit>> startupResult() {
        Future<Either<String, BoxedUnit>> result = this.check(this.startupChecks);
        result.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Either either = (Either)((Success)try_).value();
                if (either instanceof Right) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = ((Right)either).value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        return;
                    }
                }
                if (either instanceof Left) {
                    String reason = (String)((Left)either).value();
                    this.log.info(ManagementLogMarker$.MODULE$.startupCheckFailed(), reason);
                    return;
                }
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.log.warning(ManagementLogMarker$.MODULE$.startupCheckFailed(), e.getMessage());
                return;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
        return result;
    }

    @Override
    public Future<Object> startup() {
        return this.startupResult().map((Function1 & Serializable)_$2 -> _$2.isRight(), (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
    }

    @Override
    public Future<Either<String, BoxedUnit>> readyResult() {
        Future<Either<String, BoxedUnit>> result = this.check(this.readiness);
        result.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Either either = (Either)((Success)try_).value();
                if (either instanceof Right) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = ((Right)either).value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        return;
                    }
                }
                if (either instanceof Left) {
                    String reason = (String)((Left)either).value();
                    this.log.info(ManagementLogMarker$.MODULE$.readinessCheckFailed(), reason);
                    return;
                }
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.log.warning(ManagementLogMarker$.MODULE$.readinessCheckFailed(), e.getMessage());
                return;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
        return result;
    }

    @Override
    public Future<Object> ready() {
        return this.readyResult().map((Function1 & Serializable)_$3 -> _$3.isRight(), (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
    }

    @Override
    public Future<Either<String, BoxedUnit>> aliveResult() {
        Future<Either<String, BoxedUnit>> result = this.check(this.liveness);
        result.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Either either = (Either)((Success)try_).value();
                if (either instanceof Right) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = ((Right)either).value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        return;
                    }
                }
                if (either instanceof Left) {
                    String reason = (String)((Left)either).value();
                    this.log.info(ManagementLogMarker$.MODULE$.livenessCheckFailed(), reason);
                    return;
                }
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.log.warning(ManagementLogMarker$.MODULE$.livenessCheckFailed(), e.getMessage());
                return;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
        return result;
    }

    @Override
    public Future<Object> alive() {
        return this.aliveResult().map((Function1 & Serializable)_$4 -> _$4.isRight(), (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
    }

    private Future<Object> runCheck(Function0<Future<Object>> check) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply(check)).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
    }

    private Future<Either<String, BoxedUnit>> check(Seq<Function0<Future<Object>>> checks) {
        Future timeout = org.apache.pekko.pattern.package$.MODULE$.after(this.org$apache$pekko$management$internal$HealthChecksImpl$$settings.checkTimeout(), this.org$apache$pekko$management$internal$HealthChecksImpl$$system.scheduler(), HealthChecksImpl::$anonfun$1, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
        Seq spawnedChecks = (Seq)checks.map((Function1 & Serializable)check -> {
            String checkName = check.getClass().getName();
            return Future$.MODULE$.firstCompletedOf((IterableOnce)((SeqOps)new .colon.colon((Object)timeout.recoverWith((PartialFunction)new Serializable(checkName, this){
                private final String checkName$1;
                private final /* synthetic */ HealthChecksImpl $outer;
                {
                    this.checkName$1 = checkName$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return throwable != null;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        return Future$.MODULE$.failed((Throwable)CheckTimeoutException$.MODULE$.apply(new StringBuilder(25).append("Check [").append(this.checkName$1).append("] timed out after ").append(this.$outer.org$apache$pekko$management$internal$HealthChecksImpl$$settings.checkTimeout()).toString()));
                    }
                    return function1.apply((Object)x);
                }
            }, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher()), (List)new .colon.colon((Object)this.runCheck((Function0<Future<Object>>)check).map((Function1 & Serializable)x$1 -> HealthChecksImpl.$anonfun$2$$anonfun$1(checkName, BoxesRunTime.unboxToBoolean((Object)x$1)), (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher()).recoverWith((PartialFunction)new Serializable(checkName){
                private final String checkName$3;
                {
                    this.checkName$3 = checkName$6;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable t = throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable t = throwable;
                        return Future$.MODULE$.failed((Throwable)CheckFailedException$.MODULE$.apply(new StringBuilder(17).append("Check [").append(this.checkName$3).append("] failed: ").append(t.getMessage()).toString(), t));
                    }
                    return function1.apply((Object)x);
                }
            }, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher()), (List)Nil$.MODULE$))), (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
        });
        return Future$.MODULE$.sequence((IterableOnce)spawnedChecks, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher()).map((Function1 & Serializable)completedChecks -> {
            Option option = completedChecks.collectFirst((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Either x) {
                    Either either = x;
                    if (either instanceof Left) {
                        String failure = (String)((Left)either).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Either x, Function1 function1) {
                    Either either = x;
                    if (either instanceof Left) {
                        String failure = (String)((Left)either).value();
                        return failure;
                    }
                    return function1.apply((Object)x);
                }
            });
            if (option instanceof Some) {
                String notOk = (String)((Some)option).value();
                return package$.MODULE$.Left().apply((Object)notOk);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)this.org$apache$pekko$management$internal$HealthChecksImpl$$system.dispatcher());
    }

    private static final Future $anonfun$1() {
        return Future$.MODULE$.failed((Throwable)new RuntimeException());
    }

    private static final /* synthetic */ Either $anonfun$2$$anonfun$1(String checkName$2, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        if (!bl) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(15).append("Check [").append(checkName$2).append("] not ok").toString());
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }
}

