/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.scaladsl;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.http.javadsl.server.directives.SecurityDirectives;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.ServerBuilder;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.PathMatcher$;
import org.apache.pekko.http.scaladsl.server.PathMatchers$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.RouteResult$;
import org.apache.pekko.http.scaladsl.server.directives.Credentials;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.management.ManagementLogMarker$;
import org.apache.pekko.management.NamedRouteProvider;
import org.apache.pekko.management.NamedRouteProvider$;
import org.apache.pekko.management.PekkoManagementSettings;
import org.apache.pekko.management.scaladsl.ManagementRouteProvider;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderAdapter;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettings;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettings$;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettingsImpl;
import org.apache.pekko.management.scaladsl.PekkoManagement$;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.ManifestInfo;
import org.apache.pekko.util.ManifestInfo$;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class PekkoManagement
implements Extension {
    private final ExtendedActorSystem system;
    private final MarkerLoggingAdapter log;
    private final PekkoManagementSettings settings;
    private final Seq<ManagementRouteProvider> routeProviders;
    private final AtomicReference<Future<Http.ServerBinding>> bindingFuture;
    private final Promise<Uri> selfUriPromise;

    public static Extension apply(ActorSystem actorSystem) {
        return PekkoManagement$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return PekkoManagement$.MODULE$.apply(classicActorSystemProvider);
    }

    public static PekkoManagement createExtension(ExtendedActorSystem extendedActorSystem) {
        return PekkoManagement$.MODULE$.createExtension(extendedActorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return PekkoManagement$.MODULE$.get(actorSystem);
    }

    public static PekkoManagement get(ActorSystem actorSystem) {
        return PekkoManagement$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return PekkoManagement$.MODULE$.get(classicActorSystemProvider);
    }

    public static PekkoManagement get(ClassicActorSystemProvider classicActorSystemProvider) {
        return PekkoManagement$.MODULE$.get(classicActorSystemProvider);
    }

    public static PekkoManagement$ lookup() {
        return PekkoManagement$.MODULE$.lookup();
    }

    public PekkoManagement(ExtendedActorSystem system) {
        this.system = system;
        ((ManifestInfo)ManifestInfo$.MODULE$.apply((ActorSystem)system)).checkSameVersion("Pekko Management", (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pekko-discovery-consul", "pekko-discovery-aws-api", "pekko-discovery-marathon-api", "pekko-discovery-aws-api-async", "pekko-discovery-kubernetes-api", "pekko-lease-kubernetes", "pekko-management", "pekko-management-cluster-bootstrap", "pekko-management-cluster-http"})), true);
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromClass());
        this.settings = new PekkoManagementSettings(system.settings().config());
        this.routeProviders = this.loadRouteProviders();
        this.bindingFuture = new AtomicReference();
        this.selfUriPromise = Promise$.MODULE$.apply();
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public PekkoManagementSettings settings() {
        return this.settings;
    }

    private ManagementRouteProviderSettings providerSettings() {
        String protocol = "http";
        String host = this.settings().Http().Hostname();
        int port = this.settings().Http().Port();
        String path = (String)this.settings().Http().BasePath().fold(PekkoManagement::$anonfun$1, (Function1 & Serializable)_$1 -> new StringBuilder(1).append("/").append((String)_$1).toString());
        Uri selfBaseUri = Uri$.MODULE$.from(protocol, Uri$.MODULE$.from$default$2(), host, port, path, Uri$.MODULE$.from$default$6(), Uri$.MODULE$.from$default$7(), Uri$.MODULE$.from$default$8());
        return ManagementRouteProviderSettings$.MODULE$.apply(selfBaseUri, this.settings().Http().RouteProvidersReadOnly());
    }

    public Function1<RequestContext, Future<RouteResult>> routes() {
        return this.prepareCombinedRoutes(this.providerSettings());
    }

    public Function1<RequestContext, Future<RouteResult>> routes(Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings> transformSettings) {
        return this.prepareCombinedRoutes((ManagementRouteProviderSettings)transformSettings.apply((Object)this.providerSettings()));
    }

    public Future<Uri> start() {
        return this.start((Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings>)(Function1 & Serializable)x -> (ManagementRouteProviderSettings)Predef$.MODULE$.identity(x));
    }

    public Future<Uri> start(Function1<ManagementRouteProviderSettings, ManagementRouteProviderSettings> transformSettings) {
        Promise serverBindingPromise = Promise$.MODULE$.apply();
        if (this.bindingFuture.compareAndSet(null, (Future<Http.ServerBinding>)serverBindingPromise.future())) {
            Future future;
            try {
                ServerBuilder serverBuilder;
                String effectiveBindHostname = this.settings().Http().EffectiveBindHostname();
                int effectiveBindPort = this.settings().Http().EffectiveBindPort();
                ManagementRouteProviderSettings effectiveProviderSettings = (ManagementRouteProviderSettings)transformSettings.apply((Object)this.providerSettings());
                this.log.info("Binding Pekko Management (HTTP) endpoint to: {}:{}", (Object)effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)effectiveBindPort));
                Function1<RequestContext, Future<RouteResult>> combinedRoutes = this.prepareCombinedRoutes(effectiveProviderSettings);
                ServerBuilder baseBuilder = Http$.MODULE$.apply((ClassicActorSystemProvider)this.system()).newServerAt(effectiveBindHostname, effectiveBindPort).withSettings(((ServerSettings)ServerSettings$.MODULE$.apply((ActorSystem)this.system())).withRemoteAddressHeader(true));
                Option<HttpsConnectionContext> option = effectiveProviderSettings.httpsConnectionContext();
                if (option instanceof Some) {
                    HttpsConnectionContext httpsContext = (HttpsConnectionContext)((Some)option).value();
                    serverBuilder = baseBuilder.enableHttps(httpsContext);
                } else if (None$.MODULE$.equals(option)) {
                    serverBuilder = baseBuilder;
                } else {
                    throw new MatchError(option);
                }
                ServerBuilder securedBuilder = serverBuilder;
                Future serverFutureBinding = securedBuilder.bind(RouteResult$.MODULE$.routeToFunction(combinedRoutes, (ClassicActorSystemProvider)this.system()));
                future = serverBindingPromise.completeWith(serverFutureBinding).future().flatMap((Function1 & Serializable)binding -> {
                    int boundPort = binding.localAddress().getPort();
                    this.log.info(ManagementLogMarker$.MODULE$.boundHttp(new StringBuilder(1).append(effectiveBindHostname).append(":").append(boundPort).toString()), "Bound Pekko Management (HTTP) endpoint to: {}:{}", (Object)effectiveBindHostname, (Object)BoxesRunTime.boxToInteger((int)boundPort));
                    return this.selfUriPromise.success((Object)effectiveProviderSettings.selfBaseUri().withPort(boundPort)).future();
                }, (ExecutionContext)this.system().dispatcher());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    this.log.warning(ex.getMessage());
                    future = Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Failed to start Pekko Management HTTP endpoint.", ex));
                }
                throw throwable;
            }
            return future;
        }
        return this.selfUriPromise.future();
    }

    private Function1<RequestContext, Future<RouteResult>> prepareCombinedRoutes(ManagementRouteProviderSettings providerSettings) {
        String pathPrefixName = (String)this.settings().Http().BasePath().getOrElse(PekkoManagement::$anonfun$3);
        Directive basePath = pathPrefixName.isEmpty() ? Directives$.MODULE$.rawPathPrefix(PathMatcher$.MODULE$._segmentStringToPathMatcher(pathPrefixName)) : Directives$.MODULE$.pathPrefix(PathMatchers$.MODULE$.separateOnSlashes(pathPrefixName));
        Seq combinedRoutes = (Seq)this.routeProviders.map((Function1 & Serializable)provider -> {
            this.log.info("Including HTTP management routes for {}", (Object)Logging$.MODULE$.simpleName(provider));
            return provider.routes(providerSettings);
        });
        if (combinedRoutes.nonEmpty()) {
            return (Function1)Directive$.MODULE$.addByNameNullaryApply(basePath).apply(() -> this.prepareCombinedRoutes$$anonfun$1(combinedRoutes, providerSettings));
        }
        throw new IllegalArgumentException("No routes configured for pekko management! Double check your `pekko.management.http.routes` config.");
    }

    public Future<Done> stop() {
        Future<Http.ServerBinding> binding;
        do {
            if ((binding = this.bindingFuture.get()) != null) continue;
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        } while (!this.bindingFuture.compareAndSet(binding, null));
        return binding.flatMap((Function1 & Serializable)_$5 -> _$5.unbind(), (ExecutionContext)this.system().dispatcher()).map((Function1 & Serializable)_$6 -> Done$.MODULE$, (ExecutionContext)this.system().dispatcher());
    }

    private Seq<ManagementRouteProvider> loadRouteProviders() {
        DynamicAccess dynamicAccess = this.system().dynamicAccess();
        return (Seq)this.settings().Http().RouteProviders().map((Function1 & Serializable)x$1 -> {
            NamedRouteProvider namedRouteProvider = x$1;
            if (namedRouteProvider != null) {
                NamedRouteProvider namedRouteProvider2 = NamedRouteProvider$.MODULE$.unapply(namedRouteProvider);
                String string = namedRouteProvider2._1();
                String string2 = namedRouteProvider2._2();
                String name = string;
                String fqcn = string2;
                Try try_ = dynamicAccess.getObjectFor(fqcn, ClassTag$.MODULE$.apply(ExtensionIdProvider.class)).recoverWith((PartialFunction)new Serializable(dynamicAccess, fqcn){
                    private final DynamicAccess dynamicAccess$2;
                    private final String fqcn$1;
                    {
                        this.dynamicAccess$2 = dynamicAccess$8;
                        this.fqcn$1 = fqcn$7;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        return this.dynamicAccess$2.createInstanceFor(this.fqcn$1, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(ExtensionIdProvider.class));
                    }
                }).recoverWith((PartialFunction)new Serializable(dynamicAccess, fqcn, this){
                    private final DynamicAccess dynamicAccess$3;
                    private final String fqcn$2;
                    private final /* synthetic */ PekkoManagement $outer;
                    {
                        this.dynamicAccess$3 = dynamicAccess$9;
                        this.fqcn$2 = fqcn$8;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException;
                        {
                        }
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = Tuple2$.MODULE$.apply(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return this.dynamicAccess$3.createInstanceFor(this.fqcn$2, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ExtensionIdProvider.class));
                        }
                        return function1.apply((Object)x);
                    }
                }).recoverWith((PartialFunction)new Serializable(dynamicAccess, fqcn){
                    private final DynamicAccess dynamicAccess$4;
                    private final String fqcn$3;
                    {
                        this.dynamicAccess$4 = dynamicAccess$10;
                        this.fqcn$3 = fqcn$9;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException;
                        {
                        }
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException) {
                            return this.dynamicAccess$4.createInstanceFor(this.fqcn$3, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(ManagementRouteProvider.class));
                        }
                        return function1.apply((Object)x);
                    }
                }).recoverWith((PartialFunction)new Serializable(dynamicAccess, fqcn, this){
                    private final DynamicAccess dynamicAccess$5;
                    private final String fqcn$4;
                    private final /* synthetic */ PekkoManagement $outer;
                    {
                        this.dynamicAccess$5 = dynamicAccess$11;
                        this.fqcn$4 = fqcn$10;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException;
                        {
                        }
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = Tuple2$.MODULE$.apply(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return this.dynamicAccess$5.createInstanceFor(this.fqcn$4, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ManagementRouteProvider.class));
                        }
                        return function1.apply((Object)x);
                    }
                }).recoverWith((PartialFunction)new Serializable(dynamicAccess, fqcn){
                    private final DynamicAccess dynamicAccess$6;
                    private final String fqcn$5;
                    {
                        this.dynamicAccess$6 = dynamicAccess$12;
                        this.fqcn$5 = fqcn$11;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException;
                        {
                        }
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException) {
                            return this.dynamicAccess$6.createInstanceFor(this.fqcn$5, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(org.apache.pekko.management.javadsl.ManagementRouteProvider.class));
                        }
                        return function1.apply((Object)x);
                    }
                }).recoverWith((PartialFunction)new Serializable(dynamicAccess, fqcn, this){
                    private final DynamicAccess dynamicAccess$7;
                    private final String fqcn$6;
                    private final /* synthetic */ PekkoManagement $outer;
                    {
                        this.dynamicAccess$7 = dynamicAccess$13;
                        this.fqcn$6 = fqcn$12;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException;
                        {
                        }
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof ClassCastException || throwable instanceof NoSuchMethodException) {
                            Tuple2 tuple2 = Tuple2$.MODULE$.apply(ExtendedActorSystem.class, (Object)this.$outer.system());
                            return this.dynamicAccess$7.createInstanceFor(this.fqcn$6, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(org.apache.pekko.management.javadsl.ManagementRouteProvider.class));
                        }
                        return function1.apply((Object)x);
                    }
                });
                if (try_ instanceof Success) {
                    Object object = ((Success)try_).value();
                    if (object instanceof ExtensionIdProvider) {
                        ExtensionIdProvider p = (ExtensionIdProvider)object;
                        Extension extension = this.system().registerExtension(p.lookup());
                        if (extension instanceof ManagementRouteProvider) {
                            ManagementRouteProvider provider = (ManagementRouteProvider)extension;
                            return provider;
                        }
                        if (extension instanceof org.apache.pekko.management.javadsl.ManagementRouteProvider) {
                            org.apache.pekko.management.javadsl.ManagementRouteProvider provider = (org.apache.pekko.management.javadsl.ManagementRouteProvider)extension;
                            return new ManagementRouteProviderAdapter(provider);
                        }
                        Extension other = extension;
                        throw new RuntimeException(new StringBuilder(63).append("Extension [").append(fqcn).append("] should create a 'ManagementRouteProvider' but was ").append(new StringBuilder(2).append("[").append(other.getClass().getName()).append("]").toString()).toString());
                    }
                    if (object instanceof ManagementRouteProvider) {
                        ManagementRouteProvider provider = (ManagementRouteProvider)object;
                        return provider;
                    }
                    if (object instanceof org.apache.pekko.management.javadsl.ManagementRouteProvider) {
                        org.apache.pekko.management.javadsl.ManagementRouteProvider provider = (org.apache.pekko.management.javadsl.ManagementRouteProvider)object;
                        return new ManagementRouteProviderAdapter(provider);
                    }
                    throw new RuntimeException(new StringBuilder(78).append("[").append(fqcn).append("] is not an 'ExtensionIdProvider', 'ExtensionId' or 'ManagementRouteProvider'").toString());
                }
                if (try_ instanceof Failure) {
                    Throwable problem = ((Failure)try_).exception();
                    throw new RuntimeException(new StringBuilder(51).append("While trying to load route provider extension [").append(name).append(" = ").append(fqcn).append("]").toString(), problem);
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError((Object)namedRouteProvider);
        });
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final Optional credsToJava$1(Credentials cred) {
        Credentials credentials = cred;
        if (credentials instanceof Credentials.Provided) {
            Credentials.Provided provided = (Credentials.Provided)credentials;
            return Optional.of(SecurityDirectives.ProvidedCredentials$.MODULE$.apply(provided));
        }
        return Optional.empty();
    }

    private final Function1 wrapWithAuthenticatorIfPresent$1(ManagementRouteProviderSettings providerSettings$1, Function1 inner) {
        ManagementRouteProviderSettingsImpl providerSettingsImpl = (ManagementRouteProviderSettingsImpl)providerSettings$1;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(providerSettingsImpl.scaladslAuth(), providerSettingsImpl.javadslAuth());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return inner;
            }
            if (option instanceof Some) {
                Function1 asyncAuthenticator = (Function1)((Some)option).value();
                if (None$.MODULE$.equals(option2)) {
                    return (Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.authenticateBasicAsync("secured", asyncAuthenticator), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)_$2 -> inner);
                }
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                Function auth = (Function)((Some)option2).value();
                return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.authenticateBasicAsync("secured", (Function1 & Serializable)c -> {
                    CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)auth.apply(PekkoManagement.credsToJava$1(c)));
                    return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(completionStage).map((Function1 & Serializable)_$3 -> {
                        Optional optional = OptionConverters$.MODULE$.RichOptional(_$3);
                        return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
                    }, (ExecutionContext)this.system().dispatcher());
                }).optional(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)_$4 -> inner);
            }
            if (option instanceof Some && option2 instanceof Some) {
                throw new IllegalStateException("Unexpected that both scaladsl and javadsl auth were defined");
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final Function1 prepareCombinedRoutes$$anonfun$1(Seq combinedRoutes$1, ManagementRouteProviderSettings providerSettings$3) {
        return this.wrapWithAuthenticatorIfPresent$1(providerSettings$3, Directives$.MODULE$.concat(combinedRoutes$1));
    }
}

