/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.dynamodb.journal;

import org.apache.pekko.persistence.dynamodb.journal.PartitionKeys;
import org.apache.pekko.persistence.dynamodb.journal.package$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxesRunTime;

public final class DynamoPartitionGrouped$
extends GraphStage<FlowShape<Object, PartitionKeys>> {
    public static final DynamoPartitionGrouped$ MODULE$ = new DynamoPartitionGrouped$();
    private static final Inlet<Object> in = Inlet$.MODULE$.apply("DynamoEventNum.in");
    private static final Outlet<PartitionKeys> out = Outlet$.MODULE$.apply("DynamoPartitionKeys.out");
    private static final Attributes initialAttributes = Attributes$.MODULE$.name("DynamoPartitionGrouped");
    private static final FlowShape<Object, PartitionKeys> shape = new FlowShape(MODULE$.in(), MODULE$.out());

    public Inlet<Object> in() {
        return in;
    }

    public Outlet<PartitionKeys> out() {
        return out;
    }

    public Attributes initialAttributes() {
        return initialAttributes;
    }

    public FlowShape<Object, PartitionKeys> shape() {
        return shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(){
            private final ReusableBuilder<Object, Vector<Object>> partitionBuf;
            private boolean hasElements;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            private ReusableBuilder<Object, Vector<Object>> partitionBuf() {
                return this.partitionBuf;
            }

            private boolean hasElements() {
                return this.hasElements;
            }

            private void hasElements_$eq(boolean x$1) {
                this.hasElements = x$1;
            }

            private void pushOut(long currentSeqNo, Vector<Object> partitionGroup) {
                this.partitionBuf().clear();
                this.hasElements_$eq(false);
                long partitionSeqNo = currentSeqNo / (long)package$.MODULE$.PartitionSize();
                this.push(DynamoPartitionGrouped$.MODULE$.out(), new PartitionKeys(partitionSeqNo, (Seq<Object>)partitionGroup));
            }

            public void onPush() {
                long currentSeqNo = BoxesRunTime.unboxToLong((Object)this.grab(DynamoPartitionGrouped$.MODULE$.in()));
                this.partitionBuf().$plus$eq((Object)BoxesRunTime.boxToLong((long)currentSeqNo));
                this.hasElements_$eq(true);
                if ((currentSeqNo + 1L) % (long)package$.MODULE$.PartitionSize() == 0L) {
                    Vector partitionGroup = (Vector)this.partitionBuf().result();
                    this.pushOut(currentSeqNo, (Vector<Object>)partitionGroup);
                    return;
                }
                this.pull(DynamoPartitionGrouped$.MODULE$.in());
            }

            public void onPull() {
                this.pull(DynamoPartitionGrouped$.MODULE$.in());
            }

            public void onUpstreamFinish() {
                if (this.hasElements()) {
                    Vector partitionGroup = (Vector)this.partitionBuf().result();
                    long currentSeqNo = BoxesRunTime.unboxToLong((Object)partitionGroup.last());
                    this.pushOut(currentSeqNo, (Vector<Object>)partitionGroup);
                }
                this.completeStage();
            }
            {
                void var1_1;
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                ReusableBuilder b = scala.package$.MODULE$.Vector().newBuilder();
                b.sizeHint(package$.MODULE$.PartitionSize());
                this.partitionBuf = var1_1;
                this.hasElements = false;
                this.setHandlers(DynamoPartitionGrouped$.MODULE$.in(), DynamoPartitionGrouped$.MODULE$.out(), this);
            }
        };
    }

    private DynamoPartitionGrouped$() {
    }
}

