/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.dynamodb.query;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.persistence.dynamodb.ClientConfig;
import org.apache.pekko.persistence.dynamodb.DynamoDBClientConfig;
import org.apache.pekko.persistence.dynamodb.DynamoDBConfig;
import org.apache.pekko.persistence.dynamodb.query.DynamoDBReadJournalConfig$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001\u0002\u0011\"\u00019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u00191\u0006\u0001)A\u0005\u0017\"9q\u000b\u0001b\u0001\n\u0003Q\u0005B\u0002-\u0001A\u0003%1\nC\u0004Z\u0001\t\u0007I\u0011\u0001&\t\ri\u0003\u0001\u0015!\u0003L\u0011\u001dY\u0006A1A\u0005\u0002)Ca\u0001\u0018\u0001!\u0002\u0013Y\u0005bB/\u0001\u0005\u0004%\tA\u0013\u0005\u0007=\u0002\u0001\u000b\u0011B&\t\u000f}\u0003!\u0019!C\u0001A\"1A\r\u0001Q\u0001\n\u0005Dq!\u001a\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004g\u0001\u0001\u0006I!\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0001a\u0011\u0019A\u0007\u0001)A\u0005C\"9\u0011\u000e\u0001b\u0001\n\u0003Q\u0005B\u00026\u0001A\u0003%1\nC\u0003l\u0001\u0011\u0005C\u000eC\u0004n\u0001\t\u0007I\u0011\t8\t\rI\u0004\u0001\u0015!\u0003p\u0011\u001d\u0019\bA1A\u0005B)Ca\u0001\u001e\u0001!\u0002\u0013Y\u0005bB;\u0001\u0005\u0004%\tE\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\b\u000bm\f\u0003\u0012\u0001?\u0007\u000b\u0001\n\u0003\u0012A?\t\u000b\u0011kB\u0011\u0001@\t\r}lB\u0011AA\u0001\u0005e!\u0015P\\1n_\u0012\u0013%+Z1e\u0015>,(O\\1m\u0007>tg-[4\u000b\u0005\t\u001a\u0013!B9vKJL(B\u0001\u0013&\u0003!!\u0017P\\1n_\u0012\u0014'B\u0001\u0014(\u0003-\u0001XM]:jgR,gnY3\u000b\u0005!J\u0013!\u00029fW.|'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001_U\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0007C\u0001\u001c8\u001b\u0005\u0019\u0013B\u0001\u001d$\u00059!\u0015P\\1n_\u0012\u00135i\u001c8gS\u001e\f\u0011a\u0019\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\naaY8oM&<'BA A\u0003!!\u0018\u0010]3tC\u001a,'\"A!\u0002\u0007\r|W.\u0003\u0002Dy\t11i\u001c8gS\u001e\fa\u0001P5oSRtDC\u0001$I!\t9\u0005!D\u0001\"\u0011\u0015I$\u00011\u0001;\u0003\u0015!\u0016M\u00197f+\u0005Y\u0005C\u0001'T\u001d\ti\u0015\u000b\u0005\u0002Oc5\tqJ\u0003\u0002Q[\u00051AH]8pizJ!AU\u0019\u0002\rA\u0013X\rZ3g\u0013\t!VK\u0001\u0004TiJLgn\u001a\u0006\u0003%F\na\u0001V1cY\u0016\u0004\u0013a\u0003&pkJt\u0017\r\u001c(b[\u0016\fABS8ve:\fGNT1nK\u0002\na!Q<t\u0017\u0016L\u0018aB!xg.+\u0017\u0010I\u0001\n\u0003^\u001c8+Z2sKR\f!\"Q<t'\u0016\u001c'/\u001a;!\u0003!)e\u000e\u001a9pS:$\u0018!C#oIB|\u0017N\u001c;!\u0003-i\u0015\r\u001f\"bi\u000eDw)\u001a;\u0016\u0003\u0005\u0004\"\u0001\r2\n\u0005\r\f$aA%oi\u0006aQ*\u0019=CCR\u001c\u0007nR3uA\u0005iQ*\u0019=CCR\u001c\u0007n\u0016:ji\u0016\fa\"T1y\u0005\u0006$8\r[,sSR,\u0007%A\u0006NCbLE/Z7TSj,\u0017\u0001D'bq&#X-\\*ju\u0016\u0004\u0013a\u0006)feNL7\u000f^3oG\u0016LEm]%oI\u0016Dh*Y7f\u0003a\u0001VM]:jgR,gnY3JINLe\u000eZ3y\u001d\u0006lW\rI\u0001\ti>\u001cFO]5oOR\t1*\u0001\u0004dY&,g\u000e^\u000b\u0002_B\u0011a\u0007]\u0005\u0003c\u000e\u0012Ab\u00117jK:$8i\u001c8gS\u001e\fqa\u00197jK:$\b%\u0001\tDY&,g\u000e\u001e#jgB\fGo\u00195fe\u0006\t2\t\\5f]R$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002\u000fQ\u0013\u0018mY5oOV\tq\u000f\u0005\u00021q&\u0011\u00110\r\u0002\b\u0005>|G.Z1o\u0003!!&/Y2j]\u001e\u0004\u0013!\u0007#z]\u0006lw\u000e\u0012\"SK\u0006$'j\\;s]\u0006d7i\u001c8gS\u001e\u0004\"aR\u000f\u0014\u0005uyC#\u0001?\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005\u0005\rAc\u0001$\u0002\u0006!9\u0011qA\u0010A\u0004\u0005%\u0011aC1di>\u00148+_:uK6\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f9\u0013!B1di>\u0014\u0018\u0002BA\n\u0003\u001b\u00111\"Q2u_J\u001c\u0016p\u001d;f[\u0002")
public class DynamoDBReadJournalConfig
implements DynamoDBConfig {
    private final String Table;
    private final String JournalName;
    private final String AwsKey;
    private final String AwsSecret;
    private final String Endpoint;
    private final int MaxBatchGet;
    private final int MaxBatchWrite;
    private final int MaxItemSize;
    private final String PersistenceIdsIndexName;
    private final ClientConfig client;
    private final String ClientDispatcher;
    private final boolean Tracing;

    public static DynamoDBReadJournalConfig apply(ActorSystem actorSystem) {
        return DynamoDBReadJournalConfig$.MODULE$.apply(actorSystem);
    }

    @Override
    public String Table() {
        return this.Table;
    }

    @Override
    public String JournalName() {
        return this.JournalName;
    }

    @Override
    public String AwsKey() {
        return this.AwsKey;
    }

    @Override
    public String AwsSecret() {
        return this.AwsSecret;
    }

    @Override
    public String Endpoint() {
        return this.Endpoint;
    }

    @Override
    public int MaxBatchGet() {
        return this.MaxBatchGet;
    }

    @Override
    public int MaxBatchWrite() {
        return this.MaxBatchWrite;
    }

    @Override
    public int MaxItemSize() {
        return this.MaxItemSize;
    }

    public String PersistenceIdsIndexName() {
        return this.PersistenceIdsIndexName;
    }

    public String toString() {
        return new StringBuilder(51).append("DynamoDBReadJournalConfig(Table:").append(this.Table()).append(",AwsKey:").append(this.AwsKey()).append(",Endpoint:").append(this.Endpoint()).append(")").toString();
    }

    @Override
    public ClientConfig client() {
        return this.client;
    }

    @Override
    public String ClientDispatcher() {
        return this.ClientDispatcher;
    }

    @Override
    public boolean Tracing() {
        return this.Tracing;
    }

    public DynamoDBReadJournalConfig(Config c) {
        this.Table = c.getString("journal-table");
        this.JournalName = c.getString("journal-name");
        this.AwsKey = c.getString("aws-access-key-id");
        this.AwsSecret = c.getString("aws-secret-access-key");
        this.Endpoint = c.getString("endpoint");
        this.MaxBatchGet = c.getInt("aws-api-limits.max-batch-get");
        this.MaxBatchWrite = c.getInt("aws-api-limits.max-batch-write");
        this.MaxItemSize = c.getInt("aws-api-limits.max-item-size");
        this.PersistenceIdsIndexName = c.getString("persistence-ids-index-name");
        this.client = new DynamoDBClientConfig(c);
        this.ClientDispatcher = c.getString("client-dispatcher");
        this.Tracing = c.getBoolean("tracing");
    }
}

