/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.dynamodb.snapshot;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotMetadata$;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.dynamodb.DynamoDBRequests;
import org.apache.pekko.persistence.dynamodb.snapshot.DynamoDBSnapshotRejection;
import org.apache.pekko.persistence.dynamodb.snapshot.DynamoDBSnapshotStore;
import org.apache.pekko.persistence.dynamodb.snapshot.package$;
import org.apache.pekko.persistence.serialization.Snapshot;
import org.apache.pekko.serialization.AsyncSerializer;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005mf!C\t\u0013!\u0003\r\taHAZ\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u001dy\u0003A1A\u0005\u0002ABQa\u000e\u0001\u0005\naBQ!\u0015\u0001\u0005\u0002ICQ!\u0015\u0001\u0005\u0002}CQa\u001a\u0001\u0005\n!DQ! \u0001\u0005\u0002yDq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002 \u0001!I!!\t\t\u0013\u0005U\u0002!%A\u0005\n\u0005]\u0002bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002\"\u0002!I!a)\t\u000f\u00055\u0006\u0001\"\u0003\u00020\nAB)\u001f8b[>$%i\u00158baNDw\u000e\u001e*fcV,7\u000f^:\u000b\u0005M!\u0012\u0001C:oCB\u001c\bn\u001c;\u000b\u0005U1\u0012\u0001\u00033z]\u0006lw\u000e\u001a2\u000b\u0005]A\u0012a\u00039feNL7\u000f^3oG\u0016T!!\u0007\u000e\u0002\u000bA,7n[8\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dBS\"\u0001\u000b\n\u0005%\"\"\u0001\u0005#z]\u0006lw\u000e\u0012\"SKF,Xm\u001d;t\u0003\u0019!\u0013N\\5uIQ\tA\u0006\u0005\u0002\"[%\u0011aF\t\u0002\u0005+:LG/\u0001\u0004u_Vs\u0017\u000e^\u000b\u0002cA!\u0011E\r\u001b-\u0013\t\u0019$EA\u0005Gk:\u001cG/[8ocA\u0011\u0011%N\u0005\u0003m\t\u00121!\u00118z\u0003!IG/Z7TSj,GcA\u001d=\u0013B\u0011\u0011EO\u0005\u0003w\t\u00121!\u00138u\u0011\u0015i4\u00011\u0001?\u00031\u0001\u0018M\u001d;ji&|gnS3z!\tydI\u0004\u0002A\tB\u0011\u0011II\u0007\u0002\u0005*\u00111IH\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\u0012\t\u000b)\u001b\u0001\u0019A&\u0002%M,'/[1mSj,Gm\u00158baNDw\u000e\u001e\t\u0004C1s\u0015BA'#\u0005\u0015\t%O]1z!\t\ts*\u0003\u0002QE\t!!)\u001f;f\u0003\u0019!W\r\\3uKR\u00111+\u0017\t\u0004)^cS\"A+\u000b\u0005Y\u0013\u0013AC2p]\u000e,(O]3oi&\u0011\u0001,\u0016\u0002\u0007\rV$XO]3\t\u000bi#\u0001\u0019A.\u0002\u00115,G/\u00193bi\u0006\u0004\"\u0001X/\u000e\u0003YI!A\u0018\f\u0003!Ms\u0017\r]:i_RlU\r^1eCR\fGcA*aE\")\u0011-\u0002a\u0001}\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012DQaY\u0003A\u0002\u0011\f\u0001b\u0019:ji\u0016\u0014\u0018.\u0019\t\u00039\u0016L!A\u001a\f\u00033Ms\u0017\r]:i_R\u001cV\r\\3di&|gn\u0011:ji\u0016\u0014\u0018.Y\u0001\u0012g:\f\u0007o\u001d5pi\u0012+G.\u001a;f%\u0016\fHcA5xqB\u0011!.^\u0007\u0002W*\u0011A.\\\u0001\u0006[>$W\r\u001c\u0006\u0003]>\f!\u0002Z=oC6|GM\u0019<3\u0015\t\u0001\u0018/\u0001\u0005tKJ4\u0018nY3t\u0015\t\u00118/A\u0005b[\u0006TxN\\1xg*\tA/A\u0002d_6L!A^6\u0003\u0019]\u0013\u0018\u000e^3SKF,Xm\u001d;\t\u000b\u00054\u0001\u0019\u0001 \t\u000be4\u0001\u0019\u0001>\u0002\u0015M,\u0017/^3oG\u0016t%\u000f\u0005\u0002\"w&\u0011AP\t\u0002\u0005\u0019>tw-\u0001\u0003tCZ,G\u0003C*\u0000\u0003\u0003\t\u0019!a\u0002\t\u000b\u0005<\u0001\u0019\u0001 \t\u000be<\u0001\u0019\u0001>\t\r\u0005\u0015q\u00011\u0001{\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0003\u0014\u000f\u0001\u0007A'\u0001\u0003m_\u0006$GCBA\u0007\u00037\ti\u0002\u0005\u0003U/\u0006=\u0001#B\u0011\u0002\u0012\u0005U\u0011bAA\nE\t1q\n\u001d;j_:\u00042\u0001XA\f\u0013\r\tIB\u0006\u0002\u0011'\u0016dWm\u0019;fINs\u0017\r]:i_RDQ!\u0019\u0005A\u0002yBQa\u0019\u0005A\u0002\u0011\fq\u0002\\8bIF+XM]=SKN,H\u000e\u001e\u000b\t\u0003G\tY#!\f\u00020A!AkVA\u0013!\rQ\u0017qE\u0005\u0004\u0003SY'aC)vKJL(+Z:vYRDQ!Y\u0005A\u0002yBQaY\u0005A\u0002\u0011D\u0011\"!\r\n!\u0003\u0005\r!a\r\u0002\u000b1LW.\u001b;\u0011\t\u0005\n\t\"O\u0001\u001aY>\fG-U;fef\u0014Vm];mi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002:)\"\u00111GA\u001eW\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA$E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0013\u0011\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00047pC\u0012\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\u0015\u0005\r\u0012\u0011KA*\u0003/\nY\u0006C\u0003b\u0017\u0001\u0007a\b\u0003\u0004\u0002V-\u0001\rA_\u0001\r[&tG+[7fgR\fW\u000e\u001d\u0005\u0007\u00033Z\u0001\u0019\u0001>\u0002\u00195\f\u0007\u0010V5nKN$\u0018-\u001c9\t\u000f\u0005E2\u00021\u0001\u00024\u0005YAn\\1e\u0005f\u001cV-\u001d(s))\t\u0019#!\u0019\u0002d\u0005\u001d\u00141\u000e\u0005\u0006C2\u0001\rA\u0010\u0005\u0007\u0003Kb\u0001\u0019\u0001>\u0002\u001b5LgnU3rk\u0016t7-\u001a(s\u0011\u0019\tI\u0007\u0004a\u0001u\u0006iQ.\u0019=TKF,XM\\2f\u001dJDq!!\r\r\u0001\u0004\t\u0019$\u0001\u0006m_\u0006$')\u001f\"pi\"$\u0002\"a\t\u0002r\u0005M\u0014Q\u000f\u0005\u0006C6\u0001\rA\u0010\u0005\u0006G6\u0001\r\u0001\u001a\u0005\b\u0003ci\u0001\u0019AA\u001a\u00039!xn\u00158baNDw\u000e^%uK6$\"\"a\u001f\u0002\u001a\u0006m\u0015QTAP!\u0011!v+! \u0011\t\u0005}\u00141\u0013\b\u0005\u0003\u0003\u000byI\u0004\u0003\u0002\u0004\u00065e\u0002BAC\u0003\u0017sA!a\"\u0002\n6\t!$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0003+YI1!!%\u0015\u0003\u001d\u0001\u0018mY6bO\u0016LA!!&\u0002\u0018\n!\u0011\n^3n\u0015\r\t\t\n\u0006\u0005\u0006C:\u0001\rA\u0010\u0005\u0006s:\u0001\rA\u001f\u0005\u0007\u0003\u000bq\u0001\u0019\u0001>\t\u000bMq\u0001\u0019\u0001\u001b\u0002!\u0019\u0014x.\\*oCB\u001c\bn\u001c;Ji\u0016lGCBAS\u0003O\u000bI\u000b\u0005\u0003U/\u0006U\u0001\"B1\u0010\u0001\u0004q\u0004bBAV\u001f\u0001\u0007\u0011QP\u0001\u0005SR,W.A\nnKN\u001c\u0018mZ3QCJ$\u0018\u000e^5p].+\u0017\u0010F\u0002?\u0003cCQ!\u0019\tA\u0002y\u0002B!!.\u000286\t!#C\u0002\u0002:J\u0011Q\u0003R=oC6|GIQ*oCB\u001c\bn\u001c;Ti>\u0014X\r")
public interface DynamoDBSnapshotRequests
extends DynamoDBRequests {
    public void org$apache$pekko$persistence$dynamodb$snapshot$DynamoDBSnapshotRequests$_setter_$toUnit_$eq(Function1<Object, BoxedUnit> var1);

    public Function1<Object, BoxedUnit> toUnit();

    private int itemSize(String partitionKey, byte[] serializedSnapshot) {
        return package$.MODULE$.DynamoFixedByteSize() + partitionKey.length() + ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(serializedSnapshot));
    }

    public static /* synthetic */ Future delete$(DynamoDBSnapshotRequests $this, SnapshotMetadata metadata) {
        return $this.delete(metadata);
    }

    default public Future<BoxedUnit> delete(SnapshotMetadata metadata) {
        DeleteItemRequest request = new DeleteItemRequest().withTableName(((DynamoDBSnapshotStore)this).journalSettings().Table()).addKeyEntry(package$.MODULE$.Key(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.S(this.messagePartitionKey(metadata.persistenceId()))).addKeyEntry(package$.MODULE$.SequenceNr(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(metadata.sequenceNr()));
        return ((DynamoDBSnapshotStore)this).dynamo().deleteItem(request).map(this.toUnit(), (ExecutionContext)((Actor)this).context().dispatcher());
    }

    public static /* synthetic */ Future delete$(DynamoDBSnapshotRequests $this, String persistenceId, SnapshotSelectionCriteria criteria) {
        return $this.delete(persistenceId, criteria);
    }

    default public Future<BoxedUnit> delete(String persistenceId, SnapshotSelectionCriteria criteria) {
        return this.loadQueryResult(persistenceId, criteria, (Option<Object>)None$.MODULE$).flatMap((Function1 & Serializable)queryResult -> {
            Seq result = (Seq)package.JavaConverters$.MODULE$.ListHasAsScala(queryResult.getItems()).asScala().toSeq().map((Function1 & Serializable)item -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((AttributeValue)item.get(package$.MODULE$.SequenceNr())).getN()))));
            return this.doBatch((Function1<Seq<WriteRequest>, String>)(Function1 & Serializable)batch -> new StringBuilder(21).append("execute batch delete ").append(batch).toString(), (Seq<WriteRequest>)((Seq)result.map((Function1 & Serializable)x$2 -> this.snapshotDeleteReq(persistenceId, BoxesRunTime.unboxToLong((Object)x$2))))).map(this.toUnit(), (ExecutionContext)((Actor)this).context().dispatcher());
        }, (ExecutionContext)((Actor)this).context().dispatcher());
    }

    private WriteRequest snapshotDeleteReq(String persistenceId, long sequenceNr) {
        WriteRequest writeRequest = new WriteRequest();
        DeleteRequest deleteRequest = new DeleteRequest();
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(package$.MODULE$.Key(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.S(this.messagePartitionKey(persistenceId)));
        item.put(package$.MODULE$.SequenceNr(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(sequenceNr));
        return writeRequest.withDeleteRequest(deleteRequest.withKey(item));
    }

    public static /* synthetic */ Future save$(DynamoDBSnapshotRequests $this, String persistenceId, long sequenceNr, long timestamp, Object snapshot) {
        return $this.save(persistenceId, sequenceNr, timestamp, snapshot);
    }

    default public Future<BoxedUnit> save(String persistenceId, long sequenceNr, long timestamp, Object snapshot) {
        return this.toSnapshotItem(persistenceId, sequenceNr, timestamp, snapshot).flatMap((Function1 & Serializable)snapshotItem -> ((DynamoDBSnapshotStore)this).dynamo().putItem(this.putItem((Map<String, AttributeValue>)snapshotItem)).map(this.toUnit(), (ExecutionContext)((Actor)this).context().dispatcher()), (ExecutionContext)((Actor)this).context().dispatcher());
    }

    public static /* synthetic */ Future load$(DynamoDBSnapshotRequests $this, String persistenceId, SnapshotSelectionCriteria criteria) {
        return $this.load(persistenceId, criteria);
    }

    default public Future<Option<SelectedSnapshot>> load(String persistenceId, SnapshotSelectionCriteria criteria) {
        return this.loadQueryResult(persistenceId, criteria, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1))).flatMap((Function1 & Serializable)result -> {
            Option option = package.JavaConverters$.MODULE$.ListHasAsScala(result.getItems()).asScala().headOption();
            if (option instanceof Some) {
                Map youngest = (Map)((Some)option).value();
                return this.fromSnapshotItem(persistenceId, youngest).map((Function1 & Serializable)x$3 -> new Some(x$3), (ExecutionContext)((Actor)this).context().dispatcher());
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)((Actor)this).context().dispatcher());
    }

    private Future<QueryResult> loadQueryResult(String persistenceId, SnapshotSelectionCriteria criteria, Option<Object> limit) {
        if (criteria != null) {
            long maxSequenceNr = criteria.maxSequenceNr();
            long maxTimestamp = criteria.maxTimestamp();
            long minSequenceNr = criteria.minSequenceNr();
            long minTimestamp = criteria.minTimestamp();
            if (minSequenceNr == 0L && maxSequenceNr == Long.MAX_VALUE) {
                return this.loadByTimestamp(persistenceId, minTimestamp, maxTimestamp, limit);
            }
        }
        if (criteria != null) {
            long maxSequenceNr = criteria.maxSequenceNr();
            long maxTimestamp = criteria.maxTimestamp();
            long minSequenceNr = criteria.minSequenceNr();
            if (criteria.minTimestamp() == 0L && maxTimestamp == Long.MAX_VALUE) {
                return this.loadBySeqNr(persistenceId, minSequenceNr, maxSequenceNr, limit);
            }
        }
        return this.loadByBoth(persistenceId, criteria, limit);
    }

    private Option<Object> loadQueryResult$default$3() {
        return None$.MODULE$;
    }

    private Future<QueryResult> loadByTimestamp(String persistenceId, long minTimestamp, long maxTimestamp, Option<Object> limit) {
        QueryRequest request = new QueryRequest().withTableName(((DynamoDBSnapshotStore)this).journalSettings().Table()).withIndexName(package$.MODULE$.TimestampIndex()).withKeyConditionExpression(new StringBuilder(58).append(" ").append(package$.MODULE$.Key()).append(" = :partitionKeyVal AND ").append(package$.MODULE$.Timestamp()).append(" BETWEEN :tsMinVal AND :tsMaxVal ").toString()).addExpressionAttributeValuesEntry(":partitionKeyVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.S(this.messagePartitionKey(persistenceId))).addExpressionAttributeValuesEntry(":tsMinVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(minTimestamp)).addExpressionAttributeValuesEntry(":tsMaxVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(maxTimestamp)).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(true));
        limit.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> request.setLimit(Predef$.MODULE$.int2Integer(x$4)));
        request.setSelect(Select.ALL_ATTRIBUTES);
        return ((DynamoDBSnapshotStore)this).dynamo().query(request);
    }

    private Future<QueryResult> loadBySeqNr(String persistenceId, long minSequenceNr, long maxSequenceNr, Option<Object> limit) {
        QueryRequest request = new QueryRequest().withTableName(((DynamoDBSnapshotStore)this).journalSettings().Table()).withKeyConditionExpression(new StringBuilder(59).append(" ").append(package$.MODULE$.Key()).append(" = :partitionKeyVal AND ").append(package$.MODULE$.SequenceNr()).append(" BETWEEN :seqMinVal AND :seqMaxVal").toString()).addExpressionAttributeValuesEntry(":partitionKeyVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.S(this.messagePartitionKey(persistenceId))).addExpressionAttributeValuesEntry(":seqMinVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(minSequenceNr)).addExpressionAttributeValuesEntry(":seqMaxVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(maxSequenceNr)).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withConsistentRead(Predef$.MODULE$.boolean2Boolean(true));
        limit.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> request.setLimit(Predef$.MODULE$.int2Integer(x$5)));
        return ((DynamoDBSnapshotStore)this).dynamo().query(request);
    }

    private Future<QueryResult> loadByBoth(String persistenceId, SnapshotSelectionCriteria criteria, Option<Object> limit) {
        QueryRequest request = new QueryRequest().withTableName(((DynamoDBSnapshotStore)this).journalSettings().Table()).withKeyConditionExpression(new StringBuilder(59).append(" ").append(package$.MODULE$.Key()).append(" = :partitionKeyVal AND ").append(package$.MODULE$.SequenceNr()).append(" BETWEEN :seqMinVal AND :seqMaxVal").toString()).addExpressionAttributeValuesEntry(":partitionKeyVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.S(this.messagePartitionKey(persistenceId))).addExpressionAttributeValuesEntry(":seqMinVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(criteria.minSequenceNr())).addExpressionAttributeValuesEntry(":seqMaxVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(criteria.maxSequenceNr())).withScanIndexForward(Predef$.MODULE$.boolean2Boolean(false)).withFilterExpression(new StringBuilder(33).append(package$.MODULE$.Timestamp()).append(" BETWEEN :tsMinVal AND :tsMaxVal ").toString()).addExpressionAttributeValuesEntry(":tsMinVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(criteria.minTimestamp())).addExpressionAttributeValuesEntry(":tsMaxVal", org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(criteria.maxTimestamp())).withConsistentRead(Predef$.MODULE$.boolean2Boolean(true));
        limit.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> request.setLimit(Predef$.MODULE$.int2Integer(x$6)));
        return ((DynamoDBSnapshotStore)this).dynamo().query(request);
    }

    private Future<Map<String, AttributeValue>> toSnapshotItem(String persistenceId, long sequenceNr, long timestamp, Object snapshot) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        String partitionKey = this.messagePartitionKey(persistenceId);
        item.put(package$.MODULE$.Key(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.S(partitionKey));
        item.put(package$.MODULE$.SequenceNr(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(sequenceNr));
        item.put(package$.MODULE$.Timestamp(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(timestamp));
        Serializer serializer = ((DynamoDBSnapshotStore)this).serialization().findSerializerFor(snapshot);
        String manifest = Serializers$.MODULE$.manifestFor(serializer, snapshot);
        return (serializer instanceof AsyncSerializer ? (Future)Serialization$.MODULE$.withTransportInformation((ExtendedActorSystem)((Actor)this).context().system(), (Function0 & Serializable)() -> ((AsyncSerializer)serializer).toBinaryAsync(snapshot)) : Future$.MODULE$.apply((Function0 & Serializable)() -> (byte[])((DynamoDBSnapshotStore)this).serialization().serialize(snapshot).get(), (ExecutionContext)((Actor)this).context().dispatcher())).map((Function1 & Serializable)data -> {
            int size = this.itemSize(partitionKey, (byte[])data);
            if (size > ((DynamoDBSnapshotStore)this).journalSettings().MaxItemSize()) {
                throw new DynamoDBSnapshotRejection(new StringBuilder(25).append("MaxItemSize exceeded: ").append(size).append(" > ").append(((DynamoDBSnapshotStore)this).journalSettings().MaxItemSize()).toString(), null);
            }
            item.put(package$.MODULE$.PayloadData(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.B((byte[])data));
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(manifest))) {
                item.put(package$.MODULE$.SerializerManifest(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.S(manifest));
            }
            item.put(package$.MODULE$.SerializerId(), org.apache.pekko.persistence.dynamodb.package$.MODULE$.N(serializer.identifier()));
            return item;
        }, (ExecutionContext)((Actor)this).context().dispatcher());
    }

    private Future<SelectedSnapshot> fromSnapshotItem(String persistenceId, Map<String, AttributeValue> item) {
        long seqNr = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(item.get(package$.MODULE$.SequenceNr()).getN()));
        long timestamp = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(item.get(package$.MODULE$.Timestamp()).getN()));
        if (item.containsKey(package$.MODULE$.PayloadData())) {
            ByteBuffer payloadData = item.get(package$.MODULE$.PayloadData()).getB();
            int serId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(item.get(package$.MODULE$.SerializerId()).getN()));
            String manifest = item.containsKey(package$.MODULE$.SerializerManifest()) ? item.get(package$.MODULE$.SerializerManifest()).getS() : "";
            Serializer serializer = (Serializer)((DynamoDBSnapshotStore)this).serialization().serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)serId));
            return (serializer instanceof AsyncSerializer ? (Future)Serialization$.MODULE$.withTransportInformation((ExtendedActorSystem)((Actor)this).context().system(), (Function0 & Serializable)() -> ((AsyncSerializer)serializer).fromBinaryAsync(payloadData.array(), manifest)) : Future$.MODULE$.successful(((DynamoDBSnapshotStore)this).serialization().deserialize(payloadData.array(), serId, manifest).get())).map((Function1 & Serializable)data -> new SelectedSnapshot(SnapshotMetadata$.MODULE$.apply(persistenceId, seqNr, timestamp), data), (ExecutionContext)((Actor)this).context().dispatcher());
        }
        ByteBuffer payloadValue = item.get(package$.MODULE$.Payload()).getB();
        return Future$.MODULE$.successful((Object)new SelectedSnapshot(SnapshotMetadata$.MODULE$.apply(persistenceId, seqNr, timestamp), ((Snapshot)((DynamoDBSnapshotStore)this).serialization().deserialize(payloadValue.array(), Snapshot.class).get()).data()));
    }

    private String messagePartitionKey(String persistenceId) {
        return new StringBuilder(3).append(((DynamoDBSnapshotStore)this).journalSettings().JournalName()).append("-P-").append(persistenceId).toString();
    }

    public static /* synthetic */ void $anonfun$toUnit$1(Object x$1) {
    }

    public static void $init$(DynamoDBSnapshotRequests $this) {
        $this.org$apache$pekko$persistence$dynamodb$snapshot$DynamoDBSnapshotRequests$_setter_$toUnit_$eq((Function1<Object, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            DynamoDBSnapshotRequests.$anonfun$toUnit$1(x$1);
            return BoxedUnit.UNIT;
        });
    }
}

