/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.jdbc.snapshot.dao;

import java.io.Serializable;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotMetadata$;
import org.apache.pekko.persistence.jdbc.PekkoSerialization$;
import org.apache.pekko.persistence.jdbc.config.SnapshotConfig;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotDao;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotQueries;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotTables;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.stream.Materializer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Success;
import scala.util.Try;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.RunnableCompiled;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\r\u001a\u0001!B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!y\u0005A!A!\u0002\u0017\u0001\u0006\u0002\u0003,\u0001\u0005\u000b\u0007I1A,\t\u0011y\u0003!\u0011!Q\u0001\naCQa\u0018\u0001\u0005\u0002\u0001Dq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001b\u0005\u0006_\u0002!I\u0001\u001d\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t)\u000b\u0001C!\u0003OCq!a+\u0001\t\u0003\ni\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\n\u0011B)\u001a4bk2$8K\\1qg\"|G\u000fR1p\u0015\tQ2$A\u0002eC>T!\u0001H\u000f\u0002\u0011Mt\u0017\r]:i_RT!AH\u0010\u0002\t)$'m\u0019\u0006\u0003A\u0005\n1\u0002]3sg&\u001cH/\u001a8dK*\u0011!eI\u0001\u0006a\u0016\\7n\u001c\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aEj\u0011!G\u0005\u0003ee\u00111b\u00158baNDw\u000e\u001e#b_\u0006\u0011AM\u0019\t\u0003kq\u0002\"A\u000e\u001e\u000e\u0003]R!A\b\u001d\u000b\u0003e\nQa\u001d7jG.L!aO\u001c\u0003\u0017)#'m\u0019\"bG.,g\u000eZ\u0005\u0003{i\u00121\u0002R1uC\n\f7/\u001a#fM\u00069\u0001O]8gS2,\u0007C\u0001\u001cA\u0013\t\tuGA\u0006KI\n\u001c\u0007K]8gS2,\u0017AD:oCB\u001c\bn\u001c;D_:4\u0017n\u001a\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rv\taaY8oM&<\u0017B\u0001%F\u00059\u0019f.\u00199tQ>$8i\u001c8gS\u001e\fQb]3sS\u0006d\u0017N_1uS>t\u0007CA&N\u001b\u0005a%BA%\"\u0013\tqEJA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\u0003K\u000e\u0004\"!\u0015+\u000e\u0003IS!aU\u0016\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002V%\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004[\u0006$X#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m\u000b\u0013AB:ue\u0016\fW.\u0003\u0002^5\naQ*\u0019;fe&\fG.\u001b>fe\u0006!Q.\u0019;!\u0003\u0019a\u0014N\\5u}Q)\u0011-\u001a4hQR\u0019!m\u00193\u0011\u0005A\u0002\u0001\"B(\t\u0001\b\u0001\u0006\"\u0002,\t\u0001\bA\u0006\"B\u001a\t\u0001\u0004!\u0004\"\u0002 \t\u0001\u0004y\u0004\"\u0002\"\t\u0001\u0004\u0019\u0005\"B%\t\u0001\u0004Q\u0015aB9vKJLWm]\u000b\u0002WB\u0011\u0001\u0007\\\u0005\u0003[f\u0011qb\u00158baNDw\u000e^)vKJLWm]\u0001\tcV,'/[3tA\u0005qAo\\*oCB\u001c\bn\u001c;ECR\fGcA9\u0002\u0004A\u0019!/^<\u000e\u0003MT!\u0001^\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003mN\u00141\u0001\u0016:z!\u0011Q\u0003P\u001f@\n\u0005e\\#A\u0002+va2,'\u0007\u0005\u0002|y6\tq$\u0003\u0002~?\t\u00012K\\1qg\"|G/T3uC\u0012\fG/\u0019\t\u0003U}L1!!\u0001,\u0005\r\te.\u001f\u0005\b\u0003\u000bY\u0001\u0019AA\u0004\u0003\r\u0011xn\u001e\t\u0005\u0003\u0013\tyAD\u00021\u0003\u0017I1!!\u0004\u001a\u00039\u0019f.\u00199tQ>$H+\u00192mKNLA!!\u0005\u0002\u0014\tY1K\\1qg\"|GOU8x\u0015\r\ti!G\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016\u001cf.\u00199tQ>$HCBA\r\u00037\ty\u0002\u0005\u0003sk\u0006\u001d\u0001BBA\u000f\u0019\u0001\u0007!0\u0001\u0003nKR\f\u0007\"\u0002\u000f\r\u0001\u0004q\u0018!\u0005>fe>|%o\u00148f':\f\u0007o\u001d5piR!\u0011QEA\u0016!\u0011Q\u0013qE<\n\u0007\u0005%2F\u0001\u0004PaRLwN\u001c\u0005\b\u0003[i\u0001\u0019AA\u0018\u0003\u0011\u0011xn^:\u0011\r\u0005E\u0012\u0011IA\u0004\u001d\u0011\t\u0019$!\u0010\u000f\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f(\u0003\u0019a$o\\8u}%\tA&C\u0002\u0002@-\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002D\u0005\u0015#aA*fc*\u0019\u0011qH\u0016\u0002\u001d1\fG/Z:u':\f\u0007o\u001d5piR!\u00111JA)!\u0015\t\u0016QJA\u0013\u0013\r\tyE\u0015\u0002\u0007\rV$XO]3\t\u000f\u0005Mc\u00021\u0001\u0002V\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u0004B!a\u0016\u0002`9!\u0011\u0011LA.!\r\t)dK\u0005\u0004\u0003;Z\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002b\u0005\r$AB*ue&twMC\u0002\u0002^-\nqc\u001d8baNDw\u000e\u001e$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005-\u0013\u0011NA6\u0011\u001d\t\u0019f\u0004a\u0001\u0003+Bq!!\u001c\u0010\u0001\u0004\ty'\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007\u000fE\u0002+\u0003cJ1!a\u001d,\u0005\u0011auN\\4\u00021Mt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%\u000f\u0006\u0004\u0002L\u0005e\u00141\u0010\u0005\b\u0003'\u0002\u0002\u0019AA+\u0011\u001d\ti\b\u0005a\u0001\u0003_\nQ\"\\1y'\u0016\fX/\u001a8dK:\u0013\u0018aJ:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"a\u0013\u0002\u0004\u0006\u0015\u0015q\u0011\u0005\b\u0003'\n\u0002\u0019AA+\u0011\u001d\ti(\u0005a\u0001\u0003_Bq!!\u001c\u0012\u0001\u0004\ty'\u0001\u0003tCZ,GCBAG\u0003+\u000bI\nE\u0003R\u0003\u001b\ny\tE\u0002+\u0003#K1!a%,\u0005\u0011)f.\u001b;\t\r\u0005]%\u00031\u0001{\u0003A\u0019h.\u00199tQ>$X*\u001a;bI\u0006$\u0018\rC\u0003\u001d%\u0001\u0007a0\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003\u001b\u000by*!)\t\u000f\u0005M3\u00031\u0001\u0002V!9\u00111U\nA\u0002\u0005=\u0014AC:fcV,gnY3Oe\u0006\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\ti)!+\t\u000f\u0005MC\u00031\u0001\u0002V\u00059B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003\u001b\u000by+!-\t\u000f\u0005MS\u00031\u0001\u0002V!9\u0011QP\u000bA\u0002\u0005=\u0014A\u00063fY\u0016$X-\u00169U_6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u00055\u0015qWA]\u0011\u001d\t\u0019F\u0006a\u0001\u0003+Bq!!\u001c\u0017\u0001\u0004\ty'\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"!$\u0002@\u0006\u0005\u00171\u0019\u0005\b\u0003':\u0002\u0019AA+\u0011\u001d\tih\u0006a\u0001\u0003_Bq!!\u001c\u0018\u0001\u0004\ty\u0007")
public class DefaultSnapshotDao
implements SnapshotDao {
    private final JdbcBackend.DatabaseDef db;
    private final JdbcProfile profile;
    private final Serialization serialization;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final SnapshotQueries queries;

    public Materializer mat() {
        return this.mat;
    }

    public SnapshotQueries queries() {
        return this.queries;
    }

    private Try<Tuple2<SnapshotMetadata, Object>> toSnapshotData(SnapshotTables.SnapshotRow row) {
        Try snapshot2 = this.serialization.deserialize(row.snapshotPayload(), row.snapshotSerId(), row.snapshotSerManifest());
        return snapshot2.flatMap((Function1 & Serializable)snapshot -> {
            Some some;
            Tuple2 tuple2;
            Option metadata = row.metaPayload().flatMap((Function1 & Serializable)mPayload -> row.metaSerId().map((Function1 & Serializable)mSerId -> DefaultSnapshotDao.$anonfun$toSnapshotData$3(mPayload, BoxesRunTime.unboxToInt((Object)mSerId))));
            Option option = metadata;
            if (None$.MODULE$.equals(option)) {
                return new Success((Object)new Tuple2((Object)SnapshotMetadata$.MODULE$.apply(row.persistenceId(), row.sequenceNumber(), row.created()), snapshot));
            }
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                byte[] payload = (byte[])tuple2._1();
                int id = tuple2._2$mcI$sp();
                return $this.serialization.deserialize(payload, id, (String)row.metaSerManifest().getOrElse((Function0 & Serializable)() -> "")).map((Function1 & Serializable)meta -> new Tuple2((Object)SnapshotMetadata$.MODULE$.apply(row.persistenceId(), row.sequenceNumber(), row.created(), (Option)new Some(meta)), snapshot));
            }
            throw new MatchError((Object)option);
        });
    }

    private Try<SnapshotTables.SnapshotRow> serializeSnapshot(SnapshotMetadata meta, Object snapshot) {
        Option serializedMetadata = meta.metadata().flatMap((Function1 & Serializable)m -> PekkoSerialization$.MODULE$.serialize($this.serialization, m).toOption());
        return PekkoSerialization$.MODULE$.serialize(this.serialization, snapshot).map((Function1 & Serializable)serializedSnapshot -> new SnapshotTables.SnapshotRow(meta.persistenceId(), meta.sequenceNr(), meta.timestamp(), serializedSnapshot.serId(), serializedSnapshot.serManifest(), serializedSnapshot.payload(), (Option<Object>)serializedMetadata.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.serId())), (Option<String>)serializedMetadata.map((Function1 & Serializable)x$2 -> x$2.serManifest()), (Option<byte[]>)serializedMetadata.map((Function1 & Serializable)x$3 -> x$3.payload())));
    }

    private Option<Tuple2<SnapshotMetadata, Object>> zeroOrOneSnapshot(Seq<SnapshotTables.SnapshotRow> rows) {
        return rows.headOption().map((Function1 & Serializable)row -> (Tuple2)this.toSnapshotData((SnapshotTables.SnapshotRow)row).get());
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> latestSnapshot(String persistenceId) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectLatestByPersistenceId().apply((Object)persistenceId))).result()).flatMap((Function1 & Serializable)rows -> {
            Option option = rows.headOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                SnapshotTables.SnapshotRow row = (SnapshotTables.SnapshotRow)some.value();
                return Future$.MODULE$.fromTry(this.toSnapshotData(row)).map((Function1 & Serializable)x$4 -> Option$.MODULE$.apply(x$4), $this.ec);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)rows), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))))).result()).map((Function1 & Serializable)rows -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)rows), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)x$5 -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)x$5), this.ec);
    }

    @Override
    public Future<BoxedUnit> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        Future eventualSnapshotRow = Future$.MODULE$.fromTry(this.serializeSnapshot(snapshotMetadata, snapshot));
        return eventualSnapshotRow.map((Function1 & Serializable)snapshotRow -> this.queries().insertOrUpdate((SnapshotTables.SnapshotRow)snapshotRow), this.ec).flatMap((Function1 & Serializable)a -> $this.db.run(a), this.ec).map((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> delete(String persistenceId, long sequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdAndSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteAllSnapshots(String persistenceId) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectAll().apply((Object)persistenceId)).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    public static final /* synthetic */ Tuple2 $anonfun$toSnapshotData$3(byte[] mPayload$1, int mSerId) {
        return new Tuple2((Object)mPayload$1, (Object)BoxesRunTime.boxToInteger((int)mSerId));
    }

    public DefaultSnapshotDao(JdbcBackend.DatabaseDef db, JdbcProfile profile, SnapshotConfig snapshotConfig, Serialization serialization, ExecutionContext ec, Materializer mat) {
        this.db = db;
        this.profile = profile;
        this.serialization = serialization;
        this.ec = ec;
        this.mat = mat;
        this.queries = new SnapshotQueries(profile, snapshotConfig.snapshotTableConfiguration());
    }
}

