/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.query.journal.leveldb.scaladsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URLEncoder;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.persistence.query.EventEnvelope;
import org.apache.pekko.persistence.query.NoOffset$;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.Sequence;
import org.apache.pekko.persistence.query.Sequence$;
import org.apache.pekko.persistence.query.journal.leveldb.AllPersistenceIdsStage;
import org.apache.pekko.persistence.query.journal.leveldb.EventsByPersistenceIdStage;
import org.apache.pekko.persistence.query.journal.leveldb.EventsByTagStage;
import org.apache.pekko.persistence.query.journal.leveldb.scaladsl.LeveldbReadJournal$;
import org.apache.pekko.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import org.apache.pekko.persistence.query.scaladsl.CurrentEventsByTagQuery;
import org.apache.pekko.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import org.apache.pekko.persistence.query.scaladsl.EventsByPersistenceIdQuery;
import org.apache.pekko.persistence.query.scaladsl.EventsByTagQuery;
import org.apache.pekko.persistence.query.scaladsl.PersistenceIdsQuery;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public class LeveldbReadJournal
implements PersistenceIdsQuery,
CurrentPersistenceIdsQuery,
EventsByPersistenceIdQuery,
CurrentEventsByPersistenceIdQuery,
EventsByTagQuery,
CurrentEventsByTagQuery {
    private final Some<FiniteDuration> refreshInterval;
    private final String writeJournalPluginId;
    private final int maxBufSize;
    private final String resolvedWriteJournalPluginId;

    public static String Identifier() {
        return LeveldbReadJournal$.MODULE$.Identifier();
    }

    /*
     * Unable to fully structure code
     */
    public LeveldbReadJournal(ExtendedActorSystem system, Config config) {
        super();
        this.refreshInterval = Some$.MODULE$.apply((Object)new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("refresh-interval", package$.MODULE$.MILLISECONDS()))).millis());
        this.writeJournalPluginId = config.getString("write-plugin");
        this.maxBufSize = config.getInt("max-buffer-size");
        v0 = this.resolvedWriteJournalPluginId = this.writeJournalPluginId.isEmpty() != false ? system.settings().config().getString("pekko.persistence.journal.plugin") : this.writeJournalPluginId;
        if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.resolvedWriteJournalPluginId))) ** GOTO lbl-1000
        v1 = system.settings().config().getConfig(this.resolvedWriteJournalPluginId).getString("class");
        var3_3 = "org.apache.pekko.persistence.journal.leveldb.LeveldbJournal";
        if (!(v1 != null ? v1.equals(var3_3) == false : var3_3 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Predef$.MODULE$.require(v2, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$1(), ()Ljava/lang/Object;)((LeveldbReadJournal)this));
    }

    @Override
    public Source<String, NotUsed> persistenceIds() {
        return Source$.MODULE$.fromMaterializer((Function2 & Serializable)(mat, _$1) -> Source$.MODULE$.fromGraph((Graph)new AllPersistenceIdsStage(true, this.writeJournalPluginId, (Materializer)mat)).named("allPersistenceIds")).mapMaterializedValue((Function1 & Serializable)_$2 -> NotUsed$.MODULE$);
    }

    @Override
    public Source<String, NotUsed> currentPersistenceIds() {
        return Source$.MODULE$.fromMaterializer((Function2 & Serializable)(mat, _$3) -> Source$.MODULE$.fromGraph((Graph)new AllPersistenceIdsStage(false, this.writeJournalPluginId, (Materializer)mat)).named("allPersistenceIds")).mapMaterializedValue((Function1 & Serializable)_$4 -> NotUsed$.MODULE$);
    }

    @Override
    public Source<EventEnvelope, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return Source$.MODULE$.fromMaterializer((Function2 & Serializable)(mat, _$5) -> Source$.MODULE$.fromGraph((Graph)new EventsByPersistenceIdStage(persistenceId, fromSequenceNr, toSequenceNr, this.maxBufSize, this.writeJournalPluginId, (Option<FiniteDuration>)this.refreshInterval, (Materializer)mat)).named(new StringBuilder(22).append("eventsByPersistenceId-").append(persistenceId).toString())).mapMaterializedValue((Function1 & Serializable)_$6 -> NotUsed$.MODULE$);
    }

    public long eventsByPersistenceId$default$2() {
        return 0L;
    }

    public long eventsByPersistenceId$default$3() {
        return Long.MAX_VALUE;
    }

    @Override
    public Source<EventEnvelope, NotUsed> currentEventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return Source$.MODULE$.fromMaterializer((Function2 & Serializable)(mat, _$7) -> Source$.MODULE$.fromGraph((Graph)new EventsByPersistenceIdStage(persistenceId, fromSequenceNr, toSequenceNr, this.maxBufSize, this.writeJournalPluginId, (Option<FiniteDuration>)None$.MODULE$, (Materializer)mat)).named(new StringBuilder(29).append("currentEventsByPersistenceId-").append(persistenceId).toString())).mapMaterializedValue((Function1 & Serializable)_$8 -> NotUsed$.MODULE$);
    }

    public long currentEventsByPersistenceId$default$2() {
        return 0L;
    }

    public long currentEventsByPersistenceId$default$3() {
        return Long.MAX_VALUE;
    }

    @Override
    public Source<EventEnvelope, NotUsed> eventsByTag(String tag, Offset offset) {
        return Source$.MODULE$.fromMaterializer((Function2 & Serializable)(mat, _$9) -> {
            Offset offset = offset;
            if (offset instanceof Sequence) {
                Sequence seq = (Sequence)offset;
                return Source$.MODULE$.fromGraph((Graph)new EventsByTagStage(tag, seq.value(), this.maxBufSize, Long.MAX_VALUE, this.writeJournalPluginId, (Option<FiniteDuration>)this.refreshInterval, (Materializer)mat)).named(new StringBuilder(12).append("eventsByTag-").append(URLEncoder.encode(tag, ByteString$.MODULE$.UTF_8())).toString());
            }
            if (NoOffset$.MODULE$.equals(offset)) {
                return this.eventsByTag(tag, Sequence$.MODULE$.apply(0L));
            }
            throw new IllegalArgumentException(new StringBuilder(33).append("LevelDB does not support ").append(Logging$.MODULE$.simpleName(offset.getClass())).append(" offsets").toString());
        }).mapMaterializedValue((Function1 & Serializable)_$10 -> NotUsed$.MODULE$);
    }

    public Offset eventsByTag$default$2() {
        return Sequence$.MODULE$.apply(0L);
    }

    @Override
    public Source<EventEnvelope, NotUsed> currentEventsByTag(String tag, Offset offset) {
        return Source$.MODULE$.fromMaterializer((Function2 & Serializable)(mat, _$11) -> {
            Offset offset = offset;
            if (offset instanceof Sequence) {
                Sequence seq = (Sequence)offset;
                return Source$.MODULE$.fromGraph((Graph)new EventsByTagStage(tag, seq.value(), this.maxBufSize, Long.MAX_VALUE, this.writeJournalPluginId, (Option<FiniteDuration>)None$.MODULE$, (Materializer)mat)).named(new StringBuilder(19).append("currentEventsByTag-").append(URLEncoder.encode(tag, ByteString$.MODULE$.UTF_8())).toString());
            }
            if (NoOffset$.MODULE$.equals(offset)) {
                return this.currentEventsByTag(tag, Sequence$.MODULE$.apply(0L));
            }
            throw new IllegalArgumentException(new StringBuilder(33).append("LevelDB does not support ").append(Logging$.MODULE$.simpleName(offset.getClass())).append(" offsets").toString());
        }).mapMaterializedValue((Function1 & Serializable)_$12 -> NotUsed$.MODULE$);
    }

    public Offset currentEventsByTag$default$2() {
        return Sequence$.MODULE$.apply(0L);
    }

    private final Object $init$$$anonfun$1() {
        return new StringBuilder(106).append("Leveldb read journal can only work with a Leveldb write journal. Current plugin [").append(this.resolvedWriteJournalPluginId).append("] is not a LeveldbJournal").toString();
    }
}

