/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.query.typed;

import java.io.Serializable;
import java.util.Optional;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.typed.EventEnvelope$;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;

@ApiMayChange
public final class EventEnvelope<Event> {
    private final Offset offset;
    private final String persistenceId;
    private final long sequenceNr;
    private final Option eventOption;
    private final long timestamp;
    private final Option eventMetadata;
    private final String entityType;
    private final int slice;

    public static <Event> EventEnvelope<Event> apply(Offset offset, String string, long l, Event Event, long l2, String string2, int n) {
        return EventEnvelope$.MODULE$.apply(offset, string, l, Event, l2, string2, n);
    }

    public static <Event> EventEnvelope<Event> create(Offset offset, String string, long l, Event Event, long l2, String string2, int n) {
        return EventEnvelope$.MODULE$.create(offset, string, l, Event, l2, string2, n);
    }

    public static <Event> Option<Tuple5<Offset, String, Object, Option<Event>, Object>> unapply(EventEnvelope<Event> eventEnvelope) {
        return EventEnvelope$.MODULE$.unapply(eventEnvelope);
    }

    public EventEnvelope(Offset offset, String persistenceId, long sequenceNr, Option<Event> eventOption, long timestamp, Option<Object> eventMetadata, String entityType, int slice) {
        this.offset = offset;
        this.persistenceId = persistenceId;
        this.sequenceNr = sequenceNr;
        this.eventOption = eventOption;
        this.timestamp = timestamp;
        this.eventMetadata = eventMetadata;
        this.entityType = entityType;
        this.slice = slice;
    }

    public Offset offset() {
        return this.offset;
    }

    public String persistenceId() {
        return this.persistenceId;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public Option<Event> eventOption() {
        return this.eventOption;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Option<Object> eventMetadata() {
        return this.eventMetadata;
    }

    public String entityType() {
        return this.entityType;
    }

    public int slice() {
        return this.slice;
    }

    public Event event() {
        Option<Event> option = this.eventOption();
        if (option instanceof Some) {
            Object evt = ((Some)option).value();
            return (Event)evt;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Event was not loaded. Use eventOption and load the event on demand with LoadEventQuery.");
        }
        throw new MatchError(option);
    }

    public Event getEvent() {
        Option<Event> option = this.eventOption();
        if (option instanceof Some) {
            Object evt = ((Some)option).value();
            return (Event)evt;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Event was not loaded. Use getOptionalEvent and load the event on demand with LoadEventQuery.");
        }
        throw new MatchError(option);
    }

    public Optional<Event> getOptionalEvent() {
        Option option = OptionConverters$.MODULE$.RichOption(this.eventOption());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    public Optional<Object> getEventMetaData() {
        Option option = OptionConverters$.MODULE$.RichOption(this.eventMetadata().map((Function1 & Serializable)_$1 -> _$1));
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, (Object)this.offset());
        result = HashCode$.MODULE$.hash(result, (Object)this.persistenceId());
        result = HashCode$.MODULE$.hash(result, this.sequenceNr());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof EventEnvelope)) return false;
        EventEnvelope other = (EventEnvelope)object;
        Offset offset = this.offset();
        Offset offset2 = other.offset();
        if (offset == null) {
            if (offset2 != null) {
                return false;
            }
        } else if (!offset.equals(offset2)) return false;
        String string = this.persistenceId();
        String string2 = other.persistenceId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.sequenceNr() != other.sequenceNr()) return false;
        Option<Event> option = this.eventOption();
        Option<Event> option2 = other.eventOption();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.timestamp() != other.timestamp()) return false;
        Option<Object> option3 = this.eventMetadata();
        Option<Object> option4 = other.eventMetadata();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        String string3 = this.entityType();
        String string4 = other.entityType();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.slice() != other.slice()) return false;
        return true;
    }

    public String toString() {
        return new StringBuilder(22).append("EventEnvelope(").append(this.offset()).append(",").append(this.persistenceId()).append(",").append(this.sequenceNr()).append(",").append(this.eventOption()).append(",").append(this.timestamp()).append(",").append(this.eventMetadata()).append(",").append(this.entityType()).append(",").append(this.slice()).append(")").toString();
    }
}

