/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.query;

import java.io.Serializable;
import java.util.Optional;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.query.EventEnvelope$;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product4;
import scala.Some$;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;

public final class EventEnvelope
implements Product4<Offset, String, Object, Object>,
Serializable {
    private final Offset offset;
    private final String persistenceId;
    private final long sequenceNr;
    private final Object event;
    private final long timestamp;
    private final Option eventMetadata;

    public static EventEnvelope apply(Offset offset, String string, long l, Object object) {
        return EventEnvelope$.MODULE$.apply(offset, string, l, object);
    }

    public static EventEnvelope apply(Offset offset, String string, long l, Object object, long l2) {
        return EventEnvelope$.MODULE$.apply(offset, string, l, object, l2);
    }

    public static EventEnvelope apply(Offset offset, String string, long l, Object object, long l2, Option<Object> option) {
        return EventEnvelope$.MODULE$.apply(offset, string, l, object, l2, option);
    }

    public static Function1<Offset, Function1<String, Function1<Object, Function1<Object, EventEnvelope>>>> curried() {
        return EventEnvelope$.MODULE$.curried();
    }

    public static Function1<Tuple4<Offset, String, Object, Object>, EventEnvelope> tupled() {
        return EventEnvelope$.MODULE$.tupled();
    }

    public static Option<Tuple4<Offset, String, Object, Object>> unapply(EventEnvelope eventEnvelope) {
        return EventEnvelope$.MODULE$.unapply(eventEnvelope);
    }

    public EventEnvelope(Offset offset, String persistenceId, long sequenceNr, Object event, long timestamp, Option<Object> eventMetadata) {
        this.offset = offset;
        this.persistenceId = persistenceId;
        this.sequenceNr = sequenceNr;
        this.event = event;
        this.timestamp = timestamp;
        this.eventMetadata = eventMetadata;
        Product4.$init$((Product4)this);
    }

    public Offset offset() {
        return this.offset;
    }

    public String persistenceId() {
        return this.persistenceId;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public Object event() {
        return this.event;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Option<Object> eventMetadata() {
        return this.eventMetadata;
    }

    public EventEnvelope(Offset offset, String persistenceId, long sequenceNr, Object event) {
        this(offset, persistenceId, sequenceNr, event, 0L, (Option<Object>)None$.MODULE$);
    }

    public EventEnvelope(Offset offset, String persistenceId, long sequenceNr, Object event, long timestamp) {
        this(offset, persistenceId, sequenceNr, event, timestamp, (Option<Object>)None$.MODULE$);
    }

    public Optional<Object> getEventMetaData() {
        Option option = OptionConverters$.MODULE$.RichOption(this.eventMetadata());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, (Object)this.offset());
        result = HashCode$.MODULE$.hash(result, (Object)this.persistenceId());
        result = HashCode$.MODULE$.hash(result, this.sequenceNr());
        result = HashCode$.MODULE$.hash(result, this.event());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof EventEnvelope)) return false;
        EventEnvelope other = (EventEnvelope)object;
        Offset offset = this.offset();
        Offset offset2 = other.offset();
        if (offset == null) {
            if (offset2 != null) {
                return false;
            }
        } else if (!offset.equals(offset2)) return false;
        String string = this.persistenceId();
        String string2 = other.persistenceId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.sequenceNr() != other.sequenceNr()) return false;
        if (!BoxesRunTime.equals((Object)this.event(), (Object)other.event())) return false;
        return true;
    }

    public String toString() {
        return new StringBuilder(20).append("EventEnvelope(").append(this.offset()).append(",").append(this.persistenceId()).append(",").append(this.sequenceNr()).append(",").append(this.event()).append(",").append(this.timestamp()).append(",").append(this.eventMetadata()).append(")").toString();
    }

    public EventEnvelope copy(Offset offset, String persistenceId, long sequenceNr, Object event) {
        return new EventEnvelope(offset, persistenceId, sequenceNr, event, this.timestamp(), this.eventMetadata());
    }

    public Offset copy$default$1() {
        return this.offset();
    }

    public String copy$default$2() {
        return this.persistenceId();
    }

    public long copy$default$3() {
        return this.sequenceNr();
    }

    public Object copy$default$4() {
        return this.event();
    }

    @InternalApi
    public EventEnvelope withMetadata(Object metadata) {
        return new EventEnvelope(this.offset(), this.persistenceId(), this.sequenceNr(), this.event(), this.timestamp(), (Option<Object>)Some$.MODULE$.apply(metadata));
    }

    public String productPrefix() {
        return "EventEnvelope";
    }

    public Offset _1() {
        return this.offset();
    }

    public String _2() {
        return this.persistenceId();
    }

    public long _3() {
        return this.sequenceNr();
    }

    public Object _4() {
        return this.event();
    }

    public boolean canEqual(Object that) {
        return that instanceof EventEnvelope;
    }
}

