/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.query.internal;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.query.NoOffset$;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.Offset$;
import org.apache.pekko.persistence.query.Sequence;
import org.apache.pekko.persistence.query.TimeBasedUUID;
import org.apache.pekko.persistence.query.TimestampOffset;
import org.apache.pekko.persistence.query.TimestampOffset$;
import org.apache.pekko.persistence.query.internal.protobuf.QueryMessages;
import org.apache.pekko.persistence.query.typed.EventEnvelope;
import org.apache.pekko.remote.serialization.WrappedPayloadSupport$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.Serializers$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@InternalApi
public final class QuerySerializer
extends SerializerWithStringManifest
implements BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(QuerySerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private volatile Object serialization$lzy1;
    private final char manifestSeparator;
    private final char timestampOffsetSeparator;

    public QuerySerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, QuerySerializer.class, LogSource$.MODULE$.fromAnyClass());
        String EventEnvelopeManifest = "a";
        String SequenceOffsetManifest = "SEQ";
        String TimeBasedUUIDOffsetManifest = "TBU";
        String TimestampOffsetManifest = "TSO";
        String NoOffsetManifest = "NO";
        this.manifestSeparator = (char)58;
        this.timestampOffsetSeparator = (char)59;
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String manifest(Object o) {
        Object object = o;
        if (object instanceof EventEnvelope) {
            return "a";
        }
        if (object instanceof Offset) {
            Offset offset = (Offset)object;
            return (String)this.toStorageRepresentation(offset)._2();
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Can't serialize object of type ").append(o.getClass()).append(" in [").append(this.getClass().getName()).append("]").toString());
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof EventEnvelope) {
            EventEnvelope env = (EventEnvelope)object;
            QueryMessages.EventEnvelope.Builder builder = QueryMessages.EventEnvelope.newBuilder();
            Tuple2<String, String> tuple2 = this.toStorageRepresentation(env.offset());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String offset = (String)tuple2._1();
            String offsetManifest = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)offset, (Object)offsetManifest);
            String offset2 = (String)tuple22._1();
            String offsetManifest2 = (String)tuple22._2();
            builder.setPersistenceId(env.persistenceId()).setEntityType(env.entityType()).setSlice(env.slice()).setSequenceNr(env.sequenceNr()).setTimestamp(env.timestamp()).setOffset(offset2).setOffsetManifest(offsetManifest2);
            env.eventOption().foreach((Function1 & Serializable)event -> builder.setEvent(WrappedPayloadSupport$.MODULE$.payloadBuilder(event, this.serialization(), this.log)));
            env.eventMetadata().foreach((Function1 & Serializable)meta -> builder.setMetadata(WrappedPayloadSupport$.MODULE$.payloadBuilder(meta, this.serialization(), this.log)));
            return builder.build().toByteArray();
        }
        if (object instanceof Offset) {
            Offset offset = (Offset)object;
            return ((String)this.toStorageRepresentation(offset)._1()).getBytes(StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Cannot serialize object of type [").append(o.getClass().getName()).append("]").toString());
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        String string = manifest;
        if ("a".equals(string)) {
            QueryMessages.EventEnvelope env = QueryMessages.EventEnvelope.parseFrom(bytes);
            Offset offset = this.fromStorageRepresentation(env.getOffset(), env.getOffsetManifest());
            None$ eventOption = env.hasEvent() ? Option$.MODULE$.apply(WrappedPayloadSupport$.MODULE$.deserializePayload(env.getEvent(), this.serialization())) : None$.MODULE$;
            None$ metaOption = env.hasMetadata() ? Option$.MODULE$.apply(WrappedPayloadSupport$.MODULE$.deserializePayload(env.getMetadata(), this.serialization())) : None$.MODULE$;
            return new EventEnvelope(offset, env.getPersistenceId(), env.getSequenceNr(), eventOption, env.getTimestamp(), (Option<Object>)metaOption, env.getEntityType(), env.getSlice());
        }
        return this.fromStorageRepresentation(new String(bytes, StandardCharsets.UTF_8), manifest);
    }

    private Offset fromStorageRepresentation(String offsetStr, String manifest) {
        Object object;
        String string = manifest;
        switch (string == null ? 0 : string.hashCode()) {
            case 2497: {
                if (!"NO".equals(string)) break;
                return NoOffset$.MODULE$;
            }
            case 81983: {
                if (!"SEQ".equals(string)) break;
                return Offset$.MODULE$.sequence(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(offsetStr)));
            }
            case 82855: {
                if (!"TBU".equals(string)) break;
                return Offset$.MODULE$.timeBasedUUID(UUID.fromString(offsetStr));
            }
            case 83376: {
                if (!"TSO".equals(string)) break;
                return this.timestampOffsetFromStorageRepresentation(offsetStr);
            }
        }
        String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(manifest), this.manifestSeparator);
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String serializerIdStr = string2;
            String serializerManifest = string3;
            int serializerId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(serializerIdStr));
            byte[] bytes = Base64.getDecoder().decode(offsetStr);
            Object object2 = this.serialization().deserialize(bytes, serializerId, serializerManifest).get();
            if (object2 instanceof Offset) {
                Offset offset = (Offset)object2;
                return offset;
            }
            Object other = object2;
            throw new NotSerializableException(new StringBuilder(77).append("Unimplemented deserialization of offset with serializerId [").append(serializerId).append("] and manifest [").append(manifest).append("] ").append(new StringBuilder(27).append("in [").append(this.getClass().getName()).append("]. [").append(other.getClass().getName()).append("] is not an Offset.").toString()).toString());
        }
        throw new NotSerializableException(new StringBuilder(57).append("Unimplemented deserialization of offset with manifest [").append(manifest).append("] ").append(new StringBuilder(36).append("in [").append(this.getClass().getName()).append("]. [").append(manifest).append("] doesn't contain two parts.").toString()).toString());
    }

    private Tuple2<String, String> toStorageRepresentation(Offset offset) {
        Offset offset2 = offset;
        if (offset2 instanceof TimestampOffset) {
            TimestampOffset t = (TimestampOffset)offset2;
            return Tuple2$.MODULE$.apply((Object)this.timestampOffsetToStorageRepresentation(t), (Object)"TSO");
        }
        if (offset2 instanceof Sequence) {
            Sequence seq = (Sequence)offset2;
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)seq.value()).toString(), (Object)"SEQ");
        }
        if (offset2 instanceof TimeBasedUUID) {
            TimeBasedUUID tbu = (TimeBasedUUID)offset2;
            return Tuple2$.MODULE$.apply((Object)tbu.value().toString(), (Object)"TBU");
        }
        if (NoOffset$.MODULE$.equals(offset2)) {
            return Tuple2$.MODULE$.apply((Object)"", (Object)"NO");
        }
        Offset obj = offset;
        Serializer serializer = this.serialization().findSerializerFor((Object)obj);
        int serializerId = serializer.identifier();
        String serializerManifest = Serializers$.MODULE$.manifestFor(serializer, (Object)obj);
        byte[] bytes = serializer.toBinary((Object)obj);
        String offsetStr = Base64.getEncoder().encodeToString(bytes);
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(serializerManifest), this.manifestSeparator)) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Serializer manifest [").append(serializerManifest).append("] for ").append(new StringBuilder(40).append("offset [").append(offset.getClass().getName()).append("] must not contain [").append(this.manifestSeparator).append("] character.").toString()).toString());
        }
        return Tuple2$.MODULE$.apply((Object)offsetStr, (Object)new StringBuilder(0).append(serializerId).append(this.manifestSeparator).append(serializerManifest).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TimestampOffset timestampOffsetFromStorageRepresentation(String str) {
        try {
            TimestampOffset timestampOffset;
            Object[] objectArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(str), this.timestampOffsetSeparator);
            if (objectArray != null) {
                Object object = Array$.MODULE$.unapplySeq((Object)objectArray);
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 4) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
                    String string4 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 3);
                    String timestamp = string;
                    String readTimestamp = string2;
                    String pid = string3;
                    String seqNr = string4;
                    Object[] objectArray2 = new Tuple2[1];
                    String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)pid);
                    objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seqNr))));
                    timestampOffset = TimestampOffset$.MODULE$.apply(Instant.parse(timestamp), Instant.parse(readTimestamp), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))));
                    return timestampOffset;
                }
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
                    String string;
                    String timestamp = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    timestampOffset = TimestampOffset$.MODULE$.apply(Instant.parse(timestamp), (Map<String, Object>)Predef$.MODULE$.Map().empty());
                    return timestampOffset;
                }
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string6 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String timestamp = string;
                    String readTimestamp = string6;
                    timestampOffset = TimestampOffset$.MODULE$.apply(Instant.parse(timestamp), Instant.parse(readTimestamp), (Map<String, Object>)Predef$.MODULE$.Map().empty());
                    return timestampOffset;
                }
            }
            Object[] parts = objectArray;
            Map seen = Predef$.MODULE$.wrapRefArray(parts).toList().drop(2).grouped(2).map(arg_0 -> QuerySerializer.$anonfun$1((String[])parts, arg_0)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            timestampOffset = TimestampOffset$.MODULE$.apply(Instant.parse((CharSequence)parts[0]), Instant.parse((CharSequence)parts[1]), (Map<String, Object>)seen);
            return timestampOffset;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 == null) throw throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (option.isEmpty()) throw throwable;
            Throwable e = throwable2 = (Throwable)option.get();
            throw new IllegalArgumentException(new StringBuilder(48).append("Unexpected serialized TimestampOffset format [").append(str).append("].").toString(), e);
        }
    }

    private String timestampOffsetToStorageRepresentation(TimestampOffset offset) {
        StringBuilder str = new StringBuilder();
        str.append(offset.timestamp()).append(this.timestampOffsetSeparator).append(offset.readTimestamp());
        if (offset.seen().size() == 1) {
            String pid = (String)((Tuple2)offset.seen().head())._1();
            this.checkSeparator$1(offset, pid);
            long seqNr = BoxesRunTime.unboxToLong((Object)((Tuple2)offset.seen().head())._2());
            str.append(this.timestampOffsetSeparator).append(pid).append(this.timestampOffsetSeparator).append(seqNr);
        } else if (offset.seen().nonEmpty()) {
            ((List)offset.seen().toList().sortBy((Function1 & Serializable)_$1 -> (String)_$1._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String pid = (String)tuple2._1();
                    long seqNr = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    this.checkSeparator$1(offset, pid);
                    return str.append(this.timestampOffsetSeparator).append(pid).append(this.timestampOffsetSeparator).append(seqNr);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return str.toString();
    }

    private static final /* synthetic */ Tuple2 $anonfun$1(String[] parts$1, List x$1) {
        List list = x$1;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            String pid = (String)colon2.head();
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                List list3 = colon3.next$access$1();
                String seqNr = (String)colon3.head();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)pid);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seqNr))));
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(46).append("Invalid representation of Map(pid -> seqNr) [").append(Predef$.MODULE$.wrapRefArray((Object[])parts$1).toList().drop(1).mkString(",")).append("]").toString());
    }

    private final void checkSeparator$1(TimestampOffset offset$1, String pid) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(pid), this.timestampOffsetSeparator)) {
            throw new IllegalArgumentException(new StringBuilder(30).append("persistenceId [").append(pid).append("] in offset [").append(offset$1).append("] ").append(new StringBuilder(29).append("must not contain [").append(this.timestampOffsetSeparator).append("] character").toString()).toString());
        }
    }
}

