/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.PersistencePlugin$PluginHolder$;
import org.apache.pekko.persistence.PluginProvider;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Try;

@InternalApi
public abstract class PersistencePlugin<ScalaDsl, JavaDsl, T> {
    public final ExtendedActorSystem org$apache$pekko$persistence$PersistencePlugin$$system;
    private final ClassTag<T> evidence$1;
    public final PluginProvider<T, ScalaDsl, JavaDsl> org$apache$pekko$persistence$PersistencePlugin$$ev;
    private final AtomicReference<Map<String, ExtensionId<PluginHolder<ScalaDsl, JavaDsl>>>> plugins;
    private final LoggingAdapter log;

    public PersistencePlugin(ExtendedActorSystem system, ClassTag<T> evidence$1, PluginProvider<T, ScalaDsl, JavaDsl> ev) {
        this.org$apache$pekko$persistence$PersistencePlugin$$system = system;
        this.evidence$1 = evidence$1;
        this.org$apache$pekko$persistence$PersistencePlugin$$ev = ev;
        this.plugins = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.log = Logging$.MODULE$.apply((ActorSystem)system, PersistencePlugin.class, LogSource$.MODULE$.fromAnyClass());
    }

    public final PluginHolder<ScalaDsl, JavaDsl> pluginFor(String pluginId, Config readJournalPluginConfig) {
        Option option;
        while (true) {
            String configPath = pluginId;
            Map<String, ExtensionId<PluginHolder<ScalaDsl, JavaDsl>>> extensionIdMap = this.plugins.get();
            option = extensionIdMap.get((Object)configPath);
            if (option instanceof Some) {
                ExtensionId extensionId = (ExtensionId)((Some)option).value();
                return (PluginHolder)extensionId.apply((ActorSystem)this.org$apache$pekko$persistence$PersistencePlugin$$system);
            }
            if (!None$.MODULE$.equals(option)) break;
            ExtensionId extensionId = new ExtensionId<PluginHolder<ScalaDsl, JavaDsl>>(readJournalPluginConfig, configPath, this){
                private final Config readJournalPluginConfig$1;
                private final String configPath$1;
                private final /* synthetic */ PersistencePlugin $outer;
                {
                    this.readJournalPluginConfig$1 = readJournalPluginConfig$2;
                    this.configPath$1 = configPath$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public PluginHolder createExtension(ExtendedActorSystem system) {
                    T provider = this.$outer.org$apache$pekko$persistence$PersistencePlugin$$createPlugin(this.configPath$1, this.readJournalPluginConfig$1);
                    return PersistencePlugin$PluginHolder$.MODULE$.apply(this.$outer.org$apache$pekko$persistence$PersistencePlugin$$ev.scalaDsl(provider), this.$outer.org$apache$pekko$persistence$PersistencePlugin$$ev.javaDsl(provider));
                }
            };
            this.plugins.compareAndSet(extensionIdMap, (Map<String, ExtensionId<PluginHolder<ScalaDsl, JavaDsl>>>)extensionIdMap.updated((Object)configPath, (Object)extensionId));
        }
        throw new MatchError((Object)option);
    }

    public T org$apache$pekko$persistence$PersistencePlugin$$createPlugin(String configPath, Config readJournalPluginConfig) {
        Config mergedConfig = readJournalPluginConfig.withFallback((ConfigMergeable)this.org$apache$pekko$persistence$PersistencePlugin$$system.settings().config());
        Predef$.MODULE$.require(!this.isEmpty(configPath) && mergedConfig.hasPath(configPath), () -> PersistencePlugin.createPlugin$$anonfun$1(configPath));
        Config pluginConfig = mergedConfig.getConfig(configPath);
        String pluginClassName = pluginConfig.getString("class");
        this.log.debug(new StringBuilder(16).append("Create plugin: ").append(configPath).append(" ").append(pluginClassName).toString());
        Class pluginClass = (Class)this.org$apache$pekko$persistence$PersistencePlugin$$system.dynamicAccess().getClassFor(pluginClassName, ClassTag$.MODULE$.apply(Object.class)).get();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(ExtendedActorSystem.class, (Object)this.org$apache$pekko$persistence$PersistencePlugin$$system);
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(Config.class, (Object)pluginConfig);
        Tuple2 tuple23 = Tuple2$.MODULE$.apply(String.class, (Object)configPath);
        return (T)this.org$apache$pekko$persistence$PersistencePlugin$$_$instantiate$1(pluginClass, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple23).$colon$colon((Object)tuple22).$colon$colon((Object)tuple2)).recoverWith((PartialFunction)new Serializable(pluginConfig, pluginClass, this){
            private final Config pluginConfig$1;
            private final Class pluginClass$2;
            private final /* synthetic */ PersistencePlugin $outer;
            {
                this.pluginConfig$1 = pluginConfig$2;
                this.pluginClass$2 = pluginClass$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchMethodException) {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(ExtendedActorSystem.class, (Object)this.$outer.org$apache$pekko$persistence$PersistencePlugin$$system);
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply(Config.class, (Object)this.pluginConfig$1);
                    return this.$outer.org$apache$pekko$persistence$PersistencePlugin$$_$instantiate$1(this.pluginClass$2, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple22).$colon$colon((Object)tuple2));
                }
                return function1.apply((Object)x);
            }
        }).recoverWith((PartialFunction)new Serializable(pluginClass, this){
            private final Class pluginClass$4;
            private final /* synthetic */ PersistencePlugin $outer;
            {
                this.pluginClass$4 = pluginClass$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchMethodException) {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(ExtendedActorSystem.class, (Object)this.$outer.org$apache$pekko$persistence$PersistencePlugin$$system);
                    return this.$outer.org$apache$pekko$persistence$PersistencePlugin$$_$instantiate$1(this.pluginClass$4, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple2));
                }
                return function1.apply((Object)x);
            }
        }).recoverWith((PartialFunction)new Serializable(pluginClass, this){
            private final Class pluginClass$5;
            private final /* synthetic */ PersistencePlugin $outer;
            {
                this.pluginClass$5 = pluginClass$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchMethodException) {
                    return this.$outer.org$apache$pekko$persistence$PersistencePlugin$$_$instantiate$1(this.pluginClass$5, (Seq)package$.MODULE$.Nil());
                }
                return function1.apply((Object)x);
            }
        }).recoverWith((PartialFunction)new Serializable(configPath, pluginClassName){
            private final String configPath$3;
            private final String pluginClassName$1;
            {
                this.configPath$3 = configPath$5;
                this.pluginClassName$1 = pluginClassName$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException(new StringBuilder(55).append("Unable to create read journal plugin instance for path ").append(new StringBuilder(13).append("[").append(this.configPath$3).append("], class [").append(this.pluginClassName$1).append("]!").toString()).toString(), ex));
                }
                return function1.apply((Object)x);
            }
        }).get();
    }

    private boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    private static final Object createPlugin$$anonfun$1(String configPath$2) {
        return new StringBuilder(62).append("'reference.conf' is missing persistence plugin config path: '").append(configPath$2).append("'").toString();
    }

    public final Try org$apache$pekko$persistence$PersistencePlugin$$_$instantiate$1(Class pluginClass$1, Seq args) {
        return this.org$apache$pekko$persistence$PersistencePlugin$$system.dynamicAccess().createInstanceFor(pluginClass$1, args, this.evidence$1);
    }

    public static final class PluginHolder<ScalaDsl, JavaDsl>
    implements Extension,
    Product,
    Serializable {
        private final Object scaladslPlugin;
        private final Object javadslPlugin;

        public static <ScalaDsl, JavaDsl> PluginHolder<ScalaDsl, JavaDsl> apply(ScalaDsl ScalaDsl, JavaDsl JavaDsl) {
            return PersistencePlugin$PluginHolder$.MODULE$.apply(ScalaDsl, JavaDsl);
        }

        public static PluginHolder<?, ?> fromProduct(Product product) {
            return PersistencePlugin$PluginHolder$.MODULE$.fromProduct(product);
        }

        public static <ScalaDsl, JavaDsl> PluginHolder<ScalaDsl, JavaDsl> unapply(PluginHolder<ScalaDsl, JavaDsl> pluginHolder) {
            return PersistencePlugin$PluginHolder$.MODULE$.unapply(pluginHolder);
        }

        public PluginHolder(ScalaDsl scaladslPlugin, JavaDsl javadslPlugin) {
            this.scaladslPlugin = scaladslPlugin;
            this.javadslPlugin = javadslPlugin;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PluginHolder)) return false;
            PluginHolder pluginHolder = (PluginHolder)object;
            if (!BoxesRunTime.equals(this.scaladslPlugin(), pluginHolder.scaladslPlugin())) return false;
            if (!BoxesRunTime.equals(this.javadslPlugin(), pluginHolder.javadslPlugin())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PluginHolder;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PluginHolder";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "scaladslPlugin";
            }
            if (1 == n2) {
                return "javadslPlugin";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ScalaDsl scaladslPlugin() {
            return (ScalaDsl)this.scaladslPlugin;
        }

        public JavaDsl javadslPlugin() {
            return (JavaDsl)this.javadslPlugin;
        }

        public <ScalaDsl, JavaDsl> PluginHolder<ScalaDsl, JavaDsl> copy(ScalaDsl scaladslPlugin, JavaDsl javadslPlugin) {
            return new PluginHolder<ScalaDsl, JavaDsl>(scaladslPlugin, javadslPlugin);
        }

        public <ScalaDsl, JavaDsl> ScalaDsl copy$default$1() {
            return this.scaladslPlugin();
        }

        public <ScalaDsl, JavaDsl> JavaDsl copy$default$2() {
            return this.javadslPlugin();
        }

        public ScalaDsl _1() {
            return this.scaladslPlugin();
        }

        public JavaDsl _2() {
            return this.javadslPlugin();
        }
    }
}

