/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal.leveldb;

import java.io.Serializable;
import java.util.Map;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.AsyncRecovery;
import org.apache.pekko.persistence.journal.leveldb.Key;
import org.apache.pekko.persistence.journal.leveldb.Key$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbJournal;
import org.apache.pekko.persistence.journal.leveldb.LeveldbJournal$ReplayedTaggedMessage$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbStore;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.ReadOptions;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public interface LeveldbRecovery
extends AsyncRecovery {
    public static void $init$(LeveldbRecovery $this) {
    }

    public static String org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId$(LeveldbRecovery $this) {
        return $this.org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId();
    }

    default public String org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId() {
        return ((LeveldbStore)this).config().getString("replay-dispatcher");
    }

    public static MessageDispatcher org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher$(LeveldbRecovery $this) {
        return $this.org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher();
    }

    default public MessageDispatcher org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher() {
        return ((LeveldbStore)this).context().system().dispatchers().lookup(this.org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId());
    }

    public static Future asyncReadHighestSequenceNr$(LeveldbRecovery $this, String persistenceId, long fromSequenceNr) {
        return $this.asyncReadHighestSequenceNr(persistenceId, fromSequenceNr);
    }

    @Override
    default public Future<Object> asyncReadHighestSequenceNr(String persistenceId, long fromSequenceNr) {
        int nid = ((LeveldbStore)this).numericId(persistenceId);
        return Future$.MODULE$.apply(() -> this.asyncReadHighestSequenceNr$$anonfun$1(nid), (ExecutionContext)this.org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static Future asyncReplayMessages$(LeveldbRecovery $this, String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        return $this.asyncReplayMessages(persistenceId, fromSequenceNr, toSequenceNr, max, (Function1<PersistentRepr, BoxedUnit>)replayCallback);
    }

    @Override
    default public Future<BoxedUnit> asyncReplayMessages(String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1<PersistentRepr, BoxedUnit> replayCallback) {
        int nid = ((LeveldbStore)this).numericId(persistenceId);
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.asyncReplayMessages$$anonfun$1(fromSequenceNr, toSequenceNr, max, replayCallback, nid);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static void replayMessages$(LeveldbRecovery $this, int persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        $this.replayMessages(persistenceId, fromSequenceNr, toSequenceNr, max, (Function1<PersistentRepr, BoxedUnit>)replayCallback);
    }

    default public void replayMessages(int persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1<PersistentRepr, BoxedUnit> replayCallback) {
        ((LeveldbStore)this).withIterator((JProcedure1 & Serializable)iter -> {
            Key startKey = Key$.MODULE$.apply(persistenceId, fromSequenceNr < 1L ? 1L : fromSequenceNr, 0);
            iter.seek(Key$.MODULE$.keyToBytes(startKey));
            this.go$1(toSequenceNr, max, (DBIterator)iter, startKey, 0L, (Function1)replayCallback);
        });
    }

    public static Future asyncReplayTaggedMessages$(LeveldbRecovery $this, String tag, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        return $this.asyncReplayTaggedMessages(tag, fromSequenceNr, toSequenceNr, max, (Function1<LeveldbJournal.ReplayedTaggedMessage, BoxedUnit>)replayCallback);
    }

    default public Future<BoxedUnit> asyncReplayTaggedMessages(String tag, long fromSequenceNr, long toSequenceNr, long max, Function1<LeveldbJournal.ReplayedTaggedMessage, BoxedUnit> replayCallback) {
        int tagNid = ((LeveldbStore)this).tagNumericId(tag);
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.asyncReplayTaggedMessages$$anonfun$1(tag, fromSequenceNr, toSequenceNr, max, replayCallback, tagNid);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.org$apache$pekko$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static void replayTaggedMessages$(LeveldbRecovery $this, String tag, int tagNid, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        $this.replayTaggedMessages(tag, tagNid, fromSequenceNr, toSequenceNr, max, (Function1<LeveldbJournal.ReplayedTaggedMessage, BoxedUnit>)replayCallback);
    }

    default public void replayTaggedMessages(String tag, int tagNid, long fromSequenceNr, long toSequenceNr, long max, Function1<LeveldbJournal.ReplayedTaggedMessage, BoxedUnit> replayCallback) {
        ((LeveldbStore)this).withIterator((JProcedure1 & Serializable)iter -> {
            Key startKey = Key$.MODULE$.apply(tagNid, fromSequenceNr < 1L ? 1L : fromSequenceNr + 1L, 0);
            iter.seek(Key$.MODULE$.keyToBytes(startKey));
            this.go$2(tag, toSequenceNr, max, (DBIterator)iter, startKey, 0L, (Function1)replayCallback);
        });
    }

    public static long readHighestSequenceNr$(LeveldbRecovery $this, int persistenceId) {
        return $this.readHighestSequenceNr(persistenceId);
    }

    default public long readHighestSequenceNr(int persistenceId) {
        long l;
        ReadOptions ro = ((LeveldbStore)this).leveldbSnapshot();
        try {
            byte[] byArray = ((LeveldbStore)this).leveldb().get(Key$.MODULE$.keyToBytes(Key$.MODULE$.counterKey(persistenceId)), ro);
            if (byArray == null) {
                l = 0L;
            } else {
                byte[] bytes = byArray;
                l = Key$.MODULE$.counterFromBytes(bytes);
            }
        }
        finally {
            ro.snapshot().close();
        }
        return l;
    }

    private long asyncReadHighestSequenceNr$$anonfun$1(int nid$1) {
        return this.readHighestSequenceNr(nid$1);
    }

    private void asyncReplayMessages$$anonfun$1(long fromSequenceNr$1, long toSequenceNr$1, long max$1, Function1 replayCallback$1, int nid$2) {
        this.replayMessages(nid$2, fromSequenceNr$1, toSequenceNr$1, max$1, (Function1<PersistentRepr, BoxedUnit>)replayCallback$1);
    }

    private void go$1(long toSequenceNr$2, long max$2, DBIterator iter, Key key, long ctr, Function1 replayCallback) {
        while (iter.hasNext()) {
            Map.Entry nextEntry = (Map.Entry)iter.next();
            Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
            if (nextKey.sequenceNr() > toSequenceNr$2) {
                return;
            }
            if (Key$.MODULE$.isDeletionKey(nextKey)) {
                key = nextKey;
                continue;
            }
            if (key.persistenceId() == nextKey.persistenceId()) {
                PersistentRepr msg = ((LeveldbStore)this).persistentFromBytes((byte[])nextEntry.getValue());
                boolean del = LeveldbRecovery.deletion$1(iter, nextKey);
                if (ctr < max$2) {
                    if (!del) {
                        replayCallback.apply((Object)msg);
                    }
                    Key key2 = nextKey;
                    long l = ctr + 1L;
                    key = key2;
                    ctr = l;
                    continue;
                }
                return;
            }
            return;
        }
    }

    private static boolean deletion$1(DBIterator iter, Key key) {
        if (iter.hasNext()) {
            Map.Entry nextEntry = iter.peekNext();
            Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
            if (key.persistenceId() == nextKey.persistenceId() && key.sequenceNr() == nextKey.sequenceNr() && Key$.MODULE$.isDeletionKey(nextKey)) {
                iter.next();
                return true;
            }
            return false;
        }
        return false;
    }

    private void asyncReplayTaggedMessages$$anonfun$1(String tag$1, long fromSequenceNr$3, long toSequenceNr$4, long max$4, Function1 replayCallback$3, int tagNid$1) {
        this.replayTaggedMessages(tag$1, tagNid$1, fromSequenceNr$3, toSequenceNr$4, max$4, (Function1<LeveldbJournal.ReplayedTaggedMessage, BoxedUnit>)replayCallback$3);
    }

    private void go$2(String tag$2, long toSequenceNr$5, long max$5, DBIterator iter, Key key, long ctr, Function1 replayCallback) {
        while (iter.hasNext()) {
            Map.Entry nextEntry = (Map.Entry)iter.next();
            Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
            if (nextKey.sequenceNr() > toSequenceNr$5) {
                return;
            }
            if (key.persistenceId() == nextKey.persistenceId()) {
                PersistentRepr msg = ((LeveldbStore)this).persistentFromBytes((byte[])nextEntry.getValue());
                if (ctr < max$5) {
                    replayCallback.apply((Object)LeveldbJournal$ReplayedTaggedMessage$.MODULE$.apply(msg, tag$2, nextKey.sequenceNr()));
                    Key key2 = nextKey;
                    long l = ctr + 1L;
                    key = key2;
                    ctr = l;
                    continue;
                }
                return;
            }
            return;
        }
    }
}

