/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.fsm;

import java.io.Serializable;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.AutoReceivedMessage;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.PersistentActor;
import org.apache.pekko.persistence.RecoveryCompleted$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotOffer;
import org.apache.pekko.persistence.SnapshotOffer$;
import org.apache.pekko.persistence.fsm.PersistentFSM$;
import org.apache.pekko.persistence.fsm.PersistentFSM$$minus$greater$;
import org.apache.pekko.persistence.fsm.PersistentFSM$CurrentState$;
import org.apache.pekko.persistence.fsm.PersistentFSM$Event$;
import org.apache.pekko.persistence.fsm.PersistentFSM$Failure$;
import org.apache.pekko.persistence.fsm.PersistentFSM$FixedDelayMode$;
import org.apache.pekko.persistence.fsm.PersistentFSM$FixedRateMode$;
import org.apache.pekko.persistence.fsm.PersistentFSM$LogEntry$;
import org.apache.pekko.persistence.fsm.PersistentFSM$PersistentFSMSnapshot$;
import org.apache.pekko.persistence.fsm.PersistentFSM$SingleMode$;
import org.apache.pekko.persistence.fsm.PersistentFSM$State$;
import org.apache.pekko.persistence.fsm.PersistentFSM$StateChangeEvent$;
import org.apache.pekko.persistence.fsm.PersistentFSM$StopEvent$;
import org.apache.pekko.persistence.fsm.PersistentFSM$SubscribeTransitionCallBack$;
import org.apache.pekko.persistence.fsm.PersistentFSM$TimeoutMarker$;
import org.apache.pekko.persistence.fsm.PersistentFSM$Timer$;
import org.apache.pekko.persistence.fsm.PersistentFSM$Transition$;
import org.apache.pekko.persistence.fsm.PersistentFSM$UnsubscribeTransitionCallBack$;
import org.apache.pekko.persistence.fsm.PersistentFSMBase;
import org.apache.pekko.persistence.fsm.SnapshotAfter;
import org.apache.pekko.persistence.fsm.SnapshotAfter$;
import org.apache.pekko.persistence.serialization.Message;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public interface PersistentFSM<S extends FSMState, D, E>
extends PersistentActor,
PersistentFSMBase<S, D, E> {
    public static Some<FiniteDuration> SomeMaxFiniteDuration() {
        return PersistentFSM$.MODULE$.SomeMaxFiniteDuration();
    }

    public static PersistentFSM$$minus$greater$ $u2192() {
        return PersistentFSM$.MODULE$.$u2192();
    }

    public static void $init$(PersistentFSM $this) {
        $this.org$apache$pekko$persistence$fsm$PersistentFSM$_setter_$domainEventTag_$eq($this.domainEventClassTag());
        $this.org$apache$pekko$persistence$fsm$PersistentFSM$$currentStateTimeout_$eq((Option<FiniteDuration>)None$.MODULE$);
    }

    public /* synthetic */ void org$apache$pekko$persistence$fsm$PersistentFSM$$super$applyState(State var1);

    public ClassTag<E> domainEventClassTag();

    public ClassTag<E> domainEventTag();

    public void org$apache$pekko$persistence$fsm$PersistentFSM$_setter_$domainEventTag_$eq(ClassTag var1);

    public static Map statesMap$(PersistentFSM $this) {
        return $this.statesMap();
    }

    default public Map<String, S> statesMap() {
        return ((IterableOnceOps)this.stateNames().map((Function1 & Serializable)name -> Tuple2$.MODULE$.apply((Object)name.identifier(), name))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<FiniteDuration> org$apache$pekko$persistence$fsm$PersistentFSM$$currentStateTimeout();

    public void org$apache$pekko$persistence$fsm$PersistentFSM$$currentStateTimeout_$eq(Option<FiniteDuration> var1);

    public D applyEvent(E var1, D var2);

    public static void onRecoveryCompleted$(PersistentFSM $this) {
        $this.onRecoveryCompleted();
    }

    default public void onRecoveryCompleted() {
    }

    public static void saveStateSnapshot$(PersistentFSM $this) {
        $this.saveStateSnapshot();
    }

    default public void saveStateSnapshot() {
        this.saveSnapshot(PersistentFSM$PersistentFSMSnapshot$.MODULE$.apply(((FSMState)this.stateName()).identifier(), this.stateData(), this.org$apache$pekko$persistence$fsm$PersistentFSM$$currentStateTimeout()));
    }

    public static PartialFunction receiveCommand$(PersistentFSM $this) {
        return $this.receiveCommand();
    }

    @Override
    default public PartialFunction<Object, BoxedUnit> receiveCommand() {
        return PersistentFSMBase.receive$(this);
    }

    public static PartialFunction receiveRecover$(PersistentFSM $this) {
        return $this.receiveRecover();
    }

    @Override
    default public PartialFunction<Object, BoxedUnit> receiveRecover() {
        return new Serializable(this){
            private final /* synthetic */ PersistentFSM $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Option option;
                Object object = x;
                if (object != null && !(option = this.$outer.domainEventTag().unapply(object)).isEmpty()) {
                    Object object2;
                    Object event = object2 = option.get();
                    return true;
                }
                if (object instanceof StateChangeEvent) {
                    StateChangeEvent stateChangeEvent = PersistentFSM$StateChangeEvent$.MODULE$.unapply((StateChangeEvent)object);
                    String string = stateChangeEvent._1();
                    Option<FiniteDuration> option2 = stateChangeEvent._2();
                    String stateIdentifier = string;
                    Option<FiniteDuration> timeout = option2;
                    return true;
                }
                if (object instanceof SnapshotOffer) {
                    SnapshotOffer snapshotOffer = SnapshotOffer$.MODULE$.unapply((SnapshotOffer)object);
                    SnapshotMetadata snapshotMetadata = snapshotOffer._1();
                    Object object3 = snapshotOffer._2();
                    if (object3 instanceof PersistentFSMSnapshot) {
                        PersistentFSMSnapshot<D> persistentFSMSnapshot = PersistentFSM$PersistentFSMSnapshot$.MODULE$.unapply((PersistentFSMSnapshot)object3);
                        String string = persistentFSMSnapshot._1();
                        D d = persistentFSMSnapshot._2();
                        Option<FiniteDuration> option3 = persistentFSMSnapshot._3();
                        String stateIdentifier = string;
                        if (d instanceof Object) {
                            D data = d;
                            Option<FiniteDuration> timeout = option3;
                            return true;
                        }
                    }
                }
                return RecoveryCompleted$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Option option;
                Object object = x;
                if (object != null && !(option = this.$outer.domainEventTag().unapply(object)).isEmpty()) {
                    Object object2;
                    Object event = object2 = option.get();
                    this.$outer.startWith(this.$outer.stateName(), this.$outer.applyEvent(event, this.$outer.stateData()), this.$outer.startWith$default$3());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof StateChangeEvent) {
                    StateChangeEvent stateChangeEvent = PersistentFSM$StateChangeEvent$.MODULE$.unapply((StateChangeEvent)object);
                    String string = stateChangeEvent._1();
                    Option<FiniteDuration> option2 = stateChangeEvent._2();
                    String stateIdentifier = string;
                    Option<FiniteDuration> timeout = option2;
                    this.$outer.startWith(this.$outer.statesMap().apply((Object)stateIdentifier), this.$outer.stateData(), timeout);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof SnapshotOffer) {
                    SnapshotOffer snapshotOffer = SnapshotOffer$.MODULE$.unapply((SnapshotOffer)object);
                    SnapshotMetadata snapshotMetadata = snapshotOffer._1();
                    Object object3 = snapshotOffer._2();
                    if (object3 instanceof PersistentFSMSnapshot) {
                        PersistentFSMSnapshot<D> persistentFSMSnapshot = PersistentFSM$PersistentFSMSnapshot$.MODULE$.unapply((PersistentFSMSnapshot)object3);
                        String string = persistentFSMSnapshot._1();
                        D d = persistentFSMSnapshot._2();
                        Option<FiniteDuration> option3 = persistentFSMSnapshot._3();
                        String stateIdentifier = string;
                        if (d instanceof Object) {
                            D data = d;
                            Option<FiniteDuration> timeout = option3;
                            this.$outer.startWith(this.$outer.statesMap().apply((Object)stateIdentifier), data, timeout);
                            return BoxedUnit.UNIT;
                        }
                    }
                }
                if (RecoveryCompleted$.MODULE$.equals(object)) {
                    this.$outer.initialize();
                    this.$outer.onRecoveryCompleted();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public static void applyState$(PersistentFSM $this, State nextState) {
        $this.applyState(nextState);
    }

    @Override
    default public void applyState(State<S, D, E> nextState) {
        ObjectRef eventsToPersist = ObjectRef.create((Object)nextState.domainEvents().toList());
        if (nextState.notifies() || nextState.timeout().nonEmpty()) {
            Seq seq = (Seq)((Seq)eventsToPersist.elem).$colon$plus((Object)PersistentFSM$StateChangeEvent$.MODULE$.apply(((FSMState)nextState.stateName()).identifier(), nextState.timeout()));
            eventsToPersist.elem = seq;
            seq = null;
        }
        if (((Seq)eventsToPersist.elem).isEmpty()) {
            this.org$apache$pekko$persistence$fsm$PersistentFSM$$super$applyState(nextState);
            return;
        }
        ObjectRef nextData = ObjectRef.create((Object)this.stateData());
        IntRef handlersExecutedCounter = IntRef.create((int)0);
        SnapshotAfter snapshotAfterExtension = SnapshotAfter$.MODULE$.get(this.context().system());
        BooleanRef doSnapshot = BooleanRef.create((boolean)false);
        this.persistAll((Seq)eventsToPersist.elem, (JProcedure1 & Serializable)x$1 -> {
            Option option;
            Object object = x$1;
            if (object != null && !(option = this.domainEventTag().unapply(object)).isEmpty()) {
                boolean bl;
                Object object2;
                Object object3;
                Object event = object3 = option.get();
                nextData$2.elem = object2 = this.applyEvent(event, nextData$2.elem);
                object2 = null;
                doSnapshot$2.elem = bl = doSnapshot$2.elem || snapshotAfterExtension.isSnapshotAfterSeqNo().apply$mcZJ$sp(this.lastSequenceNr());
                this.applyStateOnLastHandler$1(nextState, eventsToPersist, nextData, handlersExecutedCounter, doSnapshot);
                return;
            }
            if (object instanceof StateChangeEvent) {
                boolean bl;
                doSnapshot$2.elem = bl = doSnapshot$2.elem || snapshotAfterExtension.isSnapshotAfterSeqNo().apply$mcZJ$sp(this.lastSequenceNr());
                this.applyStateOnLastHandler$1(nextState, eventsToPersist, nextData, handlersExecutedCounter, doSnapshot);
                return;
            }
            throw new RuntimeException();
        });
    }

    private void applyStateOnLastHandler$1(State nextState$1, ObjectRef eventsToPersist$1, ObjectRef nextData$1, IntRef handlersExecutedCounter$1, BooleanRef doSnapshot$1) {
        int n;
        handlersExecutedCounter$1.elem = n = handlersExecutedCounter$1.elem + 1;
        if (handlersExecutedCounter$1.elem == ((Seq)eventsToPersist$1.elem).size()) {
            Object object = nextData$1.elem;
            FSMState fSMState = (FSMState)nextState$1.copy0$default$1();
            Option<FiniteDuration> option = nextState$1.copy0$default$3();
            Option<Reason> option2 = nextState$1.copy0$default$4();
            List<Object> list = nextState$1.copy0$default$5();
            boolean bl = nextState$1.copy0$default$6();
            Seq seq = nextState$1.copy0$default$7();
            Function1 function1 = nextState$1.copy0$default$8();
            this.org$apache$pekko$persistence$fsm$PersistentFSM$$super$applyState(nextState$1.copy0(fSMState, object, option, option2, list, bl, seq, function1));
            this.org$apache$pekko$persistence$fsm$PersistentFSM$$currentStateTimeout_$eq(nextState$1.timeout());
            nextState$1.afterTransitionDo().apply(this.stateData());
            if (doSnapshot$1.elem) {
                this.log().info("Saving snapshot, sequence number [{}]", (Object)BoxesRunTime.boxToLong((long)this.snapshotSequenceNr()));
                this.saveStateSnapshot();
                return;
            }
            return;
        }
    }

    public static final class CurrentState<S>
    implements Product,
    Serializable {
        private final ActorRef fsmRef;
        private final Object state;
        private final Option timeout;

        public static <S> CurrentState<S> apply(ActorRef actorRef, S s, Option<FiniteDuration> option) {
            return PersistentFSM$CurrentState$.MODULE$.apply(actorRef, s, option);
        }

        public static CurrentState<?> fromProduct(Product product) {
            return PersistentFSM$CurrentState$.MODULE$.fromProduct(product);
        }

        public static <S> CurrentState<S> unapply(CurrentState<S> currentState) {
            return PersistentFSM$CurrentState$.MODULE$.unapply(currentState);
        }

        public CurrentState(ActorRef fsmRef, S state, Option<FiniteDuration> timeout) {
            this.fsmRef = fsmRef;
            this.state = state;
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentState)) return false;
            CurrentState currentState = (CurrentState)object;
            ActorRef actorRef = this.fsmRef();
            ActorRef actorRef2 = currentState.fsmRef();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            if (!BoxesRunTime.equals(this.state(), currentState.state())) return false;
            Option<FiniteDuration> option = this.timeout();
            Option<FiniteDuration> option2 = currentState.timeout();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentState;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "CurrentState";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "fsmRef";
                }
                case 1: {
                    return "state";
                }
                case 2: {
                    return "timeout";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef fsmRef() {
            return this.fsmRef;
        }

        public S state() {
            return (S)this.state;
        }

        public Option<FiniteDuration> timeout() {
            return this.timeout;
        }

        public <S> CurrentState<S> copy(ActorRef fsmRef, S state, Option<FiniteDuration> timeout) {
            return new CurrentState<S>(fsmRef, state, timeout);
        }

        public <S> ActorRef copy$default$1() {
            return this.fsmRef();
        }

        public <S> S copy$default$2() {
            return this.state();
        }

        public <S> Option<FiniteDuration> copy$default$3() {
            return this.timeout();
        }

        public ActorRef _1() {
            return this.fsmRef();
        }

        public S _2() {
            return this.state();
        }

        public Option<FiniteDuration> _3() {
            return this.timeout();
        }
    }

    public static final class Event<D>
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Object event;
        private final Object stateData;

        public static <D> Event<D> apply(Object object, D d) {
            return PersistentFSM$Event$.MODULE$.apply(object, d);
        }

        public static Event<?> fromProduct(Product product) {
            return PersistentFSM$Event$.MODULE$.fromProduct(product);
        }

        public static <D> Event<D> unapply(Event<D> event) {
            return PersistentFSM$Event$.MODULE$.unapply(event);
        }

        public Event(Object event, D stateData) {
            this.event = event;
            this.stateData = stateData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Event)) return false;
            Event event = (Event)object;
            if (!BoxesRunTime.equals((Object)this.event(), (Object)event.event())) return false;
            if (!BoxesRunTime.equals(this.stateData(), event.stateData())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Event;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Event";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "event";
            }
            if (1 == n2) {
                return "stateData";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object event() {
            return this.event;
        }

        public D stateData() {
            return (D)this.stateData;
        }

        public <D> Event<D> copy(Object event, D stateData) {
            return new Event<D>(event, stateData);
        }

        public <D> Object copy$default$1() {
            return this.event();
        }

        public <D> D copy$default$2() {
            return this.stateData();
        }

        public Object _1() {
            return this.event();
        }

        public D _2() {
            return this.stateData();
        }
    }

    public static interface FSMState {
        public String identifier();
    }

    public static final class Failure
    implements Reason,
    Product,
    Serializable {
        private final Object cause;

        public static Failure apply(Object object) {
            return PersistentFSM$Failure$.MODULE$.apply(object);
        }

        public static Failure fromProduct(Product product) {
            return PersistentFSM$Failure$.MODULE$.fromProduct(product);
        }

        public static Failure unapply(Failure failure) {
            return PersistentFSM$Failure$.MODULE$.unapply(failure);
        }

        public Failure(Object cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Failure)) return false;
            Failure failure = (Failure)object;
            if (!BoxesRunTime.equals((Object)this.cause(), (Object)failure.cause())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Failure;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Failure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object cause() {
            return this.cause;
        }

        public Failure copy(Object cause) {
            return new Failure(cause);
        }

        public Object copy$default$1() {
            return this.cause();
        }

        public Object _1() {
            return this.cause();
        }
    }

    public static final class LogEntry<S, D>
    implements Product,
    Serializable {
        private final Object stateName;
        private final Object stateData;
        private final Object event;

        public static <S, D> LogEntry<S, D> apply(S s, D d, Object object) {
            return PersistentFSM$LogEntry$.MODULE$.apply(s, d, object);
        }

        public static LogEntry<?, ?> fromProduct(Product product) {
            return PersistentFSM$LogEntry$.MODULE$.fromProduct(product);
        }

        public static <S, D> LogEntry<S, D> unapply(LogEntry<S, D> logEntry) {
            return PersistentFSM$LogEntry$.MODULE$.unapply(logEntry);
        }

        public LogEntry(S stateName, D stateData, Object event) {
            this.stateName = stateName;
            this.stateData = stateData;
            this.event = event;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LogEntry)) return false;
            LogEntry logEntry = (LogEntry)object;
            if (!BoxesRunTime.equals(this.stateName(), logEntry.stateName())) return false;
            if (!BoxesRunTime.equals(this.stateData(), logEntry.stateData())) return false;
            if (!BoxesRunTime.equals((Object)this.event(), (Object)logEntry.event())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LogEntry;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "LogEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "stateName";
                }
                case 1: {
                    return "stateData";
                }
                case 2: {
                    return "event";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public S stateName() {
            return (S)this.stateName;
        }

        public D stateData() {
            return (D)this.stateData;
        }

        public Object event() {
            return this.event;
        }

        public <S, D> LogEntry<S, D> copy(S stateName, D stateData, Object event) {
            return new LogEntry<S, D>(stateName, stateData, event);
        }

        public <S, D> S copy$default$1() {
            return this.stateName();
        }

        public <S, D> D copy$default$2() {
            return this.stateData();
        }

        public <S, D> Object copy$default$3() {
            return this.event();
        }

        public S _1() {
            return this.stateName();
        }

        public D _2() {
            return this.stateData();
        }

        public Object _3() {
            return this.event();
        }
    }

    @InternalApi
    public static class PersistentFSMSnapshot<D>
    implements Message,
    Product {
        private final String stateIdentifier;
        private final Object data;
        private final Option timeout;

        public static <D> PersistentFSMSnapshot<D> apply(String string, D d, Option<FiniteDuration> option) {
            return PersistentFSM$PersistentFSMSnapshot$.MODULE$.apply(string, d, option);
        }

        public static PersistentFSMSnapshot<?> fromProduct(Product product) {
            return PersistentFSM$PersistentFSMSnapshot$.MODULE$.fromProduct(product);
        }

        public static <D> PersistentFSMSnapshot<D> unapply(PersistentFSMSnapshot<D> persistentFSMSnapshot) {
            return PersistentFSM$PersistentFSMSnapshot$.MODULE$.unapply(persistentFSMSnapshot);
        }

        public PersistentFSMSnapshot(String stateIdentifier, D data, Option<FiniteDuration> timeout) {
            this.stateIdentifier = stateIdentifier;
            this.data = data;
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PersistentFSMSnapshot)) return false;
            PersistentFSMSnapshot persistentFSMSnapshot = (PersistentFSMSnapshot)object;
            String string = this.stateIdentifier();
            String string2 = persistentFSMSnapshot.stateIdentifier();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equals(this.data(), persistentFSMSnapshot.data())) return false;
            Option<FiniteDuration> option = this.timeout();
            Option<FiniteDuration> option2 = persistentFSMSnapshot.timeout();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!persistentFSMSnapshot.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PersistentFSMSnapshot;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PersistentFSMSnapshot";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "stateIdentifier";
                }
                case 1: {
                    return "data";
                }
                case 2: {
                    return "timeout";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String stateIdentifier() {
            return this.stateIdentifier;
        }

        public D data() {
            return (D)this.data;
        }

        public Option<FiniteDuration> timeout() {
            return this.timeout;
        }

        public <D> PersistentFSMSnapshot<D> copy(String stateIdentifier, D data, Option<FiniteDuration> timeout) {
            return new PersistentFSMSnapshot<D>(stateIdentifier, data, timeout);
        }

        public <D> String copy$default$1() {
            return this.stateIdentifier();
        }

        public <D> D copy$default$2() {
            return this.data();
        }

        public <D> Option<FiniteDuration> copy$default$3() {
            return this.timeout();
        }

        public String _1() {
            return this.stateIdentifier();
        }

        public D _2() {
            return this.data();
        }

        public Option<FiniteDuration> _3() {
            return this.timeout();
        }
    }

    @InternalApi
    public static interface PersistentFsmEvent
    extends Message {
    }

    public static interface Reason {
    }

    public static final class State<S, D, E>
    implements Product,
    Serializable {
        private final Object stateName;
        private final Object stateData;
        private final Option timeout;
        private final Option stopReason;
        private final List replies;
        private final Seq domainEvents;
        private final Function1 afterTransitionDo;
        private final boolean notifies;

        public static <S, D, E> State<S, D, E> apply(S s, D d, Option<FiniteDuration> option, Option<Reason> option2, List<Object> list, Seq<E> seq, Function1<D, BoxedUnit> function1, boolean bl) {
            return PersistentFSM$State$.MODULE$.apply(s, d, option, option2, list, seq, function1, bl);
        }

        public static <S, D, E> State<S, D, E> unapply(State<S, D, E> state) {
            return PersistentFSM$State$.MODULE$.unapply(state);
        }

        public static <S, D, E> Option<FiniteDuration> $lessinit$greater$default$3() {
            return PersistentFSM$State$.MODULE$.$lessinit$greater$default$3();
        }

        public static <S, D, E> Option<Reason> $lessinit$greater$default$4() {
            return PersistentFSM$State$.MODULE$.$lessinit$greater$default$4();
        }

        public static <S, D, E> List<Object> $lessinit$greater$default$5() {
            return PersistentFSM$State$.MODULE$.$lessinit$greater$default$5();
        }

        public static <S, D, E> Nil$ $lessinit$greater$default$6() {
            return PersistentFSM$State$.MODULE$.$lessinit$greater$default$6();
        }

        public static <S, D, E> Function1<D, BoxedUnit> $lessinit$greater$default$7() {
            return PersistentFSM$State$.MODULE$.$lessinit$greater$default$7();
        }

        public static <S, D, E> boolean $lessinit$greater$default$8(S s, D d, Option<FiniteDuration> option, Option<Reason> option2, List<Object> list, Seq<E> seq, Function1<D, BoxedUnit> function1) {
            return PersistentFSM$State$.MODULE$.$lessinit$greater$default$8(s, d, option, option2, list, seq, function1);
        }

        public State(S stateName, D stateData, Option<FiniteDuration> timeout, Option<Reason> stopReason, List<Object> replies, Seq<E> domainEvents, Function1<D, BoxedUnit> afterTransitionDo, boolean notifies) {
            this.stateName = stateName;
            this.stateData = stateData;
            this.timeout = timeout;
            this.stopReason = stopReason;
            this.replies = replies;
            this.domainEvents = domainEvents;
            this.afterTransitionDo = afterTransitionDo;
            this.notifies = notifies;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (!BoxesRunTime.equals(this.stateName(), state.stateName())) return false;
            if (!BoxesRunTime.equals(this.stateData(), state.stateData())) return false;
            Option<FiniteDuration> option = this.timeout();
            Option<FiniteDuration> option2 = state.timeout();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Reason> option3 = this.stopReason();
            Option<Reason> option4 = state.stopReason();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            List<Object> list = this.replies();
            List<Object> list2 = state.replies();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            Seq<E> seq = this.domainEvents();
            Seq<E> seq2 = state.domainEvents();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Function1<D, BoxedUnit> function1 = this.afterTransitionDo();
            Function1<D, BoxedUnit> function12 = state.afterTransitionDo();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "stateName";
                }
                case 1: {
                    return "stateData";
                }
                case 2: {
                    return "timeout";
                }
                case 3: {
                    return "stopReason";
                }
                case 4: {
                    return "replies";
                }
                case 5: {
                    return "domainEvents";
                }
                case 6: {
                    return "afterTransitionDo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public S stateName() {
            return (S)this.stateName;
        }

        public D stateData() {
            return (D)this.stateData;
        }

        public Option<FiniteDuration> timeout() {
            return this.timeout;
        }

        public Option<Reason> stopReason() {
            return this.stopReason;
        }

        public List<Object> replies() {
            return this.replies;
        }

        public Seq<E> domainEvents() {
            return this.domainEvents;
        }

        public Function1<D, BoxedUnit> afterTransitionDo() {
            return this.afterTransitionDo;
        }

        public boolean notifies() {
            return this.notifies;
        }

        @InternalApi
        public State<S, D, E> copy0(S stateName, D stateData, Option<FiniteDuration> timeout, Option<Reason> stopReason, List<Object> replies, boolean notifies, Seq<E> domainEvents, Function1<D, BoxedUnit> afterTransitionDo) {
            return PersistentFSM$State$.MODULE$.apply(stateName, stateData, timeout, stopReason, replies, domainEvents, afterTransitionDo, notifies);
        }

        public S copy0$default$1() {
            return this.stateName();
        }

        public D copy0$default$2() {
            return this.stateData();
        }

        public Option<FiniteDuration> copy0$default$3() {
            return this.timeout();
        }

        public Option<Reason> copy0$default$4() {
            return this.stopReason();
        }

        public List<Object> copy0$default$5() {
            return this.replies();
        }

        public boolean copy0$default$6() {
            return this.notifies();
        }

        public Seq<E> copy0$default$7() {
            return this.domainEvents();
        }

        public Function1<D, BoxedUnit> copy0$default$8() {
            return this.afterTransitionDo();
        }

        public State<S, D, E> forMax(Duration timeout) {
            Duration duration = timeout;
            if (duration instanceof FiniteDuration) {
                FiniteDuration f = (FiniteDuration)duration;
                Some some = Some$.MODULE$.apply((Object)f);
                S s = this.copy0$default$1();
                D d = this.copy0$default$2();
                Option<Reason> option = this.copy0$default$4();
                List<Object> list = this.copy0$default$5();
                boolean bl = this.copy0$default$6();
                Seq<E> seq = this.copy0$default$7();
                Function1<D, BoxedUnit> function1 = this.copy0$default$8();
                return this.copy0(s, d, (Option<FiniteDuration>)some, option, list, bl, seq, function1);
            }
            Some<FiniteDuration> some = PersistentFSM$.MODULE$.SomeMaxFiniteDuration();
            S s = this.copy0$default$1();
            D d = this.copy0$default$2();
            Option<Reason> option = this.copy0$default$4();
            List<Object> list = this.copy0$default$5();
            boolean bl = this.copy0$default$6();
            Seq<E> seq = this.copy0$default$7();
            Function1<D, BoxedUnit> function1 = this.copy0$default$8();
            return this.copy0(s, d, (Option<FiniteDuration>)some, option, list, bl, seq, function1);
        }

        public State<S, D, E> forMax(java.time.Duration timeout) {
            return this.forMax((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)));
        }

        public State<S, D, E> replying(Object replyValue) {
            List list = this.replies().$colon$colon(replyValue);
            S s = this.copy0$default$1();
            D d = this.copy0$default$2();
            Option<FiniteDuration> option = this.copy0$default$3();
            Option<Reason> option2 = this.copy0$default$4();
            boolean bl = this.copy0$default$6();
            Seq<E> seq = this.copy0$default$7();
            Function1<D, BoxedUnit> function1 = this.copy0$default$8();
            return this.copy0(s, d, option, option2, (List<Object>)list, bl, seq, function1);
        }

        @InternalApi
        public State<S, D, E> using(D nextStateData) {
            return this.copy0(this.copy0$default$1(), nextStateData, this.copy0$default$3(), this.copy0$default$4(), this.copy0$default$5(), this.copy0$default$6(), this.copy0$default$7(), this.copy0$default$8());
        }

        @InternalApi
        public State<S, D, E> withStopReason(Reason reason) {
            Some some = Some$.MODULE$.apply((Object)reason);
            S s = this.copy0$default$1();
            D d = this.copy0$default$2();
            Option<FiniteDuration> option = this.copy0$default$3();
            List<Object> list = this.copy0$default$5();
            boolean bl = this.copy0$default$6();
            Seq<E> seq = this.copy0$default$7();
            Function1<D, BoxedUnit> function1 = this.copy0$default$8();
            return this.copy0(s, d, option, (Option<Reason>)some, list, bl, seq, function1);
        }

        @InternalApi
        public State<S, D, E> withNotification(boolean notifies) {
            return this.copy0(this.copy0$default$1(), this.copy0$default$2(), this.copy0$default$3(), this.copy0$default$4(), this.copy0$default$5(), notifies, this.copy0$default$7(), this.copy0$default$8());
        }

        public State<S, D, E> applying(Seq<E> events) {
            Seq seq = (Seq)this.domainEvents().$plus$plus(events);
            S s = this.copy0$default$1();
            D d = this.copy0$default$2();
            Option<FiniteDuration> option = this.copy0$default$3();
            Option<Reason> option2 = this.copy0$default$4();
            List<Object> list = this.copy0$default$5();
            boolean bl = this.copy0$default$6();
            Function1<D, BoxedUnit> function1 = this.copy0$default$8();
            return this.copy0(s, d, option, option2, list, bl, seq, function1);
        }

        public State<S, D, E> applying(E ... events) {
            return this.applying((Seq<E>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])events));
        }

        public State<S, D, E> andThen(Function1<D, BoxedUnit> handler) {
            return this.copy0(this.copy0$default$1(), this.copy0$default$2(), this.copy0$default$3(), this.copy0$default$4(), this.copy0$default$5(), this.copy0$default$6(), this.copy0$default$7(), handler);
        }

        public <S, D, E> State<S, D, E> copy(S stateName, D stateData, Option<FiniteDuration> timeout, Option<Reason> stopReason, List<Object> replies, Seq<E> domainEvents, Function1<D, BoxedUnit> afterTransitionDo, boolean notifies) {
            return new State<S, D, E>(stateName, stateData, timeout, stopReason, replies, domainEvents, afterTransitionDo, notifies);
        }

        public <S, D, E> S copy$default$1() {
            return this.stateName();
        }

        public <S, D, E> D copy$default$2() {
            return this.stateData();
        }

        public <S, D, E> Option<FiniteDuration> copy$default$3() {
            return this.timeout();
        }

        public <S, D, E> Option<Reason> copy$default$4() {
            return this.stopReason();
        }

        public <S, D, E> List<Object> copy$default$5() {
            return this.replies();
        }

        public <S, D, E> Seq<E> copy$default$6() {
            return this.domainEvents();
        }

        public <S, D, E> Function1<D, BoxedUnit> copy$default$7() {
            return this.afterTransitionDo();
        }

        public S _1() {
            return this.stateName();
        }

        public D _2() {
            return this.stateData();
        }

        public Option<FiniteDuration> _3() {
            return this.timeout();
        }

        public Option<Reason> _4() {
            return this.stopReason();
        }

        public List<Object> _5() {
            return this.replies();
        }

        public Seq<E> _6() {
            return this.domainEvents();
        }

        public Function1<D, BoxedUnit> _7() {
            return this.afterTransitionDo();
        }
    }

    public static class StateChangeEvent
    implements PersistentFsmEvent,
    Product {
        private final String stateIdentifier;
        private final Option timeout;

        public static StateChangeEvent apply(String string, Option<FiniteDuration> option) {
            return PersistentFSM$StateChangeEvent$.MODULE$.apply(string, option);
        }

        public static StateChangeEvent fromProduct(Product product) {
            return PersistentFSM$StateChangeEvent$.MODULE$.fromProduct(product);
        }

        public static StateChangeEvent unapply(StateChangeEvent stateChangeEvent) {
            return PersistentFSM$StateChangeEvent$.MODULE$.unapply(stateChangeEvent);
        }

        public StateChangeEvent(String stateIdentifier, Option<FiniteDuration> timeout) {
            this.stateIdentifier = stateIdentifier;
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StateChangeEvent)) return false;
            StateChangeEvent stateChangeEvent = (StateChangeEvent)object;
            String string = this.stateIdentifier();
            String string2 = stateChangeEvent.stateIdentifier();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<FiniteDuration> option = this.timeout();
            Option<FiniteDuration> option2 = stateChangeEvent.timeout();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!stateChangeEvent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StateChangeEvent;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StateChangeEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "stateIdentifier";
            }
            if (1 == n2) {
                return "timeout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String stateIdentifier() {
            return this.stateIdentifier;
        }

        public Option<FiniteDuration> timeout() {
            return this.timeout;
        }

        public StateChangeEvent copy(String stateIdentifier, Option<FiniteDuration> timeout) {
            return new StateChangeEvent(stateIdentifier, timeout);
        }

        public String copy$default$1() {
            return this.stateIdentifier();
        }

        public Option<FiniteDuration> copy$default$2() {
            return this.timeout();
        }

        public String _1() {
            return this.stateIdentifier();
        }

        public Option<FiniteDuration> _2() {
            return this.timeout();
        }
    }

    public static final class StopEvent<S, D>
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Reason reason;
        private final Object currentState;
        private final Object stateData;

        public static <S, D> StopEvent<S, D> apply(Reason reason, S s, D d) {
            return PersistentFSM$StopEvent$.MODULE$.apply(reason, s, d);
        }

        public static StopEvent<?, ?> fromProduct(Product product) {
            return PersistentFSM$StopEvent$.MODULE$.fromProduct(product);
        }

        public static <S, D> StopEvent<S, D> unapply(StopEvent<S, D> stopEvent) {
            return PersistentFSM$StopEvent$.MODULE$.unapply(stopEvent);
        }

        public StopEvent(Reason reason, S currentState, D stateData) {
            this.reason = reason;
            this.currentState = currentState;
            this.stateData = stateData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StopEvent)) return false;
            StopEvent stopEvent = (StopEvent)object;
            Reason reason = this.reason();
            Reason reason2 = stopEvent.reason();
            if (reason == null) {
                if (reason2 != null) {
                    return false;
                }
            } else if (!reason.equals(reason2)) return false;
            if (!BoxesRunTime.equals(this.currentState(), stopEvent.currentState())) return false;
            if (!BoxesRunTime.equals(this.stateData(), stopEvent.stateData())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StopEvent;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "StopEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "reason";
                }
                case 1: {
                    return "currentState";
                }
                case 2: {
                    return "stateData";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Reason reason() {
            return this.reason;
        }

        public S currentState() {
            return (S)this.currentState;
        }

        public D stateData() {
            return (D)this.stateData;
        }

        public <S, D> StopEvent<S, D> copy(Reason reason, S currentState, D stateData) {
            return new StopEvent<S, D>(reason, currentState, stateData);
        }

        public <S, D> Reason copy$default$1() {
            return this.reason();
        }

        public <S, D> S copy$default$2() {
            return this.currentState();
        }

        public <S, D> D copy$default$3() {
            return this.stateData();
        }

        public Reason _1() {
            return this.reason();
        }

        public S _2() {
            return this.currentState();
        }

        public D _3() {
            return this.stateData();
        }
    }

    public static final class SubscribeTransitionCallBack
    implements Product,
    Serializable {
        private final ActorRef actorRef;

        public static SubscribeTransitionCallBack apply(ActorRef actorRef) {
            return PersistentFSM$SubscribeTransitionCallBack$.MODULE$.apply(actorRef);
        }

        public static SubscribeTransitionCallBack fromProduct(Product product) {
            return PersistentFSM$SubscribeTransitionCallBack$.MODULE$.fromProduct(product);
        }

        public static SubscribeTransitionCallBack unapply(SubscribeTransitionCallBack subscribeTransitionCallBack) {
            return PersistentFSM$SubscribeTransitionCallBack$.MODULE$.unapply(subscribeTransitionCallBack);
        }

        public SubscribeTransitionCallBack(ActorRef actorRef) {
            this.actorRef = actorRef;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribeTransitionCallBack)) return false;
            SubscribeTransitionCallBack subscribeTransitionCallBack = (SubscribeTransitionCallBack)object;
            ActorRef actorRef = this.actorRef();
            ActorRef actorRef2 = subscribeTransitionCallBack.actorRef();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubscribeTransitionCallBack;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SubscribeTransitionCallBack";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "actorRef";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef actorRef() {
            return this.actorRef;
        }

        public SubscribeTransitionCallBack copy(ActorRef actorRef) {
            return new SubscribeTransitionCallBack(actorRef);
        }

        public ActorRef copy$default$1() {
            return this.actorRef();
        }

        public ActorRef _1() {
            return this.actorRef();
        }
    }

    @InternalApi
    public static final class TimeoutMarker
    implements Product,
    Serializable {
        private final long generation;

        public static TimeoutMarker apply(long l) {
            return PersistentFSM$TimeoutMarker$.MODULE$.apply(l);
        }

        public static TimeoutMarker fromProduct(Product product) {
            return PersistentFSM$TimeoutMarker$.MODULE$.fromProduct(product);
        }

        public static TimeoutMarker unapply(TimeoutMarker timeoutMarker) {
            return PersistentFSM$TimeoutMarker$.MODULE$.unapply(timeoutMarker);
        }

        public TimeoutMarker(long generation) {
            this.generation = generation;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.generation()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TimeoutMarker)) return false;
            TimeoutMarker timeoutMarker = (TimeoutMarker)object;
            if (this.generation() != timeoutMarker.generation()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TimeoutMarker;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TimeoutMarker";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "generation";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long generation() {
            return this.generation;
        }

        public TimeoutMarker copy(long generation) {
            return new TimeoutMarker(generation);
        }

        public long copy$default$1() {
            return this.generation();
        }

        public long _1() {
            return this.generation();
        }
    }

    @InternalApi
    public static final class Timer
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final String name;
        private final Object msg;
        private final TimerMode mode;
        private final int generation;
        private final Object owner;
        private Option<Cancellable> ref;
        private final Scheduler scheduler;
        private final ExecutionContextExecutor executionContext;

        public static Timer apply(String string, Object object, TimerMode timerMode, int n, Object object2, ActorContext actorContext) {
            return PersistentFSM$Timer$.MODULE$.apply(string, object, timerMode, n, object2, actorContext);
        }

        public static Timer unapply(Timer timer) {
            return PersistentFSM$Timer$.MODULE$.unapply(timer);
        }

        public Timer(String name, Object msg, TimerMode mode, int generation, Object owner, ActorContext context) {
            this.name = name;
            this.msg = msg;
            this.mode = mode;
            this.generation = generation;
            this.owner = owner;
            this.scheduler = context.system().scheduler();
            this.executionContext = context.dispatcher();
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.msg()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.mode()));
            n = Statics.mix((int)n, (int)this.generation());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.owner()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Timer)) return false;
            Timer timer = (Timer)object;
            if (this.generation() != timer.generation()) return false;
            String string = this.name();
            String string2 = timer.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equals((Object)this.msg(), (Object)timer.msg())) return false;
            TimerMode timerMode = this.mode();
            TimerMode timerMode2 = timer.mode();
            if (timerMode == null) {
                if (timerMode2 != null) {
                    return false;
                }
            } else if (!timerMode.equals(timerMode2)) return false;
            if (!BoxesRunTime.equals((Object)this.owner(), (Object)timer.owner())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Timer;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Timer";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "msg";
                }
                case 2: {
                    return "mode";
                }
                case 3: {
                    return "generation";
                }
                case 4: {
                    return "owner";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public Object msg() {
            return this.msg;
        }

        public TimerMode mode() {
            return this.mode;
        }

        public int generation() {
            return this.generation;
        }

        public Object owner() {
            return this.owner;
        }

        public void schedule(ActorRef actor, FiniteDuration timeout) {
            Cancellable cancellable;
            Timer timer;
            Object object = this.msg();
            if (object instanceof AutoReceivedMessage) {
                AutoReceivedMessage m = (AutoReceivedMessage)object;
                timer = m;
            } else {
                timer = this;
            }
            Timer timerMsg = timer;
            TimerMode timerMode = this.mode();
            if (PersistentFSM$SingleMode$.MODULE$.equals(timerMode)) {
                cancellable = this.scheduler.scheduleOnce(timeout, actor, (Object)timerMsg, (ExecutionContext)this.executionContext, this.scheduler.scheduleOnce$default$5(timeout, actor, (Object)timerMsg));
            } else if (PersistentFSM$FixedDelayMode$.MODULE$.equals(timerMode)) {
                cancellable = this.scheduler.scheduleWithFixedDelay(timeout, timeout, actor, (Object)timerMsg, (ExecutionContext)this.executionContext, this.scheduler.scheduleWithFixedDelay$default$6(timeout, timeout, actor, (Object)timerMsg));
            } else if (PersistentFSM$FixedRateMode$.MODULE$.equals(timerMode)) {
                cancellable = this.scheduler.scheduleAtFixedRate(timeout, timeout, actor, (Object)timerMsg, (ExecutionContext)this.executionContext, this.scheduler.scheduleAtFixedRate$default$6(timeout, timeout, actor, (Object)timerMsg));
            } else {
                throw new MatchError((Object)timerMode);
            }
            this.ref = Some$.MODULE$.apply((Object)cancellable);
        }

        public void cancel() {
            if (this.ref.isDefined()) {
                ((Cancellable)this.ref.get()).cancel();
                this.ref = None$.MODULE$;
                return;
            }
        }

        public Timer copy(String name, Object msg, TimerMode mode, int generation, Object owner, ActorContext context) {
            return new Timer(name, msg, mode, generation, owner, context);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Object copy$default$2() {
            return this.msg();
        }

        public TimerMode copy$default$3() {
            return this.mode();
        }

        public int copy$default$4() {
            return this.generation();
        }

        public Object copy$default$5() {
            return this.owner();
        }

        public String _1() {
            return this.name();
        }

        public Object _2() {
            return this.msg();
        }

        public TimerMode _3() {
            return this.mode();
        }

        public int _4() {
            return this.generation();
        }

        public Object _5() {
            return this.owner();
        }
    }

    @InternalApi
    public static interface TimerMode {
        public boolean repeat();
    }

    public static final class Transition<S>
    implements Product,
    Serializable {
        private final ActorRef fsmRef;
        private final Object from;
        private final Object to;
        private final Option timeout;

        public static <S> Transition<S> apply(ActorRef actorRef, S s, S s2, Option<FiniteDuration> option) {
            return PersistentFSM$Transition$.MODULE$.apply(actorRef, s, s2, option);
        }

        public static Transition<?> fromProduct(Product product) {
            return PersistentFSM$Transition$.MODULE$.fromProduct(product);
        }

        public static <S> Transition<S> unapply(Transition<S> transition) {
            return PersistentFSM$Transition$.MODULE$.unapply(transition);
        }

        public Transition(ActorRef fsmRef, S from, S to, Option<FiniteDuration> timeout) {
            this.fsmRef = fsmRef;
            this.from = from;
            this.to = to;
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Transition)) return false;
            Transition transition = (Transition)object;
            ActorRef actorRef = this.fsmRef();
            ActorRef actorRef2 = transition.fsmRef();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            if (!BoxesRunTime.equals(this.from(), transition.from())) return false;
            if (!BoxesRunTime.equals(this.to(), transition.to())) return false;
            Option<FiniteDuration> option = this.timeout();
            Option<FiniteDuration> option2 = transition.timeout();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Transition;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Transition";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "fsmRef";
                }
                case 1: {
                    return "from";
                }
                case 2: {
                    return "to";
                }
                case 3: {
                    return "timeout";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef fsmRef() {
            return this.fsmRef;
        }

        public S from() {
            return (S)this.from;
        }

        public S to() {
            return (S)this.to;
        }

        public Option<FiniteDuration> timeout() {
            return this.timeout;
        }

        public <S> Transition<S> copy(ActorRef fsmRef, S from, S to, Option<FiniteDuration> timeout) {
            return new Transition<S>(fsmRef, from, to, timeout);
        }

        public <S> ActorRef copy$default$1() {
            return this.fsmRef();
        }

        public <S> S copy$default$2() {
            return this.from();
        }

        public <S> S copy$default$3() {
            return this.to();
        }

        public <S> Option<FiniteDuration> copy$default$4() {
            return this.timeout();
        }

        public ActorRef _1() {
            return this.fsmRef();
        }

        public S _2() {
            return this.from();
        }

        public S _3() {
            return this.to();
        }

        public Option<FiniteDuration> _4() {
            return this.timeout();
        }
    }

    public static final class UnsubscribeTransitionCallBack
    implements Product,
    Serializable {
        private final ActorRef actorRef;

        public static UnsubscribeTransitionCallBack apply(ActorRef actorRef) {
            return PersistentFSM$UnsubscribeTransitionCallBack$.MODULE$.apply(actorRef);
        }

        public static UnsubscribeTransitionCallBack fromProduct(Product product) {
            return PersistentFSM$UnsubscribeTransitionCallBack$.MODULE$.fromProduct(product);
        }

        public static UnsubscribeTransitionCallBack unapply(UnsubscribeTransitionCallBack unsubscribeTransitionCallBack) {
            return PersistentFSM$UnsubscribeTransitionCallBack$.MODULE$.unapply(unsubscribeTransitionCallBack);
        }

        public UnsubscribeTransitionCallBack(ActorRef actorRef) {
            this.actorRef = actorRef;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnsubscribeTransitionCallBack)) return false;
            UnsubscribeTransitionCallBack unsubscribeTransitionCallBack = (UnsubscribeTransitionCallBack)object;
            ActorRef actorRef = this.actorRef();
            ActorRef actorRef2 = unsubscribeTransitionCallBack.actorRef();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnsubscribeTransitionCallBack;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnsubscribeTransitionCallBack";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "actorRef";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef actorRef() {
            return this.actorRef;
        }

        public UnsubscribeTransitionCallBack copy(ActorRef actorRef) {
            return new UnsubscribeTransitionCallBack(actorRef);
        }

        public ActorRef copy$default$1() {
            return this.actorRef();
        }

        public ActorRef _1() {
            return this.actorRef();
        }
    }
}

