/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.AsyncWriteJournal;
import org.apache.pekko.persistence.journal.AsyncWriteProxy$InitTimeout$;
import org.apache.pekko.persistence.journal.AsyncWriteProxy$SetStore$;
import org.apache.pekko.persistence.journal.AsyncWriteTarget;
import org.apache.pekko.persistence.journal.AsyncWriteTarget$DeleteMessagesTo$;
import org.apache.pekko.persistence.journal.AsyncWriteTarget$ReplayMessages$;
import org.apache.pekko.persistence.journal.AsyncWriteTarget$ReplaySuccess$;
import org.apache.pekko.persistence.journal.AsyncWriteTarget$WriteMessages$;
import org.apache.pekko.persistence.journal.ReplayMediator;
import org.apache.pekko.util.Timeout;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public interface AsyncWriteProxy
extends AsyncWriteJournal,
Stash,
ActorLogging {
    public static void $init$(AsyncWriteProxy $this) {
        $this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitialized_$eq(false);
        $this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitTimedOut_$eq(false);
        $this.store_$eq((Option<ActorRef>)None$.MODULE$);
        $this.org$apache$pekko$persistence$journal$AsyncWriteProxy$_setter_$org$apache$pekko$persistence$journal$AsyncWriteProxy$$storeNotInitialized_$eq(Future$.MODULE$.failed((Throwable)new TimeoutException("Store not initialized. Use `SharedLeveldbJournal.setStore(sharedStore, system)`")));
    }

    public /* synthetic */ void org$apache$pekko$persistence$journal$AsyncWriteProxy$$super$aroundPreStart();

    public /* synthetic */ void org$apache$pekko$persistence$journal$AsyncWriteProxy$$super$aroundReceive(PartialFunction var1, Object var2);

    public boolean org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitialized();

    public void org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitialized_$eq(boolean var1);

    public boolean org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitTimedOut();

    public void org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitTimedOut_$eq(boolean var1);

    public Option<ActorRef> store();

    public void store_$eq(Option<ActorRef> var1);

    public Future<Nothing$> org$apache$pekko$persistence$journal$AsyncWriteProxy$$storeNotInitialized();

    public void org$apache$pekko$persistence$journal$AsyncWriteProxy$_setter_$org$apache$pekko$persistence$journal$AsyncWriteProxy$$storeNotInitialized_$eq(Future var1);

    public static void aroundPreStart$(AsyncWriteProxy $this) {
        $this.aroundPreStart();
    }

    default public void aroundPreStart() {
        this.context().system().scheduler().scheduleOnce(this.timeout().duration(), this.self(), (Object)AsyncWriteProxy$InitTimeout$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$super$aroundPreStart();
    }

    public static void aroundReceive$(AsyncWriteProxy $this, PartialFunction receive, Object msg) {
        $this.aroundReceive((PartialFunction<Object, BoxedUnit>)receive, msg);
    }

    default public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object msg) {
        if (this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitialized()) {
            Object object = msg;
            AsyncWriteProxy$InitTimeout$ asyncWriteProxy$InitTimeout$ = AsyncWriteProxy$InitTimeout$.MODULE$;
            if (object == null ? asyncWriteProxy$InitTimeout$ != null : !object.equals(asyncWriteProxy$InitTimeout$)) {
                this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$super$aroundReceive(receive, msg);
                return;
            }
            return;
        }
        Object object = msg;
        if (object instanceof SetStore) {
            ActorRef actorRef;
            SetStore setStore = AsyncWriteProxy$SetStore$.MODULE$.unapply((SetStore)object);
            ActorRef ref = actorRef = setStore._1();
            this.store_$eq((Option<ActorRef>)Some$.MODULE$.apply((Object)ref));
            this.unstashAll();
            this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitialized_$eq(true);
            return;
        }
        if (AsyncWriteProxy$InitTimeout$.MODULE$.equals(object)) {
            this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitTimedOut_$eq(true);
            this.unstashAll();
            return;
        }
        if (this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$isInitTimedOut()) {
            this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$super$aroundReceive(receive, msg);
            return;
        }
        this.stash();
    }

    public Timeout timeout();

    public static Future asyncWriteMessages$(AsyncWriteProxy $this, Seq messages) {
        return $this.asyncWriteMessages((Seq<AtomicWrite>)messages);
    }

    @Override
    default public Future<Seq<Try<BoxedUnit>>> asyncWriteMessages(Seq<AtomicWrite> messages) {
        Option<ActorRef> option = this.store();
        if (option instanceof Some) {
            ActorRef s = (ActorRef)((Some)option).value();
            return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(s), (Object)AsyncWriteTarget$WriteMessages$.MODULE$.apply(messages), this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(Seq.class));
        }
        if (None$.MODULE$.equals(option)) {
            return this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$storeNotInitialized();
        }
        throw new MatchError(option);
    }

    public static Future asyncDeleteMessagesTo$(AsyncWriteProxy $this, String persistenceId, long toSequenceNr) {
        return $this.asyncDeleteMessagesTo(persistenceId, toSequenceNr);
    }

    @Override
    default public Future<BoxedUnit> asyncDeleteMessagesTo(String persistenceId, long toSequenceNr) {
        Option<ActorRef> option = this.store();
        if (option instanceof Some) {
            ActorRef s = (ActorRef)((Some)option).value();
            return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(s), (Object)AsyncWriteTarget$DeleteMessagesTo$.MODULE$.apply(persistenceId, toSequenceNr), this.timeout(), this.self()).mapTo((ClassTag)ClassTag$.MODULE$.Unit());
        }
        if (None$.MODULE$.equals(option)) {
            return this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$storeNotInitialized();
        }
        throw new MatchError(option);
    }

    public static Future asyncReplayMessages$(AsyncWriteProxy $this, String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        return $this.asyncReplayMessages(persistenceId, fromSequenceNr, toSequenceNr, max, (Function1<PersistentRepr, BoxedUnit>)replayCallback);
    }

    @Override
    default public Future<BoxedUnit> asyncReplayMessages(String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1<PersistentRepr, BoxedUnit> replayCallback) {
        Option<ActorRef> option = this.store();
        if (option instanceof Some) {
            ActorRef s = (ActorRef)((Some)option).value();
            Promise replayCompletionPromise = Promise$.MODULE$.apply();
            ActorRef mediator = this.context().actorOf(Props$.MODULE$.apply(ReplayMediator.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{replayCallback, replayCompletionPromise, this.timeout().duration()})).withDeploy(Deploy$.MODULE$.local()));
            s.tell((Object)AsyncWriteTarget$ReplayMessages$.MODULE$.apply(persistenceId, fromSequenceNr, toSequenceNr, max), mediator);
            return replayCompletionPromise.future();
        }
        if (None$.MODULE$.equals(option)) {
            return this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$storeNotInitialized();
        }
        throw new MatchError(option);
    }

    public static Future asyncReadHighestSequenceNr$(AsyncWriteProxy $this, String persistenceId, long fromSequenceNr) {
        return $this.asyncReadHighestSequenceNr(persistenceId, fromSequenceNr);
    }

    @Override
    default public Future<Object> asyncReadHighestSequenceNr(String persistenceId, long fromSequenceNr) {
        Option<ActorRef> option = this.store();
        if (option instanceof Some) {
            ActorRef s = (ActorRef)((Some)option).value();
            return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(s), (Object)AsyncWriteTarget$ReplayMessages$.MODULE$.apply(persistenceId, 0L, 0L, 0L), this.timeout(), this.self()).map((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (object instanceof AsyncWriteTarget.ReplaySuccess) {
                    long l;
                    AsyncWriteTarget.ReplaySuccess replaySuccess = AsyncWriteTarget$ReplaySuccess$.MODULE$.unapply((AsyncWriteTarget.ReplaySuccess)object);
                    long highest = l = replaySuccess._1();
                    return highest;
                }
                throw new RuntimeException();
            }, (ExecutionContext)this.context().dispatcher());
        }
        if (None$.MODULE$.equals(option)) {
            return this.org$apache$pekko$persistence$journal$AsyncWriteProxy$$storeNotInitialized();
        }
        throw new MatchError(option);
    }

    public static final class SetStore
    implements Product,
    Serializable {
        private final ActorRef ref;

        public static SetStore apply(ActorRef actorRef) {
            return AsyncWriteProxy$SetStore$.MODULE$.apply(actorRef);
        }

        public static SetStore fromProduct(Product product) {
            return AsyncWriteProxy$SetStore$.MODULE$.fromProduct(product);
        }

        public static SetStore unapply(SetStore setStore) {
            return AsyncWriteProxy$SetStore$.MODULE$.unapply(setStore);
        }

        public SetStore(ActorRef ref) {
            this.ref = ref;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SetStore)) return false;
            SetStore setStore = (SetStore)object;
            ActorRef actorRef = this.ref();
            ActorRef actorRef2 = setStore.ref();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SetStore;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SetStore";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ref";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef ref() {
            return this.ref;
        }

        public SetStore copy(ActorRef ref) {
            return new SetStore(ref);
        }

        public ActorRef copy$default$1() {
            return this.ref();
        }

        public ActorRef _1() {
            return this.ref();
        }
    }
}

