/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.journal.EventAdapter;
import org.apache.pekko.persistence.journal.EventAdapters$;
import org.apache.pekko.persistence.journal.EventAdapters$CombinedReadEventAdapter$;
import org.apache.pekko.persistence.journal.EventSeq;
import org.apache.pekko.persistence.journal.EventSeq$;
import org.apache.pekko.persistence.journal.IdentityEventAdapter$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public class EventAdapters {
    private final ConcurrentHashMap<Class<?>, EventAdapter> map;
    private final Seq<Tuple2<Class<?>, EventAdapter>> bindings;
    private final LoggingAdapter log;

    public static EventAdapters apply(ExtendedActorSystem extendedActorSystem, Config config) {
        return EventAdapters$.MODULE$.apply(extendedActorSystem, config);
    }

    public static Try<EventAdapter> instantiateAdapter(String string, ExtendedActorSystem extendedActorSystem) {
        return EventAdapters$.MODULE$.instantiateAdapter(string, extendedActorSystem);
    }

    public EventAdapters(ConcurrentHashMap<Class<?>, EventAdapter> map, Seq<Tuple2<Class<?>, EventAdapter>> bindings, LoggingAdapter log) {
        this.map = map;
        this.bindings = bindings;
        this.log = log;
    }

    public EventAdapter get(Class<?> clazz) {
        EventAdapter eventAdapter = this.map.get(clazz);
        if (eventAdapter == null) {
            EventAdapter eventAdapter2;
            Tuple2 tuple2;
            Tuple2 tuple22;
            Option option;
            Seq seq = (Seq)this.bindings.filter((Function1 & Serializable)_$1 -> ((Class)_$1._1()).isAssignableFrom(clazz));
            if (seq != null && !(option = package$.MODULE$.$plus$colon().unapply((SeqOps)seq)).isEmpty() && (tuple22 = (Tuple2)(tuple2 = (Tuple2)option.get())._1()) != null) {
                EventAdapter bestMatch = (EventAdapter)tuple22._2();
                eventAdapter2 = bestMatch;
            } else {
                eventAdapter2 = IdentityEventAdapter$.MODULE$;
            }
            IdentityEventAdapter$ value = eventAdapter2;
            EventAdapter eventAdapter3 = this.map.putIfAbsent(clazz, value);
            if (eventAdapter3 == null) {
                this.log.debug("Using EventAdapter: {} for event [{}]", (Object)value.getClass().getName(), (Object)clazz.getName());
                return value;
            }
            EventAdapter some = eventAdapter3;
            return some;
        }
        EventAdapter value = eventAdapter;
        return value;
    }

    public String toString() {
        return new StringBuilder(4).append(this.getClass().getName()).append("(").append(this.map).append(", ").append(this.bindings).append(")").toString();
    }

    public static class CombinedReadEventAdapter
    implements EventAdapter,
    Product,
    Serializable {
        private final Seq adapters;

        public static CombinedReadEventAdapter apply(Seq<EventAdapter> seq) {
            return EventAdapters$CombinedReadEventAdapter$.MODULE$.apply(seq);
        }

        public static CombinedReadEventAdapter fromProduct(Product product) {
            return EventAdapters$CombinedReadEventAdapter$.MODULE$.fromProduct(product);
        }

        public static CombinedReadEventAdapter unapply(CombinedReadEventAdapter combinedReadEventAdapter) {
            return EventAdapters$CombinedReadEventAdapter$.MODULE$.unapply(combinedReadEventAdapter);
        }

        public CombinedReadEventAdapter(Seq<EventAdapter> adapters) {
            this.adapters = adapters;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CombinedReadEventAdapter)) return false;
            CombinedReadEventAdapter combinedReadEventAdapter = (CombinedReadEventAdapter)object;
            Seq<EventAdapter> seq = this.adapters();
            Seq<EventAdapter> seq2 = combinedReadEventAdapter.adapters();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!combinedReadEventAdapter.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CombinedReadEventAdapter;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CombinedReadEventAdapter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "adapters";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<EventAdapter> adapters() {
            return this.adapters;
        }

        private IllegalStateException onlyReadSideException() {
            return new IllegalStateException("CombinedReadEventAdapter must not be used when writing (creating manifests) events!");
        }

        @Override
        public String manifest(Object event) {
            throw this.onlyReadSideException();
        }

        @Override
        public Object toJournal(Object event) {
            throw this.onlyReadSideException();
        }

        @Override
        public EventSeq fromJournal(Object event, String manifest) {
            return EventSeq$.MODULE$.apply((Seq<Object>)((Seq)this.adapters().flatMap((Function1 & Serializable)_$2 -> _$2.fromJournal(event, manifest).events())));
        }

        public String toString() {
            return new StringBuilder(26).append("CombinedReadEventAdapter(").append(((IterableOnceOps)this.adapters().map((Function1 & Serializable)_$3 -> _$3.getClass().getCanonicalName())).mkString(",")).append(")").toString();
        }

        public CombinedReadEventAdapter copy(Seq<EventAdapter> adapters) {
            return new CombinedReadEventAdapter(adapters);
        }

        public Seq<EventAdapter> copy$default$1() {
            return this.adapters();
        }

        public Seq<EventAdapter> _1() {
            return this.adapters();
        }
    }
}

