/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorIdentity;
import org.apache.pekko.actor.ActorIdentity$;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Identify$;
import org.apache.pekko.actor.ReceiveTimeout$;
import org.apache.pekko.actor.RootActorPath$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.DeleteMessagesFailure$;
import org.apache.pekko.persistence.DeleteSnapshotFailure$;
import org.apache.pekko.persistence.DeleteSnapshotsFailure$;
import org.apache.pekko.persistence.JournalProtocol;
import org.apache.pekko.persistence.JournalProtocol$DeleteMessagesTo$;
import org.apache.pekko.persistence.JournalProtocol$LoopMessageSuccess$;
import org.apache.pekko.persistence.JournalProtocol$ReplayMessages$;
import org.apache.pekko.persistence.JournalProtocol$ReplayMessagesFailure$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessageFailure$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessages$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessagesFailed$;
import org.apache.pekko.persistence.NonPersistentRepr;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistentEnvelope;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.SaveSnapshotFailure$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotProtocol;
import org.apache.pekko.persistence.SnapshotProtocol$DeleteSnapshot$;
import org.apache.pekko.persistence.SnapshotProtocol$DeleteSnapshots$;
import org.apache.pekko.persistence.SnapshotProtocol$LoadSnapshotFailed$;
import org.apache.pekko.persistence.SnapshotProtocol$SaveSnapshot$;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.journal.PersistencePluginProxy$;
import org.apache.pekko.persistence.journal.PersistencePluginProxy$InitTimeout$;
import org.apache.pekko.persistence.journal.PersistencePluginProxy$Journal$;
import org.apache.pekko.persistence.journal.PersistencePluginProxy$SnapshotStore$;
import org.apache.pekko.persistence.journal.PersistencePluginProxy$TargetLocation$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class PersistencePluginProxy
implements Actor,
StashSupport,
UnrestrictedStash,
Stash,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final Config config;
    private final String pluginId;
    public final PluginType org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType;
    public final FiniteDuration org$apache$pekko$persistence$journal$PersistencePluginProxy$$initTimeout;
    public final String org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId;
    private final boolean startTarget;
    public final Address org$apache$pekko$persistence$journal$PersistencePluginProxy$$selfAddress;

    public static void setTargetLocation(ActorSystem actorSystem, Address address) {
        PersistencePluginProxy$.MODULE$.setTargetLocation(actorSystem, address);
    }

    public static void start(ActorSystem actorSystem) {
        PersistencePluginProxy$.MODULE$.start(actorSystem);
    }

    public PersistencePluginProxy(Config config) {
        Mirror.Singleton singleton;
        this.config = config;
        Actor.$init$((Actor)this);
        StashSupport.$init$((StashSupport)this);
        ActorLogging.$init$((ActorLogging)this);
        String string = this.pluginId = this.self().path().name();
        if ("pekko.persistence.journal.proxy".equals(string)) {
            singleton = PersistencePluginProxy$Journal$.MODULE$;
        } else if ("pekko.persistence.snapshot-store.proxy".equals(string)) {
            singleton = PersistencePluginProxy$SnapshotStore$.MODULE$;
        } else {
            String other = string;
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown plugin type: ").append(other).toString());
        }
        this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType = singleton;
        this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$initTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("init-timeout", package$.MODULE$.MILLISECONDS()))).millis();
        String key = new StringBuilder(14).append("target-").append(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier()).append("-plugin").toString();
        String string2 = (String)Helpers$.MODULE$.Requiring((Object)config.getString(key));
        this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId = (String)Helpers.Requiring$.MODULE$.requiring$extension((Object)string2, (Function1 & Serializable)_$1 -> {
            String string = _$1;
            String string2 = "";
            return string == null ? string2 != null : !string.equals(string2);
        }, () -> this.$init$$$anonfun$2(key));
        this.startTarget = config.getBoolean(new StringBuilder(13).append("start-target-").append(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier()).toString());
        this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$selfAddress = ((ExtendedActorSystem)this.context().system()).provider().getDefaultAddress();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$((Actor)this);
    }

    public void preStart() {
        String targetAddress;
        if (this.startTarget) {
            ActorRef actorRef;
            PluginType pluginType = this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType;
            if (PersistencePluginProxy$Journal$.MODULE$.equals(pluginType)) {
                this.log().info("Starting target journal [{}]", (Object)this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId);
                Persistence persistence = (Persistence)Persistence$.MODULE$.apply(this.context().system());
                actorRef = persistence.journalFor(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId, persistence.journalFor$default$2());
            } else if (PersistencePluginProxy$SnapshotStore$.MODULE$.equals(pluginType)) {
                this.log().info("Starting target snapshot-store [{}]", (Object)this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId);
                Persistence persistence = (Persistence)Persistence$.MODULE$.apply(this.context().system());
                actorRef = persistence.snapshotStoreFor(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId, persistence.snapshotStoreFor$default$2());
            } else {
                throw new MatchError((Object)pluginType);
            }
            ActorRef target = actorRef;
            this.context().become(this.active(target, true));
            return;
        }
        String targetAddressKey = new StringBuilder(15).append("target-").append(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier()).append("-address").toString();
        String string = targetAddress = this.config.getString(targetAddressKey);
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            try {
                this.log().info("Setting target {} address to {}", (Object)this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier(), (Object)targetAddress);
                PersistencePluginProxy$.MODULE$.setTargetLocation(this.context().system(), AddressFromURIString$.MODULE$.apply(targetAddress));
            }
            catch (URISyntaxException uRISyntaxException) {
                this.log().warning("Invalid URL provided for target {} address: {}", (Object)this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier(), (Object)targetAddress);
            }
        }
        Scheduler scheduler = this.context().system().scheduler();
        scheduler.scheduleOnce(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$initTimeout, this.self(), (Object)PersistencePluginProxy$InitTimeout$.MODULE$, (ExecutionContext)this.context().dispatcher(), scheduler.scheduleOnce$default$5(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$initTimeout, this.self(), (Object)PersistencePluginProxy$InitTimeout$.MODULE$));
    }

    public TimeoutException org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException() {
        return new TimeoutException(new StringBuilder(25).append("Target ").append(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier()).append(" not initialized. ").append(new StringBuilder(71).append("Use `PersistencePluginProxy.setTargetLocation` or set `target-").append(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier()).append("-address`").toString()).toString());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.init();
    }

    public PartialFunction<Object, BoxedUnit> init() {
        return new Serializable(this){
            private final /* synthetic */ PersistencePluginProxy $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof TargetLocation) {
                    Address address;
                    TargetLocation targetLocation = PersistencePluginProxy$TargetLocation$.MODULE$.unapply((TargetLocation)object);
                    Address address2 = address = targetLocation._1();
                    return true;
                }
                if (PersistencePluginProxy$InitTimeout$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof TargetLocation) {
                    Address address;
                    TargetLocation targetLocation = PersistencePluginProxy$TargetLocation$.MODULE$.unapply((TargetLocation)object);
                    Address address2 = address = targetLocation._1();
                    this.$outer.context().setReceiveTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
                    this.$outer.context().become(this.$outer.identifying(address2));
                } else if (PersistencePluginProxy$InitTimeout$.MODULE$.equals(object)) {
                    this.$outer.log().info("Initialization timed-out (after {}), Use `PersistencePluginProxy.setTargetLocation` or set `target-{}-address`", (Object)this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$initTimeout, (Object)this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier());
                    this.$outer.context().become(this.$outer.initTimedOut());
                    this.$outer.unstashAll();
                } else if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                } else {
                    this.$outer.stash();
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public void becomeIdentifying(Address address) {
        this.sendIdentify(address);
        this.context().setReceiveTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        this.context().become(this.identifying(address));
    }

    public void sendIdentify(Address address) {
        ActorSelection sel = this.context().actorSelection(RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div("system").$div(this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId));
        this.log().info("Trying to identify target {} at {}", (Object)this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier(), (Object)sel);
        ActorSelection$.MODULE$.toScala(sel).$bang((Object)Identify$.MODULE$.apply((Object)this.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId), this.self());
    }

    public PartialFunction<Object, BoxedUnit> identifying(Address address) {
        return new Serializable(address, this){
            private final Address address$1;
            private final /* synthetic */ PersistencePluginProxy $outer;
            {
                this.address$1 = address$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ActorIdentity) {
                    ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)object);
                    Object object2 = actorIdentity._1();
                    Option option = actorIdentity._2();
                    String string = this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId;
                    Object object3 = object2;
                    if (!(string != null ? !string.equals(object3) : object3 != null) && option instanceof Some) {
                        ActorRef target = (ActorRef)((Some)option).value();
                        return true;
                    }
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ActorIdentity) {
                    ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)object);
                    Object object2 = actorIdentity._1();
                    Option option = actorIdentity._2();
                    String string = this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$targetPluginId;
                    Object object3 = object2;
                    if (!(string != null ? !string.equals(object3) : object3 != null) && option instanceof Some) {
                        ActorRef target = (ActorRef)((Some)option).value();
                        this.$outer.log().info("Found target {} at [{}]", (Object)this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$pluginType.qualifier(), (Object)this.address$1);
                        this.$outer.context().setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
                        this.$outer.context().watch(target);
                        this.$outer.unstashAll();
                        Address address = this.address$1;
                        Address address2 = this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$selfAddress;
                        this.$outer.context().become(this.$outer.active(target, !(address != null ? !address.equals(address2) : address2 != null)));
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(object)) {
                    this.$outer.sendIdentify(this.address$1);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        }.orElse(this.init());
    }

    public PartialFunction<Object, BoxedUnit> active(ActorRef targetJournal, boolean targetAtThisNode) {
        return new Serializable(targetJournal, targetAtThisNode, this){
            private final ActorRef targetJournal$1;
            private final boolean targetAtThisNode$1;
            private final /* synthetic */ PersistencePluginProxy $outer;
            {
                this.targetJournal$1 = targetJournal$2;
                this.targetAtThisNode$1 = targetAtThisNode$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof TargetLocation) {
                    Address address;
                    TargetLocation targetLocation = PersistencePluginProxy$TargetLocation$.MODULE$.unapply((TargetLocation)object);
                    Address address2 = address = targetLocation._1();
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    ActorRef actorRef2 = this.targetJournal$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null)) {
                        return true;
                    }
                    return true;
                }
                if (PersistencePluginProxy$InitTimeout$.MODULE$.equals(object)) {
                    return true;
                }
                Object msg = object;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                block2: {
                    Object object;
                    block3: {
                        block1: {
                            Address address;
                            object = x;
                            if (!(object instanceof TargetLocation)) break block1;
                            TargetLocation targetLocation = PersistencePluginProxy$TargetLocation$.MODULE$.unapply((TargetLocation)object);
                            Address address2 = address = targetLocation._1();
                            if (!this.targetAtThisNode$1) break block2;
                            Address address3 = address2;
                            Address address4 = this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$selfAddress;
                            if (address3 == null ? address4 != null : !address3.equals(address4)) {
                                this.$outer.becomeIdentifying(address2);
                            }
                            break block2;
                        }
                        if (!(object instanceof Terminated)) break block3;
                        Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                        ActorRef actorRef = terminated._1();
                        ActorRef actorRef2 = this.targetJournal$1;
                        ActorRef actorRef3 = actorRef;
                        if (actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null) break block2;
                        this.$outer.context().unwatch(this.targetJournal$1);
                        this.$outer.context().become(this.$outer.initTimedOut());
                        break block2;
                    }
                    if (PersistencePluginProxy$InitTimeout$.MODULE$.equals(object)) break block2;
                    Object msg = object;
                    this.targetJournal$1.forward(msg, this.$outer.context());
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> initTimedOut() {
        return new Serializable(this){
            private final /* synthetic */ PersistencePluginProxy $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof JournalProtocol.Request) {
                    JournalProtocol.Request req = (JournalProtocol.Request)object;
                    return true;
                }
                if (object instanceof SnapshotProtocol.Request) {
                    SnapshotProtocol.Request req = (SnapshotProtocol.Request)object;
                    return true;
                }
                if (object instanceof TargetLocation) {
                    Address address;
                    TargetLocation targetLocation = PersistencePluginProxy$TargetLocation$.MODULE$.unapply((TargetLocation)object);
                    Address address2 = address = targetLocation._1();
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return true;
                }
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof JournalProtocol.Request) {
                    JournalProtocol.Request req = (JournalProtocol.Request)object;
                    JournalProtocol.Request request = req;
                    if (request instanceof JournalProtocol.WriteMessages) {
                        JournalProtocol.WriteMessages writeMessages = JournalProtocol$WriteMessages$.MODULE$.unapply((JournalProtocol.WriteMessages)request);
                        Seq<PersistentEnvelope> seq = writeMessages._1();
                        ActorRef actorRef = writeMessages._2();
                        int n = writeMessages._3();
                        Seq<PersistentEnvelope> messages = seq;
                        ActorRef persistentActor = actorRef;
                        int actorInstanceId = n;
                        int atomicWriteCount = messages.count(PersistencePluginProxy::org$apache$pekko$persistence$journal$PersistencePluginProxy$$anon$4$$_$_$$anonfun$1);
                        persistentActor.$bang((Object)JournalProtocol$WriteMessagesFailed$.MODULE$.apply(this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException(), atomicWriteCount), this.$outer.self());
                        messages.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                            PersistentEnvelope persistentEnvelope = x$1;
                            if (persistentEnvelope instanceof AtomicWrite) {
                                AtomicWrite a = (AtomicWrite)persistentEnvelope;
                                a.payload().foreach((Function1)(JProcedure1 & Serializable)p -> persistentActor.$bang((Object)JournalProtocol$WriteMessageFailure$.MODULE$.apply((PersistentRepr)p, this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException(), actorInstanceId), this.$outer.self()));
                                return;
                            }
                            if (persistentEnvelope instanceof NonPersistentRepr) {
                                NonPersistentRepr r = (NonPersistentRepr)persistentEnvelope;
                                persistentActor.$bang((Object)JournalProtocol$LoopMessageSuccess$.MODULE$.apply(r.payload(), actorInstanceId), this.$outer.self());
                                return;
                            }
                            throw new MatchError((Object)persistentEnvelope);
                        });
                        return BoxedUnit.UNIT;
                    } else if (request instanceof JournalProtocol.ReplayMessages) {
                        ActorRef actorRef;
                        JournalProtocol.ReplayMessages replayMessages = JournalProtocol$ReplayMessages$.MODULE$.unapply((JournalProtocol.ReplayMessages)request);
                        long l = replayMessages._1();
                        long l2 = replayMessages._2();
                        long l3 = replayMessages._3();
                        String string = replayMessages._4();
                        ActorRef persistentActor = actorRef = replayMessages._5();
                        persistentActor.$bang((Object)JournalProtocol$ReplayMessagesFailure$.MODULE$.apply(this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException()), this.$outer.self());
                        return BoxedUnit.UNIT;
                    } else {
                        if (!(request instanceof JournalProtocol.DeleteMessagesTo)) throw new MatchError((Object)request);
                        JournalProtocol.DeleteMessagesTo deleteMessagesTo = JournalProtocol$DeleteMessagesTo$.MODULE$.unapply((JournalProtocol.DeleteMessagesTo)request);
                        String string = deleteMessagesTo._1();
                        long l = deleteMessagesTo._2();
                        ActorRef actorRef = deleteMessagesTo._3();
                        long toSequenceNr = l;
                        ActorRef persistentActor = actorRef;
                        persistentActor.$bang((Object)DeleteMessagesFailure$.MODULE$.apply(this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException(), toSequenceNr), this.$outer.self());
                    }
                    return BoxedUnit.UNIT;
                } else if (object instanceof SnapshotProtocol.Request) {
                    SnapshotProtocol.Request req = (SnapshotProtocol.Request)object;
                    SnapshotProtocol.Request request = req;
                    if (request instanceof SnapshotProtocol.LoadSnapshot) {
                        this.$outer.sender().$bang((Object)SnapshotProtocol$LoadSnapshotFailed$.MODULE$.apply(this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException()), this.$outer.self());
                        return BoxedUnit.UNIT;
                    } else if (request instanceof SnapshotProtocol.SaveSnapshot) {
                        SnapshotProtocol.SaveSnapshot saveSnapshot = SnapshotProtocol$SaveSnapshot$.MODULE$.unapply((SnapshotProtocol.SaveSnapshot)request);
                        SnapshotMetadata snapshotMetadata = saveSnapshot._1();
                        Object object2 = saveSnapshot._2();
                        SnapshotMetadata metadata = snapshotMetadata;
                        this.$outer.sender().$bang((Object)SaveSnapshotFailure$.MODULE$.apply(metadata, this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException()), this.$outer.self());
                        return BoxedUnit.UNIT;
                    } else if (request instanceof SnapshotProtocol.DeleteSnapshot) {
                        SnapshotMetadata snapshotMetadata;
                        SnapshotProtocol.DeleteSnapshot deleteSnapshot = SnapshotProtocol$DeleteSnapshot$.MODULE$.unapply((SnapshotProtocol.DeleteSnapshot)request);
                        SnapshotMetadata metadata = snapshotMetadata = deleteSnapshot._1();
                        this.$outer.sender().$bang((Object)DeleteSnapshotFailure$.MODULE$.apply(metadata, this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException()), this.$outer.self());
                        return BoxedUnit.UNIT;
                    } else {
                        SnapshotSelectionCriteria snapshotSelectionCriteria;
                        if (!(request instanceof SnapshotProtocol.DeleteSnapshots)) throw new MatchError((Object)request);
                        SnapshotProtocol.DeleteSnapshots deleteSnapshots = SnapshotProtocol$DeleteSnapshots$.MODULE$.unapply((SnapshotProtocol.DeleteSnapshots)request);
                        String string = deleteSnapshots._1();
                        SnapshotSelectionCriteria criteria = snapshotSelectionCriteria = deleteSnapshots._2();
                        this.$outer.sender().$bang((Object)DeleteSnapshotsFailure$.MODULE$.apply(criteria, this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException()), this.$outer.self());
                    }
                    return BoxedUnit.UNIT;
                } else if (object instanceof TargetLocation) {
                    Address address;
                    TargetLocation targetLocation = PersistencePluginProxy$TargetLocation$.MODULE$.unapply((TargetLocation)object);
                    Address address2 = address = targetLocation._1();
                    this.$outer.becomeIdentifying(address2);
                    return BoxedUnit.UNIT;
                } else if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return BoxedUnit.UNIT;
                } else {
                    TimeoutException e = this.$outer.org$apache$pekko$persistence$journal$PersistencePluginProxy$$timeoutException();
                    this.$outer.log().error((Throwable)e, "Failed PersistencePluginProxy request: {}", (Object)e.getMessage());
                }
                return BoxedUnit.UNIT;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$persistence$journal$PersistencePluginProxy$$anon$4$$_$_$$anonfun$1(org.apache.pekko.persistence.PersistentEnvelope ), applyOrElse$$anonfun$1(int org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentEnvelope ), applyOrElse$$anonfun$1$$anonfun$1(int org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentRepr )}, serializedLambda);
            }
        };
    }

    private final Object $init$$$anonfun$2(String key$1) {
        return new StringBuilder(17).append(this.pluginId).append(".").append(key$1).append(" must be defined").toString();
    }

    public static final /* synthetic */ boolean org$apache$pekko$persistence$journal$PersistencePluginProxy$$anon$4$$_$_$$anonfun$1(PersistentEnvelope _$2) {
        return _$2 instanceof AtomicWrite;
    }

    public static interface PluginType {
        public String qualifier();
    }

    public static final class TargetLocation
    implements Product,
    Serializable {
        private final Address address;

        public static TargetLocation apply(Address address) {
            return PersistencePluginProxy$TargetLocation$.MODULE$.apply(address);
        }

        public static TargetLocation fromProduct(Product product) {
            return PersistencePluginProxy$TargetLocation$.MODULE$.fromProduct(product);
        }

        public static TargetLocation unapply(TargetLocation targetLocation) {
            return PersistencePluginProxy$TargetLocation$.MODULE$.unapply(targetLocation);
        }

        public TargetLocation(Address address) {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TargetLocation)) return false;
            TargetLocation targetLocation = (TargetLocation)object;
            Address address = this.address();
            Address address2 = targetLocation.address();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TargetLocation;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TargetLocation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address address() {
            return this.address;
        }

        public TargetLocation copy(Address address) {
            return new TargetLocation(address);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public Address _1() {
            return this.address();
        }
    }
}

