/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.persistence.journal.EventAdapter;
import org.apache.pekko.persistence.journal.EventAdapters;
import org.apache.pekko.persistence.journal.EventAdapters$CombinedReadEventAdapter$;
import org.apache.pekko.persistence.journal.IdentityEventAdapters$;
import org.apache.pekko.persistence.journal.NoopReadEventAdapter$;
import org.apache.pekko.persistence.journal.NoopWriteEventAdapter$;
import org.apache.pekko.persistence.journal.ReadEventAdapter;
import org.apache.pekko.persistence.journal.WriteEventAdapter;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;

public final class EventAdapters$
implements Serializable {
    public static final EventAdapters$CombinedReadEventAdapter$ CombinedReadEventAdapter;
    public static final EventAdapters$ MODULE$;

    private EventAdapters$() {
    }

    static {
        MODULE$ = new EventAdapters$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EventAdapters$.class);
    }

    public EventAdapters apply(ExtendedActorSystem system, Config config) {
        Map<String, String> adapters = this.configToMap(config, "event-adapters");
        Map<String, Seq<String>> adapterBindings = this.configToListMap(config, "event-adapter-bindings");
        if (adapters.isEmpty() && adapterBindings.isEmpty()) {
            return IdentityEventAdapters$.MODULE$;
        }
        return this.apply(system, adapters, adapterBindings);
    }

    private EventAdapters apply(ExtendedActorSystem system, Map<String, String> adapters, Map<String, Seq<String>> adapterBindings) {
        Set adapterNames = adapters.keys().toSet();
        adapterBindings.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String fqn = (String)tuple2._1();
                Seq boundToAdapters = (Seq)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String fqn = (String)tuple2._1();
                Seq boundToAdapters = (Seq)tuple2._2();
                boundToAdapters.foreach((Function1)(JProcedure1 & Serializable)boundAdapter -> Predef$.MODULE$.require(adapterNames.apply((Object)boundAdapter.toString()), () -> this.apply$$anonfun$2$$anonfun$1$$anonfun$1(fqn, boundAdapter, boundToAdapters, adapters)));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Map handlers = (Map)adapters.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                if (string != null) {
                    String k = string;
                    if (string2 != null) {
                        String v = string2;
                        return true;
                    }
                }
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                if (string != null) {
                    String k = string;
                    if (string2 != null) {
                        String v = string2;
                        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, this.instantiateAdapter(v, system).get());
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Map bs = (Map)adapterBindings.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                if (string != null) {
                    String k = string;
                    if (seq instanceof Seq) {
                        Seq as = seq;
                        return true;
                    }
                }
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                if (string != null) {
                    String k = string;
                    if (seq instanceof Seq) {
                        Seq as = seq;
                        if (as.size() == 1) {
                            return Tuple2$.MODULE$.apply(system.dynamicAccess().getClassFor(k, ClassTag$.MODULE$.Any()).get(), handlers.apply(as.head()));
                        }
                        return Tuple2$.MODULE$.apply(system.dynamicAccess().getClassFor(k, ClassTag$.MODULE$.Any()).get(), (Object)NoopWriteEventAdapter$.MODULE$.apply(EventAdapters$CombinedReadEventAdapter$.MODULE$.apply((Seq<EventAdapter>)((Seq)as.map((Function1)handlers)))));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Seq bindings = this.sort((Iterable)bs);
        ConcurrentHashMap backing = (ConcurrentHashMap)bindings.foldLeft(new ConcurrentHashMap(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                ConcurrentHashMap map = (ConcurrentHashMap)tuple2._1();
                if (tuple22 != null) {
                    Class c = (Class)tuple22._1();
                    EventAdapter s = (EventAdapter)tuple22._2();
                    map.put(c, s);
                    return map;
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return new EventAdapters(backing, bindings, Logging$.MODULE$.apply((ActorSystem)system, EventAdapters.class, LogSource$.MODULE$.fromAnyClass()));
    }

    public Try<EventAdapter> instantiateAdapter(String adapterFQN, ExtendedActorSystem system) {
        Class clazz = (Class)system.dynamicAccess().getClassFor(adapterFQN, ClassTag$.MODULE$.Any()).get();
        if (EventAdapter.class.isAssignableFrom(clazz)) {
            return this.instantiate(adapterFQN, system, ClassTag$.MODULE$.apply(EventAdapter.class));
        }
        if (WriteEventAdapter.class.isAssignableFrom(clazz)) {
            return this.instantiate(adapterFQN, system, ClassTag$.MODULE$.apply(WriteEventAdapter.class)).map((Function1 & Serializable)writeEventAdapter -> NoopReadEventAdapter$.MODULE$.apply((WriteEventAdapter)writeEventAdapter));
        }
        if (ReadEventAdapter.class.isAssignableFrom(clazz)) {
            return this.instantiate(adapterFQN, system, ClassTag$.MODULE$.apply(ReadEventAdapter.class)).map((Function1 & Serializable)readEventAdapter -> NoopWriteEventAdapter$.MODULE$.apply((ReadEventAdapter)readEventAdapter));
        }
        throw new IllegalArgumentException(new StringBuilder(58).append("Configured ").append(adapterFQN).append(" does not implement any EventAdapter interface!").toString());
    }

    private <T> Try<T> instantiate(String fqn, ExtendedActorSystem system, ClassTag<T> evidence$1) {
        Object[] objectArray = new Tuple2[1];
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)system);
        return system.dynamicAccess().createInstanceFor(fqn, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), evidence$1).recoverWith((PartialFunction)new Serializable(system, fqn, evidence$1, this){
            private final ExtendedActorSystem system$3;
            private final String fqn$3;
            private final ClassTag evidence$1$1;
            {
                this.system$3 = system$4;
                this.fqn$3 = fqn$4;
                this.evidence$1$1 = evidence$1$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchMethodException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchMethodException) {
                    return this.system$3.dynamicAccess().createInstanceFor(this.fqn$3, (Seq)package$.MODULE$.Nil(), this.evidence$1$1);
                }
                return function1.apply((Object)x);
            }
        });
    }

    private <T> Seq<Tuple2<Class<?>, T>> sort(Iterable<Tuple2<Class<?>, T>> in) {
        return (Seq)((IterableOnceOps)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable)(buf, ca) -> {
            Buffer buffer;
            int n = buf.indexWhere((Function1 & Serializable)_$4 -> ((Class)_$4._1()).isAssignableFrom((Class)ca._1()));
            if (-1 == n) {
                buffer = buf.append(ca);
            } else {
                int x = n;
                buf.insert(x, ca);
                buffer = BoxedUnit.UNIT;
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    private final Map<String, String> configToMap(Config config, String path) {
        if (config.hasPath(path)) {
            return (Map)package.JavaConverters$.MODULE$.MapHasAsScala(config.getConfig(path).root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v.toString());
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return Predef$.MODULE$.Map().empty();
    }

    private final Map<String, Seq<String>> configToListMap(Config config, String path) {
        if (config.hasPath(path)) {
            return (Map)package.JavaConverters$.MODULE$.MapHasAsScala(config.getConfig(path).root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ArrayList v;
                    String string = (String)tuple2._1();
                    Object object = tuple2._2();
                    String k = string;
                    if (object instanceof ArrayList && (v = (ArrayList)object) != null) {
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)((IterableOnceOps)package.JavaConverters$.MODULE$.ListHasAsScala((List)v).asScala().map((Function1 & Serializable)_$5 -> _$5.toString())).toList());
                    }
                    String k2 = string;
                    Object v2 = object;
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)k2);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{v2.toString()})));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return Predef$.MODULE$.Map().empty();
    }

    private final Object apply$$anonfun$2$$anonfun$1$$anonfun$1(String fqn$2, String boundAdapter$1, Seq boundToAdapters$2, Map adapters$3) {
        return new StringBuilder(70).append(fqn$2).append(" was bound to undefined event-adapter: ").append(boundAdapter$1).append(" (bindings: ").append(boundToAdapters$2.mkString("[", ", ", "]")).append(", known adapters: ").append(adapters$3.keys().mkString()).append(")").toString();
    }
}

