/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal.leveldb;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.persistence.journal.leveldb.Key;
import scala.Product;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Key$
implements Mirror.Product,
Serializable {
    public static final Key$ MODULE$ = new Key$();

    private Key$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Key$.class);
    }

    public Key apply(int persistenceId, long sequenceNr, int mappingId) {
        return new Key(persistenceId, sequenceNr, mappingId);
    }

    public Key unapply(Key x$1) {
        return x$1;
    }

    public byte[] keyToBytes(Key key) {
        ByteBuffer bb = ByteBuffer.allocate(20);
        bb.putInt(key.persistenceId());
        bb.putLong(key.sequenceNr());
        bb.putInt(key.mappingId());
        return bb.array();
    }

    public Key keyFromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        int aid = bb.getInt();
        long snr = bb.getLong();
        int mid = bb.getInt();
        return new Key(aid, snr, mid);
    }

    public Key counterKey(int persistenceId) {
        return this.apply(persistenceId, 0L, 0);
    }

    public byte[] counterToBytes(long ctr) {
        return ByteBuffer.allocate(8).putLong(ctr).array();
    }

    public long counterFromBytes(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    public Key mappingKey(int id) {
        return this.apply(1, 0L, id);
    }

    public boolean isMappingKey(Key key) {
        return key.persistenceId() == 1;
    }

    public Key deletionKey(int persistenceId, long sequenceNr) {
        return this.apply(persistenceId, sequenceNr, 1);
    }

    public boolean isDeletionKey(Key key) {
        return key.mappingId() == 1;
    }

    public Key fromProduct(Product x$0) {
        return new Key(BoxesRunTime.unboxToInt((Object)x$0.productElement(0)), BoxesRunTime.unboxToLong((Object)x$0.productElement(1)), BoxesRunTime.unboxToInt((Object)x$0.productElement(2)));
    }
}

