/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal.leveldb;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.Tagged;
import org.apache.pekko.persistence.journal.Tagged$;
import org.apache.pekko.persistence.journal.WriteJournalBase;
import org.apache.pekko.persistence.journal.leveldb.Key;
import org.apache.pekko.persistence.journal.leveldb.Key$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbCompaction;
import org.apache.pekko.persistence.journal.leveldb.LeveldbCompaction$TryCompactLeveldb$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbIdMapping;
import org.apache.pekko.persistence.journal.leveldb.LeveldbJournal;
import org.apache.pekko.persistence.journal.leveldb.LeveldbJournal$CurrentPersistenceIds$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbJournal$EventAppended$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbJournal$PersistenceIdAdded$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbJournal$TaggedEventAppended$;
import org.apache.pekko.persistence.journal.leveldb.LeveldbRecovery;
import org.apache.pekko.persistence.journal.leveldb.LeveldbStore$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.iq80.leveldb.impl.Iq80DBFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.MultiMap;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public interface LeveldbStore
extends WriteJournalBase,
LeveldbIdMapping,
LeveldbRecovery,
LeveldbCompaction {
    public static Config emptyConfig() {
        return LeveldbStore$.MODULE$.emptyConfig();
    }

    public static Map<String, Object> toCompactionIntervalMap(ConfigObject configObject) {
        return LeveldbStore$.MODULE$.toCompactionIntervalMap(configObject);
    }

    public static void $init$(LeveldbStore $this) {
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$config_$eq($this.prepareConfig());
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$nativeLeveldb_$eq($this.config().getBoolean("native"));
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbOptions_$eq(new Options().createIfMissing(true));
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbWriteOptions_$eq(new WriteOptions().sync($this.config().getBoolean("fsync")).snapshot(false));
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbDir_$eq(new File($this.config().getString("dir")));
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$compactionIntervals_$eq(LeveldbStore$.MODULE$.toCompactionIntervalMap($this.config().getObject("compaction-intervals")));
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers_$eq((HashMap)new MultiMap<String, ActorRef>(){
            {
                MultiMap.$init$((MultiMap)this);
            }
        });
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers_$eq((HashMap)new MultiMap<String, ActorRef>(){
            {
                MultiMap.$init$((MultiMap)this);
            }
        });
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers_$eq((scala.collection.immutable.Set<ActorRef>)Predef$.MODULE$.Set().empty());
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSequenceNr_$eq((Map<String, Object>)Predef$.MODULE$.Map().empty());
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagPersistenceIdPrefix_$eq("$$$");
        $this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$serialization_$eq((Serialization)SerializationExtension$.MODULE$.apply($this.context().system()));
    }

    public /* synthetic */ void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$super$preStart();

    public /* synthetic */ void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$super$postStop();

    public Config prepareConfig();

    public Config config();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$config_$eq(Config var1);

    public boolean nativeLeveldb();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$nativeLeveldb_$eq(boolean var1);

    public Options leveldbOptions();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbOptions_$eq(Options var1);

    public static ReadOptions leveldbReadOptions$(LeveldbStore $this) {
        return $this.leveldbReadOptions();
    }

    default public ReadOptions leveldbReadOptions() {
        return new ReadOptions().verifyChecksums(this.config().getBoolean("checksum"));
    }

    public WriteOptions leveldbWriteOptions();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbWriteOptions_$eq(WriteOptions var1);

    public File leveldbDir();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbDir_$eq(File var1);

    public DB leveldb();

    public void leveldb_$eq(DB var1);

    @Override
    public Map<String, Object> compactionIntervals();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$compactionIntervals_$eq(Map var1);

    public HashMap<String, scala.collection.mutable.Set<ActorRef>> org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers_$eq(HashMap var1);

    public HashMap<String, scala.collection.mutable.Set<ActorRef>> org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers_$eq(HashMap var1);

    public scala.collection.immutable.Set<ActorRef> org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers_$eq(scala.collection.immutable.Set<ActorRef> var1);

    public Map<String, Object> org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSequenceNr();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSequenceNr_$eq(Map<String, Object> var1);

    public String org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagPersistenceIdPrefix();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagPersistenceIdPrefix_$eq(String var1);

    public static DBFactory leveldbFactory$(LeveldbStore $this) {
        return $this.leveldbFactory();
    }

    default public DBFactory leveldbFactory() {
        if (this.nativeLeveldb()) {
            return JniDBFactory.factory;
        }
        return Iq80DBFactory.factory;
    }

    public Serialization serialization();

    public void org$apache$pekko$persistence$journal$leveldb$LeveldbStore$_setter_$serialization_$eq(Serialization var1);

    public static Future asyncWriteMessages$(LeveldbStore $this, Seq messages) {
        return $this.asyncWriteMessages((Seq<AtomicWrite>)messages);
    }

    default public Future<Seq<Try<BoxedUnit>>> asyncWriteMessages(Seq<AtomicWrite> messages) {
        ObjectRef persistenceIds = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef allTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        Future result = Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> this.$anonfun$1(messages, allTags, persistenceIds)));
        if (this.hasPersistenceIdSubscribers()) {
            ((scala.collection.immutable.Set)persistenceIds.elem).foreach((Function1)(JProcedure1 & Serializable)pid -> this.notifyPersistenceIdChange((String)pid));
        }
        if (this.hasTagSubscribers() && ((scala.collection.immutable.Set)allTags.elem).nonEmpty()) {
            ((scala.collection.immutable.Set)allTags.elem).foreach((Function1)(JProcedure1 & Serializable)tag -> this.notifyTagChange((String)tag));
        }
        return result;
    }

    public static Future asyncDeleteMessagesTo$(LeveldbStore $this, String persistenceId, long toSequenceNr) {
        return $this.asyncDeleteMessagesTo(persistenceId, toSequenceNr);
    }

    default public Future<BoxedUnit> asyncDeleteMessagesTo(String persistenceId, long toSequenceNr) {
        Future future;
        try {
            future = Future$.MODULE$.successful(this.withBatch((Function1)(JProcedure1 & Serializable)batch -> {
                int nid = this.numericId(persistenceId);
                long fromSequenceNr = BoxesRunTime.unboxToLong(this.withIterator((Function1 & Serializable)iter -> {
                    Key startKey = Key$.MODULE$.apply(nid, 1L, 0);
                    iter.seek(Key$.MODULE$.keyToBytes(startKey));
                    if (iter.hasNext()) {
                        return Key$.MODULE$.keyFromBytes((byte[])iter.peekNext().getKey()).sequenceNr();
                    }
                    return Long.MAX_VALUE;
                }));
                if (fromSequenceNr != Long.MAX_VALUE) {
                    long toSeqNr = package$.MODULE$.min(toSequenceNr, this.readHighestSequenceNr(nid));
                    for (long sequenceNr = fromSequenceNr; sequenceNr <= toSeqNr; ++sequenceNr) {
                        batch.delete(Key$.MODULE$.keyToBytes(Key$.MODULE$.apply(nid, sequenceNr, 0)));
                    }
                    this.self().$bang((Object)LeveldbCompaction$TryCompactLeveldb$.MODULE$.apply(persistenceId, toSeqNr), this.self());
                    return;
                }
            }));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                future = Future$.MODULE$.failed(e);
            }
            throw throwable;
        }
        return future;
    }

    public static ReadOptions leveldbSnapshot$(LeveldbStore $this) {
        return $this.leveldbSnapshot();
    }

    default public ReadOptions leveldbSnapshot() {
        return this.leveldbReadOptions().snapshot(this.leveldb().getSnapshot());
    }

    public static Object withIterator$(LeveldbStore $this, Function1 body) {
        return $this.withIterator(body);
    }

    default public <R> R withIterator(Function1<DBIterator, R> body) {
        Object object;
        ReadOptions ro = this.leveldbSnapshot();
        DBIterator iterator = this.leveldb().iterator(ro);
        try {
            object = body.apply((Object)iterator);
        }
        finally {
            iterator.close();
            ro.snapshot().close();
        }
        return (R)object;
    }

    public static Object withBatch$(LeveldbStore $this, Function1 body) {
        return $this.withBatch(body);
    }

    /*
     * WARNING - void declaration
     */
    default public <R> R withBatch(Function1<WriteBatch, R> body) {
        void v0;
        try (WriteBatch batch = this.leveldb().createWriteBatch();){
            void var3_3;
            Object r = body.apply((Object)batch);
            this.leveldb().write(batch, this.leveldbWriteOptions());
            v0 = var3_3;
        }
        return v0;
    }

    public static byte[] persistentToBytes$(LeveldbStore $this, PersistentRepr p) {
        return $this.persistentToBytes(p);
    }

    default public byte[] persistentToBytes(PersistentRepr p) {
        return (byte[])this.serialization().serialize((Object)p).get();
    }

    public static PersistentRepr persistentFromBytes$(LeveldbStore $this, byte[] a) {
        return $this.persistentFromBytes(a);
    }

    default public PersistentRepr persistentFromBytes(byte[] a) {
        return (PersistentRepr)this.serialization().deserialize(a, PersistentRepr.class).get();
    }

    private void addToMessageBatch(PersistentRepr persistent, scala.collection.immutable.Set<String> tags, WriteBatch batch) {
        byte[] persistentBytes = this.persistentToBytes(persistent.withTimestamp(System.currentTimeMillis()));
        int nid = this.numericId(persistent.persistenceId());
        batch.put(Key$.MODULE$.keyToBytes(Key$.MODULE$.counterKey(nid)), Key$.MODULE$.counterToBytes(persistent.sequenceNr()));
        batch.put(Key$.MODULE$.keyToBytes(Key$.MODULE$.apply(nid, persistent.sequenceNr(), 0)), persistentBytes);
        tags.foreach((Function1 & Serializable)tag -> {
            int tagNid = this.tagNumericId((String)tag);
            long tagSeqNr = this.nextTagSequenceNr((String)tag);
            batch.put(Key$.MODULE$.keyToBytes(Key$.MODULE$.counterKey(tagNid)), Key$.MODULE$.counterToBytes(tagSeqNr));
            return batch.put(Key$.MODULE$.keyToBytes(Key$.MODULE$.apply(tagNid, tagSeqNr, 0)), persistentBytes);
        });
    }

    private long nextTagSequenceNr(String tag) {
        long l;
        Option option = this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSequenceNr().get((Object)tag);
        if (option instanceof Some) {
            long n;
            l = n = BoxesRunTime.unboxToLong((Object)((Some)option).value());
        } else if (None$.MODULE$.equals(option)) {
            l = this.readHighestSequenceNr(this.tagNumericId(tag));
        } else {
            throw new MatchError((Object)option);
        }
        long n = l;
        this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSequenceNr_$eq((Map<String, Object>)((Map)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSequenceNr().updated((Object)tag, (Object)BoxesRunTime.boxToLong((long)(n + 1L)))));
        return n + 1L;
    }

    public static int tagNumericId$(LeveldbStore $this, String tag) {
        return $this.tagNumericId(tag);
    }

    default public int tagNumericId(String tag) {
        return this.numericId(this.tagAsPersistenceId(tag));
    }

    public static String tagAsPersistenceId$(LeveldbStore $this, String tag) {
        return $this.tagAsPersistenceId(tag);
    }

    default public String tagAsPersistenceId(String tag) {
        return new StringBuilder(0).append(this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagPersistenceIdPrefix()).append(tag).toString();
    }

    public static void preStart$(LeveldbStore $this) {
        $this.preStart();
    }

    @Override
    default public void preStart() {
        this.leveldb_$eq(this.leveldbFactory().open(this.leveldbDir(), this.nativeLeveldb() ? this.leveldbOptions() : this.leveldbOptions().compressionType(CompressionType.NONE)));
        this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$super$preStart();
    }

    public static void postStop$(LeveldbStore $this) {
        $this.postStop();
    }

    default public void postStop() {
        this.leveldb().close();
        this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$super$postStop();
    }

    public static boolean hasPersistenceIdSubscribers$(LeveldbStore $this) {
        return $this.hasPersistenceIdSubscribers();
    }

    default public boolean hasPersistenceIdSubscribers() {
        return this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers().nonEmpty();
    }

    public static void addPersistenceIdSubscriber$(LeveldbStore $this, ActorRef subscriber, String persistenceId) {
        $this.addPersistenceIdSubscriber(subscriber, persistenceId);
    }

    default public void addPersistenceIdSubscriber(ActorRef subscriber, String persistenceId) {
        ((MultiMap)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers()).addBinding((Object)persistenceId, (Object)subscriber);
    }

    public static void removeSubscriber$(LeveldbStore $this, ActorRef subscriber) {
        $this.removeSubscriber(subscriber);
    }

    default public void removeSubscriber(ActorRef subscriber) {
        Iterable keys = (Iterable)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers().collect((PartialFunction)new Serializable(subscriber){
            private final ActorRef subscriber$1;
            {
                this.subscriber$1 = subscriber$5;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    scala.collection.mutable.Set s = (scala.collection.mutable.Set)tuple2._2();
                    if (s.contains((Object)this.subscriber$1)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    scala.collection.mutable.Set s = (scala.collection.mutable.Set)tuple2._2();
                    if (s.contains((Object)this.subscriber$1)) {
                        return k;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        keys.foreach((Function1 & Serializable)key -> (HashMap)((MultiMap)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers()).removeBinding(key, (Object)subscriber));
        Iterable tagKeys = (Iterable)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers().collect((PartialFunction)new Serializable(subscriber){
            private final ActorRef subscriber$3;
            {
                this.subscriber$3 = subscriber$6;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    scala.collection.mutable.Set s = (scala.collection.mutable.Set)tuple2._2();
                    if (s.contains((Object)this.subscriber$3)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    scala.collection.mutable.Set s = (scala.collection.mutable.Set)tuple2._2();
                    if (s.contains((Object)this.subscriber$3)) {
                        return k;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        tagKeys.foreach((Function1 & Serializable)key -> (HashMap)((MultiMap)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers()).removeBinding(key, (Object)subscriber));
        this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers().$minus((Object)subscriber)));
    }

    public static boolean hasTagSubscribers$(LeveldbStore $this) {
        return $this.hasTagSubscribers();
    }

    default public boolean hasTagSubscribers() {
        return this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers().nonEmpty();
    }

    public static void addTagSubscriber$(LeveldbStore $this, ActorRef subscriber, String tag) {
        $this.addTagSubscriber(subscriber, tag);
    }

    default public void addTagSubscriber(ActorRef subscriber, String tag) {
        ((MultiMap)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers()).addBinding((Object)tag, (Object)subscriber);
    }

    public static boolean hasAllPersistenceIdsSubscribers$(LeveldbStore $this) {
        return $this.hasAllPersistenceIdsSubscribers();
    }

    default public boolean hasAllPersistenceIdsSubscribers() {
        return this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers().nonEmpty();
    }

    public static void addAllPersistenceIdsSubscriber$(LeveldbStore $this, ActorRef subscriber) {
        $this.addAllPersistenceIdsSubscriber(subscriber);
    }

    default public void addAllPersistenceIdsSubscriber(ActorRef subscriber) {
        this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers().$plus((Object)subscriber)));
        subscriber.$bang((Object)LeveldbJournal$CurrentPersistenceIds$.MODULE$.apply(this.allPersistenceIds()), this.self());
    }

    private void notifyPersistenceIdChange(String persistenceId) {
        if (this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers().contains((Object)persistenceId)) {
            LeveldbJournal.EventAppended changed = LeveldbJournal$EventAppended$.MODULE$.apply(persistenceId);
            ((IterableOnceOps)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$persistenceIdSubscribers().apply((Object)persistenceId)).foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.$bang((Object)changed, this.self()));
            return;
        }
    }

    private void notifyTagChange(String tag) {
        if (this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers().contains((Object)tag)) {
            LeveldbJournal.TaggedEventAppended changed = LeveldbJournal$TaggedEventAppended$.MODULE$.apply(tag);
            ((IterableOnceOps)this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagSubscribers().apply((Object)tag)).foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.$bang((Object)changed, this.self()));
            return;
        }
    }

    public static void newPersistenceIdAdded$(LeveldbStore $this, String id) {
        $this.newPersistenceIdAdded(id);
    }

    @Override
    default public void newPersistenceIdAdded(String id) {
        if (this.hasAllPersistenceIdsSubscribers() && !id.startsWith(this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagPersistenceIdPrefix())) {
            LeveldbJournal.PersistenceIdAdded added = LeveldbJournal$PersistenceIdAdded$.MODULE$.apply(id);
            this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$allPersistenceIdsSubscribers().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.$bang((Object)added, this.self()));
            return;
        }
    }

    private Object $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(PersistentRepr p$1) {
        return new StringBuilder(37).append("persistenceId [").append(p$1.persistenceId()).append("] must not start with ").append(this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagPersistenceIdPrefix()).toString();
    }

    private void $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(AtomicWrite a$1, ObjectRef allTags$3, WriteBatch batch$1, ObjectRef persistenceIds$3) {
        a$1.payload().foreach((Function1)(JProcedure1 & Serializable)p -> {
            Tuple2 tuple2;
            Object object = p.payload();
            if (object instanceof Tagged) {
                Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object);
                Object object2 = tagged._1();
                scala.collection.immutable.Set<String> set = tagged._2();
                Object payload = object2;
                scala.collection.immutable.Set<String> tags = set;
                tuple2 = Tuple2$.MODULE$.apply((Object)p.withPayload(payload), tags);
            } else {
                tuple2 = Tuple2$.MODULE$.apply(p, (Object)Predef$.MODULE$.Set().empty());
            }
            Tuple2 tuple22 = tuple2;
            PersistentRepr p2 = (PersistentRepr)tuple22._1();
            scala.collection.immutable.Set tags = (scala.collection.immutable.Set)tuple22._2();
            if (tags.nonEmpty() && this.hasTagSubscribers()) {
                scala.collection.immutable.Set set = (scala.collection.immutable.Set)((scala.collection.immutable.Set)allTags$5.elem).union((Set)tags);
                allTags$5.elem = set;
                set = null;
            }
            Predef$.MODULE$.require(!p2.persistenceId().startsWith(this.org$apache$pekko$persistence$journal$leveldb$LeveldbStore$$tagPersistenceIdPrefix()), () -> this.$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(p));
            this.addToMessageBatch(p2, (scala.collection.immutable.Set<String>)tags, batch$1);
        });
        if (this.hasPersistenceIdSubscribers()) {
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)((scala.collection.immutable.Set)persistenceIds$3.elem).$plus((Object)a$1.persistenceId());
            persistenceIds$3.elem = set;
            set = null;
            return;
        }
    }

    private Seq $anonfun$1(Seq messages$1, ObjectRef allTags$1, ObjectRef persistenceIds$1) {
        return (Seq)this.withBatch((Function1 & Serializable)batch -> (Seq)messages$1.map((Function1 & Serializable)a -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1((AtomicWrite)a, allTags$1, (WriteBatch)batch, persistenceIds$1);
            return BoxedUnit.UNIT;
        })));
    }
}

