/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.persistence.serialization.Snapshot;
import org.apache.pekko.persistence.serialization.Snapshot$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class SnapshotSerializer
implements Serializer,
BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SnapshotSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private volatile Object serialization$lzy1;

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.includeManifest = false;
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    public Serialization org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof Snapshot) {
            Object object2;
            Snapshot snapshot = Snapshot$.MODULE$.unapply((Snapshot)object);
            Object data = object2 = snapshot._1();
            return this.snapshotToBinary(data);
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Can't serialize object of type ").append(o.getClass()).toString());
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return Snapshot$.MODULE$.apply(this.snapshotFromBinary(bytes));
    }

    private byte[] headerToBinary(Object snapshot, Serializer snapshotSerializer) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, snapshotSerializer.identifier());
        String ms = Serializers$.MODULE$.manifestFor(snapshotSerializer, snapshot);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
            out.write(ms.getBytes(ByteString$.MODULE$.UTF_8()));
        }
        return out.toByteArray();
    }

    private Tuple2<Object, String> headerFromBinary(byte[] bytes) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int serializerId = this.readInt(in);
        if ((serializerId & 0xEDAC) == 60844) {
            throw new NotSerializableException("Replaying snapshot from akka 2.3.x version is not supported any more");
        }
        int remaining = in.available();
        if (remaining == 0) {
            string = "";
        } else {
            byte[] manifestBytes = new byte[remaining];
            in.read(manifestBytes);
            string = new String(manifestBytes, ByteString$.MODULE$.UTF_8());
        }
        String manifest = string;
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
    }

    private byte[] snapshotToBinary(Object snapshot) {
        byte[] byArray;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.system().provider().serializationInformation());
            }
            byArray = this.serialize$1(snapshot);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return byArray;
    }

    private Object snapshotFromBinary(byte[] bytes) {
        int headerLength = this.readInt(new ByteArrayInputStream(bytes));
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        byte[] headerBytes = (byte[])ArrayOps$.MODULE$.slice$extension(object, 4, headerLength + 4);
        Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
        byte[] snapshotBytes = (byte[])ArrayOps$.MODULE$.drop$extension(object2, headerLength + 4);
        Tuple2<Object, String> tuple2 = this.headerFromBinary(headerBytes);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int serializerId = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String manifest = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
        int serializerId2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        String manifest2 = (String)tuple22._2();
        return this.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization().deserialize(snapshotBytes, serializerId2, manifest2).recoverWith((PartialFunction)new Serializable(manifest2, snapshotBytes, serializerId2, this){
            private final String manifest$1;
            private final byte[] snapshotBytes$1;
            private final int serializerId$1;
            private final /* synthetic */ SnapshotSerializer $outer;
            {
                this.manifest$1 = manifest$2;
                this.snapshotBytes$1 = snapshotBytes$2;
                this.serializerId$1 = serializerId$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NotSerializableException && this.manifest$1.startsWith("akka");
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NotSerializableException && this.manifest$1.startsWith("akka")) {
                    return this.$outer.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization().deserialize(this.snapshotBytes$1, this.serializerId$1, this.manifest$1.replaceFirst("akka", "org.apache.pekko"));
                }
                return function1.apply((Object)x);
            }
        }).get();
    }

    private void writeInt(OutputStream out, int i) {
        out.write(i >>> 0);
        out.write(i >>> 8);
        out.write(i >>> 16);
        out.write(i >>> 24);
    }

    private int readInt(InputStream in) {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if ((b1 | b2 | b3 | b3) == -1) {
            throw new EOFException();
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private final byte[] serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization().findSerializerFor(snapshot$1);
        byte[] headerBytes = this.headerToBinary(snapshot$1, snapshotSerializer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }
}

