/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pki.pem;

import com.hierynomus.asn1.ASN1InputStream;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.der.DERDecoder;
import com.hierynomus.asn1.types.ASN1Object;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.primitive.ASN1Integer;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.pki.pem.PEMDecoder;
import org.apache.pekko.pki.pem.PEMLoadingException;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;

public final class DERPrivateKeyLoader$
implements Serializable {
    public static final DERPrivateKeyLoader$ MODULE$ = new DERPrivateKeyLoader$();

    private DERPrivateKeyLoader$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DERPrivateKeyLoader$.class);
    }

    @ApiMayChange
    public PrivateKey load(PEMDecoder.DERData derData) throws PEMLoadingException {
        String string = derData.label();
        if ("RSA PRIVATE KEY".equals(string)) {
            return this.loadPkcs1PrivateKey(derData.bytes());
        }
        if ("PRIVATE KEY".equals(string)) {
            return this.loadPkcs8PrivateKey(derData.bytes());
        }
        String unknown = string;
        throw new PEMLoadingException(new StringBuilder(64).append("Don't know how to read a private key from PEM data with label [").append(unknown).append("]").toString());
    }

    private PrivateKey loadPkcs1PrivateKey(byte[] bytes) {
        RSAPrivateKeySpec rSAPrivateKeySpec;
        ASN1Sequence aSN1Sequence;
        try (ASN1InputStream derInputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), bytes);){
            aSN1Sequence = (ASN1Sequence)derInputStream.readObject();
        }
        ASN1Sequence sequence = aSN1Sequence;
        int version = this.getInteger(sequence, 0, "version").intValueExact();
        if (version < 0 || version > 1) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported PKCS1 version: ").append(version).toString());
        }
        BigInteger modulus = this.getInteger(sequence, 1, "modulus");
        BigInteger publicExponent = this.getInteger(sequence, 2, "publicExponent");
        BigInteger privateExponent = this.getInteger(sequence, 3, "privateExponent");
        BigInteger prime1 = this.getInteger(sequence, 4, "prime1");
        BigInteger prime2 = this.getInteger(sequence, 5, "prime2");
        BigInteger exponent1 = this.getInteger(sequence, 6, "exponent1");
        BigInteger exponent2 = this.getInteger(sequence, 7, "exponent2");
        BigInteger coefficient = this.getInteger(sequence, 8, "coefficient");
        if (version == 0) {
            rSAPrivateKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
        } else {
            ASN1Sequence otherPrimeInfosSequence = this.getSequence(sequence, 9, "otherPrimeInfos");
            RSAOtherPrimeInfo[] otherPrimeInfos = (RSAOtherPrimeInfo[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), otherPrimeInfosSequence.size()).map((Function1 & Serializable)i -> this.$anonfun$1(otherPrimeInfosSequence, BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(RSAOtherPrimeInfo.class));
            rSAPrivateKeySpec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient, otherPrimeInfos);
        }
        RSAPrivateCrtKeySpec keySpec = rSAPrivateKeySpec;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private BigInteger getInteger(ASN1Sequence sequence, int index, String name) {
        ASN1Object aSN1Object = sequence.get(index);
        if (aSN1Object instanceof ASN1Integer) {
            ASN1Integer integer = (ASN1Integer)aSN1Object;
            return integer.getValue();
        }
        ASN1Object other = aSN1Object;
        throw new IllegalArgumentException(new StringBuilder(46).append("Expected integer tag for ").append(name).append(" at index ").append(index).append(", but got: ").append(other.getTag()).toString());
    }

    private ASN1Sequence getSequence(ASN1Sequence sequence, int index, String name) {
        ASN1Object aSN1Object = sequence.get(index);
        if (aSN1Object instanceof ASN1Sequence) {
            ASN1Sequence seq = (ASN1Sequence)aSN1Object;
            return seq;
        }
        ASN1Object other = aSN1Object;
        throw new IllegalArgumentException(new StringBuilder(47).append("Expected sequence tag for ").append(name).append(" at index ").append(index).append(", but got: ").append(other.getTag()).toString());
    }

    private PrivateKey loadPkcs8PrivateKey(byte[] bytes) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private final /* synthetic */ RSAOtherPrimeInfo $anonfun$1(ASN1Sequence otherPrimeInfosSequence$1, int i) {
        String name = new StringBuilder(17).append("otherPrimeInfos[").append(i).append("]").toString();
        ASN1Sequence seq = this.getSequence(otherPrimeInfosSequence$1, i, name);
        BigInteger prime = this.getInteger(seq, 0, new StringBuilder(6).append(name).append(".prime").toString());
        BigInteger exponent = this.getInteger(seq, 1, new StringBuilder(9).append(name).append(".exponent").toString());
        BigInteger coefficient = this.getInteger(seq, 2, new StringBuilder(12).append(name).append(".coefficient").toString());
        return new RSAOtherPrimeInfo(prime, exponent, coefficient);
    }
}

