/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.protobuf;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pekko.protobuf.ByteString;
import org.apache.pekko.protobuf.Descriptors;
import org.apache.pekko.protobuf.ExtensionRegistry;
import org.apache.pekko.protobuf.Message;
import org.apache.pekko.protobuf.MessageOrBuilder;
import org.apache.pekko.protobuf.UnknownFieldSet;
import org.apache.pekko.protobuf.WireFormat;

public final class TextFormat {
    private static final Printer DEFAULT_PRINTER = new Printer();
    private static final Printer SINGLE_LINE_PRINTER = Printer.access$100(new Printer(), true);
    private static final Printer UNICODE_PRINTER = Printer.access$200(new Printer(), false);
    private static final int BUFFER_SIZE = 4096;

    private TextFormat() {
    }

    public static void print(MessageOrBuilder messageOrBuilder, Appendable appendable) throws IOException {
        TextFormat.DEFAULT_PRINTER.print(messageOrBuilder, new TextGenerator(appendable));
    }

    public static void print(UnknownFieldSet unknownFieldSet, Appendable appendable) throws IOException {
        TextFormat.DEFAULT_PRINTER.printUnknownFields(unknownFieldSet, new TextGenerator(appendable));
    }

    public static String shortDebugString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.print(messageOrBuilder, new TextGenerator(stringBuilder));
            return stringBuilder.toString().trim();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String shortDebugString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.printUnknownFields(unknownFieldSet, new TextGenerator(stringBuilder));
            return stringBuilder.toString().trim();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(messageOrBuilder, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(unknownFieldSet, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.UNICODE_PRINTER.print(messageOrBuilder, new TextGenerator(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.UNICODE_PRINTER.printUnknownFields(unknownFieldSet, new TextGenerator(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        TextFormat.DEFAULT_PRINTER.printField(fieldDescriptor, object, new TextGenerator(appendable));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.printField(fieldDescriptor, object, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        TextFormat.DEFAULT_PRINTER.printFieldValue(fieldDescriptor, object, new TextGenerator(appendable));
    }

    public static void printUnknownFieldValue(int n, Object object, Appendable appendable) throws IOException {
        TextFormat.printUnknownFieldValue(n, object, new TextGenerator(appendable));
    }

    private static void printUnknownFieldValue(int n, Object object, TextGenerator textGenerator) throws IOException {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                textGenerator.print(TextFormat.unsignedToString((Long)object));
                break;
            }
            case 5: {
                textGenerator.print(String.format((Locale)null, "0x%08x", (Integer)object));
                break;
            }
            case 1: {
                textGenerator.print(String.format((Locale)null, "0x%016x", (Long)object));
                break;
            }
            case 2: {
                textGenerator.print("\"");
                textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                textGenerator.print("\"");
                break;
            }
            case 3: {
                TextFormat.DEFAULT_PRINTER.printUnknownFields((UnknownFieldSet)object, textGenerator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad tag: " + n);
            }
        }
    }

    private static String unsignedToString(int n) {
        if (n >= 0) {
            return Integer.toString(n);
        }
        return Long.toString((long)n & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l & Long.MAX_VALUE).setBit(63).toString();
    }

    public static void merge(Readable readable, Message.Builder builder) throws IOException {
        TextFormat.merge(readable, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(CharSequence charSequence, Message.Builder builder) throws ParseException {
        TextFormat.merge(charSequence, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(Readable readable, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        TextFormat.merge(TextFormat.toStringBuilder(readable), extensionRegistry, builder);
    }

    private static StringBuilder toStringBuilder(Readable readable) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(4096);
        while ((n = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n);
        }
        return stringBuilder;
    }

    public static void merge(CharSequence charSequence, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(charSequence);
        while (!tokenizer.atEnd()) {
            TextFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
    }

    private static void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Object object;
        Descriptors.FieldDescriptor fieldDescriptor;
        Object object2;
        Descriptors.Descriptor descriptor = builder.getDescriptorForType();
        ExtensionRegistry.ExtensionInfo extensionInfo = null;
        if (tokenizer.tryConsume("[")) {
            object2 = new StringBuilder(tokenizer.consumeIdentifier());
            while (tokenizer.tryConsume(".")) {
                ((StringBuilder)object2).append('.');
                ((StringBuilder)object2).append(tokenizer.consumeIdentifier());
            }
            extensionInfo = extensionRegistry.findExtensionByName(((StringBuilder)object2).toString());
            if (extensionInfo == null) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + object2 + "\" not found in the ExtensionRegistry.");
            }
            if (extensionInfo.descriptor.getContainingType() != descriptor) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + object2 + "\" does not extend message type \"" + descriptor.getFullName() + "\".");
            }
            tokenizer.consume("]");
            fieldDescriptor = extensionInfo.descriptor;
        } else {
            object2 = tokenizer.consumeIdentifier();
            fieldDescriptor = descriptor.findFieldByName((String)object2);
            if (fieldDescriptor == null && (fieldDescriptor = descriptor.findFieldByName((String)(object = ((String)object2).toLowerCase(Locale.US)))) != null && fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                fieldDescriptor = null;
            }
            if (fieldDescriptor != null && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP && !fieldDescriptor.getMessageType().getName().equals(object2)) {
                fieldDescriptor = null;
            }
            if (fieldDescriptor == null) {
                throw tokenizer.parseExceptionPreviousToken("Message type \"" + descriptor.getFullName() + "\" has no field named \"" + (String)object2 + "\".");
            }
        }
        object2 = null;
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            tokenizer.tryConsume(":");
            if (tokenizer.tryConsume("<")) {
                object = ">";
            } else {
                tokenizer.consume("{");
                object = "}";
            }
            Message.Builder builder2 = extensionInfo == null ? builder.newBuilderForField(fieldDescriptor) : extensionInfo.defaultInstance.newBuilderForType();
            while (!tokenizer.tryConsume((String)object)) {
                if (tokenizer.atEnd()) {
                    throw tokenizer.parseException("Expected \"" + (String)object + "\".");
                }
                TextFormat.mergeField(tokenizer, extensionRegistry, builder2);
            }
            object2 = builder2.buildPartial();
        } else {
            tokenizer.consume(":");
            switch (fieldDescriptor.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    object2 = tokenizer.consumeInt32();
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    object2 = tokenizer.consumeInt64();
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    object2 = tokenizer.consumeUInt32();
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    object2 = tokenizer.consumeUInt64();
                    break;
                }
                case FLOAT: {
                    object2 = Float.valueOf(tokenizer.consumeFloat());
                    break;
                }
                case DOUBLE: {
                    object2 = tokenizer.consumeDouble();
                    break;
                }
                case BOOL: {
                    object2 = tokenizer.consumeBoolean();
                    break;
                }
                case STRING: {
                    object2 = tokenizer.consumeString();
                    break;
                }
                case BYTES: {
                    object2 = tokenizer.consumeByteString();
                    break;
                }
                case ENUM: {
                    object = fieldDescriptor.getEnumType();
                    if (tokenizer.lookingAtInteger()) {
                        int n = tokenizer.consumeInt32();
                        object2 = ((Descriptors.EnumDescriptor)object).findValueByNumber(n);
                        if (object2 != null) break;
                        throw tokenizer.parseExceptionPreviousToken("Enum type \"" + ((Descriptors.EnumDescriptor)object).getFullName() + "\" has no value with number " + n + '.');
                    }
                    String string = tokenizer.consumeIdentifier();
                    object2 = ((Descriptors.EnumDescriptor)object).findValueByName(string);
                    if (object2 != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + ((Descriptors.EnumDescriptor)object).getFullName() + "\" has no value named \"" + string + "\".");
                }
                case MESSAGE: 
                case GROUP: {
                    throw new RuntimeException("Can't get here.");
                }
            }
        }
        if (fieldDescriptor.isRepeated()) {
            builder.addRepeatedField(fieldDescriptor, object2);
        } else {
            builder.setField(fieldDescriptor, object2);
        }
    }

    static String escapeBytes(ByteString byteString) {
        StringBuilder stringBuilder = new StringBuilder(byteString.size());
        block12: for (int i = 0; i < byteString.size(); ++i) {
            byte by = byteString.byteAt(i);
            switch (by) {
                case 7: {
                    stringBuilder.append("\\a");
                    continue block12;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    continue block12;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    continue block12;
                }
                case 10: {
                    stringBuilder.append("\\n");
                    continue block12;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block12;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block12;
                }
                case 11: {
                    stringBuilder.append("\\v");
                    continue block12;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    stringBuilder.append("\\'");
                    continue block12;
                }
                case 34: {
                    stringBuilder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (by >= 32) {
                        stringBuilder.append((char)by);
                        continue block12;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append((char)(48 + (by >>> 6 & 3)));
                    stringBuilder.append((char)(48 + (by >>> 3 & 7)));
                    stringBuilder.append((char)(48 + (by & 7)));
                }
            }
        }
        return stringBuilder.toString();
    }

    static ByteString unescapeBytes(CharSequence charSequence) throws InvalidEscapeSequenceException {
        ByteString byteString = ByteString.copyFromUtf8(charSequence.toString());
        byte[] byArray = new byte[byteString.size()];
        int n = 0;
        block13: for (int i = 0; i < byteString.size(); ++i) {
            byte by = byteString.byteAt(i);
            if (by == 92) {
                if (i + 1 < byteString.size()) {
                    int n2;
                    if (TextFormat.isOctal(by = byteString.byteAt(++i))) {
                        n2 = TextFormat.digitValue(by);
                        if (i + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(byteString.byteAt(++i));
                        }
                        if (i + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(byteString.byteAt(++i));
                        }
                        byArray[n++] = (byte)n2;
                        continue;
                    }
                    switch (by) {
                        case 97: {
                            byArray[n++] = 7;
                            continue block13;
                        }
                        case 98: {
                            byArray[n++] = 8;
                            continue block13;
                        }
                        case 102: {
                            byArray[n++] = 12;
                            continue block13;
                        }
                        case 110: {
                            byArray[n++] = 10;
                            continue block13;
                        }
                        case 114: {
                            byArray[n++] = 13;
                            continue block13;
                        }
                        case 116: {
                            byArray[n++] = 9;
                            continue block13;
                        }
                        case 118: {
                            byArray[n++] = 11;
                            continue block13;
                        }
                        case 92: {
                            byArray[n++] = 92;
                            continue block13;
                        }
                        case 39: {
                            byArray[n++] = 39;
                            continue block13;
                        }
                        case 34: {
                            byArray[n++] = 34;
                            continue block13;
                        }
                        case 120: {
                            n2 = 0;
                            if (i + 1 >= byteString.size() || !TextFormat.isHex(byteString.byteAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            n2 = TextFormat.digitValue(byteString.byteAt(++i));
                            if (i + 1 < byteString.size() && TextFormat.isHex(byteString.byteAt(i + 1))) {
                                n2 = n2 * 16 + TextFormat.digitValue(byteString.byteAt(++i));
                            }
                            byArray[n++] = (byte)n2;
                            continue block13;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)by + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            byArray[n++] = by;
        }
        return ByteString.copyFrom(byArray, 0, n);
    }

    static String escapeText(String string) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(string));
    }

    static String unescapeText(String string) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(string).toStringUtf8();
    }

    private static boolean isOctal(byte by) {
        return 48 <= by && by <= 55;
    }

    private static boolean isHex(byte by) {
        return 48 <= by && by <= 57 || 97 <= by && by <= 102 || 65 <= by && by <= 70;
    }

    private static int digitValue(byte by) {
        if (48 <= by && by <= 57) {
            return by - 48;
        }
        if (97 <= by && by <= 122) {
            return by - 97 + 10;
        }
        return by - 65 + 10;
    }

    static int parseInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, true, false);
    }

    static int parseUInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, false, false);
    }

    static long parseInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, true, true);
    }

    static long parseUInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, false, true);
    }

    private static long parseInteger(String string, boolean bl, boolean bl2) throws NumberFormatException {
        int n = 0;
        boolean bl3 = false;
        if (string.startsWith("-", n)) {
            if (!bl) {
                throw new NumberFormatException("Number must be positive: " + string);
            }
            ++n;
            bl3 = true;
        }
        int n2 = 10;
        if (string.startsWith("0x", n)) {
            n += 2;
            n2 = 16;
        } else if (string.startsWith("0", n)) {
            n2 = 8;
        }
        String string2 = string.substring(n);
        long l = 0L;
        if (string2.length() < 16) {
            l = Long.parseLong(string2, n2);
            if (bl3) {
                l = -l;
            }
            if (!bl2) {
                if (bl) {
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (l >= 0x100000000L || l < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            }
        } else {
            BigInteger bigInteger = new BigInteger(string2, n2);
            if (bl3) {
                bigInteger = bigInteger.negate();
            }
            if (!bl2) {
                if (bl) {
                    if (bigInteger.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (bigInteger.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            } else if (bl) {
                if (bigInteger.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + string);
                }
            } else if (bigInteger.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + string);
            }
            l = bigInteger.longValue();
        }
        return l;
    }

    static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String string) {
            super(string);
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String string) {
            this(-1, -1, string);
        }

        public ParseException(int n, int n2, String string) {
            super(Integer.toString(n) + ":" + n2 + ": " + string);
            this.line = n;
            this.column = n2;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence charSequence) {
            this.text = charSequence;
            this.matcher = WHITESPACE.matcher(charSequence);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String string) {
            if (this.currentToken.equals(string)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String string) throws ParseException {
            if (!this.tryConsume(string)) {
                throw this.parseException("Expected \"" + string + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.') continue;
                throw this.parseException("Expected identifier.");
            }
            String string = this.currentToken;
            this.nextToken();
            return string;
        }

        public int consumeInt32() throws ParseException {
            try {
                int n = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int n = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long l = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long l = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double d = Double.parseDouble(this.currentToken);
                this.nextToken();
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float f = Float.parseFloat(this.currentToken);
                this.nextToken();
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
            this.consumeByteString(arrayList);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(arrayList);
            }
            return ByteString.copyFrom(arrayList);
        }

        private void consumeByteString(List<ByteString> list) throws ParseException {
            char c;
            char c2 = c = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (c != '\"' && c != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != c) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String string = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString byteString = TextFormat.unescapeBytes(string);
                this.nextToken();
                list.add(byteString);
            }
            catch (InvalidEscapeSequenceException invalidEscapeSequenceException) {
                throw this.parseException(invalidEscapeSequenceException.getMessage());
            }
        }

        public ParseException parseException(String string) {
            return new ParseException(this.line + 1, this.column + 1, string);
        }

        public ParseException parseExceptionPreviousToken(String string) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, string);
        }

        private ParseException integerParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse integer: " + numberFormatException.getMessage());
        }

        private ParseException floatParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse number: " + numberFormatException.getMessage());
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private boolean atStartOfLine = true;

        private TextGenerator(Appendable appendable) {
            this.output = appendable;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int n = this.indent.length();
            if (n == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(n - 2, n);
        }

        public void print(CharSequence charSequence) throws IOException {
            int n = charSequence.length();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) != '\n') continue;
                this.write(charSequence.subSequence(n2, n), i - n2 + 1);
                n2 = i + 1;
                this.atStartOfLine = true;
            }
            this.write(charSequence.subSequence(n2, n), n - n2);
        }

        private void write(CharSequence charSequence, int n) throws IOException {
            if (n == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(charSequence);
        }
    }

    private static final class Printer {
        boolean singleLineMode = false;
        boolean escapeNonAscii = true;

        private Printer() {
        }

        private Printer setSingleLineMode(boolean bl) {
            this.singleLineMode = bl;
            return this;
        }

        private Printer setEscapeNonAscii(boolean bl) {
            this.escapeNonAscii = bl;
            return this;
        }

        private void print(MessageOrBuilder messageOrBuilder, TextGenerator textGenerator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : messageOrBuilder.getAllFields().entrySet()) {
                this.printField(entry.getKey(), entry.getValue(), textGenerator);
            }
            this.printUnknownFields(messageOrBuilder.getUnknownFields(), textGenerator);
        }

        private void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            if (fieldDescriptor.isRepeated()) {
                for (Object e : (List)object) {
                    this.printSingleField(fieldDescriptor, e, textGenerator);
                }
            } else {
                this.printSingleField(fieldDescriptor, object, textGenerator);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            if (fieldDescriptor.isExtension()) {
                textGenerator.print("[");
                if (fieldDescriptor.getContainingType().getOptions().getMessageSetWireFormat() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && fieldDescriptor.isOptional() && fieldDescriptor.getExtensionScope() == fieldDescriptor.getMessageType()) {
                    textGenerator.print(fieldDescriptor.getMessageType().getFullName());
                } else {
                    textGenerator.print(fieldDescriptor.getFullName());
                }
                textGenerator.print("]");
            } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                textGenerator.print(fieldDescriptor.getMessageType().getName());
            } else {
                textGenerator.print(fieldDescriptor.getName());
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    textGenerator.print(" { ");
                } else {
                    textGenerator.print(" {\n");
                    textGenerator.indent();
                }
            } else {
                textGenerator.print(": ");
            }
            this.printFieldValue(fieldDescriptor, object, textGenerator);
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    textGenerator.print("} ");
                } else {
                    textGenerator.outdent();
                    textGenerator.print("}\n");
                }
            } else if (this.singleLineMode) {
                textGenerator.print(" ");
            } else {
                textGenerator.print("\n");
            }
        }

        private void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
            switch (fieldDescriptor.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    textGenerator.print(((Integer)object).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    textGenerator.print(((Long)object).toString());
                    break;
                }
                case BOOL: {
                    textGenerator.print(((Boolean)object).toString());
                    break;
                }
                case FLOAT: {
                    textGenerator.print(((Float)object).toString());
                    break;
                }
                case DOUBLE: {
                    textGenerator.print(((Double)object).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    textGenerator.print(TextFormat.unsignedToString((Integer)object));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    textGenerator.print(TextFormat.unsignedToString((Long)object));
                    break;
                }
                case STRING: {
                    textGenerator.print("\"");
                    textGenerator.print(this.escapeNonAscii ? TextFormat.escapeText((String)object) : (String)object);
                    textGenerator.print("\"");
                    break;
                }
                case BYTES: {
                    textGenerator.print("\"");
                    textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                    textGenerator.print("\"");
                    break;
                }
                case ENUM: {
                    textGenerator.print(((Descriptors.EnumValueDescriptor)object).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)object, textGenerator);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFieldSet, TextGenerator textGenerator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFieldSet.asMap().entrySet()) {
                int n = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                this.printUnknownField(n, 0, field.getVarintList(), textGenerator);
                this.printUnknownField(n, 5, field.getFixed32List(), textGenerator);
                this.printUnknownField(n, 1, field.getFixed64List(), textGenerator);
                this.printUnknownField(n, 2, field.getLengthDelimitedList(), textGenerator);
                for (UnknownFieldSet unknownFieldSet2 : field.getGroupList()) {
                    textGenerator.print(entry.getKey().toString());
                    if (this.singleLineMode) {
                        textGenerator.print(" { ");
                    } else {
                        textGenerator.print(" {\n");
                        textGenerator.indent();
                    }
                    this.printUnknownFields(unknownFieldSet2, textGenerator);
                    if (this.singleLineMode) {
                        textGenerator.print("} ");
                        continue;
                    }
                    textGenerator.outdent();
                    textGenerator.print("}\n");
                }
            }
        }

        private void printUnknownField(int n, int n2, List<?> list, TextGenerator textGenerator) throws IOException {
            for (Object obj : list) {
                textGenerator.print(String.valueOf(n));
                textGenerator.print(": ");
                TextFormat.printUnknownFieldValue(n2, obj, textGenerator);
                textGenerator.print(this.singleLineMode ? " " : "\n");
            }
        }

        static /* synthetic */ Printer access$100(Printer printer, boolean bl) {
            return printer.setSingleLineMode(bl);
        }

        static /* synthetic */ Printer access$200(Printer printer, boolean bl) {
            return printer.setEscapeNonAscii(bl);
        }
    }
}

