/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.Association;
import org.apache.pekko.remote.artery.AssociationState;
import org.apache.pekko.remote.artery.AssociationState$UidKnown$;
import org.apache.pekko.remote.artery.AssociationState$UidQuarantined$;
import org.apache.pekko.remote.artery.AssociationState$UidUnknown$;
import org.apache.pekko.remote.artery.ImmutableLongMap;
import org.apache.pekko.remote.artery.ImmutableLongMap$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea!\u0002\u0007\u000e\u0001=9\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u000b5\u0002A\u0011\u0001\u0018\t\rE\u0002\u0001\u0015!\u00033\u0011\u0019I\u0005\u0001)A\u0005\u0015\")a\n\u0001C\u0003\u001f\")a\n\u0001C\u00013\")A\r\u0001C\u0003K\")Q\u000e\u0001C\u0001]\")!\u000f\u0001C\u0001g\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u0005\u0001\u0011%\u00111\u0002\u0002\u0014\u0003N\u001cxnY5bi&|gNU3hSN$(/\u001f\u0006\u0003\u001d=\ta!\u0019:uKJL(B\u0001\t\u0012\u0003\u0019\u0011X-\\8uK*\u0011!cE\u0001\u0006a\u0016\\7n\u001c\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\f\u0011c\u0019:fCR,\u0017i]:pG&\fG/[8o\u0007\u0001\u0001B!G\u0011$S%\u0011!E\u0007\u0002\n\rVt7\r^5p]F\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\t\u0002\u000b\u0005\u001cGo\u001c:\n\u0005!*#aB!eIJ,7o\u001d\t\u0003U-j\u0011!D\u0005\u0003Y5\u00111\"Q:t_\u000eL\u0017\r^5p]\u00061A(\u001b8jiz\"\"a\f\u0019\u0011\u0005)\u0002\u0001\"\u0002\u0010\u0003\u0001\u0004\u0001\u0013!F1tg>\u001c\u0017.\u0019;j_:\u001c()_!eIJ,7o\u001d\t\u0004gqrT\"\u0001\u001b\u000b\u0005U2\u0014AB1u_6L7M\u0003\u00028q\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005eR\u0014\u0001B;uS2T\u0011aO\u0001\u0005U\u00064\u0018-\u0003\u0002>i\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003@\r\u000eJcB\u0001!E!\t\t%$D\u0001C\u0015\t\u0019u$\u0001\u0004=e>|GOP\u0005\u0003\u000bj\ta\u0001\u0015:fI\u00164\u0017BA$I\u0005\ri\u0015\r\u001d\u0006\u0003\u000bj\t\u0011#Y:t_\u000eL\u0017\r^5p]N\u0014\u00150V5e!\r\u0019Dh\u0013\t\u0004U1K\u0013BA'\u000e\u0005AIU.\\;uC\ndW\rT8oO6\u000b\u0007/A\u0006bgN|7-[1uS>tGCA\u0015Q\u0011\u0015\tV\u00011\u0001$\u00035\u0011X-\\8uK\u0006#GM]3tg\"\u0012Qa\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-j\t!\"\u00198o_R\fG/[8o\u0013\tAVKA\u0004uC&d'/Z2\u0015\u0005i{\u0006cA.^S5\tAL\u0003\u0002:#%\u0011a\f\u0018\u0002\n\u001fB$\u0018n\u001c8WC2DQ\u0001\u0019\u0004A\u0002\u0005\f1!^5e!\tI\"-\u0003\u0002d5\t!Aj\u001c8h\u0003\u0019\u0019X\r^+J\tR\u0011\u0011F\u001a\u0005\u0006O\u001e\u0001\r\u0001[\u0001\u0005a\u0016,'\u000f\u0005\u0002jU6\tq\"\u0003\u0002l\u001f\tiQK\\5rk\u0016\fE\r\u001a:fgND#aB*\u0002\u001f\u0005dG.Q:t_\u000eL\u0017\r^5p]N,\u0012a\u001c\t\u0004\u007fAL\u0013BA9I\u0005\r\u0019V\r^\u0001\u0018e\u0016lwN^3V]V\u001cX\rZ)vCJ\fg\u000e^5oK\u0012$\"\u0001^<\u0011\u0005e)\u0018B\u0001<\u001b\u0005\u0011)f.\u001b;\t\u000baL\u0001\u0019A=\u0002\u000b\u00054G/\u001a:\u0011\u0005itX\"A>\u000b\u0005ql\u0018\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005]R\u0012BA@|\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0001E]3n_Z,WK\\;tK\u0012\fV/\u0019:b]RLg.\u001a3Cs\u0006#GM]3tgR\u0019A/!\u0002\t\u000baT\u0001\u0019A=)\u0005)\u0019\u0016\u0001\b:f[>4X-\u00168vg\u0016$\u0017+^1sC:$\u0018N\\3e\u0005f,\u0016\u000e\u001a\u000b\u0004i\u00065\u0001\"\u0002=\f\u0001\u0004I\bFA\u0006T\u0001")
public class AssociationRegistry {
    private final Function1<Address, Association> createAssociation;
    private final AtomicReference<Map<Address, Association>> associationsByAddress;
    private final AtomicReference<ImmutableLongMap<Association>> associationsByUid;

    public final Association association(Address remoteAddress) {
        Option option;
        while (true) {
            Map<Address, Association> currentMap;
            if ((option = (currentMap = this.associationsByAddress.get()).get((Object)remoteAddress)) instanceof Some) {
                Some some = (Some)option;
                Association existing = (Association)some.value();
                return existing;
            }
            if (!None$.MODULE$.equals(option)) break;
            Association newAssociation = (Association)this.createAssociation.apply((Object)remoteAddress);
            Map newMap = currentMap.updated((Object)remoteAddress, (Object)newAssociation);
            if (!this.associationsByAddress.compareAndSet(currentMap, (Map<Address, Association>)newMap)) continue;
            newAssociation.associate();
            return newAssociation;
        }
        throw new MatchError((Object)option);
    }

    public Association association(long uid) {
        return this.associationsByUid.get().get(uid);
    }

    public final Association setUID(UniqueAddress peer) {
        while (true) {
            Association a = this.association(peer.address());
            ImmutableLongMap<Association> currentMap = this.associationsByUid.get();
            Association association = currentMap.get(peer.uid());
            Association association2 = (Association)OptionVal.Some$.MODULE$.unapply((Object)association);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)association2)) {
                Association previous = (Association)OptionVal$.MODULE$.get$extension((Object)association2);
                if (previous == a) {
                    return a;
                }
                throw new IllegalArgumentException(new StringBuilder(27).append("UID collision old [").append(previous).append("] new [").append(a).append("]").toString());
            }
            ImmutableLongMap<Association> newMap = currentMap.updated(peer.uid(), a);
            if (!this.associationsByUid.compareAndSet(currentMap, newMap)) continue;
            return a;
        }
    }

    public Set<Association> allAssociations() {
        return ((MapLike)this.associationsByAddress.get()).values().toSet();
    }

    public void removeUnusedQuarantined(FiniteDuration after) {
        this.removeUnusedQuarantinedByAddress(after);
        this.removeUnusedQuarantinedByUid(after);
    }

    private void removeUnusedQuarantinedByAddress(FiniteDuration after) {
        block1: {
            BoxedUnit boxedUnit;
            while (true) {
                long now = System.nanoTime();
                long afterNanos = after.toNanos();
                Map<Address, Association> currentMap = this.associationsByAddress.get();
                Map remove = (Map)currentMap.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        Map acc = (Map)tuple2._1();
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Address address = (Address)tuple22._1();
                            Association association = (Association)tuple22._2();
                            AssociationState state = association.associationState();
                            if (now - state.lastUsedTimestamp().get() >= afterNanos) {
                                AssociationState.UniqueRemoteAddressState uniqueRemoteAddressState = state.uniqueRemoteAddressState();
                                if (AssociationState$UidQuarantined$.MODULE$.equals(uniqueRemoteAddressState) ? true : AssociationState$UidUnknown$.MODULE$.equals(uniqueRemoteAddressState)) {
                                    return acc.updated((Object)address, (Object)association);
                                }
                                if (AssociationState$UidKnown$.MODULE$.equals(uniqueRemoteAddressState)) {
                                    return acc;
                                }
                                throw new MatchError((Object)uniqueRemoteAddressState);
                            }
                            return acc;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
                if (!remove.nonEmpty()) break;
                Map newMap = (Map)currentMap.$minus$minus((GenTraversableOnce)remove.keysIterator());
                if (!this.associationsByAddress.compareAndSet(currentMap, (Map<Address, Association>)newMap)) continue;
                remove.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
                    x$20.removedAfterQuarantined();
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
                break block1;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void removeUnusedQuarantinedByUid(FiniteDuration after) {
        block1: {
            BoxedUnit boxedUnit;
            while (true) {
                long now = System.nanoTime();
                long afterNanos = after.toNanos();
                ImmutableLongMap<Association> currentMap = this.associationsByUid.get();
                Map remove = (Map)currentMap.keysIterator().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> AssociationRegistry.$anonfun$removeUnusedQuarantinedByUid$1(currentMap, now, afterNanos, x0$1, BoxesRunTime.unboxToLong((Object)x1$1)));
                if (!remove.nonEmpty()) break;
                ImmutableLongMap newMap = (ImmutableLongMap)remove.keysIterator().foldLeft(currentMap, (Function2 & Serializable & scala.Serializable)(acc, uid) -> acc.remove(BoxesRunTime.unboxToLong((Object)uid)));
                if (!this.associationsByUid.compareAndSet(currentMap, newMap)) continue;
                remove.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)x$21 -> {
                    x$21.removedAfterQuarantined();
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
                break block1;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Map $anonfun$removeUnusedQuarantinedByUid$1(ImmutableLongMap currentMap$1, long now$2, long afterNanos$2, Map x0$1, long x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToLong((long)x1$1));
        if (tuple2 != null) {
            Map acc = (Map)tuple2._1();
            long uid = tuple2._2$mcJ$sp();
            Association association = (Association)OptionVal$.MODULE$.get$extension(currentMap$1.get(uid));
            AssociationState state = association.associationState();
            if (now$2 - state.lastUsedTimestamp().get() >= afterNanos$2) {
                AssociationState.UniqueRemoteAddressState uniqueRemoteAddressState = state.uniqueRemoteAddressState();
                if (AssociationState$UidQuarantined$.MODULE$.equals(uniqueRemoteAddressState) ? true : AssociationState$UidUnknown$.MODULE$.equals(uniqueRemoteAddressState)) {
                    return acc.updated((Object)BoxesRunTime.boxToLong((long)uid), (Object)association);
                }
                if (AssociationState$UidKnown$.MODULE$.equals(uniqueRemoteAddressState)) {
                    return acc;
                }
                throw new MatchError((Object)uniqueRemoteAddressState);
            }
            return acc;
        }
        throw new MatchError((Object)tuple2);
    }

    public AssociationRegistry(Function1<Address, Association> createAssociation) {
        this.createAssociation = createAssociation;
        this.associationsByAddress = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.associationsByUid = new AtomicReference(ImmutableLongMap$.MODULE$.empty(ClassTag$.MODULE$.apply(Association.class)));
    }
}

