/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.SystemMessageAcker$;
import org.apache.pekko.remote.artery.SystemMessageDelivery;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0019<aa\u0004\t\t\u0002QQbA\u0002\u000f\u0011\u0011\u0003!R\u0004C\u0003%\u0003\u0011\u0005a\u0005C\u0004(\u0003\t\u0007I\u0011\u0001\u0015\t\r1\n\u0001\u0015!\u0003*\r\u0015a\u0002\u0003\u0001\n6\u0011!)UA!A!\u0002\u00131\u0005\"\u0002\u0013\u0006\t\u0003I\u0005b\u0002'\u0006\u0005\u0004%\t!\u0014\u0005\u0007#\u0016\u0001\u000b\u0011\u0002(\t\u000fI+!\u0019!C\u0001'\"1q+\u0002Q\u0001\nQCq\u0001W\u0003C\u0002\u0013\u0005\u0013\f\u0003\u0004[\u000b\u0001\u0006IA\u0010\u0005\u00067\u0016!\t\u0005X\u0001\u0013'f\u001cH/Z7NKN\u001c\u0018mZ3BG.,'O\u0003\u0002\u0012%\u00051\u0011M\u001d;fefT!a\u0005\u000b\u0002\rI,Wn\u001c;f\u0015\t)b#A\u0003qK.\\wN\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<\u0007CA\u000e\u0002\u001b\u0005\u0001\"AE*zgR,W.T3tg\u0006<W-Q2lKJ\u001c\"!\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u000e\u0002C5\u000b\u0007PT3hCRLg/Z!dW:|w\u000f\\3eO\u0016lWM\u001c;M_\u001e<\u0017N\\4\u0016\u0003%\u0002\"a\b\u0016\n\u0005-\u0002#aA%oi\u0006\u0011S*\u0019=OK\u001e\fG/\u001b<f\u0003\u000e\\gn\\<mK\u0012<W-\\3oi2{wmZ5oO\u0002B#!\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0012AC1o]>$\u0018\r^5p]&\u00111\u0007\r\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e\u000b\u0002\u0001]M\u0011QA\u000e\t\u0004oqrT\"\u0001\u001d\u000b\u0005eR\u0014!B:uC\u001e,'BA\u001e\u0015\u0003\u0019\u0019HO]3b[&\u0011Q\b\u000f\u0002\u000b\u000fJ\f\u0007\u000f[*uC\u001e,\u0007\u0003B A\u0005\nk\u0011AO\u0005\u0003\u0003j\u0012\u0011B\u00127poNC\u0017\r]3\u0011\u0005m\u0019\u0015B\u0001#\u0011\u0005=IeNY8v]\u0012,eN^3m_B,\u0017AD5oE>,h\u000eZ\"p]R,\u0007\u0010\u001e\t\u00037\u001dK!\u0001\u0013\t\u0003\u001d%s'm\\;oI\u000e{g\u000e^3yiR\u0011!j\u0013\t\u00037\u0015AQ!R\u0004A\u0002\u0019\u000b!!\u001b8\u0016\u00039\u00032aP(C\u0013\t\u0001&HA\u0003J]2,G/A\u0002j]\u0002\n1a\\;u+\u0005!\u0006cA V\u0005&\u0011aK\u000f\u0002\u0007\u001fV$H.\u001a;\u0002\t=,H\u000fI\u0001\u0006g\"\f\u0007/Z\u000b\u0002}\u000511\u000f[1qK\u0002\n1b\u0019:fCR,Gj\\4jGR\u0011Q\f\u0019\t\u0003oyK!a\u0018\u001d\u0003\u001f\u001d\u0013\u0018\r\u001d5Ti\u0006<W\rT8hS\u000eDQ!\u0019\bA\u0002\t\f1#\u001b8iKJLG/\u001a3BiR\u0014\u0018NY;uKN\u0004\"aP2\n\u0005\u0011T$AC!uiJL'-\u001e;fg\"\u0012QA\f")
@InternalApi
public class SystemMessageAcker
extends GraphStage<FlowShape<InboundEnvelope, InboundEnvelope>> {
    public final InboundContext org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext;
    private final Inlet<InboundEnvelope> in;
    private final Outlet<InboundEnvelope> out;
    private final FlowShape<InboundEnvelope, InboundEnvelope> shape;

    public static int MaxNegativeAcknowledgementLogging() {
        return SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging();
    }

    public Inlet<InboundEnvelope> in() {
        return this.in;
    }

    public Outlet<InboundEnvelope> out() {
        return this.out;
    }

    public FlowShape<InboundEnvelope, InboundEnvelope> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private Map<UniqueAddress, Object> sequenceNumbers;
            private int nackCount;
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final /* synthetic */ SystemMessageAcker $outer;

            public LoggingAdapter log() {
                return StageLogging.log$((StageLogging)this);
            }

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFinish() throws Exception {
                InHandler.onUpstreamFinish$((InHandler)this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            private Map<UniqueAddress, Object> sequenceNumbers() {
                return this.sequenceNumbers;
            }

            private void sequenceNumbers_$eq(Map<UniqueAddress, Object> x$1) {
                this.sequenceNumbers = x$1;
            }

            private int nackCount() {
                return this.nackCount;
            }

            private void nackCount_$eq(int x$1) {
                this.nackCount = x$1;
            }

            private UniqueAddress localAddress() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.localAddress();
            }

            public Class<?> logSource() {
                return SystemMessageAcker.class;
            }

            public void onPush() {
                InboundEnvelope env = (InboundEnvelope)this.grab(this.$outer.in());
                Object object = env.message();
                if (object instanceof SystemMessageDelivery.SystemMessageEnvelope) {
                    long l;
                    SystemMessageDelivery.SystemMessageEnvelope systemMessageEnvelope = (SystemMessageDelivery.SystemMessageEnvelope)object;
                    long n = systemMessageEnvelope.seqNo();
                    UniqueAddress ackReplyTo = systemMessageEnvelope.ackReplyTo();
                    Option option = this.sequenceNumbers().get((Object)ackReplyTo);
                    if (None$.MODULE$.equals(option)) {
                        l = 1L;
                    } else if (option instanceof Some) {
                        long seqNo;
                        Some some = (Some)option;
                        l = seqNo = BoxesRunTime.unboxToLong((Object)some.value());
                    } else {
                        throw new MatchError((Object)option);
                    }
                    long expectedSeqNo = l;
                    if (n == expectedSeqNo) {
                        this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), new SystemMessageDelivery.Ack(n, this.localAddress()));
                        this.sequenceNumbers_$eq((Map<UniqueAddress, Object>)this.sequenceNumbers().updated((Object)ackReplyTo, (Object)BoxesRunTime.boxToLong((long)(n + 1L))));
                        InboundEnvelope unwrapped = env.withMessage(systemMessageEnvelope.message());
                        this.push(this.$outer.out(), unwrapped);
                        return;
                    }
                    if (n < expectedSeqNo) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("Deduplicate system message [{}] from [{}], expected [{}]", (Object)BoxesRunTime.boxToLong((long)n), (Object)$anon$2.fromRemoteAddressStr$1(env), (Object)BoxesRunTime.boxToLong((long)expectedSeqNo));
                        }
                        this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), new SystemMessageDelivery.Ack(expectedSeqNo - 1L, this.localAddress()));
                        this.pull(this.$outer.in());
                        return;
                    }
                    if (this.nackCount() < SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging()) {
                        this.nackCount_$eq(this.nackCount() + 1);
                        String maxNackReached = this.nackCount() == SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging() ? new StringBuilder(53).append(". This happened [").append(SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging()).append("] times and will not be logged more.").toString() : "";
                        this.log().warning("Sending negative acknowledgement of system message [{}] from [{}], highest acknowledged [{}]{}", (Object)BoxesRunTime.boxToLong((long)n), (Object)$anon$2.fromRemoteAddressStr$1(env), (Object)BoxesRunTime.boxToLong((long)(expectedSeqNo - 1L)), (Object)maxNackReached);
                    }
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), new SystemMessageDelivery.Nack(expectedSeqNo - 1L, this.localAddress()));
                    this.pull(this.$outer.in());
                    return;
                }
                this.push(this.$outer.out(), env);
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            private static final String fromRemoteAddressStr$1(InboundEnvelope env$1) {
                OutboundContext outboundContext = env$1.association();
                OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
                    OutboundContext a = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
                    return a.remoteAddress().toString();
                }
                return "N/A";
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                StageLogging.$init$((StageLogging)this);
                this.sequenceNumbers = Predef$.MODULE$.Map().empty();
                this.nackCount = 0;
                this.setHandlers($outer.in(), $outer.out(), this);
            }
        };
    }

    public SystemMessageAcker(InboundContext inboundContext) {
        this.org$apache$pekko$remote$artery$SystemMessageAcker$$inboundContext = inboundContext;
        this.in = Inlet$.MODULE$.apply("SystemMessageAcker.in");
        this.out = Outlet$.MODULE$.apply("SystemMessageAcker.out");
        this.shape = new FlowShape(this.in(), this.out());
    }
}

