/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import org.apache.pekko.remote.transport.netty.SSLSettings;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0017/\u0001mB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0006\u0019\u0002!\t!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u00191\u0006\u0001)A\u0005'\"9q\u000b\u0001b\u0001\n\u0003A\u0006B\u00023\u0001A\u0003%\u0011\fC\u0004f\u0001\t\u0007I\u0011\u00014\t\r)\u0004\u0001\u0015!\u0003h\u0011\u0019Y\u0007\u0001)C\u0005Y\"91\u000f\u0001b\u0001\n\u0003!\bBB?\u0001A\u0003%Q\u000fC\u0004\u007f\u0001\t\u0007I\u0011A@\t\u000f\u0005\u0005\u0001\u0001)A\u0005[\"A\u00111\u0001\u0001C\u0002\u0013\u0005q\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B7\t\u0011\u0005\u001d\u0001A1A\u0005\u0002}Dq!!\u0003\u0001A\u0003%Q\u000e\u0003\u0005\u0002\f\u0001\u0011\r\u0011\"\u0001\u0000\u0011\u001d\ti\u0001\u0001Q\u0001\n5D\u0011\"a\u0004\u0001\u0005\u0004%\t!!\u0005\t\u000f\u0005M\u0001\u0001)A\u0005]\"I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003/\u0001\u0001\u0015!\u0003o\u0011!\tI\u0002\u0001b\u0001\n\u0003\u0011\u0006bBA\u000e\u0001\u0001\u0006Ia\u0015\u0005\t\u0003;\u0001!\u0019!C\u0001%\"9\u0011q\u0004\u0001!\u0002\u0013\u0019\u0006\u0002CA\u0011\u0001\t\u0007I\u0011\u0001*\t\u000f\u0005\r\u0002\u0001)A\u0005'\"A\u0011Q\u0005\u0001C\u0002\u0013\u0005\u0001\fC\u0004\u0002(\u0001\u0001\u000b\u0011B-\t\u0011\u0005%\u0002A1A\u0005\u0002aCq!a\u000b\u0001A\u0003%\u0011\fC\u0005\u0002.\u0001\u0011\r\u0011\"\u0001\u0002\u0012!9\u0011q\b\u0001!\u0002\u0013q\u0007\"CA\"\u0001\t\u0007I\u0011AA\t\u0011\u001d\tY\u0005\u0001Q\u0001\n9D\u0011\"a\u0014\u0001\u0005\u0004%\t!!\u0015\t\u0011\u0005m\u0003\u0001)A\u0005\u0003'B\u0011\"!\u0018\u0001\u0005\u0004%\t!!\u0005\t\u000f\u0005}\u0003\u0001)A\u0005]\"I\u0011\u0011\r\u0001C\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003G\u0002\u0001\u0015!\u0003o\u0011\u001d\t)\u0007\u0001C\u0005\u0003O\u0012aCT3uif$&/\u00198ta>\u0014HoU3ui&twm\u001d\u0006\u0003_A\nQA\\3uifT!!\r\u001a\u0002\u0013Q\u0014\u0018M\\:q_J$(BA\u001a5\u0003\u0019\u0011X-\\8uK*\u0011QGN\u0001\u0006a\u0016\\7n\u001c\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0004CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g-\u0001\u0004d_:4\u0017n\u001a\t\u0003\t*k\u0011!\u0012\u0006\u0003\u0005\u001aS!a\u0012%\u0002\u0011QL\b/Z:bM\u0016T\u0011!S\u0001\u0004G>l\u0017BA&F\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"\"A\u0014)\u0011\u0005=\u0003Q\"\u0001\u0018\t\u000b\t\u0013\u0001\u0019A\"\u0002\u0013\u0015s\u0017M\u00197f'NdW#A*\u0011\u0005u\"\u0016BA+?\u0005\u001d\u0011un\u001c7fC:\f!\"\u00128bE2,7k\u001d7!\u0003i\u00196\u000bT#oO&tW\r\u0015:pm&$WM]\"mCN\u001ch*Y7f+\u0005I\u0006C\u0001.b\u001d\tYv\f\u0005\u0002]}5\tQL\u0003\u0002_u\u00051AH]8pizJ!\u0001\u0019 \u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003Az\n1dU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u00072\f7o\u001d(b[\u0016\u0004\u0013AE+tK\u0012K7\u000f]1uG\",'OR8s\u0013>,\u0012a\u001a\t\u0004{!L\u0016BA5?\u0005\u0019y\u0005\u000f^5p]\u0006\u0019Rk]3ESN\u0004\u0018\r^2iKJ4uN]%pA\u0005Qq\u000e\u001d;j_:\u001c\u0016N_3\u0015\u00055\f\bcA\u001fi]B\u0011Qh\\\u0005\u0003az\u00121!\u00138u\u0011\u0015\u0011\u0018\u00021\u0001Z\u0003\u0005\u0019\u0018!E\"p]:,7\r^5p]RKW.Z8viV\tQ\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006AA-\u001e:bi&|gN\u0003\u0002{}\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005q<(A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0013\u0007>tg.Z2uS>tG+[7f_V$\b%\u0001\rXe&$XMQ;gM\u0016\u0014\b*[4i/\u0006$XM]'be.,\u0012!\\\u0001\u001a/JLG/\u001a\"vM\u001a,'\u000fS5hQ^\u000bG/\u001a:NCJ\\\u0007%A\fXe&$XMQ;gM\u0016\u0014Hj\\<XCR,'/T1sW\u0006ArK]5uK\n+hMZ3s\u0019><x+\u0019;fe6\u000b'o\u001b\u0011\u0002\u001dM+g\u000e\u001a\"vM\u001a,'oU5{K\u0006y1+\u001a8e\u0005V4g-\u001a:TSj,\u0007%A\tSK\u000e,\u0017N^3Ck\u001a4WM]*ju\u0016\f!CU3dK&4XMQ;gM\u0016\u00148+\u001b>fA\u0005aQ*\u0019=Ge\u0006lWmU5{KV\ta.A\u0007NCb4%/Y7f'&TX\rI\u0001\b\u0005\u0006\u001c7\u000e\\8h\u0003!\u0011\u0015mY6m_\u001e\u0004\u0013A\u0003+da:{G-\u001a7bs\u0006YAk\u00199O_\u0012,G.Y=!\u00031!6\r]&fKB\fG.\u001b<f\u00035!6\r]&fKB\fG.\u001b<fA\u0005aAk\u00199SKV\u001cX-\u00113ee\u0006iAk\u00199SKV\u001cX-\u00113ee\u0002\n\u0001\u0002S8ti:\fW.Z\u0001\n\u0011>\u001cHO\\1nK\u0002\nABQ5oI\"{7\u000f\u001e8b[\u0016\fQBQ5oI\"{7\u000f\u001e8b[\u0016\u0004\u0013\u0001\u0004)peR\u001cV\r\\3di>\u0014\bf\u0002\u0012\u00022\u0005]\u00121\b\t\u0004{\u0005M\u0012bAA\u001b}\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005e\u0012aM,B%:Kej\u0012\u001e!)\"L7\u000fI:i_VdG\rI8oYf\u0004#-\u001a\u0011vg\u0016$\u0007EY=!aJ|g-Z:tS>t\u0017\r\\:/C\t\ti$A\u00023]A\nQ\u0002U8siN+G.Z2u_J\u0004\u0003fB\u0012\u00022\u0005]\u00121H\u0001\u0011\u0005&tG\rU8siN+G.Z2u_JDs\u0001JA\u0019\u0003o\t9%\t\u0002\u0002J\u0005\u0019!G\f\u001b\u0002#\tKg\u000e\u001a)peR\u001cV\r\\3di>\u0014\b\u0005K\u0004&\u0003c\t9$a\u0012\u0002\u0017M\u001bHnU3ui&twm]\u000b\u0003\u0003'\u0002B!\u00105\u0002VA\u0019q*a\u0016\n\u0007\u0005ecFA\u0006T'2\u001bV\r\u001e;j]\u001e\u001c\u0018\u0001D*tYN+G\u000f^5oON\u0004\u0013AG*feZ,'oU8dW\u0016$xk\u001c:lKJ\u0004vn\u001c7TSj,\u0017aG*feZ,'oU8dW\u0016$xk\u001c:lKJ\u0004vn\u001c7TSj,\u0007%\u0001\u000eDY&,g\u000e^*pG.,GoV8sW\u0016\u0014\bk\\8m'&TX-A\u000eDY&,g\u000e^*pG.,GoV8sW\u0016\u0014\bk\\8m'&TX\rI\u0001\u000bG>l\u0007/\u001e;f/B\u001bFc\u00018\u0002j!)!\t\fa\u0001\u0007\":\u0001!!\r\u0002n\u0005E\u0014EAA8\u0003)\u001aE.Y:tS\u000e\u0004#/Z7pi&tw\rI5tA\u0011,\u0007O]3dCR,G\r\f\u0011vg\u0016\u0004\u0013I\u001d;fef\f#!a\u001d\u0002\u0015\u0005[7.\u0019\u00113]Yr\u0003\u0007")
public class NettyTransportSettings {
    private final Config config;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option<String> UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option<Object> WriteBufferHighWaterMark;
    private final Option<Object> WriteBufferLowWaterMark;
    private final Option<Object> SendBufferSize;
    private final Option<Object> ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option<SSLSettings> SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        switch (n) {
            case 0: {
                return None$.MODULE$;
            }
        }
        if (n < 0) {
            throw new ConfigurationException(new StringBuilder(52).append("Setting '").append(s).append("' must be 0 or positive (and fit in an Int)").toString());
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    private static final Nothing$ throwInvalidNettyVersion$1(String nettyVersion$1) {
        throw new IllegalArgumentException(new StringBuilder(197).append("pekko-remote with the Netty transport requires Netty version 3.10.6 or ").append("later. Version [").append(nettyVersion$1).append("] is on the class path. Issue https://github.com/netty/netty/pull/4739 ").append("may cause messages to not be delivered.").toString());
    }

    public NettyTransportSettings(Config config) {
        this.config = config;
        this.EnableSsl = config.getBoolean("enable-ssl");
        this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
        String string = config.getString("use-dispatcher-for-io");
        this.UseDispatcherForIo = ("".equals(string) ? true : string == null) ? None$.MODULE$ : new Some((Object)string);
        this.ConnectionTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "connection-timeout");
        this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
        this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
        this.SendBufferSize = this.optionSize("send-buffer-size");
        this.ReceiveBufferSize = this.optionSize("receive-buffer-size");
        this.MaxFrameSize = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size"))))), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 32000, (Function0 & Serializable & scala.Serializable)() -> "Setting 'maximum-frame-size' must be at least 32000 bytes"));
        this.Backlog = config.getInt("backlog");
        this.TcpNodelay = config.getBoolean("tcp-nodelay");
        this.TcpKeepalive = config.getBoolean("tcp-keepalive");
        String string2 = config.getString("tcp-reuse-addr");
        this.TcpReuseAddr = "off-for-windows".equals(string2) ? !Helpers$.MODULE$.isWindows() : config.getBoolean("tcp-reuse-addr");
        String string3 = config.getString("hostname");
        this.Hostname = "".equals(string3) ? InetAddress.getLocalHost().getHostAddress() : string3;
        String string4 = config.getString("bind-hostname");
        this.BindHostname = "".equals(string4) ? this.Hostname() : string4;
        this.PortSelector = config.getInt("port");
        String string5 = config.getString("bind-port");
        this.BindPortSelector = "".equals(string5) ? this.PortSelector() : new StringOps(Predef$.MODULE$.augmentString(string5)).toInt();
        this.SslSettings = this.EnableSsl() ? new Some((Object)new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
        this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
        this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
        String nettyVersion = "3.10.6.Final-5f56a03";
        try {
            String[] segments = nettyVersion.split("[.-]");
            if (segments.length < 3 || new StringOps(Predef$.MODULE$.augmentString(segments[0])).toInt() != 3 || new StringOps(Predef$.MODULE$.augmentString(segments[1])).toInt() != 10 || new StringOps(Predef$.MODULE$.augmentString(segments[2])).toInt() < 6) {
                throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
        }
    }
}

