/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.PhiAccrualFailureDetector;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class DefaultFailureDetectorRegistry<A>
implements FailureDetectorRegistry<A> {
    private final Function0<FailureDetector> detectorFactory;
    private final AtomicReference<Map<A, FailureDetector>> resourceToFailureDetector;
    private final Lock failureDetectorCreationLock;

    public DefaultFailureDetectorRegistry(Function0<FailureDetector> detectorFactory) {
        this.detectorFactory = detectorFactory;
        this.resourceToFailureDetector = new AtomicReference<Object>(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
        this.failureDetectorCreationLock = new ReentrantLock();
    }

    @Override
    public final boolean isAvailable(A resource) {
        Option option = ((MapOps)this.resourceToFailureDetector.get()).get(resource);
        if (option instanceof Some) {
            FailureDetector r = (FailureDetector)((Some)option).value();
            return r.isAvailable();
        }
        return true;
    }

    @Override
    public final boolean isMonitoring(A resource) {
        Option option = ((MapOps)this.resourceToFailureDetector.get()).get(resource);
        if (option instanceof Some) {
            FailureDetector r = (FailureDetector)((Some)option).value();
            return r.isMonitoring();
        }
        return false;
    }

    @Override
    public final void heartbeat(A resource) {
        Option option = ((MapOps)this.resourceToFailureDetector.get()).get(resource);
        if (option instanceof Some) {
            FailureDetector failureDetector = (FailureDetector)((Some)option).value();
            failureDetector.heartbeat();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            block8: {
                this.failureDetectorCreationLock.lock();
                try {
                    Map<A, FailureDetector> oldTable = this.resourceToFailureDetector.get();
                    Option option2 = oldTable.get(resource);
                    if (option2 instanceof Some) {
                        FailureDetector failureDetector = (FailureDetector)((Some)option2).value();
                        failureDetector.heartbeat();
                        break block8;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        FailureDetector newDetector = (FailureDetector)this.detectorFactory.apply();
                        FailureDetector failureDetector = newDetector;
                        if (failureDetector instanceof PhiAccrualFailureDetector) {
                            PhiAccrualFailureDetector phi = (PhiAccrualFailureDetector)failureDetector;
                            phi.address_$eq(resource.toString());
                        }
                        newDetector.heartbeat();
                        Object object = Predef$.MODULE$.ArrowAssoc(resource);
                        this.resourceToFailureDetector.set((Map<A, FailureDetector>)oldTable.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)newDetector)));
                        break block8;
                    }
                    throw new MatchError((Object)option2);
                }
                finally {
                    this.failureDetectorCreationLock.unlock();
                }
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public final void remove(A resource) {
        Map<A, FailureDetector> oldTable;
        while ((oldTable = this.resourceToFailureDetector.get()).contains(resource)) {
            Map newTable = (Map)oldTable.$minus(resource);
            if (!this.resourceToFailureDetector.compareAndSet(oldTable, newTable)) continue;
            return;
        }
    }

    @Override
    public final void reset() {
        Map<A, FailureDetector> oldTable;
        while (!this.resourceToFailureDetector.compareAndSet(oldTable = this.resourceToFailureDetector.get(), Map$.MODULE$.empty())) {
        }
    }

    public Option<FailureDetector> failureDetector(A resource) {
        return ((MapOps)this.resourceToFailureDetector.get()).get(resource);
    }
}

