/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Set;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorPathExtractor$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.DeadLetter;
import org.apache.pekko.actor.DeadLetter$;
import org.apache.pekko.actor.DeadLetterActorRef;
import org.apache.pekko.actor.DeadLetterActorRef$;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Deployer;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.EmptyLocalActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.FSM;
import org.apache.pekko.actor.FSM$$minus$greater$;
import org.apache.pekko.actor.FSM$StateTimeout$;
import org.apache.pekko.actor.FSM$StopEvent$;
import org.apache.pekko.actor.IgnoreActorRef$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalActorRef;
import org.apache.pekko.actor.LocalActorRefProvider;
import org.apache.pekko.actor.LocalScope$;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Nobody$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.RootActorPath$;
import org.apache.pekko.actor.Scope;
import org.apache.pekko.actor.Status;
import org.apache.pekko.actor.SystemGuardian;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.VirtualPathContainer;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.DaemonMsgCreate;
import org.apache.pekko.remote.DaemonMsgCreate$;
import org.apache.pekko.remote.DefaultFailureDetectorRegistry;
import org.apache.pekko.remote.EndpointManager;
import org.apache.pekko.remote.EndpointManager$Send$;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetectorLoader$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.RemoteActorRefProvider$Idle$;
import org.apache.pekko.remote.RemoteActorRefProvider$Internals$;
import org.apache.pekko.remote.RemoteActorRefProvider$Uninitialized$;
import org.apache.pekko.remote.RemoteActorRefProvider$WaitDaemonShutdown$;
import org.apache.pekko.remote.RemoteActorRefProvider$WaitTransportShutdown$;
import org.apache.pekko.remote.RemoteDeployer;
import org.apache.pekko.remote.RemoteDeploymentWatcher;
import org.apache.pekko.remote.RemoteDeploymentWatcher$WatchRemote$;
import org.apache.pekko.remote.RemoteScope;
import org.apache.pekko.remote.RemoteScope$;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.RemoteSystemDaemon;
import org.apache.pekko.remote.RemoteTransport;
import org.apache.pekko.remote.RemoteWatcher$;
import org.apache.pekko.remote.Remoting;
import org.apache.pekko.remote.SeqNo;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.ArterySettings$AeronUpd$;
import org.apache.pekko.remote.artery.ArterySettings$Tcp$;
import org.apache.pekko.remote.artery.ArterySettings$TlsTcp$;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.SystemMessageDelivery;
import org.apache.pekko.remote.artery.SystemMessageDelivery$SystemMessageEnvelope$;
import org.apache.pekko.remote.artery.aeron.ArteryAeronUdpTransport;
import org.apache.pekko.remote.artery.tcp.ArteryTcpTransport;
import org.apache.pekko.remote.serialization.ActorRefResolveThreadLocalCache;
import org.apache.pekko.remote.serialization.ActorRefResolveThreadLocalCache$;
import org.apache.pekko.routing.Listeners;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.util.ErrorMessages$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class RemoteActorRefProvider
implements ActorRefProvider {
    private final String systemName;
    private final ActorSystem.Settings settings;
    private final EventStream eventStream;
    private final DynamicAccess dynamicAccess;
    private final RemoteSettings remoteSettings;
    private final boolean hasClusterOrUseUnsafe;
    private final boolean warnOnUnsafeRemote;
    private final Deployer deployer;
    private final LocalActorRefProvider local;
    private volatile MarkerLoggingAdapter _log;
    private volatile Internals _internals;
    private volatile ActorRef remotingTerminator;
    private volatile Option<ActorRef> _remoteWatcher;
    private volatile Option<ActorRef> remoteDeploymentWatcher;
    private volatile ActorRefResolveThreadLocalCache actorRefResolveThreadLocalCache;
    private Serialization.Information serializationInformationCache;
    private volatile String _addressString;

    public RemoteActorRefProvider(String systemName, ActorSystem.Settings settings, EventStream eventStream, DynamicAccess dynamicAccess) {
        this.systemName = systemName;
        this.settings = settings;
        this.eventStream = eventStream;
        this.dynamicAccess = dynamicAccess;
        this.remoteSettings = new RemoteSettings(settings.config());
        this.hasClusterOrUseUnsafe = settings.HasCluster() || this.remoteSettings().UseUnsafeRemoteFeaturesWithoutCluster();
        this.warnOnUnsafeRemote = !settings.HasCluster() && !this.remoteSettings().UseUnsafeRemoteFeaturesWithoutCluster() && this.remoteSettings().WarnUnsafeWatchWithoutCluster();
        this.deployer = this.createDeployer();
        this.local = new LocalActorRefProvider(systemName, settings, eventStream, dynamicAccess, this.deployer(), (Option)Some$.MODULE$.apply((Function1 & Serializable)deadLettersPath -> new RemoteDeadLetterActorRef(this, (ActorPath)deadLettersPath, eventStream)));
        this._log = this.local().log();
        this._remoteWatcher = None$.MODULE$;
        this.remoteDeploymentWatcher = None$.MODULE$;
        OptionVal$.MODULE$.None();
        this.serializationInformationCache = null;
        OptionVal$.MODULE$.None();
        this._addressString = null;
    }

    public String systemName() {
        return this.systemName;
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    public DynamicAccess dynamicAccess() {
        return this.dynamicAccess;
    }

    public RemoteSettings remoteSettings() {
        return this.remoteSettings;
    }

    public final boolean hasClusterOrUseUnsafe() {
        return this.hasClusterOrUseUnsafe;
    }

    public Deployer deployer() {
        return this.deployer;
    }

    public RemoteDeployer createDeployer() {
        return new RemoteDeployer(this.settings(), this.dynamicAccess());
    }

    public LocalActorRefProvider local() {
        return this.local;
    }

    public LoggingAdapter log() {
        return this._log;
    }

    public ActorPath rootPath() {
        return this.local().rootPath();
    }

    public InternalActorRef deadLetters() {
        return this.local().deadLetters();
    }

    public ActorRef ignoreRef() {
        return this.local().ignoreRef();
    }

    public InternalActorRef rootGuardian() {
        return this.local().rootGuardian();
    }

    public LocalActorRef guardian() {
        return this.local().guardian();
    }

    public LocalActorRef systemGuardian() {
        return this.local().systemGuardian();
    }

    public Future<Terminated> terminationFuture() {
        return this.local().terminationFuture();
    }

    public void registerTempActor(InternalActorRef actorRef, ActorPath path) {
        this.local().registerTempActor(actorRef, path);
    }

    public void unregisterTempActor(ActorPath path) {
        this.local().unregisterTempActor(path);
    }

    public ActorPath tempPath() {
        return this.local().tempPath();
    }

    public ActorPath tempPath(String prefix) {
        return this.local().tempPath(prefix);
    }

    public VirtualPathContainer tempContainer() {
        return this.local().tempContainer();
    }

    public RemoteTransport transport() {
        return this._internals.transport();
    }

    public InternalActorRef remoteDaemon() {
        return this._internals.remoteDaemon();
    }

    public Option<ActorRef> remoteWatcher() {
        return this._remoteWatcher;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void init(ActorSystemImpl system) {
        this.local().init(system);
        this.actorRefResolveThreadLocalCache = (ActorRefResolveThreadLocalCache)ActorRefResolveThreadLocalCache$.MODULE$.apply((ActorSystem)system);
        this.remotingTerminator = system.systemActorOf(this.remoteSettings().configureDispatcher(Props$.MODULE$.apply(RemotingTerminator.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.local().systemGuardian()}))), "remoting-terminator");
        if (!this.remoteSettings().Artery().Enabled()) ** GOTO lbl-1000
        v0 = this.remoteSettings().Artery().Transport();
        var2_2 = ArterySettings$AeronUpd$.MODULE$;
        if (!(v0 != null ? v0.equals(var2_2) == false : var2_2 != null)) {
            this.checkAeronOnClassPath(system);
        } else if (!this.remoteSettings().Artery().Enabled()) {
            this.checkNettyOnClassPath(system);
        }
        d = new RemoteSystemDaemon(system, this.local().rootPath().$div("remote"), this.rootGuardian(), this.remotingTerminator, this._log, this.remoteSettings().untrustedMode());
        this.local().registerExtraNames((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"remote", (Object)d)})));
        var4_4 = d;
        if (!this.remoteSettings().Artery().Enabled()) ** GOTO lbl27
        var7_5 = this.remoteSettings().Artery().Transport();
        if (ArterySettings$AeronUpd$.MODULE$.equals(var7_5)) {
            v1 /* !! */  = new ArteryAeronUdpTransport((ExtendedActorSystem)system, this);
        } else if (ArterySettings$Tcp$.MODULE$.equals(var7_5)) {
            v1 /* !! */  = new ArteryTcpTransport((ExtendedActorSystem)system, this, false);
        } else if (ArterySettings$TlsTcp$.MODULE$.equals(var7_5)) {
            v1 /* !! */  = new ArteryTcpTransport((ExtendedActorSystem)system, this, true);
        } else {
            throw new MatchError((Object)var7_5);
lbl27:
            // 1 sources

            v1 /* !! */  = new Remoting((ExtendedActorSystem)system, this);
        }
        var6_6 = v1 /* !! */ ;
        this._internals = internals = RemoteActorRefProvider$Internals$.MODULE$.apply(var6_6, (InternalActorRef)var4_4);
        var8_8 = this.remotingTerminator;
        var8_8.$bang((Object)internals, var8_8.$bang$default$2((Object)internals));
        this._log = Logging$.MODULE$.withMarker((LoggingBus)this.eventStream(), (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.warnIfDirectUse();
        this.warnIfUseUnsafeWithoutCluster();
        this.transport().start();
        this._addressString = (String)OptionVal.Some$.MODULE$.apply((Object)this._internals.transport().defaultAddress().toString());
        this._remoteWatcher = this.createOrNone((Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, init$$anonfun$1(org.apache.pekko.actor.ActorSystemImpl ), ()Lorg/apache/pekko/actor/ActorRef;)((RemoteActorRefProvider)this, (ActorSystemImpl)system));
        this.remoteDeploymentWatcher = this.createOrNone((Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, init$$anonfun$2(org.apache.pekko.actor.ActorSystemImpl ), ()Lorg/apache/pekko/actor/ActorRef;)((RemoteActorRefProvider)this, (ActorSystemImpl)system));
    }

    private void checkNettyOnClassPath(ActorSystemImpl system) {
        this.checkClassOrThrow(system, "org.jboss.netty.channel.Channel", "Classic", "Netty", "https://pekko.apache.org/docs/pekko/current/remoting.html");
    }

    private void checkAeronOnClassPath(ActorSystemImpl system) {
        String arteryLink = "https://pekko.apache.org/docs/pekko/current/remoting-artery.html";
        this.checkClassOrThrow(system, "io.aeron.driver.MediaDriver", "Artery", "Aeron driver", arteryLink);
        this.checkClassOrThrow(system, "io.aeron.Aeron", "Artery", "Aeron client", arteryLink);
    }

    private void checkClassOrThrow(ActorSystemImpl system, String className, String remoting, String libraryMissing, String link) {
        Throwable throwable;
        Try try_ = system.dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any());
        if (try_ instanceof Failure && ((throwable = ((Failure)try_).exception()) instanceof ClassNotFoundException || throwable instanceof NoClassDefFoundError)) {
            throw new IllegalStateException(new StringBuilder(84).append(remoting).append(" remoting is enabled but ").append(libraryMissing).append(" is not on the classpath, it must be added explicitly. See ").append(link).toString());
        }
    }

    private <T> Option<T> createOrNone(Function0<T> func) {
        if (this.hasClusterOrUseUnsafe()) {
            return Some$.MODULE$.apply(func.apply());
        }
        return None$.MODULE$;
    }

    public ActorRef createRemoteWatcher(ActorSystemImpl system) {
        return system.systemActorOf(this.remoteSettings().configureDispatcher(RemoteWatcher$.MODULE$.props(this.remoteSettings(), this.createRemoteWatcherFailureDetector((ExtendedActorSystem)system))), "remote-watcher");
    }

    public FailureDetectorRegistry<Address> createRemoteWatcherFailureDetector(ExtendedActorSystem system) {
        return new DefaultFailureDetectorRegistry<Address>((Function0<FailureDetector>)(Function0 & Serializable)() -> this.createFailureDetector$1(system));
    }

    public ActorRef createRemoteDeploymentWatcher(ActorSystemImpl system) {
        return system.systemActorOf(this.remoteSettings().configureDispatcher(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(RemoteDeploymentWatcher.class))), "remote-deployment-watcher");
    }

    public void warnIfDirectUse() {
        if (this.remoteSettings().WarnAboutDirectUse()) {
            this.log().warning("Using the 'remote' ActorRefProvider directly, which is a low-level layer. For most use cases, the 'cluster' abstraction on top of remoting is more suitable instead.");
            return;
        }
    }

    public void warnIfUseUnsafeWithoutCluster() {
        if (!this.settings().HasCluster()) {
            if (this.remoteSettings().UseUnsafeRemoteFeaturesWithoutCluster()) {
                this.log().info("Pekko Cluster not in use - enabling unsafe features anyway because `pekko.remote.use-unsafe-remote-features-outside-cluster` has been enabled.");
                return;
            }
            this.log().warning("Pekko Cluster not in use - Using Pekko Cluster is recommended if you need remote watch and deploy.");
            return;
        }
    }

    public void warnOnUnsafe(String message) {
        if (this.warnOnUnsafeRemote) {
            this.log().warning(message);
            return;
        }
        this.log().debug(message);
    }

    public void warnIfUnsafeDeathwatchWithoutCluster(ActorRef watchee, ActorRef watcher, String action) {
        this.warnOnUnsafe(new StringBuilder(36).append("Dropped remote ").append(action).append(": disabled for [").append(watcher).append(" -> ").append(watchee).append("]").toString());
    }

    public void warnIfNotRemoteActorRef(ActorPath path) {
        this.warnOnUnsafe(new StringBuilder(58).append("Remote deploy of [").append(path).append("] is not allowed, falling back to local.").toString());
    }

    public boolean shouldCreateRemoteActorRef(ActorSystem system, Address address) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public InternalActorRef actorOf(ActorSystemImpl system, Props props, InternalActorRef supervisor, ActorPath path, boolean systemService, Option<Deploy> deploy, boolean lookupDeploy, boolean async) {
        block21: {
            block18: {
                block20: {
                    block19: {
                        if (systemService) {
                            return this.local().actorOf(system, props, supervisor, path, systemService, deploy, lookupDeploy, async);
                        }
                        elems = path.elements();
                        if (!lookupDeploy) break block19;
                        var11_10 = (String)elems.head();
                        switch (var11_10 == null ? 0 : var11_10.hashCode()) {
                            case -934610874: {
                                if (!"remote".equals(var11_10)) break;
                                v0 = this.lookupRemotes$1((Iterable)elems);
                                break block20;
                            }
                            case -887328209: {
                                if (!"system".equals(var11_10)) {
                                    break;
                                }
                                ** GOTO lbl17
                            }
                            case 3599307: {
                                if (!"user".equals(var11_10)) break;
lbl17:
                                // 2 sources

                                v0 = this.deployer().lookup((Iterable)elems.drop(1));
                                break block20;
                            }
                        }
                        v0 = None$.MODULE$;
                        break block20;
                    }
                    v0 = None$.MODULE$;
                }
                lookup = v0;
                var14_12 = deploy.toList();
                var13_13 = lookup.toList().$colon$colon$colon(var14_12);
                v1 = package$.MODULE$.Nil();
                var15_14 = var13_13;
                if (!(v1 != null ? v1.equals(var15_14) == false : var15_14 != null)) {
                    v2 = package$.MODULE$.Nil();
                } else {
                    l = var13_13;
                    v2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Deploy[]{(Deploy)l.reduce((Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(org.apache.pekko.actor.Deploy org.apache.pekko.actor.Deploy ), (Lorg/apache/pekko/actor/Deploy;Lorg/apache/pekko/actor/Deploy;)Lorg/apache/pekko/actor/Deploy;)())}));
                }
                deployment = v2;
                var17_17 = (Deploy)package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Deploy[]{props.deploy()})).$plus$plus((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, actorOf$$anonfun$1(scala.collection.immutable.List ), ()Lscala/collection/IterableOnce;)((List)deployment)).reduce((Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, actorOf$$anonfun$2(org.apache.pekko.actor.Deploy org.apache.pekko.actor.Deploy ), (Lorg/apache/pekko/actor/Deploy;Lorg/apache/pekko/actor/Deploy;)Lorg/apache/pekko/actor/Deploy;)());
                if (var17_17 == null || (var18_18 = Deploy$.MODULE$.unapply(var17_17)).isEmpty() || !((var20_20 = (Scope)(var19_19 = (Tuple6)var18_18.get())._4()) instanceof RemoteScope)) break block21;
                var21_21 = RemoteScope$.MODULE$.unapply((RemoteScope)var20_20);
                address = var22_22 = var21_21._1();
                d = var17_17;
                if (this.hasAddress(address)) {
                    return this.local().actorOf(system, props, supervisor, path, false, deployment.headOption(), false, async);
                }
                v3 = props.deploy().scope();
                var25_25 = LocalScope$.MODULE$;
                if (!(v3 != null ? v3.equals(var25_25) == false : var25_25 != null)) {
                    throw new ConfigurationException(new StringBuilder(27).append(ErrorMessages$.MODULE$.RemoteDeploymentConfigErrorPrefix()).append(" for local-only Props at [").append(path).append("]").toString());
                }
                try {
                    if (!this.hasClusterOrUseUnsafe() || !this.shouldCreateRemoteActorRef((ActorSystem)system, address)) ** GOTO lbl70
                    try {
                        dispatcher = system.dispatchers().lookup(props.dispatcher());
                        system.mailboxes().getMailboxType(props, dispatcher.configurator().config());
                    }
                    catch (Throwable var27_27) {
                        var28_28 = var27_27;
                        if (var28_28 != null && !(var29_29 = NonFatal$.MODULE$.unapply(var28_28)).isEmpty()) {
                            e = var30_30 = (Throwable)var29_29.get();
                            throw new ConfigurationException(new StringBuilder(73).append("configuration problem while creating [").append(path).append("] with dispatcher [").append(props.dispatcher()).append("] and mailbox [").append(props.mailbox()).append("]").toString(), e);
                        }
                        throw var27_27;
                    }
                }
                catch (Throwable var34_34) {
                    var35_35 = var34_34;
                    if (var35_35 != null && !(var36_36 = NonFatal$.MODULE$.unapply(var35_35)).isEmpty()) {
                        e = var37_37 = (Throwable)var36_36.get();
                        throw new IllegalArgumentException(new StringBuilder(31).append("remote deployment failed for [").append(path).append("]").toString(), e);
                    }
                    throw var34_34;
                }
                localAddress = this.transport().localAddressForRemote(address);
                rpath = RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div("remote").$div(localAddress.protocol()).$div(localAddress.hostPort()).$div((Iterable)path.elements()).withUid(path.uid());
                v4 = new RemoteActorRef(this.transport(), localAddress, rpath, supervisor, (Option<Props>)Some$.MODULE$.apply((Object)props), (Option<Deploy>)Some$.MODULE$.apply((Object)d));
                break block18;
lbl70:
                // 1 sources

                this.warnIfNotRemoteActorRef(path);
                v4 = this.local().actorOf(system, props, supervisor, path, systemService, deployment.headOption(), false, async);
            }
            return v4;
        }
        return this.local().actorOf(system, props, supervisor, path, systemService, deployment.headOption(), false, async);
    }

    public ActorRef rootGuardianAt(Address address) {
        RemoteActorRef remoteActorRef;
        if (this.hasAddress(address)) {
            return this.rootGuardian();
        }
        try {
            remoteActorRef = new RemoteActorRef(this.transport(), this.transport().localAddressForRemote(address), (ActorPath)RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()), (InternalActorRef)Nobody$.MODULE$, (Option<Props>)None$.MODULE$, (Option<Deploy>)None$.MODULE$);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log().error(e, "No root guardian at [{}]", (Object)address);
                remoteActorRef = new EmptyLocalActorRef((ActorRefProvider)this, (ActorPath)RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()), this.eventStream());
            }
            throw throwable;
        }
        return (ActorRef)remoteActorRef;
    }

    public InternalActorRef resolveActorRefWithLocalAddress(String path, Address localAddress) {
        Option option;
        String string = path;
        if (string != null && !(option = ActorPathExtractor$.MODULE$.unapply(string)).isEmpty()) {
            RemoteActorRef remoteActorRef;
            Tuple2 tuple2 = (Tuple2)option.get();
            Address address = (Address)tuple2._1();
            scala.collection.immutable.Iterable elems = (scala.collection.immutable.Iterable)tuple2._2();
            if (this.hasAddress(address)) {
                return this.local().resolveActorRef(this.rootGuardian(), (Iterable)elems);
            }
            try {
                remoteActorRef = new RemoteActorRef(this.transport(), localAddress, RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div((Iterable)elems), (InternalActorRef)Nobody$.MODULE$, (Option<Props>)None$.MODULE$, (Option<Deploy>)None$.MODULE$);
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option2.get();
                    this.log().warning("Error while resolving ActorRef [{}] due to [{}]", (Object)path, (Object)e.getMessage());
                    remoteActorRef = new EmptyLocalActorRef((ActorRefProvider)this, RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div((Iterable)elems), this.eventStream());
                }
                throw throwable;
            }
            return remoteActorRef;
        }
        this.log().debug("Resolve (deserialization) of unknown (invalid) path [{}], using deadLetters.", (Object)path);
        return this.deadLetters();
    }

    public ActorRef resolveActorRef(String path) {
        ActorRefResolveThreadLocalCache actorRefResolveThreadLocalCache = this.actorRefResolveThreadLocalCache;
        if (actorRefResolveThreadLocalCache == null) {
            return this.internalResolveActorRef(path);
        }
        ActorRefResolveThreadLocalCache c = actorRefResolveThreadLocalCache;
        return c.threadLocalCache(this).resolve(path);
    }

    public ActorRef internalResolveActorRef(String path) {
        Option option;
        String string = path;
        String p = string;
        if (IgnoreActorRef$.MODULE$.isIgnoreRefPath(p)) {
            return this.ignoreRef();
        }
        if (string != null && !(option = ActorPathExtractor$.MODULE$.unapply(string)).isEmpty()) {
            RemoteActorRef remoteActorRef;
            Tuple2 tuple2 = (Tuple2)option.get();
            Address address = (Address)tuple2._1();
            scala.collection.immutable.Iterable elems = (scala.collection.immutable.Iterable)tuple2._2();
            if (this.hasAddress(address)) {
                return this.local().resolveActorRef(this.rootGuardian(), (Iterable)elems);
            }
            ActorPath rootPath = RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div((Iterable)elems);
            try {
                remoteActorRef = new RemoteActorRef(this.transport(), this.transport().localAddressForRemote(address), rootPath, (InternalActorRef)Nobody$.MODULE$, (Option<Props>)None$.MODULE$, (Option<Deploy>)None$.MODULE$);
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option2.get();
                    this.log().warning("Error while resolving ActorRef [{}] due to [{}]", (Object)path, (Object)e.getMessage());
                    remoteActorRef = new EmptyLocalActorRef((ActorRefProvider)this, rootPath, this.eventStream());
                }
                throw throwable;
            }
            return (ActorRef)remoteActorRef;
        }
        this.log().debug("Resolve (deserialization) of unknown (invalid) path [{}], using deadLetters.", (Object)path);
        return this.deadLetters();
    }

    public ActorRef resolveActorRef(ActorPath path) {
        RemoteActorRef remoteActorRef;
        if (this.hasAddress(path.address())) {
            return this.local().resolveActorRef(this.rootGuardian(), (Iterable)path.elements());
        }
        try {
            remoteActorRef = new RemoteActorRef(this.transport(), this.transport().localAddressForRemote(path.address()), path, (InternalActorRef)Nobody$.MODULE$, (Option<Props>)None$.MODULE$, (Option<Deploy>)None$.MODULE$);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log().warning("Error while resolving ActorRef [{}] due to [{}]", (Object)path, (Object)e.getMessage());
                remoteActorRef = new EmptyLocalActorRef((ActorRefProvider)this, path, this.eventStream());
            }
            throw throwable;
        }
        return (ActorRef)remoteActorRef;
    }

    public void useActorOnNode(ActorRef ref, Props props, Deploy deploy, ActorRef supervisor) {
        Option<ActorRef> option = this.remoteDeploymentWatcher;
        if (option instanceof Some) {
            ActorRef watcher = (ActorRef)((Some)option).value();
            this.log().debug("[{}] Instantiating Remote Actor [{}]", (Object)this.rootPath(), (Object)ref.path());
            ActorRef actorRef = this.resolveActorRef(RootActorPath$.MODULE$.apply(ref.path().address(), RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div("remote"));
            DaemonMsgCreate daemonMsgCreate = DaemonMsgCreate$.MODULE$.apply(props, deploy, ref.path().toSerializationFormat(), supervisor);
            actorRef.$bang((Object)daemonMsgCreate, actorRef.$bang$default$2((Object)daemonMsgCreate));
            RemoteDeploymentWatcher.WatchRemote watchRemote = RemoteDeploymentWatcher$WatchRemote$.MODULE$.apply(ref, supervisor);
            watcher.$bang((Object)watchRemote, watcher.$bang$default$2((Object)watchRemote));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.warnIfUseUnsafeWithoutCluster();
            return;
        }
        throw new MatchError(option);
    }

    public Option<Address> getExternalAddressFor(Address addr) {
        Address address = addr;
        if (this.hasAddress(addr)) {
            return Some$.MODULE$.apply((Object)this.local().rootPath().address());
        }
        if (address != null) {
            Address address2 = Address$.MODULE$.unapply(address);
            String string = address2._1();
            String string2 = address2._2();
            Option option = address2._3();
            Option option2 = address2._4();
            if (option instanceof Some && option2 instanceof Some) {
                Some some;
                try {
                    some = Some$.MODULE$.apply((Object)this.transport().localAddressForRemote(addr));
                }
                catch (Throwable throwable) {
                    Option option3;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option3 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option3.get();
                        some = None$.MODULE$;
                    }
                    throw throwable;
                }
                return some;
            }
        }
        return None$.MODULE$;
    }

    public Address getDefaultAddress() {
        return this.transport().defaultAddress();
    }

    @InternalApi
    public Serialization.Information serializationInformation() {
        Serialization.Information information = this.serializationInformationCache;
        Serialization.Information information2 = (Serialization.Information)OptionVal.Some$.MODULE$.unapply((Object)information);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)information2)) {
            Serialization.Information information3;
            Serialization.Information info = information3 = (Serialization.Information)OptionVal$.MODULE$.get$extension((Object)information2);
            return info;
        }
        if (this.transport() == null || this.transport().defaultAddress() == null) {
            return this.local().serializationInformation();
        }
        Serialization.Information info = Serialization.Information$.MODULE$.apply(this.transport().defaultAddress(), (ActorSystem)this.transport().system());
        this.serializationInformationCache = (Serialization.Information)OptionVal.Some$.MODULE$.apply((Object)info);
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasAddress(Address address) {
        Address address2 = address;
        Address address3 = this.local().rootPath().address();
        if (address2 == null) {
            if (address3 == null) return true;
        } else if (address2.equals(address3)) return true;
        Address address4 = address;
        Address address5 = this.rootPath().address();
        if (address4 == null) {
            if (address5 == null) return true;
        } else if (address4.equals(address5)) return true;
        if (!this.transport().addresses().apply((Object)address)) return false;
        return true;
    }

    public void quarantine(Address address, Option<Object> uid, String reason) {
        this.transport().quarantine(address, uid, reason);
    }

    public String addressString() {
        String string = this._addressString;
        String string2 = (String)OptionVal.Some$.MODULE$.unapply((Object)string);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)string2)) {
            String string3;
            String addr = string3 = (String)OptionVal$.MODULE$.get$extension((Object)string2);
            return addr;
        }
        return this.local().addressString();
    }

    private final ActorRef init$$anonfun$1(ActorSystemImpl system$1) {
        return this.createRemoteWatcher(system$1);
    }

    private final ActorRef init$$anonfun$2(ActorSystemImpl system$2) {
        return this.createRemoteDeploymentWatcher(system$2);
    }

    private final FailureDetector createFailureDetector$1(ExtendedActorSystem system$3) {
        return FailureDetectorLoader$.MODULE$.load(this.remoteSettings().WatchFailureDetectorImplementationClass(), this.remoteSettings().WatchFailureDetectorConfig(), (ActorSystem)system$3);
    }

    private final Option lookupRemotes$1(Iterable p) {
        Option option;
        block3: {
            String string;
            while (true) {
                if (None$.MODULE$.equals(option = p.headOption())) {
                    return None$.MODULE$;
                }
                if (!(option instanceof Some)) break block3;
                string = (String)((Some)option).value();
                if (!"remote".equals(string)) break;
                p = (Iterable)p.drop(3);
            }
            if ("user".equals(string)) {
                return this.deployer().lookup((Iterable)p.drop(1));
            }
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private static final /* synthetic */ Deploy $anonfun$1(Deploy a, Deploy b) {
        return b.withFallback(a);
    }

    private static final IterableOnce actorOf$$anonfun$1(List deployment$1) {
        return deployment$1.iterator();
    }

    private static final /* synthetic */ Deploy actorOf$$anonfun$2(Deploy a, Deploy b) {
        return b.withFallback(a);
    }

    public static final class Internals
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final RemoteTransport transport;
        private final InternalActorRef remoteDaemon;

        public static Internals apply(RemoteTransport remoteTransport, InternalActorRef internalActorRef) {
            return RemoteActorRefProvider$Internals$.MODULE$.apply(remoteTransport, internalActorRef);
        }

        public static Internals fromProduct(Product product) {
            return RemoteActorRefProvider$Internals$.MODULE$.fromProduct(product);
        }

        public static Internals unapply(Internals internals) {
            return RemoteActorRefProvider$Internals$.MODULE$.unapply(internals);
        }

        public Internals(RemoteTransport transport, InternalActorRef remoteDaemon) {
            this.transport = transport;
            this.remoteDaemon = remoteDaemon;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Internals)) return false;
            Internals internals = (Internals)object;
            RemoteTransport remoteTransport = this.transport();
            RemoteTransport remoteTransport2 = internals.transport();
            if (remoteTransport == null) {
                if (remoteTransport2 != null) {
                    return false;
                }
            } else if (!remoteTransport.equals(remoteTransport2)) return false;
            InternalActorRef internalActorRef = this.remoteDaemon();
            InternalActorRef internalActorRef2 = internals.remoteDaemon();
            if (internalActorRef == null) {
                if (internalActorRef2 == null) return true;
                return false;
            } else {
                if (!internalActorRef.equals(internalActorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Internals;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Internals";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "transport";
            }
            if (1 == n2) {
                return "remoteDaemon";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public RemoteTransport transport() {
            return this.transport;
        }

        public InternalActorRef remoteDaemon() {
            return this.remoteDaemon;
        }

        public Internals copy(RemoteTransport transport, InternalActorRef remoteDaemon) {
            return new Internals(transport, remoteDaemon);
        }

        public RemoteTransport copy$default$1() {
            return this.transport();
        }

        public InternalActorRef copy$default$2() {
            return this.remoteDaemon();
        }

        public RemoteTransport _1() {
            return this.transport();
        }

        public InternalActorRef _2() {
            return this.remoteDaemon();
        }
    }

    public static class RemoteDeadLetterActorRef
    extends DeadLetterActorRef {
        private final ActorRefProvider _provider;

        public RemoteDeadLetterActorRef(ActorRefProvider _provider, ActorPath _path, EventStream _eventStream) {
            this._provider = _provider;
            super(_provider, _path, _eventStream);
        }

        public void $bang(Object message, ActorRef sender) {
            Object object = message;
            if (object instanceof EndpointManager.Send) {
                EndpointManager.Send send = EndpointManager$Send$.MODULE$.unapply((EndpointManager.Send)object);
                Object object2 = send._1();
                ActorRef actorRef = send._2();
                RemoteActorRef remoteActorRef = send._3();
                Option<SeqNo> option = send._4();
                Object m = object2;
                ActorRef senderOption = actorRef;
                RemoteActorRef recipient = remoteActorRef;
                Option<SeqNo> seqOpt = option;
                if (seqOpt.isEmpty()) {
                    super.$bang((Object)DeadLetter$.MODULE$.apply(m, (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, (Object)this._provider.deadLetters()), (ActorRef)recipient), sender);
                    return;
                }
                return;
            }
            if (object instanceof DeadLetter) {
                DeadLetter deadLetter = DeadLetter$.MODULE$.unapply((DeadLetter)object);
                Object object3 = deadLetter._1();
                ActorRef actorRef = deadLetter._2();
                ActorRef actorRef2 = deadLetter._3();
                if (object3 instanceof EndpointManager.Send) {
                    EndpointManager.Send send = EndpointManager$Send$.MODULE$.unapply((EndpointManager.Send)object3);
                    Object object4 = send._1();
                    ActorRef actorRef3 = send._2();
                    RemoteActorRef remoteActorRef = send._3();
                    Option<SeqNo> option = send._4();
                    Object m = object4;
                    ActorRef senderOption = actorRef3;
                    RemoteActorRef recipient = remoteActorRef;
                    Option<SeqNo> seqOpt = option;
                    if (seqOpt.isEmpty()) {
                        super.$bang((Object)DeadLetter$.MODULE$.apply(m, (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)senderOption, (Object)this._provider.deadLetters()), (ActorRef)recipient), sender);
                        return;
                    }
                    return;
                }
            }
            if (object instanceof OutboundEnvelope) {
                OutboundEnvelope env = (OutboundEnvelope)object;
                ActorRef actorRef = env.sender();
                RemoteActorRef remoteActorRef = env.recipient();
                super.$bang((Object)DeadLetter$.MODULE$.apply(this.unwrapSystemMessageEnvelope(env.message()), (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)actorRef, (Object)this._provider.deadLetters()), (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)remoteActorRef, (Object)this._provider.deadLetters())), sender);
                return;
            }
            if (object instanceof DeadLetter) {
                DeadLetter deadLetter = DeadLetter$.MODULE$.unapply((DeadLetter)object);
                Object object5 = deadLetter._1();
                ActorRef actorRef = deadLetter._2();
                ActorRef actorRef4 = deadLetter._3();
                if (object5 instanceof OutboundEnvelope) {
                    OutboundEnvelope env = (OutboundEnvelope)object5;
                    ActorRef actorRef5 = env.sender();
                    RemoteActorRef remoteActorRef = env.recipient();
                    super.$bang((Object)DeadLetter$.MODULE$.apply(this.unwrapSystemMessageEnvelope(env.message()), (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)actorRef5, (Object)this._provider.deadLetters()), (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)remoteActorRef, (Object)this._provider.deadLetters())), sender);
                    return;
                }
            }
            super.$bang(message, sender);
        }

        private Object unwrapSystemMessageEnvelope(Object msg) {
            Object object = msg;
            if (object instanceof SystemMessageDelivery.SystemMessageEnvelope) {
                SystemMessageDelivery.SystemMessageEnvelope systemMessageEnvelope = SystemMessageDelivery$SystemMessageEnvelope$.MODULE$.unapply((SystemMessageDelivery.SystemMessageEnvelope)object);
                Object object2 = systemMessageEnvelope._1();
                long l = systemMessageEnvelope._2();
                UniqueAddress uniqueAddress = systemMessageEnvelope._3();
                Object m = object2;
                return m;
            }
            return msg;
        }

        public Object writeReplace() throws ObjectStreamException {
            return DeadLetterActorRef$.MODULE$.serialized();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class RemotingTerminator
    implements FSM<TerminatorState, Option<Internals>>,
    RequiresMessageQueue<UnboundedMessageQueueSemantics> {
        private ActorContext context;
        private ActorRef self;
        private Set listeners;
        private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
        private FSM.Event$ Event;
        private FSM$StopEvent$ StopEvent;
        private FSM$$minus$greater$ $minus$greater;
        private FSM$StateTimeout$ StateTimeout;
        private FSM.State org$apache$pekko$actor$FSM$$currentState;
        private Option org$apache$pekko$actor$FSM$$timeoutFuture;
        private FSM.State org$apache$pekko$actor$FSM$$nextState;
        private long org$apache$pekko$actor$FSM$$generation;
        private Map org$apache$pekko$actor$FSM$$timers;
        private Iterator org$apache$pekko$actor$FSM$$timerGen;
        private Map org$apache$pekko$actor$FSM$$stateFunctions;
        private Map org$apache$pekko$actor$FSM$$stateTimeouts;
        private PartialFunction org$apache$pekko$actor$FSM$$handleEventDefault;
        private PartialFunction org$apache$pekko$actor$FSM$$handleEvent;
        private PartialFunction org$apache$pekko$actor$FSM$$terminateEvent;
        private List org$apache$pekko$actor$FSM$$transitionEvent;
        public final ActorRef org$apache$pekko$remote$RemoteActorRefProvider$RemotingTerminator$$systemGuardian;

        public RemotingTerminator(ActorRef systemGuardian) {
            this.org$apache$pekko$remote$RemoteActorRefProvider$RemotingTerminator$$systemGuardian = systemGuardian;
            Actor.$init$((Actor)this);
            Listeners.$init$((Listeners)this);
            ActorLogging.$init$((ActorLogging)this);
            FSM.$init$((FSM)this);
            this.startWith(RemoteActorRefProvider$Uninitialized$.MODULE$, None$.MODULE$, this.startWith$default$3());
            this.when(RemoteActorRefProvider$Uninitialized$.MODULE$, this.when$default$2(), (PartialFunction)new Serializable(this){
                private final /* synthetic */ RemotingTerminator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(FSM.Event x) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (object instanceof Internals) {
                            Internals i = (Internals)object;
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(FSM.Event x, Function1 function1) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (object instanceof Internals) {
                            Internals i = (Internals)object;
                            this.$outer.org$apache$pekko$remote$RemoteActorRefProvider$RemotingTerminator$$systemGuardian.$bang((Object)SystemGuardian.RegisterTerminationHook$.MODULE$, this.$outer.self());
                            return this.$outer.goto(RemoteActorRefProvider$Idle$.MODULE$).using((Object)Some$.MODULE$.apply((Object)i));
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            this.when(RemoteActorRefProvider$Idle$.MODULE$, this.when$default$2(), (PartialFunction)new Serializable(this){
                private final /* synthetic */ RemotingTerminator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(FSM.Event x) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (SystemGuardian.TerminationHook$.MODULE$.equals(object) && option instanceof Some) {
                            Internals internals = (Internals)((Some)option).value();
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(FSM.Event x, Function1 function1) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (SystemGuardian.TerminationHook$.MODULE$.equals(object) && option instanceof Some) {
                            Internals internals = (Internals)((Some)option).value();
                            this.$outer.log().info("Shutting down remote daemon.");
                            internals.remoteDaemon().$bang((Object)SystemGuardian.TerminationHook$.MODULE$, this.$outer.self());
                            return this.$outer.goto(RemoteActorRefProvider$WaitDaemonShutdown$.MODULE$);
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            this.when(RemoteActorRefProvider$WaitDaemonShutdown$.MODULE$, this.when$default$2(), (PartialFunction)new Serializable(this){
                private final /* synthetic */ RemotingTerminator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(FSM.Event x) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (SystemGuardian.TerminationHookDone$.MODULE$.equals(object) && option instanceof Some) {
                            Internals internals = (Internals)((Some)option).value();
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(FSM.Event x, Function1 function1) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (SystemGuardian.TerminationHookDone$.MODULE$.equals(object) && option instanceof Some) {
                            Internals internals = (Internals)((Some)option).value();
                            this.$outer.log().info("Remote daemon shut down; proceeding with flushing remote transports.");
                            org.apache.pekko.pattern.package$.MODULE$.pipe(internals.transport().shutdown(), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.self(), this.$outer.self());
                            return this.$outer.goto(RemoteActorRefProvider$WaitTransportShutdown$.MODULE$);
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            this.when(RemoteActorRefProvider$WaitTransportShutdown$.MODULE$, this.when$default$2(), (PartialFunction)new Serializable(this){
                private final /* synthetic */ RemotingTerminator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(FSM.Event x) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (Done$.MODULE$.equals(object)) {
                            return true;
                        }
                        FSM.Event event3 = this.$outer.Event().unapply(event);
                        Object object2 = event3._1();
                        Option option2 = (Option)event3._2();
                        if (object2 instanceof Status.Failure) {
                            Throwable throwable;
                            Status.Failure failure = Status.Failure$.MODULE$.unapply((Status.Failure)object2);
                            Throwable ex = throwable = failure._1();
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(FSM.Event x, Function1 function1) {
                    FSM.Event event = x;
                    if (event != null) {
                        FSM.Event event2 = this.$outer.Event().unapply(event);
                        Object object = event2._1();
                        Option option = (Option)event2._2();
                        if (Done$.MODULE$.equals(object)) {
                            this.$outer.log().info("Remoting shut down.");
                            this.$outer.org$apache$pekko$remote$RemoteActorRefProvider$RemotingTerminator$$systemGuardian.$bang((Object)SystemGuardian.TerminationHookDone$.MODULE$, this.$outer.self());
                            return this.$outer.stop();
                        }
                        FSM.Event event3 = this.$outer.Event().unapply(event);
                        Object object2 = event3._1();
                        Option option2 = (Option)event3._2();
                        if (object2 instanceof Status.Failure) {
                            Throwable throwable;
                            Status.Failure failure = Status.Failure$.MODULE$.unapply((Status.Failure)object2);
                            Throwable ex = throwable = failure._1();
                            this.$outer.log().error(ex, "Remoting shut down with error");
                            this.$outer.org$apache$pekko$remote$RemoteActorRefProvider$RemotingTerminator$$systemGuardian.$bang((Object)SystemGuardian.TerminationHookDone$.MODULE$, this.$outer.self());
                            return this.$outer.stop();
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public Set listeners() {
            return this.listeners;
        }

        public void org$apache$pekko$routing$Listeners$_setter_$listeners_$eq(Set x$0) {
            this.listeners = x$0;
        }

        public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
            return this.org$apache$pekko$actor$ActorLogging$$_log;
        }

        public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
            this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
        }

        public FSM.Event$ Event() {
            return this.Event;
        }

        public FSM$StopEvent$ StopEvent() {
            return this.StopEvent;
        }

        public FSM$$minus$greater$ $minus$greater() {
            return this.$minus$greater;
        }

        public FSM$StateTimeout$ StateTimeout() {
            return this.StateTimeout;
        }

        public FSM.State org$apache$pekko$actor$FSM$$currentState() {
            return this.org$apache$pekko$actor$FSM$$currentState;
        }

        public Option org$apache$pekko$actor$FSM$$timeoutFuture() {
            return this.org$apache$pekko$actor$FSM$$timeoutFuture;
        }

        public FSM.State org$apache$pekko$actor$FSM$$nextState() {
            return this.org$apache$pekko$actor$FSM$$nextState;
        }

        public long org$apache$pekko$actor$FSM$$generation() {
            return this.org$apache$pekko$actor$FSM$$generation;
        }

        public Map org$apache$pekko$actor$FSM$$timers() {
            return this.org$apache$pekko$actor$FSM$$timers;
        }

        public Iterator org$apache$pekko$actor$FSM$$timerGen() {
            return this.org$apache$pekko$actor$FSM$$timerGen;
        }

        public Map org$apache$pekko$actor$FSM$$stateFunctions() {
            return this.org$apache$pekko$actor$FSM$$stateFunctions;
        }

        public Map org$apache$pekko$actor$FSM$$stateTimeouts() {
            return this.org$apache$pekko$actor$FSM$$stateTimeouts;
        }

        public PartialFunction org$apache$pekko$actor$FSM$$handleEventDefault() {
            return this.org$apache$pekko$actor$FSM$$handleEventDefault;
        }

        public PartialFunction org$apache$pekko$actor$FSM$$handleEvent() {
            return this.org$apache$pekko$actor$FSM$$handleEvent;
        }

        public PartialFunction org$apache$pekko$actor$FSM$$terminateEvent() {
            return this.org$apache$pekko$actor$FSM$$terminateEvent;
        }

        public List org$apache$pekko$actor$FSM$$transitionEvent() {
            return this.org$apache$pekko$actor$FSM$$transitionEvent;
        }

        public void org$apache$pekko$actor$FSM$$currentState_$eq(FSM.State x$1) {
            this.org$apache$pekko$actor$FSM$$currentState = x$1;
        }

        public void org$apache$pekko$actor$FSM$$timeoutFuture_$eq(Option x$1) {
            this.org$apache$pekko$actor$FSM$$timeoutFuture = x$1;
        }

        public void org$apache$pekko$actor$FSM$$nextState_$eq(FSM.State x$1) {
            this.org$apache$pekko$actor$FSM$$nextState = x$1;
        }

        public void org$apache$pekko$actor$FSM$$generation_$eq(long x$1) {
            this.org$apache$pekko$actor$FSM$$generation = x$1;
        }

        public void org$apache$pekko$actor$FSM$$handleEvent_$eq(PartialFunction x$1) {
            this.org$apache$pekko$actor$FSM$$handleEvent = x$1;
        }

        public void org$apache$pekko$actor$FSM$$terminateEvent_$eq(PartialFunction x$1) {
            this.org$apache$pekko$actor$FSM$$terminateEvent = x$1;
        }

        public void org$apache$pekko$actor$FSM$$transitionEvent_$eq(List x$1) {
            this.org$apache$pekko$actor$FSM$$transitionEvent = x$1;
        }

        public void org$apache$pekko$actor$FSM$_setter_$Event_$eq(FSM.Event$ x$0) {
            this.Event = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$StopEvent_$eq(FSM$StopEvent$ x$0) {
            this.StopEvent = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$$minus$greater_$eq(FSM$$minus$greater$ x$0) {
            this.$minus$greater = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$StateTimeout_$eq(FSM$StateTimeout$ x$0) {
            this.StateTimeout = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$org$apache$pekko$actor$FSM$$timers_$eq(Map x$0) {
            this.org$apache$pekko$actor$FSM$$timers = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$org$apache$pekko$actor$FSM$$timerGen_$eq(Iterator x$0) {
            this.org$apache$pekko$actor$FSM$$timerGen = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$org$apache$pekko$actor$FSM$$stateFunctions_$eq(Map x$0) {
            this.org$apache$pekko$actor$FSM$$stateFunctions = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$org$apache$pekko$actor$FSM$$stateTimeouts_$eq(Map x$0) {
            this.org$apache$pekko$actor$FSM$$stateTimeouts = x$0;
        }

        public void org$apache$pekko$actor$FSM$_setter_$org$apache$pekko$actor$FSM$$handleEventDefault_$eq(PartialFunction x$0) {
            this.org$apache$pekko$actor$FSM$$handleEventDefault = x$0;
        }

        public /* synthetic */ void org$apache$pekko$actor$FSM$$super$postStop() {
            Actor.postStop$((Actor)this);
        }
    }

    public static interface TerminatorState {
    }
}

